/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.SelectionComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.chart.linechart.OverlayComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.DragAndDropList;
import com.android.tools.profilers.ProfilerAction;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureView;
import com.android.tools.profilers.cpu.CpuKernelCellRenderer;
import com.android.tools.profilers.cpu.CpuKernelModel;
import com.android.tools.profilers.cpu.CpuKernelTooltipView;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilingConfigurationView;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.CpuThreadsTooltipView;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.CpuUsageTooltip;
import com.android.tools.profilers.cpu.CpuUsageTooltipView;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ThreadCellRenderer;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import com.android.tools.profilers.cpu.atrace.CpuKernelTooltip;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import com.android.tools.profilers.event.EventActivityTooltip;
import com.android.tools.profilers.event.EventActivityTooltipView;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.EventSimpleEventTooltip;
import com.android.tools.profilers.event.EventSimpleEventTooltipView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public class CpuProfilerStageView
extends StageView<CpuProfilerStage> {
    private static final String RECORD_TEXT = "Record";
    private static final String STOP_TEXT = "Stop";
    private static final int MONITOR_PANEL_ROW = 0;
    private static final int DETAILS_PANEL_ROW = 1;
    private static final int DETAILS_KERNEL_PANEL_ROW = 0;
    private static final int DETAILS_THREADS_PANEL_ROW = 1;
    @VisibleForTesting
    static final String ATRACE_BUFFER_OVERFLOW_TITLE = "System Trace Buffer Overflow Detected";
    @VisibleForTesting
    static final String ATRACE_BUFFER_OVERFLOW_MESSAGE = "Your capture exceeded the buffer limit, some data may be missing. Consider recording a shorter trace.";
    @VisibleForTesting
    static final float SPLITTER_DEFAULT_RATIO = 0.5f;
    @VisibleForTesting
    static final float KERNEL_VIEW_SPLITTER_RATIO = 0.75f;
    private final CpuProfilerStage myStage;
    private final JButton myCaptureButton;
    private final JLabel myCaptureStatus;
    private final DragAndDropList<CpuThreadsModel.RangedCpuThread> myThreads;
    private final JList<CpuKernelModel.CpuState> myCpus;
    @NotNull
    private final JBSplitter mySplitter;
    @NotNull
    private final LoadingPanel myCaptureViewLoading;
    @Nullable
    private CpuCaptureView myCaptureView;
    @NotNull
    private final CpuProfilingConfigurationView myProfilingConfigurationView;
    @NotNull
    private final JPanel myHelpTipPanel;
    @NotNull
    private final SelectionComponent mySelection;
    @NotNull
    private final RangeTooltipComponent myTooltipComponent;
    @NotNull
    private final JLabel myImportedSelectedProcessLabel;

    public CpuProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull CpuProfilerStage stage) {
        JBPanel overlayPanel;
        if (profilersView == null) {
            CpuProfilerStageView.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CpuProfilerStageView.$$$reportNull$$$0(1);
        }
        super(profilersView, stage);
        this.myStage = stage;
        ProfilerTimeline timeline = this.getTimeline();
        this.myImportedSelectedProcessLabel = new JLabel();
        stage.getAspect().addDependency((AspectObserver)this).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, this::updateCaptureState).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::updateCaptureSelection).onChange((Enum)CpuProfilerAspect.SELECTED_THREADS, this::updateThreadSelection).onChange((Enum)CpuProfilerAspect.CAPTURE_DETAILS, this::updateCaptureDetails).onChange((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME, this::updateCaptureElapsedTime);
        this.getTooltipBinder().bind(CpuUsageTooltip.class, CpuUsageTooltipView::new);
        this.getTooltipBinder().bind(CpuKernelTooltip.class, CpuKernelTooltipView::new);
        this.getTooltipBinder().bind(CpuThreadsTooltip.class, CpuThreadsTooltipView::new);
        this.getTooltipBinder().bind(EventActivityTooltip.class, EventActivityTooltipView::new);
        this.getTooltipBinder().bind(EventSimpleEventTooltip.class, EventSimpleEventTooltipView::new);
        this.getTooltipPanel().setLayout(new FlowLayout(0, 0, 0));
        this.mySelection = new SelectionComponent(((CpuProfilerStage)this.getStage()).getSelectionModel(), this.getTimeline().getViewRange());
        this.mySelection.setCursorSetter(ProfilerLayeredPane::setCursorOnProfilerLayeredPane);
        final boolean[] isMouseOverOverlay = new boolean[]{false};
        this.myTooltipComponent = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> isMouseOverOverlay[0] && this.mySelection.getMode() != SelectionComponent.Mode.MOVE);
        this.myThreads = new DragAndDropList<CpuThreadsModel.RangedCpuThread>(this.myStage.getThreadStates());
        this.myCpus = new JBList((ListModel)this.myStage.getCpuKernelModel());
        OverlayComponent overlay = new OverlayComponent((Component)this.mySelection);
        overlay.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                isMouseOverOverlay[0] = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                isMouseOverOverlay[0] = false;
            }
        });
        JPanel details = new JPanel((LayoutManager)new TabularLayout("*", "Fit-,*"));
        details.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        details.add((Component)this.myTooltipComponent, new TabularLayout.Constraint(0, 0, 3, 1));
        if (!this.myStage.isImportTraceMode()) {
            EventMonitorView eventsView = new EventMonitorView(profilersView, stage.getEventMonitor());
            eventsView.registerTooltip(this.myTooltipComponent, (Stage)((Object)this.getStage()));
            details.add((Component)eventsView.getComponent(), new TabularLayout.Constraint(0, 0));
        }
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        monitorPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        if (!((CpuProfilerStage)this.getStage()).hasUserUsedCpuCapture() && !((CpuProfilerStage)this.getStage()).isImportTraceMode()) {
            this.installProfilingInstructions((JPanel)monitorPanel);
        }
        if (this.myStage.isImportTraceMode()) {
            JBPanel tipPanel = new JBPanel((LayoutManager)new BorderLayout());
            this.configureImportTipPanel((JPanel)tipPanel);
            AxisComponent timeAxisGuide = new AxisComponent(this.myStage.getTimeAxisGuide(), AxisComponent.AxisOrientation.BOTTOM);
            this.configureImportAxisPanel(timeAxisGuide, (JPanel)monitorPanel);
            overlayPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
            this.configureImportOverlayPanel((JPanel)overlayPanel, overlay);
            monitorPanel.add((Component)timeAxisGuide, new TabularLayout.Constraint(0, 0));
            monitorPanel.add((Component)overlay, new TabularLayout.Constraint(0, 0));
            monitorPanel.add((Component)this.mySelection, new TabularLayout.Constraint(0, 0));
            monitorPanel.add((Component)tipPanel, new TabularLayout.Constraint(0, 0));
            monitorPanel.add((Component)overlayPanel, new TabularLayout.Constraint(0, 0));
        } else {
            JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
            this.configureAxisPanel((JPanel)axisPanel);
            JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
            this.configureLegendPanel((JPanel)legendPanel);
            overlayPanel = new JBPanel((LayoutManager)new BorderLayout());
            this.configureOverlayPanel((JPanel)overlayPanel, overlay);
            JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
            this.configureLineChart((JPanel)lineChartPanel, overlay);
            monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
            monitorPanel.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
            monitorPanel.add((Component)overlayPanel, new TabularLayout.Constraint(0, 0));
            monitorPanel.add((Component)this.mySelection, new TabularLayout.Constraint(0, 0));
            monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        }
        JComponent timeAxis = this.buildTimeAxis(this.myStage.getStudioProfilers());
        ProfilerScrollbar scrollbar = new ProfilerScrollbar(timeline, details);
        TabularLayout mainLayout = new TabularLayout("*");
        mainLayout.setRowSizing(0, PanelSpacing.MONITOR.toString());
        mainLayout.setRowSizing(1, PanelSpacing.DETAILS.toString());
        JBPanel mainPanel = new JBPanel((LayoutManager)mainLayout);
        mainPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        TabularLayout detailsLayout = new TabularLayout("*");
        detailsLayout.setRowSizing(0, PanelSpacing.KERNEL.toString());
        detailsLayout.setRowSizing(1, PanelSpacing.THREADS_EXPANDED.toString());
        JBPanel detailsPanel = new JBPanel((LayoutManager)detailsLayout);
        detailsPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.configureKernelPanel((JPanel)detailsPanel);
        this.configureThreadsPanel((JPanel)detailsPanel, detailsLayout);
        mainPanel.add((Component)monitorPanel, new TabularLayout.Constraint(0, 0));
        mainPanel.add((Component)detailsPanel, new TabularLayout.Constraint(1, 0));
        details.add((Component)mainPanel, new TabularLayout.Constraint(1, 0));
        details.add((Component)timeAxis, new TabularLayout.Constraint(3, 0));
        details.add((Component)((Object)scrollbar), new TabularLayout.Constraint(4, 0));
        this.myHelpTipPanel = new JPanel(new BorderLayout());
        this.configureHelpTipPanel();
        this.mySplitter = new JBSplitter(true);
        this.mySplitter.setFirstComponent((JComponent)details);
        this.mySplitter.setSecondComponent(null);
        this.mySplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        this.getComponent().add((Component)this.mySplitter, "Center");
        this.myCaptureButton = new JButton(RECORD_TEXT);
        this.myCaptureButton.setPreferredSize((Dimension)JBDimension.create((Dimension)this.myCaptureButton.getPreferredSize()).withHeight(ProfilerLayout.TOOLBAR_HEIGHT - 1));
        this.myCaptureButton.addActionListener(event -> this.capture());
        this.myCaptureStatus = new JLabel("");
        this.myCaptureStatus.setFont(ProfilerFonts.STANDARD_FONT);
        this.myCaptureStatus.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.myCaptureStatus.setForeground(ProfilerColors.CPU_CAPTURE_STATUS);
        this.myCaptureViewLoading = this.getProfilersView().getIdeProfilerComponents().createLoadingPanel(-1);
        this.myCaptureViewLoading.setLoadingText("Parsing capture...");
        this.myProfilingConfigurationView = new CpuProfilingConfigurationView(this.myStage, this.getIdeComponents());
        this.updateCaptureState();
        this.installContextMenu();
    }

    private void ensureCaptureInViewRange() {
        CpuCapture capture = this.myStage.getCapture();
        assert (capture != null);
        ProfilerTimeline timeline = this.myStage.getStudioProfilers().getTimeline();
        double padding = timeline.getViewRange().getLength() * 0.05;
        timeline.adjustRangeCloseToMiddleView(new Range(capture.getRange().getMin() - padding, capture.getRange().getMax() + padding));
    }

    private void configureKernelPanel(final JPanel detailsPanel) {
        final CpuKernelModel cpuModel = this.myStage.getCpuKernelModel();
        MyScrollPane scrollingCpus = new MyScrollPane();
        ((JComponent)((Object)scrollingCpus)).setBorder(ProfilerLayout.MONITOR_BORDER);
        ((JScrollPane)((Object)scrollingCpus)).setViewportView(this.myCpus);
        ((Component)((Object)scrollingCpus)).addMouseWheelListener(new CpuMouseWheelListener(detailsPanel));
        this.myCpus.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.myCpus.setCellRenderer(new CpuKernelCellRenderer(((CpuProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig(), this.myStage.getStudioProfilers().getSession().getPid(), this.myStage.getUpdatableManager(), this.myCpus, this.myThreads));
        this.myCpus.addListSelectionListener(e -> this.cpuKernelRunningStateSelected(cpuModel));
        this.myCpus.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CpuProfilerStageView.this.cpuKernelRunningStateSelected(cpuModel);
                ((CpuProfilerStage)CpuProfilerStageView.this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectCpuKernelElement();
            }
        });
        this.myCpus.addMouseListener(new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuKernelTooltip(this.myStage)));
        this.myCpus.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = CpuProfilerStageView.this.myCpus.locationToIndex(e.getPoint());
                if (row != -1) {
                    CpuKernelModel.CpuState model = (CpuKernelModel.CpuState)CpuProfilerStageView.this.myCpus.getModel().getElementAt(row);
                    if (CpuProfilerStageView.this.myStage.getTooltip() instanceof CpuKernelTooltip) {
                        CpuKernelTooltip tooltip = (CpuKernelTooltip)CpuProfilerStageView.this.myStage.getTooltip();
                        tooltip.setCpuSeries(model.getCpuId(), model.getSeries());
                    }
                }
            }
        });
        this.myTooltipComponent.registerListenersOn(this.myCpus);
        final HideablePanel kernelsPanel = new HideablePanel.Builder("KERNEL", (JComponent)((Object)scrollingCpus)).setShowSeparator(false).setInitiallyExpanded(false).setClickableComponent(HideablePanel.ClickableComponent.TITLE).build();
        cpuModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                boolean hasElements = CpuProfilerStageView.this.myCpus.getModel().getSize() != 0;
                CpuProfilerStageView.this.myCpus.setVisibleRowCount(Math.min(4, CpuProfilerStageView.this.myCpus.getModel().getSize()));
                kernelsPanel.setVisible(hasElements);
                kernelsPanel.setExpanded(hasElements);
                kernelsPanel.setTitle(String.format("KERNEL (%d)", CpuProfilerStageView.this.myCpus.getModel().getSize()));
                if (hasElements) {
                    CpuProfilerStageView.this.mySplitter.setProportion(0.75f);
                } else {
                    CpuProfilerStageView.this.mySplitter.setProportion(0.5f);
                }
                detailsPanel.revalidate();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        kernelsPanel.setVisible(false);
        kernelsPanel.setBorder((Border)JBUI.Borders.empty());
        kernelsPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        kernelsPanel.addStateChangedListener(e -> ((CpuProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackToggleCpuKernelHideablePanel());
        ((JComponent)((Object)scrollingCpus)).setBorder((Border)JBUI.Borders.empty());
        detailsPanel.add((Component)kernelsPanel, new TabularLayout.Constraint(0, 0));
    }

    private void configureThreadsPanel(JPanel detailsPanel, TabularLayout detailsLayout) {
        MyScrollPane scrollingThreads = new MyScrollPane();
        ((Component)((Object)scrollingThreads)).addMouseWheelListener(new CpuMouseWheelListener(detailsPanel));
        this.myThreads.getSelectionModel().setSelectionMode(0);
        this.myThreads.setBorder(null);
        this.myThreads.setCellRenderer(new ThreadCellRenderer((JList<CpuThreadsModel.RangedCpuThread>)this.myThreads, this.myStage.getUpdatableManager()));
        this.myThreads.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        ((JComponent)((Object)scrollingThreads)).setBorder(null);
        CpuThreadsModel model = this.myStage.getThreadStates();
        this.myThreads.addListSelectionListener(e -> {
            int selectedIndex = this.myThreads.getSelectedIndex();
            if (selectedIndex >= 0) {
                CpuThreadsModel.RangedCpuThread thread2 = (CpuThreadsModel.RangedCpuThread)model.getElementAt(selectedIndex);
                if (this.myStage.getSelectedThread() != thread2.getThreadId()) {
                    this.myStage.setSelectedThread(thread2.getThreadId());
                    this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectThread();
                }
            } else {
                this.myStage.setSelectedThread(-1);
            }
        });
        this.myThreads.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CpuProfilerStageView.this.myThreads.getSelectedIndex() < 0 && CpuProfilerStageView.this.myThreads.getModel().getSize() > 0) {
                    CpuProfilerStageView.this.myThreads.setSelectedIndex(0);
                }
            }
        });
        ((JComponent)((Object)scrollingThreads)).setBorder(ProfilerLayout.MONITOR_BORDER);
        ((JScrollPane)((Object)scrollingThreads)).setViewportView(this.myThreads);
        this.myThreads.addMouseListener(new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuThreadsTooltip(this.myStage)));
        this.myThreads.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = CpuProfilerStageView.this.myThreads.locationToIndex(e.getPoint());
                if (row != -1) {
                    CpuThreadsModel.RangedCpuThread model = (CpuThreadsModel.RangedCpuThread)CpuProfilerStageView.this.myThreads.getModel().getElementAt(row);
                    if (CpuProfilerStageView.this.myStage.getTooltip() instanceof CpuThreadsTooltip) {
                        CpuThreadsTooltip tooltip = (CpuThreadsTooltip)CpuProfilerStageView.this.myStage.getTooltip();
                        tooltip.setThread(model.getName(), model.getStateSeries());
                    }
                }
            }
        });
        this.myTooltipComponent.registerListenersOn(this.myThreads);
        final AxisComponent timeAxisGuide = new AxisComponent(this.myStage.getTimeAxisGuide(), AxisComponent.AxisOrientation.BOTTOM);
        timeAxisGuide.setShowAxisLine(false);
        timeAxisGuide.setShowLabels(false);
        timeAxisGuide.setHideTickAtMin(true);
        timeAxisGuide.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
        ((Component)((Object)scrollingThreads)).addComponentListener(new ComponentAdapter((JScrollPane)((Object)scrollingThreads)){
            final /* synthetic */ JScrollPane val$scrollingThreads;
            {
                this.val$scrollingThreads = jScrollPane;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                timeAxisGuide.setMarkerLengths(this.val$scrollingThreads.getHeight(), 0);
            }
        });
        JPanel threads = new JPanel((LayoutManager)new TabularLayout("*", "*"));
        threads.add((Component)timeAxisGuide, new TabularLayout.Constraint(0, 0));
        threads.add((Component)((Object)scrollingThreads), new TabularLayout.Constraint(0, 0));
        final HideablePanel threadsPanel = new HideablePanel.Builder("THREADS", (JComponent)threads).setShowSeparator(false).setClickableComponent(HideablePanel.ClickableComponent.TITLE).build();
        threadsPanel.addStateChangedListener(actionEvent -> {
            ((CpuProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackToggleCpuThreadsHideablePanel();
            PanelSpacing panelSpacing = threadsPanel.isExpanded() ? PanelSpacing.THREADS_EXPANDED : PanelSpacing.THREADS_COLLAPSED;
            detailsLayout.setRowSizing(1, panelSpacing.toString());
        });
        threadsPanel.setBorder(JBUI.Borders.customLine((Color)ProfilerColors.CPU_AXIS_GUIDE_COLOR, (int)2, (int)0, (int)0, (int)0));
        threadsPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.myThreads.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                threadsPanel.setTitle(String.format("THREADS (%d)", CpuProfilerStageView.this.myThreads.getModel().getSize()));
            }
        });
        threads.setBorder((Border)new JBEmptyBorder(0, 0, 0, 0));
        detailsPanel.add((Component)threadsPanel, new TabularLayout.Constraint(1, 0));
    }

    private void configureHelpTipPanel() {
        FontMetrics headerMetrics = SwingUtilities2.getFontMetrics((JComponent)this.myHelpTipPanel, ProfilerFonts.H3_FONT);
        FontMetrics bodyMetrics = SwingUtilities2.getFontMetrics((JComponent)this.myHelpTipPanel, ProfilerFonts.STANDARD_FONT);
        InstructionsPanel infoMessage = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(headerMetrics, "Thread details unavailable"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(bodyMetrics, "Click Record to start capturing CPU activity"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(bodyMetrics, "or select a capture in the timeline.")}).setColors(JBColor.foreground(), null).build();
        this.myHelpTipPanel.add((Component)infoMessage, "Center");
    }

    private void configureImportTipPanel(JPanel panel) {
        panel.setOpaque(false);
        panel.setBackground(new Color(0, 0, 0, 0));
        InstructionsPanel infoMessage = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(SwingUtilities2.getFontMetrics((JComponent)panel, ProfilerFonts.H3_FONT), "Cpu usage details unavailable")}).setColors(JBColor.foreground(), null).build();
        panel.add((Component)infoMessage);
    }

    private void configureImportAxisPanel(final AxisComponent timeAxisGuide, final JPanel monitorPanel) {
        timeAxisGuide.setShowAxisLine(false);
        timeAxisGuide.setShowLabels(false);
        timeAxisGuide.setHideTickAtMin(true);
        timeAxisGuide.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
        monitorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                timeAxisGuide.setMarkerLengths(monitorPanel.getHeight(), 0);
            }
        });
    }

    private void configureImportOverlayPanel(JPanel overlay, OverlayComponent overlayComponent) {
        overlay.setOpaque(false);
        LineChart lineChart = new LineChart(new ArrayList());
        DurationDataRenderer traceRenderer = new DurationDataRenderer.Builder(((CpuProfilerStage)this.getStage()).getTraceDurations(), ProfilerColors.CPU_CAPTURE_EVENT).setDurationBg(ProfilerColors.CPU_CAPTURE_BACKGROUND).setLabelProvider(this::formatCaptureLabel).setLabelColors(ProfilerColors.CPU_DURATION_LABEL_BACKGROUND, Color.BLACK, Color.lightGray, Color.WHITE).setClickHander(traceInfo -> ((CpuProfilerStage)this.getStage()).setAndSelectCapture(traceInfo.getTraceId())).build();
        overlayComponent.addDurationDataRenderer(traceRenderer);
        lineChart.addCustomRenderer((LineChartCustomRenderer)traceRenderer);
        overlay.add((Component)lineChart, new TabularLayout.Constraint(0, 0));
    }

    private void configureAxisPanel(JPanel axisPanel) {
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((CpuProfilerStage)this.getStage()).getCpuUsageAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        AxisComponent rightAxis = new AxisComponent(((CpuProfilerStage)this.getStage()).getThreadCountAxis(), AxisComponent.AxisOrientation.LEFT);
        rightAxis.setShowAxisLine(false);
        rightAxis.setShowMax(true);
        rightAxis.setShowUnitAtMax(true);
        rightAxis.setHideTickAtMin(true);
        rightAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        rightAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)rightAxis, "East");
    }

    private void configureOverlayPanel(JPanel overlayPanel, OverlayComponent overlay) {
        ProfilerTooltipMouseAdapter usageListener = new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuUsageTooltip(this.myStage));
        overlay.addMouseListener((MouseListener)usageListener);
        overlayPanel.addMouseListener(usageListener);
        overlayPanel.setOpaque(false);
        overlayPanel.add((Component)overlay, "Center");
        MouseAdapter doubleClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    CpuProfilerStageView.this.clearSelection();
                }
            }
        };
        overlay.addMouseListener((MouseListener)doubleClick);
        overlayPanel.addMouseListener(doubleClick);
        this.myTooltipComponent.registerListenersOn((JComponent)overlay);
        this.myTooltipComponent.registerListenersOn((JComponent)overlayPanel);
    }

    private void configureLineChart(JPanel lineChartPanel, OverlayComponent overlay) {
        lineChartPanel.setOpaque(false);
        DetailedCpuUsage cpuUsage = ((CpuProfilerStage)this.getStage()).getCpuUsage();
        LineChart lineChart = new LineChart((LineChartModel)cpuUsage);
        lineChart.configure(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        lineChart.configure(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        lineChart.configure(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        lineChart.setTopPadding(ProfilerLayout.Y_AXIS_TOP_MARGIN);
        lineChart.setFillEndGap(true);
        DurationDataRenderer traceRenderer = new DurationDataRenderer.Builder(((CpuProfilerStage)this.getStage()).getTraceDurations(), ProfilerColors.CPU_CAPTURE_EVENT).setDurationBg(ProfilerColors.CPU_CAPTURE_BACKGROUND).setLabelProvider(this::formatCaptureLabel).setLabelColors(ProfilerColors.CPU_DURATION_LABEL_BACKGROUND, Color.BLACK, Color.lightGray, Color.WHITE).setClickHander(traceInfo -> ((CpuProfilerStage)this.getStage()).setAndSelectCapture(traceInfo.getTraceId())).build();
        traceRenderer.addCustomLineConfig(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        traceRenderer.addCustomLineConfig(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        traceRenderer.addCustomLineConfig(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT_CAPTURED).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        overlay.addDurationDataRenderer(traceRenderer);
        lineChart.addCustomRenderer((LineChartCustomRenderer)traceRenderer);
        DurationDataRenderer inProgressTraceRenderer = new DurationDataRenderer.Builder(((CpuProfilerStage)this.getStage()).getInProgressTraceDuration(), ProfilerColors.CPU_CAPTURE_EVENT).setDurationBg(ProfilerColors.CPU_CAPTURE_BACKGROUND).setLabelColors(ProfilerColors.CPU_DURATION_LABEL_BACKGROUND, Color.BLACK, Color.lightGray, Color.WHITE).build();
        inProgressTraceRenderer.addCustomLineConfig(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        inProgressTraceRenderer.addCustomLineConfig(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        inProgressTraceRenderer.addCustomLineConfig(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT_CAPTURED).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        overlay.addDurationDataRenderer(inProgressTraceRenderer);
        lineChart.addCustomRenderer((LineChartCustomRenderer)inProgressTraceRenderer);
    }

    private void configureLegendPanel(JPanel legendPanel) {
        CpuProfilerStage.CpuStageLegends legends = ((CpuProfilerStage)this.getStage()).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        legend.configure((Legend)legends.getCpuLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_USAGE_CAPTURED));
        legend.configure((Legend)legends.getOthersLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_OTHER_USAGE_CAPTURED));
        legend.configure((Legend)legends.getThreadsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.THREADS_COUNT_CAPTURED));
        JLabel label = new JLabel(((CpuProfilerStage)this.getStage()).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        label.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
    }

    private void cpuKernelRunningStateSelected(CpuKernelModel cpuModel) {
        int selectedIndex = this.myCpus.getSelectedIndex();
        if (selectedIndex < 0) {
            this.myStage.setSelectedThread(-1);
            return;
        }
        CpuKernelModel.CpuState state = (CpuKernelModel.CpuState)cpuModel.getElementAt(selectedIndex);
        Range tooltipRange = this.myStage.getStudioProfilers().getTimeline().getTooltipRange();
        List process = ((RangedSeries)state.getModel().getSeries().get(0)).getDataSeries().getDataForXRange(tooltipRange);
        if (process.isEmpty()) {
            return;
        }
        int id = ((CpuThreadSliceInfo)((SeriesData)process.get((int)0)).value).getId();
        CpuThreadsModel threadsModel = ((CpuProfilerStage)this.getStage()).getThreadStates();
        for (int i = 0; i < this.myThreads.getModel().getSize(); ++i) {
            CpuThreadsModel.RangedCpuThread thread2 = (CpuThreadsModel.RangedCpuThread)threadsModel.getElementAt(i);
            if (id != thread2.getThreadId()) continue;
            this.myStage.setSelectedThread(thread2.getThreadId());
            this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectThread();
            break;
        }
    }

    @VisibleForTesting
    @NotNull
    CpuProfilingConfigurationView getProfilingConfigurationView() {
        CpuProfilingConfigurationView cpuProfilingConfigurationView = this.myProfilingConfigurationView;
        if (cpuProfilingConfigurationView == null) {
            CpuProfilerStageView.$$$reportNull$$$0(2);
        }
        return cpuProfilingConfigurationView;
    }

    private void clearSelection() {
        ((CpuProfilerStage)this.getStage()).getStudioProfilers().getTimeline().getSelectionRange().clear();
    }

    private void installContextMenu() {
        ContextMenuInstaller contextMenuInstaller = this.getIdeComponents().createContextMenuInstaller();
        this.installRecordMenuItem(contextMenuInstaller);
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isExportCpuTraceEnabled()) {
            this.installExportTraceMenuItem(contextMenuInstaller);
        }
        this.installCaptureNavigationMenuItems(contextMenuInstaller);
        this.getProfilersView().installCommonMenuItems((JComponent)this.mySelection);
    }

    private void installCaptureNavigationMenuItems(ContextMenuInstaller contextMenuInstaller) {
        int shortcutModifier = AdtUiUtils.getActionMask() | 0x40;
        ProfilerAction navigateNext = new ProfilerAction.Builder("Next capture").setContainerComponent(this.getComponent()).setActionRunnable(() -> this.myStage.navigateNext()).setEnableBooleanSupplier(() -> !this.myStage.isImportTraceMode() && this.myStage.getTraceIdsIterator().hasNext()).setKeyStrokes(KeyStroke.getKeyStroke(39, shortcutModifier)).build();
        ProfilerAction navigatePrevious = new ProfilerAction.Builder("Previous capture").setContainerComponent(this.getComponent()).setActionRunnable(() -> this.myStage.navigatePrevious()).setEnableBooleanSupplier(() -> !this.myStage.isImportTraceMode() && this.myStage.getTraceIdsIterator().hasPrevious()).setKeyStrokes(KeyStroke.getKeyStroke(37, shortcutModifier)).build();
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelection, navigateNext);
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelection, navigatePrevious);
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelection, ContextMenuItem.SEPARATOR);
    }

    private void installExportTraceMenuItem(ContextMenuInstaller contextMenuInstaller) {
        ProfilerAction exportTrace = new ProfilerAction.Builder("Export trace...").setIcon(StudioIcons.Common.EXPORT).setContainerComponent(this.getComponent()).setEnableBooleanSupplier(() -> !this.myStage.isImportTraceMode()).build();
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelection, exportTrace, x -> exportTrace.isEnabled() && this.getTraceIntersectingWithMouseX(x) != null, x -> this.getIdeComponents().createExportDialog().open(() -> "Export trace as", () -> CpuProfiler.generateCaptureFileName(this.getTraceIntersectingWithMouseX(x).getProfilerType()), () -> "trace", file -> ((CpuProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().saveFile((File)file, output -> CpuProfiler.saveCaptureToFile(this.getTraceIntersectingWithMouseX(x).getTraceInfo(), output), null)));
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelection, ContextMenuItem.SEPARATOR);
    }

    private void installRecordMenuItem(ContextMenuInstaller contextMenuInstaller) {
        ProfilerAction record = new ProfilerAction.Builder(() -> this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING ? "Stop recording" : "Record CPU trace").setContainerComponent(this.getComponent()).setEnableBooleanSupplier(() -> this.shouldEnableCaptureButton() && !this.myStage.isImportTraceMode() && (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING || this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.IDLE)).setKeyStrokes(KeyStroke.getKeyStroke(82, AdtUiUtils.getActionMask())).setActionRunnable(() -> this.capture()).build();
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelection, record);
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelection, ContextMenuItem.SEPARATOR);
    }

    private CpuTraceInfo getTraceIntersectingWithMouseX(int mouseXLocation) {
        Range range = this.getTimeline().getViewRange();
        double pos = (double)mouseXLocation / this.mySelection.getSize().getWidth() * range.getLength() + range.getMin();
        return ((CpuProfilerStage)this.getStage()).getIntersectingTraceInfo(new Range(pos, pos));
    }

    private void installProfilingInstructions(@NotNull JPanel parent) {
        if (parent == null) {
            CpuProfilerStageView.$$$reportNull$$$0(3);
        }
        assert (parent.getLayout().getClass() == TabularLayout.class);
        FontMetrics metrics = SwingUtilities2.getFontMetrics((JComponent)parent, ProfilerFonts.H2_FONT);
        InstructionsPanel panel = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(metrics, "Click Record to start capturing CPU activity")}).setEaseOut(((CpuProfilerStage)this.getStage()).getInstructionsEaseOutModel(), instructionsPanel -> {
            if (parent == null) {
                CpuProfilerStageView.$$$reportNull$$$0(4);
            }
            parent.remove((Component)instructionsPanel);
        }).setBackgroundCornerRadius(ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER, ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER).build();
        parent.add((Component)panel, new TabularLayout.Constraint(0, 0));
    }

    @Override
    public JComponent getToolbar() {
        if (this.myStage.isImportTraceMode()) {
            JPanel panel = new JPanel((LayoutManager)new TabularLayout("8px,*", "*"));
            panel.add((Component)this.myImportedSelectedProcessLabel, new TabularLayout.Constraint(0, 1));
            return panel;
        }
        JPanel panel = new JPanel(new BorderLayout());
        JPanel toolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        toolbar.add(this.myProfilingConfigurationView.getComponent());
        toolbar.add(this.myCaptureButton);
        toolbar.add(this.myCaptureStatus);
        SessionsManager sessions = ((CpuProfilerStage)this.getStage()).getStudioProfilers().getSessionsManager();
        sessions.addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, () -> this.myCaptureButton.setEnabled(this.shouldEnableCaptureButton()));
        this.myCaptureButton.setEnabled(this.shouldEnableCaptureButton());
        panel.add((Component)toolbar, "West");
        return panel;
    }

    private boolean shouldEnableCaptureButton() {
        return this.myStage.getStudioProfilers().getSessionsManager().isSessionAlive() && !this.myStage.isApiInitiatedTracingInProgress();
    }

    @Override
    public boolean navigationControllersEnabled() {
        return !this.myStage.isImportTraceMode();
    }

    private String formatCaptureLabel(CpuTraceInfo info) {
        Range range = ((CpuProfilerStage)this.getStage()).getStudioProfilers().getTimeline().getDataRange();
        long min = (long)(info.getRange().getMin() - range.getMin());
        long max = (long)(info.getRange().getMax() - range.getMin());
        return String.format("%s - %s", TimeFormatter.getFullClockString((long)min), TimeFormatter.getFullClockString((long)max));
    }

    private void updateCaptureState() {
        this.myCaptureViewLoading.stopLoading();
        switch (this.myStage.getCaptureState()) {
            case IDLE: {
                this.myCaptureButton.setEnabled(this.shouldEnableCaptureButton());
                this.myCaptureButton.setText(RECORD_TEXT);
                this.myCaptureStatus.setText("");
                this.myCaptureButton.setToolTipText("Record a trace");
                this.myProfilingConfigurationView.getComponent().setEnabled(true);
                break;
            }
            case CAPTURING: {
                if (((CpuProfilerStage)this.getStage()).getCaptureInitiationType().equals((Object)CpuProfiler.TraceInitiationType.INITIATED_BY_API)) {
                    this.myCaptureButton.setEnabled(false);
                } else {
                    this.myCaptureButton.setEnabled(this.shouldEnableCaptureButton());
                }
                this.myCaptureButton.setText(STOP_TEXT);
                this.myCaptureStatus.setText("");
                this.myCaptureButton.setToolTipText("Stop recording");
                this.myProfilingConfigurationView.getComponent().setEnabled(false);
                break;
            }
            case PARSING: {
                this.myCaptureViewLoading.startLoading();
                this.mySplitter.setSecondComponent(this.myCaptureViewLoading.getComponent());
                break;
            }
            case PARSING_FAILURE: {
                this.mySplitter.setSecondComponent(null);
                break;
            }
            case STARTING: {
                this.myCaptureButton.setEnabled(false);
                this.myCaptureStatus.setText("Starting record...");
                this.myCaptureButton.setToolTipText("");
                this.myProfilingConfigurationView.getComponent().setEnabled(false);
                break;
            }
            case START_FAILURE: {
                this.mySplitter.setSecondComponent(null);
                break;
            }
            case STOPPING: {
                this.myCaptureButton.setEnabled(false);
                this.myCaptureStatus.setText("Stopping record...");
                this.myCaptureButton.setToolTipText("");
                this.myProfilingConfigurationView.getComponent().setEnabled(false);
                break;
            }
            case STOP_FAILURE: {
                this.mySplitter.setSecondComponent(null);
            }
        }
    }

    private void updateCaptureSelection() {
        CpuCapture capture = this.myStage.getCapture();
        if (capture == null) {
            if (this.myStage.getCaptureState() != CpuProfilerStage.CaptureState.PARSING) {
                if (this.myStage.isSelectionFailure()) {
                    this.mySplitter.setSecondComponent((JComponent)this.myHelpTipPanel);
                } else {
                    this.mySplitter.setSecondComponent(null);
                }
            }
            this.clearSelection();
            this.myCaptureView = null;
        } else if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.IDLE || this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING) {
            this.myCaptureView = new CpuCaptureView(this);
            this.mySplitter.setSecondComponent(this.myCaptureView.getComponent());
            this.ensureCaptureInViewRange();
            if (capture.getType() == CpuProfiler.CpuProfilerType.ATRACE) {
                if (this.myStage.isImportTraceMode()) {
                    this.myImportedSelectedProcessLabel.setText("Process: " + capture.getCaptureNode(capture.getMainThreadId()).getData().getName());
                } else if (((AtraceCpuCapture)capture).isMissingData()) {
                    this.myStage.getStudioProfilers().getIdeServices().showWarningBalloon(ATRACE_BUFFER_OVERFLOW_TITLE, ATRACE_BUFFER_OVERFLOW_MESSAGE, null, null);
                }
            } else {
                this.myImportedSelectedProcessLabel.setText("");
            }
        }
    }

    private void updateCaptureElapsedTime() {
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING) {
            long elapsedTimeUs = this.myStage.getCaptureElapsedTimeUs();
            this.myCaptureStatus.setText(TimeFormatter.getSemiSimplifiedClockString((long)elapsedTimeUs));
        }
    }

    private void capture() {
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING) {
            this.myStage.stopCapturing();
        } else {
            this.myStage.startCapturing();
        }
    }

    private void updateThreadSelection() {
        if (this.myStage.getSelectedThread() == -1) {
            this.myThreads.clearSelection();
            return;
        }
        for (int i = 0; i < this.myThreads.getModel().getSize(); ++i) {
            CpuThreadsModel.RangedCpuThread thread2 = (CpuThreadsModel.RangedCpuThread)this.myThreads.getModel().getElementAt(i);
            if (this.myStage.getSelectedThread() != thread2.getThreadId()) continue;
            this.myThreads.setSelectedIndex(i);
            break;
        }
        if (this.myStage.getSelectedThread() != -1 && this.myStage.isSelectionFailure()) {
            this.mySplitter.setSecondComponent((JComponent)this.myHelpTipPanel);
        }
    }

    private void updateCaptureDetails() {
        if (this.myCaptureView != null) {
            this.myCaptureView.updateView();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStageView";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStageView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfigurationView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installProfilingInstructions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installProfilingInstructions$26";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CpuMouseWheelListener
    implements MouseWheelListener {
        @NotNull
        private final JComponent myDispatchComponent;

        public CpuMouseWheelListener(@NotNull JComponent dispatchComponent) {
            if (dispatchComponent == null) {
                CpuMouseWheelListener.$$$reportNull$$$0(0);
            }
            this.myDispatchComponent = dispatchComponent;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            boolean isMenuKeyDown = AdtUiUtils.isActionKeyDown((InputEvent)e);
            boolean isShiftKeyDown = e.isShiftDown();
            if (isMenuKeyDown || isShiftKeyDown) {
                this.myDispatchComponent.dispatchEvent(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatchComponent", "com/android/tools/profilers/cpu/CpuProfilerStageView$CpuMouseWheelListener", "<init>"));
        }
    }

    private static class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            this.getVerticalScrollBar().setOpaque(false);
        }

        protected JViewport createViewport() {
            if (SystemInfo.isMac) {
                return super.createViewport();
            }
            return new JViewport();
        }
    }

    private static enum PanelSpacing {
        MONITOR("140px"),
        DETAILS("*"),
        KERNEL("Fit"),
        THREADS_COLLAPSED("Fit-"),
        THREADS_EXPANDED("*");

        private final String myLayoutString;

        private PanelSpacing(String layoutType) {
            if (layoutType == null) {
                PanelSpacing.$$$reportNull$$$0(0);
            }
            this.myLayoutString = layoutType;
        }

        public String toString() {
            return this.myLayoutString;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutType", "com/android/tools/profilers/cpu/CpuProfilerStageView$PanelSpacing", "<init>"));
        }
    }
}

