/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class CpuProfilingConfigurationView {
    static final ProfilingConfiguration EDIT_CONFIGURATIONS_ENTRY = new ProfilingConfiguration();
    static final ProfilingConfiguration CONFIG_SEPARATOR_ENTRY = new ProfilingConfiguration();
    private final ProfilingConfiguration API_INITIATED_TRACING_PROFILING_CONFIG;
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;
    @NotNull
    private final JComboBox<ProfilingConfiguration> myComboBox;

    CpuProfilingConfigurationView(@NotNull CpuProfilerStage stage, @NotNull IdeProfilerComponents ideProfilerComponents) {
        if (stage == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(1);
        }
        this.API_INITIATED_TRACING_PROFILING_CONFIG = new ProfilingConfiguration("Debug API (Java)", CpuProfiler.CpuProfilerType.ART, CpuProfiler.CpuProfilerConfiguration.Mode.UNSTATED);
        this.myStage = stage;
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.myComboBox = new ComboBox();
        this.configureProfilingConfigCombo();
    }

    @NotNull
    public JComponent getComponent() {
        JComboBox<ProfilingConfiguration> jComboBox = this.myComboBox;
        if (jComboBox == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(2);
        }
        return jComboBox;
    }

    @VisibleForTesting
    @NotNull
    ProfilingConfiguration getProfilingConfiguration() {
        if (this.myStage.isApiInitiatedTracingInProgress()) {
            ProfilingConfiguration profilingConfiguration = this.API_INITIATED_TRACING_PROFILING_CONFIG;
            if (profilingConfiguration == null) {
                CpuProfilingConfigurationView.$$$reportNull$$$0(3);
            }
            return profilingConfiguration;
        }
        ProfilingConfiguration profilingConfiguration = this.myStage.getProfilerConfigModel().getProfilingConfiguration();
        if (profilingConfiguration == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(4);
        }
        return profilingConfiguration;
    }

    @VisibleForTesting
    void setProfilingConfiguration(@NotNull ProfilingConfiguration mode) {
        if (mode == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(5);
        }
        if (mode == EDIT_CONFIGURATIONS_ENTRY) {
            this.openProfilingConfigurationsDialog();
        } else if (mode != CONFIG_SEPARATOR_ENTRY) {
            this.myStage.getProfilerConfigModel().setProfilingConfiguration(mode);
        }
    }

    @VisibleForTesting
    void openProfilingConfigurationsDialog() {
        Consumer<ProfilingConfiguration> dialogCallback = configuration -> {
            if (configuration != null) {
                this.setProfilingConfiguration((ProfilingConfiguration)configuration);
            }
        };
        Common.Device selectedDevice = this.myStage.getStudioProfilers().getDevice();
        int deviceFeatureLevel = selectedDevice != null ? selectedDevice.getFeatureLevel() : 0;
        this.myIdeProfilerComponents.openCpuProfilingConfigurationsDialog(this.myStage.getProfilerConfigModel(), deviceFeatureLevel, dialogCallback);
        this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackOpenProfilingConfigDialog();
    }

    @NotNull
    @VisibleForTesting
    List<ProfilingConfiguration> getProfilingConfigurations() {
        ArrayList<ProfilingConfiguration> configs = new ArrayList<ProfilingConfiguration>();
        if (this.myStage.isApiInitiatedTracingInProgress()) {
            configs.add(this.API_INITIATED_TRACING_PROFILING_CONFIG);
            ArrayList<ProfilingConfiguration> arrayList = configs;
            if (arrayList == null) {
                CpuProfilingConfigurationView.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        configs.add(EDIT_CONFIGURATIONS_ENTRY);
        List<ProfilingConfiguration> customEntries = this.myStage.getProfilerConfigModel().getCustomProfilingConfigurationsDeviceFiltered();
        if (!customEntries.isEmpty()) {
            configs.add(CONFIG_SEPARATOR_ENTRY);
            configs.addAll(customEntries);
        }
        configs.add(CONFIG_SEPARATOR_ENTRY);
        configs.addAll(this.myStage.getProfilerConfigModel().getDefaultProfilingConfigurations());
        ArrayList<ProfilingConfiguration> arrayList = configs;
        if (arrayList == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private void configureProfilingConfigCombo() {
        JComboBoxView<ProfilingConfiguration, CpuProfilerAspect> profilingConfiguration = new JComboBoxView<ProfilingConfiguration, CpuProfilerAspect>(this.myComboBox, this.myStage.getAspect(), CpuProfilerAspect.PROFILING_CONFIGURATION, this::getProfilingConfigurations, this::getProfilingConfiguration, this::setProfilingConfiguration);
        profilingConfiguration.bind();
        this.myComboBox.setFocusable(false);
        this.myComboBox.addKeyListener(new KeyAdapter(){

            private void skipSeparators(int indexDelta) {
                int selectedIndex = CpuProfilingConfigurationView.this.myComboBox.getSelectedIndex() + indexDelta;
                if (selectedIndex < 0 || selectedIndex == CpuProfilingConfigurationView.this.myComboBox.getItemCount()) {
                    return;
                }
                while (CpuProfilingConfigurationView.this.myComboBox.getItemAt(selectedIndex) == CONFIG_SEPARATOR_ENTRY) {
                    selectedIndex += indexDelta;
                }
                CpuProfilingConfigurationView.this.myComboBox.setSelectedIndex(selectedIndex);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    this.skipSeparators(1);
                    e.consume();
                } else if (e.getKeyCode() == 38) {
                    this.skipSeparators(-1);
                    e.consume();
                }
            }
        });
        this.myComboBox.setRenderer((ListCellRenderer<ProfilingConfiguration>)((Object)new ProfilingConfigurationRenderer()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilingConfigurationView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilingConfigurationView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfiguration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProfilingConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProfilingConfigurationRenderer
    extends ColoredListCellRenderer<ProfilingConfiguration> {
        ProfilingConfigurationRenderer() {
            this.setIpad((Insets)new JBInsets(0, UIUtil.isUnderNativeMacLookAndFeel() ? 5 : UIUtil.getListCellHPadding(), 0, 0));
        }

        public Component getListCellRendererComponent(JList<? extends ProfilingConfiguration> list, ProfilingConfiguration value, int index, boolean selected, boolean hasFocus) {
            if (value == CONFIG_SEPARATOR_ENTRY) {
                return new JSeparator();
            }
            return super.getListCellRendererComponent(list, (Object)value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends ProfilingConfiguration> list, ProfilingConfiguration value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                ProfilingConfigurationRenderer.$$$reportNull$$$0(0);
            }
            if (value == EDIT_CONFIGURATIONS_ENTRY) {
                this.setIcon(AllIcons.Actions.EditSource);
                this.append("Edit configurations...");
            } else {
                this.append(value.getName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/profilers/cpu/CpuProfilingConfigurationView$ProfilingConfigurationRenderer", "customizeCellRenderer"));
        }
    }
}

