/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CpuTreeNode;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

abstract class CpuTreeModel<T extends CpuTreeNode<T>>
extends DefaultTreeModel {
    private final Range myRange;
    private final Range myCurrentRange;
    private final AspectObserver myAspectObserver;
    private final AspectModel<Aspect> myAspectModel;

    public CpuTreeModel(@NotNull Range range, @NotNull T node) {
        if (range == null) {
            CpuTreeModel.$$$reportNull$$$0(0);
        }
        if (node == null) {
            CpuTreeModel.$$$reportNull$$$0(1);
        }
        super(new DefaultMutableTreeNode(node));
        this.myRange = range;
        this.myCurrentRange = new Range();
        this.myAspectModel = new AspectModel();
        this.myAspectObserver = new AspectObserver();
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::rangeChanged);
        this.rangeChanged();
    }

    @NotNull
    public AspectModel<Aspect> getAspect() {
        AspectModel<Aspect> aspectModel = this.myAspectModel;
        if (aspectModel == null) {
            CpuTreeModel.$$$reportNull$$$0(2);
        }
        return aspectModel;
    }

    public void rangeChanged() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        LinkedList<Range> diffs = new LinkedList<Range>();
        diffs.addAll(this.myRange.subtract(this.myCurrentRange));
        diffs.addAll(this.myCurrentRange.subtract(this.myRange));
        this.update(root, this.myRange, diffs);
        this.myCurrentRange.set(this.myRange);
        this.myAspectModel.changed((Enum)Aspect.TREE_MODEL);
    }

    public boolean changes(T data, List<Range> ranges) {
        for (Range diff : ranges) {
            if (!((CpuTreeNode)data).inRange(diff)) continue;
            return true;
        }
        return false;
    }

    private void update(DefaultMutableTreeNode node, Range range, List<Range> ranges) {
        CpuTreeNode data = (CpuTreeNode)node.getUserObject();
        if (this.changes(data, ranges)) {
            Enumeration<TreeNode> e = node.children();
            HashMap<CpuTreeNode, DefaultMutableTreeNode> children = new HashMap<CpuTreeNode, DefaultMutableTreeNode>();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
                children.put((CpuTreeNode)child.getUserObject(), child);
            }
            HashSet<CpuTreeNode> actual = new HashSet<CpuTreeNode>();
            for (CpuTreeNode cpuTreeNode : data.getChildren()) {
                if (cpuTreeNode.inRange(range)) {
                    actual.add(cpuTreeNode);
                    DefaultMutableTreeNode existing = (DefaultMutableTreeNode)children.get(cpuTreeNode);
                    if (existing == null) {
                        existing = new DefaultMutableTreeNode(cpuTreeNode);
                        this.insertNodeInto(existing, node, node.getChildCount());
                    }
                    this.update(existing, range, ranges);
                    continue;
                }
                cpuTreeNode.reset();
            }
            for (Map.Entry entry : children.entrySet()) {
                if (actual.contains(entry.getKey())) continue;
                this.removeNodeFromParent((MutableTreeNode)entry.getValue());
            }
            data.update(range);
            this.nodeChanged(node);
        }
    }

    @NotNull
    protected Range getRange() {
        Range range = this.myRange;
        if (range == null) {
            CpuTreeModel.$$$reportNull$$$0(3);
        }
        return range;
    }

    public boolean isEmpty() {
        CpuTreeNode data = (CpuTreeNode)((DefaultMutableTreeNode)this.getRoot()).getUserObject();
        return data.getTotal() == 0.0;
    }

    abstract void expand(@NotNull DefaultMutableTreeNode var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuTreeModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Aspect {
        TREE_MODEL;

    }
}

