/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.CpuUsageTooltip;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class CpuUsageTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final CpuUsageTooltip myTooltip;
    @NotNull
    private final CpuProfilerStageView myView;
    @NotNull
    private final JPanel myUnavailableDetails;

    CpuUsageTooltipView(@NotNull CpuProfilerStageView view, @NotNull CpuUsageTooltip tooltip) {
        if (view == null) {
            CpuUsageTooltipView.$$$reportNull$$$0(0);
        }
        if (tooltip == null) {
            CpuUsageTooltipView.$$$reportNull$$$0(1);
        }
        super(view.getTimeline());
        this.myTooltip = tooltip;
        this.myView = view;
        this.myUnavailableDetails = new JPanel((LayoutManager)new TabularLayout("*", "Fit,Fit-"));
    }

    @Override
    protected void updateTooltip() {
        boolean canSelect = ((CpuProfilerStage)this.myView.getStage()).getSelectionModel().canSelectRange(this.myView.getTimeline().getTooltipRange());
        this.myUnavailableDetails.setVisible(!canSelect);
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*", "*,Fit"));
        CpuProfilerStage.CpuStageLegends legends = this.myTooltip.getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setVerticalPadding(0).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        legend.setForeground(ProfilerColors.TOOLTIP_TEXT);
        legend.configure((Legend)legends.getCpuLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_USAGE_CAPTURED));
        legend.configure((Legend)legends.getOthersLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_OTHER_USAGE_CAPTURED));
        legend.configure((Legend)legends.getThreadsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.THREADS_COUNT_CAPTURED));
        panel.add((Component)legend, new TabularLayout.Constraint(0, 0));
        JSeparator separator = new JSeparator(0);
        separator.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        this.myUnavailableDetails.add((Component)separator, new TabularLayout.Constraint(0, 0));
        JLabel unavailableLabel = new JLabel("Selection Unavailable");
        unavailableLabel.setFont(ProfilerFonts.TOOLTIP_BODY_FONT);
        unavailableLabel.setForeground(ProfilerColors.TOOLTIP_LOW_CONTRAST);
        this.myUnavailableDetails.add((Component)unavailableLabel, new TabularLayout.Constraint(1, 0));
        panel.add((Component)this.myUnavailableDetails, new TabularLayout.Constraint(1, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            CpuUsageTooltipView.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuUsageTooltipView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuUsageTooltipView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

