/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.AtraceDataSeries;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MergeCaptureDataSeries<T>
implements DataSeries<T> {
    @NotNull
    private final DataSeries<T> myDataStoreSeries;
    @NotNull
    private AtraceDataSeries<T> myAtraceDataSeries;
    @NotNull
    private final CpuProfilerStage myStage;

    public MergeCaptureDataSeries(@NotNull CpuProfilerStage stage, @NotNull DataSeries<T> dataStoreSeries, @NotNull AtraceDataSeries traceState) {
        if (stage == null) {
            MergeCaptureDataSeries.$$$reportNull$$$0(0);
        }
        if (dataStoreSeries == null) {
            MergeCaptureDataSeries.$$$reportNull$$$0(1);
        }
        if (traceState == null) {
            MergeCaptureDataSeries.$$$reportNull$$$0(2);
        }
        this.myStage = stage;
        this.myAtraceDataSeries = traceState;
        this.myDataStoreSeries = dataStoreSeries;
    }

    public List<SeriesData<T>> getDataForXRange(Range xRange) {
        Range traceRange;
        double minRangeUs = xRange.getMin();
        double maxRangeUs = xRange.getMax();
        ArrayList<SeriesData<T>> seriesData = new ArrayList<SeriesData<T>>();
        if (this.myStage.getCapture() instanceof AtraceCpuCapture && (traceRange = this.myStage.getCapture().getRange()).getMin() <= maxRangeUs && traceRange.getMax() >= minRangeUs) {
            List<SeriesData<T>> atraceSeries;
            double traceStart = traceRange.getMin() < minRangeUs ? minRangeUs : traceRange.getMin();
            double atraceSeriesRequestTo = traceRange.getMax();
            if (traceRange.getMax() > maxRangeUs) {
                atraceSeriesRequestTo = maxRangeUs;
            }
            double firstAtraceSeriesEntryTime = !(atraceSeries = this.getDataForRangeFromSeries(traceStart, atraceSeriesRequestTo, this.myAtraceDataSeries)).isEmpty() ? (double)atraceSeries.get((int)0).x : atraceSeriesRequestTo;
            List<SeriesData<T>> dataStoreSeries = this.getDataForRangeFromSeries(minRangeUs, firstAtraceSeriesEntryTime, this.myDataStoreSeries);
            minRangeUs = atraceSeriesRequestTo;
            int dataStoreSeriesIndex = dataStoreSeries.size();
            if (!atraceSeries.isEmpty()) {
                while (--dataStoreSeriesIndex >= 0 && dataStoreSeries.get((int)dataStoreSeriesIndex).x > atraceSeries.get((int)0).x) {
                }
                ++dataStoreSeriesIndex;
            }
            seriesData.addAll(dataStoreSeries.subList(0, dataStoreSeriesIndex));
            seriesData.addAll(atraceSeries);
        }
        if (minRangeUs < maxRangeUs) {
            seriesData.addAll(this.getDataForRangeFromSeries(minRangeUs, maxRangeUs, this.myDataStoreSeries));
        }
        return seriesData;
    }

    private List<SeriesData<T>> getDataForRangeFromSeries(double minUs, double maxUs, DataSeries<T> series) {
        Range range = new Range(minUs, maxUs);
        return series.getDataForXRange(range);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "stage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataStoreSeries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "traceState";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/cpu/MergeCaptureDataSeries";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

