/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.CpuProfiler;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ProfilingConfiguration {
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    public static final int DEFAULT_SAMPLING_INTERVAL_US = 1000;
    public static final String ART_SAMPLED = "Sampled (Java)";
    public static final String ART_INSTRUMENTED = "Instrumented (Java)";
    static final String ART_ARTIFACT = "Method Trace (Java)";
    public static final String SIMPLEPERF = "Sampled (Native)";
    public static final String SIMPLEPERF_ARTIFACT = "Method Trace (Native)";
    public static final String ATRACE = "System Trace";
    private String myName;
    private CpuProfiler.CpuProfilerType myProfilerType;
    private CpuProfiler.CpuProfilerConfiguration.Mode myMode;
    private int myProfilingBufferSizeInMb = 8;
    private int myProfilingSamplingIntervalUs = 1000;

    public ProfilingConfiguration() {
    }

    public ProfilingConfiguration(String name, CpuProfiler.CpuProfilerType profilerType, CpuProfiler.CpuProfilerConfiguration.Mode mode) {
        this.myName = name;
        this.myProfilerType = profilerType;
        this.myMode = mode;
    }

    public CpuProfiler.CpuProfilerConfiguration.Mode getMode() {
        return this.myMode;
    }

    public void setMode(CpuProfiler.CpuProfilerConfiguration.Mode mode) {
        this.myMode = mode;
    }

    public CpuProfiler.CpuProfilerType getProfilerType() {
        return this.myProfilerType;
    }

    public void setProfilerType(CpuProfiler.CpuProfilerType profilerType) {
        this.myProfilerType = profilerType;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public int getProfilingBufferSizeInMb() {
        return this.myProfilingBufferSizeInMb;
    }

    public void setProfilingBufferSizeInMb(int profilingBufferSizeInMb) {
        this.myProfilingBufferSizeInMb = profilingBufferSizeInMb;
    }

    public int getProfilingSamplingIntervalUs() {
        return this.myProfilingSamplingIntervalUs;
    }

    public static String getDefaultConfigName(CpuProfiler.CpuProfilerType profilerType) {
        switch (profilerType) {
            case ART: {
                return ART_ARTIFACT;
            }
            case SIMPLEPERF: {
                return SIMPLEPERF_ARTIFACT;
            }
            case ATRACE: {
                return ATRACE;
            }
        }
        return "Unknown Configuration";
    }

    public int getRequiredDeviceLevel() {
        switch (this.myProfilerType) {
            case ATRACE: {
                return 23;
            }
            case SIMPLEPERF: {
                return 26;
            }
        }
        return 0;
    }

    public boolean isDeviceLevelSupported(int deviceLevel) {
        return deviceLevel >= this.getRequiredDeviceLevel();
    }

    public void setProfilingSamplingIntervalUs(int profilingSamplingIntervalUs) {
        this.myProfilingSamplingIntervalUs = profilingSamplingIntervalUs;
    }

    @NotNull
    public static ProfilingConfiguration fromProto(@NotNull CpuProfiler.CpuProfilerConfiguration proto) {
        if (proto == null) {
            ProfilingConfiguration.$$$reportNull$$$0(0);
        }
        ProfilingConfiguration configuration = new ProfilingConfiguration(proto.getName(), proto.getProfilerType(), proto.getMode());
        configuration.setProfilingSamplingIntervalUs(proto.getSamplingIntervalUs());
        configuration.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
        ProfilingConfiguration profilingConfiguration = configuration;
        if (profilingConfiguration == null) {
            ProfilingConfiguration.$$$reportNull$$$0(1);
        }
        return profilingConfiguration;
    }

    @NotNull
    public CpuProfiler.CpuProfilerConfiguration toProto() {
        CpuProfiler.CpuProfilerConfiguration cpuProfilerConfiguration = CpuProfiler.CpuProfilerConfiguration.newBuilder().setName(this.getName()).setProfilerType(this.getProfilerType()).setMode(this.getMode()).setSamplingIntervalUs(this.getProfilingSamplingIntervalUs()).setBufferSizeInMb(this.getProfilingBufferSizeInMb()).build();
        if (cpuProfilerConfiguration == null) {
            ProfilingConfiguration.$$$reportNull$$$0(2);
        }
        return cpuProfilerConfiguration;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProfilingConfiguration)) {
            return false;
        }
        ProfilingConfiguration incoming = (ProfilingConfiguration)obj;
        return StringUtil.equals((CharSequence)this.getName(), (CharSequence)incoming.getName()) && this.getProfilerType() == incoming.getProfilerType() && this.getMode() == incoming.getMode() && this.getProfilingSamplingIntervalUs() == incoming.getProfilingSamplingIntervalUs() && this.getProfilingBufferSizeInMb() == incoming.getProfilingBufferSizeInMb();
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getName() != null) {
            hashCode = this.getName().hashCode();
        }
        if (this.getProfilerType() != null) {
            hashCode ^= this.getProfilerType().hashCode();
        }
        if (this.getMode() != null) {
            hashCode ^= this.getMode().hashCode();
        }
        hashCode ^= this.getProfilingSamplingIntervalUs();
        return hashCode ^= this.getProfilingBufferSizeInMb();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/ProfilingConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/ProfilingConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromProto";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toProto";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromProto";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

