/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.common.EnumColors;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuCellRenderer;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ThreadCellRenderer
extends CpuCellRenderer<CpuThreadsModel.RangedCpuThread, CpuProfilerStage.ThreadState> {
    @NotNull
    private final Map<StateChart<CpuProfilerStage.ThreadState>, EnumColors<CpuProfilerStage.ThreadState>> myColors = new HashMap<StateChart<CpuProfilerStage.ThreadState>, EnumColors<CpuProfilerStage.ThreadState>>();

    public ThreadCellRenderer(JList<CpuThreadsModel.RangedCpuThread> list, UpdatableManager updatableManager) {
        super(list, updatableManager);
    }

    @Override
    @NotNull
    StateChart<CpuProfilerStage.ThreadState> getChartForModel(@NotNull CpuThreadsModel.RangedCpuThread model) {
        if (model == null) {
            ThreadCellRenderer.$$$reportNull$$$0(0);
        }
        StateChart stateChart = ((CpuCellRenderer.StateChartData)this.myStateCharts.get(model.getId())).getChart();
        if (stateChart == null) {
            ThreadCellRenderer.$$$reportNull$$$0(1);
        }
        return stateChart;
    }

    @Override
    public Component getListCellRendererComponent(JList list, CpuThreadsModel.RangedCpuThread value, int index, boolean isSelected, boolean cellHasFocus) {
        Icon reorderIcon = StudioIcons.Common.REORDER;
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("150px,*", "*"));
        panel.setBorder(ProfilerLayout.CPU_THREADS_BORDER);
        panel.setPreferredSize((Dimension)JBDimension.create((Dimension)panel.getPreferredSize()).withHeight(21));
        panel.setBackground(list.getBackground());
        this.myLabel.setText(value.getName());
        this.myLabel.setIcon(null);
        this.myLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)(reorderIcon.getIconWidth() + this.myLabel.getIconTextGap())));
        this.myLabel.setBackground(ProfilerColors.THREAD_LABEL_BACKGROUND);
        this.myLabel.setForeground(ProfilerColors.THREAD_LABEL_TEXT);
        int tid = value.getThreadId();
        StateChartModel<CpuProfilerStage.ThreadState> model = value.getModel();
        StateChart<CpuProfilerStage.ThreadState> stateChart = this.getOrCreateStateChart(tid, model);
        stateChart.setOpaque(true);
        stateChart.setBorder(null);
        this.myColors.get(stateChart).setColorIndex(0);
        if (isSelected) {
            this.myLabel.setBackground(ProfilerColors.CPU_THREAD_SELECTED_BACKGROUND);
            this.myLabel.setForeground(ProfilerColors.SELECTED_THREAD_LABEL_TEXT);
            stateChart.setBorder(JBUI.Borders.customLine((Color)ProfilerColors.CPU_THREAD_SELECTED_BACKGROUND, (int)2));
        }
        if (this.myHoveredIndex == index) {
            this.myLabel.setBorder((Border)JBUI.Borders.empty());
            this.myLabel.setIcon(isSelected ? ColoredIconGenerator.INSTANCE.generateWhiteIcon(reorderIcon) : reorderIcon);
        }
        panel.add((Component)this.myLabel, new TabularLayout.Constraint(0, 0));
        panel.add((Component)stateChart, new TabularLayout.Constraint(0, 0, 2));
        return panel;
    }

    private StateChart<CpuProfilerStage.ThreadState> getOrCreateStateChart(int tid, StateChartModel<CpuProfilerStage.ThreadState> model) {
        if (this.myStateCharts.containsKey(tid) && ((CpuCellRenderer.StateChartData)this.myStateCharts.get(tid)).getModel().equals(model)) {
            return ((CpuCellRenderer.StateChartData)this.myStateCharts.get(tid)).getChart();
        }
        final EnumColors enumColors = ProfilerColors.THREAD_STATES.build();
        StateChart stateChart = new StateChart(model, (StateChartColorProvider)new StateChartColorProvider<CpuProfilerStage.ThreadState>(){

            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull CpuProfilerStage.ThreadState value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                enumColors.setColorIndex(isMouseOver ? 1 : 0);
                Color color = enumColors.getColor((Enum)value);
                if (color == null) {
                    1.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/cpu/ThreadCellRenderer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/cpu/ThreadCellRenderer$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getColor";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        CpuCellRenderer.StateChartData<CpuProfilerStage.ThreadState> data = new CpuCellRenderer.StateChartData<CpuProfilerStage.ThreadState>(stateChart, model);
        stateChart.setHeightGap(0.0f);
        this.myStateCharts.put(tid, data);
        this.myColors.put((StateChart<CpuProfilerStage.ThreadState>)stateChart, (EnumColors<CpuProfilerStage.ThreadState>)enumColors);
        return stateChart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/ThreadCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/ThreadCellRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChartForModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChartForModel";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

