/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.event.EventAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.Model;
import trebuchet.model.SchedSlice;
import trebuchet.model.ThreadModel;
import trebuchet.model.base.SliceGroup;

public class AtraceFrame
extends EventAction<PerfClass>
implements DurationData {
    private static final double SECONDS_TO_US = TimeUnit.SECONDS.toMicros(1L);
    private static final double EXPECTED_FRAME_TIME_SECONDS = 0.016666666666666666;
    @NotNull
    private final Range myTotalRangeSeconds;
    @NotNull
    private final Range myRenderThreadRangeSeconds;
    @NotNull
    private final Range myMainThreadRangeSeconds;
    @NotNull
    private final List<SliceGroup> mySlices;
    @NotNull
    private final List<SchedSlice> mySchedSlice;
    @NotNull
    private final List<Range> myRanges;
    @NotNull
    private final Model myModel;
    private double myCpuTimeSeconds;

    public AtraceFrame(@NotNull Model model) {
        if (model == null) {
            AtraceFrame.$$$reportNull$$$0(0);
        }
        super(0L, 0L, (Object)PerfClass.GOOD);
        this.myTotalRangeSeconds = new Range();
        this.myRenderThreadRangeSeconds = new Range();
        this.myMainThreadRangeSeconds = new Range();
        this.mySlices = new ArrayList<SliceGroup>();
        this.mySchedSlice = new ArrayList<SchedSlice>();
        this.myRanges = new ArrayList<Range>();
        this.myModel = model;
        this.myCpuTimeSeconds = 0.0;
    }

    @NotNull
    public PerfClass getPerfClass() {
        Range rangeUs = this.getTotalRangeSeconds();
        if (rangeUs.getLength() > 0.016666666666666666) {
            PerfClass perfClass = PerfClass.BAD;
            if (perfClass == null) {
                AtraceFrame.$$$reportNull$$$0(1);
            }
            return perfClass;
        }
        PerfClass perfClass = PerfClass.GOOD;
        if (perfClass == null) {
            AtraceFrame.$$$reportNull$$$0(2);
        }
        return perfClass;
    }

    public long getDurationUs() {
        return (long)(SECONDS_TO_US * this.getTotalRangeSeconds().getLength());
    }

    public long getStartUs() {
        return (long)this.convertToProcessTimeUs(this.myTotalRangeSeconds.getMin());
    }

    public long getEndUs() {
        return (long)this.convertToProcessTimeUs(this.myTotalRangeSeconds.getMax());
    }

    @NotNull
    public PerfClass getType() {
        PerfClass perfClass = this.getPerfClass();
        if (perfClass == null) {
            AtraceFrame.$$$reportNull$$$0(3);
        }
        return perfClass;
    }

    @NotNull
    public Range getTotalRangeSeconds() {
        Range range = this.myTotalRangeSeconds;
        if (range == null) {
            AtraceFrame.$$$reportNull$$$0(4);
        }
        return range;
    }

    @NotNull
    public Range getTotalRangeProcessTime() {
        Range range = new Range(this.convertToProcessTimeUs(this.myTotalRangeSeconds.getMin()), this.convertToProcessTimeUs(this.myTotalRangeSeconds.getMax()));
        if (range == null) {
            AtraceFrame.$$$reportNull$$$0(5);
        }
        return range;
    }

    @NotNull
    public Range getRenderThreadRangeProcessTime() {
        if (!this.myRenderThreadRangeSeconds.isEmpty()) {
            Range range = new Range(this.convertToProcessTimeUs(this.myRenderThreadRangeSeconds.getMin()), this.convertToProcessTimeUs(this.myRenderThreadRangeSeconds.getMax()));
            if (range == null) {
                AtraceFrame.$$$reportNull$$$0(6);
            }
            return range;
        }
        Range range = new Range(0.0, 0.0);
        if (range == null) {
            AtraceFrame.$$$reportNull$$$0(7);
        }
        return range;
    }

    @NotNull
    public Range getUIThreadRangeProcessTime() {
        if (!this.myMainThreadRangeSeconds.isEmpty()) {
            Range range = new Range(this.convertToProcessTimeUs(this.myMainThreadRangeSeconds.getMin()), this.convertToProcessTimeUs(this.myMainThreadRangeSeconds.getMax()));
            if (range == null) {
                AtraceFrame.$$$reportNull$$$0(8);
            }
            return range;
        }
        Range range = new Range(0.0, 0.0);
        if (range == null) {
            AtraceFrame.$$$reportNull$$$0(9);
        }
        return range;
    }

    @NotNull
    public List<SliceGroup> getSlices() {
        List<SliceGroup> list = this.mySlices;
        if (list == null) {
            AtraceFrame.$$$reportNull$$$0(10);
        }
        return list;
    }

    public double getCpuTimeSeconds() {
        return this.myCpuTimeSeconds;
    }

    @NotNull
    public List<Range> getRanges() {
        List<Range> list = this.myRanges;
        if (list == null) {
            AtraceFrame.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<SchedSlice> getSchedSlice() {
        List<SchedSlice> list = this.mySchedSlice;
        if (list == null) {
            AtraceFrame.$$$reportNull$$$0(12);
        }
        return list;
    }

    private double convertToProcessTimeUs(double offsetTime) {
        return SECONDS_TO_US * (offsetTime - this.myModel.getBeginTimestamp() + this.myModel.getParentTimestamp());
    }

    public void addSlice(@NotNull SliceGroup sliceGroup, @NotNull Range range, @NotNull ThreadModel thread2) {
        if (sliceGroup == null) {
            AtraceFrame.$$$reportNull$$$0(13);
        }
        if (range == null) {
            AtraceFrame.$$$reportNull$$$0(14);
        }
        if (thread2 == null) {
            AtraceFrame.$$$reportNull$$$0(15);
        }
        this.mySlices.add(sliceGroup);
        this.myRanges.add(range);
        this.myTotalRangeSeconds.setMin(Math.min(this.myTotalRangeSeconds.getMin(), range.getMin()));
        this.myTotalRangeSeconds.setMax(Math.max(this.myTotalRangeSeconds.getMax(), range.getMax()));
        this.mySchedSlice.addAll(thread2.getSchedSlices());
        this.myCpuTimeSeconds += sliceGroup.getCpuTime();
        if (thread2.getName().equals("RenderThread")) {
            assert (this.myRenderThreadRangeSeconds.isEmpty());
            this.myRenderThreadRangeSeconds.set(range.getMin(), range.getMax());
        } else if (this.myMainThreadRangeSeconds.isEmpty()) {
            this.myMainThreadRangeSeconds.set(range.getMin(), range.getMax());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/atrace/AtraceFrame";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sliceGroup";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/atrace/AtraceFrame";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerfClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTotalRangeSeconds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTotalRangeProcessTime";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderThreadRangeProcessTime";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUIThreadRangeProcessTime";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSlices";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchedSlice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addSlice";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum PerfClass {
        GOOD,
        BAD,
        TERRIBLE;

    }
}

