/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.SliceStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.model.Model;
import trebuchet.model.ProcessModel;
import trebuchet.model.ThreadModel;
import trebuchet.model.base.SliceGroup;

public class AtraceFrameFactory {
    public static final String RENDER_THREAD_NAME = "RenderThread";
    private static final String[] RENDER_THREAD_SYNC_ELEMENTS = new String[]{RenderThreadDrawNames.RENDER_THREAD_QUEUE.getDrawName(), RenderThreadDrawNames.RENDER_THREAD_SWAP.getDrawName()};
    @NotNull
    private Model myModel;
    @NotNull
    private final AtraceThreads myThreads;

    public AtraceFrameFactory(@NotNull Model model, @NotNull ProcessModel process) {
        if (model == null) {
            AtraceFrameFactory.$$$reportNull$$$0(0);
        }
        if (process == null) {
            AtraceFrameFactory.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myThreads = this.findUiAndRenderThread(process);
    }

    @NotNull
    private AtraceThreads findUiAndRenderThread(@NotNull ProcessModel process) {
        if (process == null) {
            AtraceFrameFactory.$$$reportNull$$$0(2);
        }
        ThreadModel uiThread = null;
        ThreadModel renderThread = null;
        for (ThreadModel thread2 : process.getThreads()) {
            if (thread2.getId() == process.getId()) {
                uiThread = thread2;
            } else if (thread2.getName().equals(RENDER_THREAD_NAME)) {
                renderThread = thread2;
            }
            if (uiThread == null || renderThread == null) continue;
            break;
        }
        assert (uiThread != null);
        AtraceThreads atraceThreads = new AtraceThreads(uiThread, renderThread);
        if (atraceThreads == null) {
            AtraceFrameFactory.$$$reportNull$$$0(3);
        }
        return atraceThreads;
    }

    public List<AtraceFrame> buildFramesList() {
        List<AtraceFrame> frames = this.getUiThreadDrivenFrames();
        frames.addAll(this.getRenderThreadDrivenFrames());
        return frames;
    }

    private SliceGroup findOverlappingDrawFrame(SliceGroup reference) {
        if (this.myThreads.getRenderThread() == null) {
            return null;
        }
        SliceGroup[] slices = new SliceGroup[1];
        new SliceStream(this.myThreads.getRenderThread().getSlices()).matchName(RenderThreadDrawNames.RENDER_THREAD.getDrawName()).overlapsRange(new Range(reference.getStartTime(), reference.getEndTime())).enumerate(sliceGroup -> {
            SliceGroup threadSyncSlice = new SliceStream(sliceGroup.getChildren()).matchName(RenderThreadDrawNames.THREAD_SYNC.getDrawName()).findFirst();
            if (threadSyncSlice != null && threadSyncSlice.getStartTime() >= reference.getStartTime() && threadSyncSlice.getEndTime() <= reference.getEndTime()) {
                slices[0] = sliceGroup;
                return false;
            }
            return true;
        });
        return slices[0];
    }

    public List<AtraceFrame> getUiThreadDrivenFrames() {
        ArrayList<AtraceFrame> sliceRanges = new ArrayList<AtraceFrame>();
        Pattern frameRegex = Pattern.compile(String.format("(%s|%s)", UIThreadDrawType.MARSHMALLOW.getDrawName(), UIThreadDrawType.LEGACY.getDrawName()));
        new SliceStream(this.myThreads.getUiThread().getSlices()).matchPattern(frameRegex).enumerate(sliceGroup -> {
            AtraceFrame frame = new AtraceFrame(this.myModel);
            double startTime = sliceGroup.getStartTime();
            double endTime = sliceGroup.getEndTime();
            SliceGroup renderThreadOverlapSlice = this.findOverlappingDrawFrame((SliceGroup)sliceGroup);
            if (renderThreadOverlapSlice != null) {
                double renderThreadStartTime = renderThreadOverlapSlice.getStartTime();
                double renderThreadEndTime = renderThreadOverlapSlice.getEndTime();
                SliceGroup renderThreadSyncSlice = new SliceStream(renderThreadOverlapSlice.getChildren()).matchName(RenderThreadDrawNames.THREAD_SYNC.getDrawName()).findFirst();
                endTime = Math.min(endTime, renderThreadSyncSlice.getStartTime());
                for (String name : RENDER_THREAD_SYNC_ELEMENTS) {
                    renderThreadSyncSlice = new SliceStream(renderThreadOverlapSlice.getChildren()).matchName(name).findFirst();
                    if (renderThreadSyncSlice == null) continue;
                    renderThreadEndTime = renderThreadSyncSlice.getEndTime();
                    break;
                }
                frame.addSlice(renderThreadOverlapSlice, new Range(renderThreadStartTime, renderThreadEndTime), this.myThreads.getRenderThread());
            }
            frame.addSlice((SliceGroup)sliceGroup, new Range(startTime, endTime), this.myThreads.getUiThread());
            sliceRanges.add(frame);
            return true;
        });
        return sliceRanges;
    }

    private List<AtraceFrame> getRenderThreadDrivenFrames() {
        ArrayList<AtraceFrame> sliceRanges = new ArrayList<AtraceFrame>();
        if (this.myThreads.getRenderThread() == null) {
            return sliceRanges;
        }
        new SliceStream(this.myThreads.getRenderThread().getSlices()).matchName(RenderThreadDrawNames.RENDER_THREAD_INDEP.getDrawName()).enumerate(sliceGroup -> {
            AtraceFrame frame = new AtraceFrame(this.myModel);
            frame.addSlice((SliceGroup)sliceGroup, new Range(sliceGroup.getStartTime(), sliceGroup.getEndTime()), this.myThreads.getRenderThread());
            sliceRanges.add(frame);
            return true;
        });
        return sliceRanges;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/atrace/AtraceFrameFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/atrace/AtraceFrameFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUiAndRenderThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUiAndRenderThread";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class AtraceThreads {
        @NotNull
        private final ThreadModel myUiThread;
        @Nullable
        private final ThreadModel myRenderThread;

        @NotNull
        public ThreadModel getUiThread() {
            ThreadModel threadModel = this.myUiThread;
            if (threadModel == null) {
                AtraceThreads.$$$reportNull$$$0(0);
            }
            return threadModel;
        }

        @Nullable
        public ThreadModel getRenderThread() {
            return this.myRenderThread;
        }

        AtraceThreads(@NotNull ThreadModel uiThread, @Nullable ThreadModel renderThread) {
            if (uiThread == null) {
                AtraceThreads.$$$reportNull$$$0(1);
            }
            this.myUiThread = uiThread;
            this.myRenderThread = renderThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/atrace/AtraceFrameFactory$AtraceThreads";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUiThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/atrace/AtraceFrameFactory$AtraceThreads";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum RenderThreadDrawNames {
        RENDER_THREAD("DrawFrame"),
        RENDER_THREAD_INDEP("doFrame"),
        RENDER_THREAD_QUEUE("queueBuffer"),
        RENDER_THREAD_SWAP("eglSwapBuffers"),
        THREAD_SYNC("syncFrameState");

        @NotNull
        private final String myDrawName;

        private RenderThreadDrawNames(String drawName) {
            if (drawName == null) {
                RenderThreadDrawNames.$$$reportNull$$$0(0);
            }
            this.myDrawName = drawName;
        }

        @NotNull
        public String getDrawName() {
            String string = this.myDrawName;
            if (string == null) {
                RenderThreadDrawNames.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "drawName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/atrace/AtraceFrameFactory$RenderThreadDrawNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/atrace/AtraceFrameFactory$RenderThreadDrawNames";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDrawName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum UIThreadDrawType {
        LEGACY("performTraversals"),
        MARSHMALLOW("Choreographer#doFrame");

        @NotNull
        private final String myDrawName;

        private UIThreadDrawType(String drawName) {
            if (drawName == null) {
                UIThreadDrawType.$$$reportNull$$$0(0);
            }
            this.myDrawName = drawName;
        }

        @NotNull
        public String getDrawName() {
            String string = this.myDrawName;
            if (string == null) {
                UIThreadDrawType.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "drawName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/atrace/AtraceFrameFactory$UIThreadDrawType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/atrace/AtraceFrameFactory$UIThreadDrawType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDrawName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

