/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.simpleperf;

import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.cpu.nodemodel.SyscallModel;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class NodeNameParser {
    private static final Pattern NATIVE_SEPARATOR_PATTERN = Pattern.compile("::");
    private static final Pattern JAVA_SEPARATOR_PATTERN = Pattern.compile("\\.");

    static CaptureNodeModel parseNodeName(String fullName, boolean isUserWritten) {
        if (fullName.contains("(")) {
            return NodeNameParser.parseCppFunctionName(fullName, isUserWritten);
        }
        if (fullName.contains(".")) {
            ModelInfo modelInfo = NodeNameParser.createModelInfo(fullName, ".", JAVA_SEPARATOR_PATTERN);
            return new JavaMethodModel(modelInfo.getName(), modelInfo.getClassOrNamespace());
        }
        return new SyscallModel(fullName);
    }

    @NotNull
    public static CppFunctionModel parseCppFunctionName(String functionFullName, boolean isUserWritten) {
        String returnType;
        int returnTypeSeparatorIndex;
        String parameters = "";
        int paramsEndIndex = functionFullName.lastIndexOf(41);
        if (paramsEndIndex != -1) {
            int paramsStartIndex = NodeNameParser.findMatchingOpeningCharacterIndex(functionFullName, '(', ')', paramsEndIndex);
            parameters = functionFullName.substring(paramsStartIndex + 1, paramsEndIndex);
            functionFullName = functionFullName.substring(0, paramsStartIndex);
        }
        if ((returnTypeSeparatorIndex = NodeNameParser.separatorIndexOutsideOfTemplateInfo(functionFullName, " ", false)) >= 0 && !(returnType = functionFullName.substring(0, returnTypeSeparatorIndex)).equals("operator") && !returnType.endsWith("::operator")) {
            functionFullName = functionFullName.substring(returnTypeSeparatorIndex + 1);
        }
        String name = functionFullName;
        String classOrNamespace = "";
        int methodNameSeparatorIndex = NodeNameParser.separatorIndexOutsideOfTemplateInfo(functionFullName, "::", true);
        if (methodNameSeparatorIndex != -1) {
            classOrNamespace = functionFullName.substring(0, methodNameSeparatorIndex);
            name = functionFullName.substring(methodNameSeparatorIndex + 2);
        }
        CppFunctionModel cppFunctionModel = new CppFunctionModel.Builder(NodeNameParser.isOperatorOverload(name) ? name : NodeNameParser.removeTemplateInfo(name)).setClassOrNamespace(NodeNameParser.removeTemplateInfo(classOrNamespace)).setIsUserCode(isUserWritten).setParameters(NodeNameParser.removeTemplateInfo(parameters)).build();
        if (cppFunctionModel == null) {
            NodeNameParser.$$$reportNull$$$0(0);
        }
        return cppFunctionModel;
    }

    private static int separatorIndexOutsideOfTemplateInfo(String functionFullName, String separator, boolean lastIndex) {
        int open = 0;
        int lastOccurrenceIndex = -1;
        for (int index = 0; index <= functionFullName.length() - separator.length(); ++index) {
            char ch = functionFullName.charAt(index);
            if (ch == '<') {
                ++open;
                continue;
            }
            if (ch == '>') {
                --open;
                continue;
            }
            if (open != 0 || !functionFullName.startsWith(separator, index)) continue;
            if (!lastIndex) {
                return index;
            }
            lastOccurrenceIndex = index;
        }
        return lastOccurrenceIndex;
    }

    private static boolean isOperatorOverload(@NotNull String functionName) {
        if (functionName == null) {
            NodeNameParser.$$$reportNull$$$0(1);
        }
        String operator = "operator";
        if (!functionName.startsWith("operator")) {
            return false;
        }
        if ("operator".length() == functionName.length()) {
            return true;
        }
        return !NodeNameParser.isCppIdentifierChar(functionName.charAt("operator".length()));
    }

    private static boolean isCppIdentifierChar(char ch) {
        return 'a' <= ch && ch >= 'z' || 'A' <= ch && ch >= 'Z' || Character.isDigit(ch) || ch == '_';
    }

    @NotNull
    private static String removeTemplateInfo(@NotNull String functionFullName) {
        if (functionFullName == null) {
            NodeNameParser.$$$reportNull$$$0(2);
        }
        StringBuilder filteredName = new StringBuilder();
        int open = 0;
        for (int i = 0; i < functionFullName.length(); ++i) {
            char ch = functionFullName.charAt(i);
            if (ch == '<') {
                ++open;
                continue;
            }
            if (ch == '>') {
                --open;
                continue;
            }
            if (open != 0) continue;
            filteredName.append(ch);
        }
        if (open != 0) {
            throw new IllegalStateException("Native function signature must have matching parentheses and brackets.");
        }
        String string = filteredName.toString();
        if (string == null) {
            NodeNameParser.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static int findMatchingOpeningCharacterIndex(String functionName, char opening, char closing, int endIndex) {
        assert (functionName.charAt(endIndex) == closing);
        int count = 0;
        for (int i = endIndex; i >= 0; --i) {
            Character ch = Character.valueOf(functionName.charAt(i));
            if (ch.charValue() == closing) {
                ++count;
            } else if (ch.charValue() == opening) {
                --count;
            }
            if (count != 0) continue;
            return i;
        }
        throw new IllegalStateException("Native function signature must have matching parentheses and brackets.");
    }

    private static ModelInfo createModelInfo(String fullName, String separator, Pattern separatorPattern) {
        String[] splittedMethod = separatorPattern.split(fullName);
        int methodNameIndex = splittedMethod.length - 1;
        String methodName = splittedMethod[methodNameIndex];
        StringBuilder classOrNamespace = new StringBuilder(splittedMethod[0]);
        for (int i = 1; i < methodNameIndex; ++i) {
            classOrNamespace.append(separator);
            classOrNamespace.append(splittedMethod[i]);
        }
        return new ModelInfo(methodName, classOrNamespace.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/simpleperf/NodeNameParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionFullName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCppFunctionName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/simpleperf/NodeNameParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTemplateInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOperatorOverload";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeTemplateInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModelInfo {
        @NotNull
        private final String myName;
        @NotNull
        private final String myClassOrNamespace;

        public ModelInfo(@NotNull String name, @NotNull String classOrNamespace) {
            if (name == null) {
                ModelInfo.$$$reportNull$$$0(0);
            }
            if (classOrNamespace == null) {
                ModelInfo.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myClassOrNamespace = classOrNamespace;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ModelInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getClassOrNamespace() {
            String string = this.myClassOrNamespace;
            if (string == null) {
                ModelInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classOrNamespace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/simpleperf/NodeNameParser$ModelInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/simpleperf/NodeNameParser$ModelInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassOrNamespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

