/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.profiler.proto.EnergyProfiler;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class EnergyDuration
implements Comparable<EnergyDuration> {
    @NotNull
    private final ImmutableList<EnergyProfiler.EnergyEvent> myEventList;

    public EnergyDuration(@NotNull List<EnergyProfiler.EnergyEvent> eventList) {
        if (eventList == null) {
            EnergyDuration.$$$reportNull$$$0(0);
        }
        assert (!eventList.isEmpty());
        this.myEventList = ImmutableList.copyOf(eventList);
    }

    @Override
    public int compareTo(@NotNull EnergyDuration another) {
        if (another == null) {
            EnergyDuration.$$$reportNull$$$0(1);
        }
        return (int)(this.getInitialTimestamp() - another.getInitialTimestamp());
    }

    public long getInitialTimestamp() {
        return ((EnergyProfiler.EnergyEvent)this.myEventList.get(0)).getTimestamp();
    }

    @NotNull
    public String getName() {
        Kind kind = this.getKind();
        String namePart = "";
        switch (kind) {
            case WAKE_LOCK: {
                if (!((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).hasWakeLockAcquired()) break;
                namePart = EnergyDuration.getWakeLockLevelName(((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).getWakeLockAcquired().getLevel());
                break;
            }
            case ALARM: {
                if (!((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).hasAlarmSet()) break;
                namePart = EnergyDuration.getAlarmTypeName(((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).getAlarmSet().getType());
                break;
            }
            case LOCATION: {
                namePart = "Request";
                break;
            }
        }
        String string = !namePart.isEmpty() ? String.format("%s: %s", kind.getDisplayName(), namePart) : kind.getDisplayName();
        if (string == null) {
            EnergyDuration.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        switch (this.getKind()) {
            case WAKE_LOCK: {
                if (!((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).hasWakeLockAcquired()) break;
                String string = ((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).getWakeLockAcquired().getTag();
                if (string == null) {
                    EnergyDuration.$$$reportNull$$$0(3);
                }
                return string;
            }
            case ALARM: {
                if (!((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).hasAlarmSet()) break;
                EnergyProfiler.AlarmSet alarmSet = ((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).getAlarmSet();
                String string = alarmSet.hasOperation() ? alarmSet.getOperation().getCreatorPackage() : (alarmSet.hasListener() ? alarmSet.getListener().getTag() : "");
                if (string == null) {
                    EnergyDuration.$$$reportNull$$$0(4);
                }
                return string;
            }
            case JOB: {
                if (!((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).hasJobScheduled()) break;
                EnergyProfiler.JobInfo job = ((EnergyProfiler.EnergyEvent)this.getEventList().get(0)).getJobScheduled().getJob();
                String string = String.format("%d:%s", job.getJobId(), job.getServiceName());
                if (string == null) {
                    EnergyDuration.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        if ("n/a" == null) {
            EnergyDuration.$$$reportNull$$$0(6);
        }
        return "n/a";
    }

    @NotNull
    public Kind getKind() {
        Kind kind = Kind.from((EnergyProfiler.EnergyEvent)this.myEventList.get(0));
        if (kind == null) {
            EnergyDuration.$$$reportNull$$$0(7);
        }
        return kind;
    }

    @NotNull
    public ImmutableList<EnergyProfiler.EnergyEvent> getEventList() {
        ImmutableList<EnergyProfiler.EnergyEvent> immutableList = this.myEventList;
        if (immutableList == null) {
            EnergyDuration.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @NotNull
    public static List<EnergyDuration> groupById(@NotNull List<EnergyProfiler.EnergyEvent> events) {
        if (events == null) {
            EnergyDuration.$$$reportNull$$$0(9);
        }
        LinkedHashMap durationMap = new LinkedHashMap();
        for (EnergyProfiler.EnergyEvent event : events) {
            if (durationMap.containsKey(event.getEventId())) {
                ((List)durationMap.get(event.getEventId())).add(event);
                continue;
            }
            ArrayList<EnergyProfiler.EnergyEvent> list2 = new ArrayList<EnergyProfiler.EnergyEvent>();
            list2.add(event);
            durationMap.put(event.getEventId(), list2);
        }
        List<EnergyDuration> list3 = durationMap.values().stream().map(list -> new EnergyDuration((List<EnergyProfiler.EnergyEvent>)list)).collect(Collectors.toList());
        if (list3 == null) {
            EnergyDuration.$$$reportNull$$$0(10);
        }
        return list3;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(EnergyDuration.class);
        if (logger == null) {
            EnergyDuration.$$$reportNull$$$0(11);
        }
        return logger;
    }

    @NotNull
    public static String getWakeLockLevelName(@NotNull EnergyProfiler.WakeLockAcquired.Level level) {
        if (level == null) {
            EnergyDuration.$$$reportNull$$$0(12);
        }
        switch (level) {
            case FULL_WAKE_LOCK: {
                if ("Full" == null) {
                    EnergyDuration.$$$reportNull$$$0(13);
                }
                return "Full";
            }
            case PARTIAL_WAKE_LOCK: {
                if ("Partial" == null) {
                    EnergyDuration.$$$reportNull$$$0(14);
                }
                return "Partial";
            }
            case SCREEN_DIM_WAKE_LOCK: {
                if ("Screen Dim" == null) {
                    EnergyDuration.$$$reportNull$$$0(15);
                }
                return "Screen Dim";
            }
            case SCREEN_BRIGHT_WAKE_LOCK: {
                if ("Screen Bright" == null) {
                    EnergyDuration.$$$reportNull$$$0(16);
                }
                return "Screen Bright";
            }
            case PROXIMITY_SCREEN_OFF_WAKE_LOCK: {
                if ("Proximity Screen Off" == null) {
                    EnergyDuration.$$$reportNull$$$0(17);
                }
                return "Proximity Screen Off";
            }
        }
        if ("n/a" == null) {
            EnergyDuration.$$$reportNull$$$0(18);
        }
        return "n/a";
    }

    @NotNull
    public static String getAlarmTypeName(@NotNull EnergyProfiler.AlarmSet.Type type) {
        if (type == null) {
            EnergyDuration.$$$reportNull$$$0(19);
        }
        switch (type) {
            case RTC: {
                if ("RTC" == null) {
                    EnergyDuration.$$$reportNull$$$0(20);
                }
                return "RTC";
            }
            case RTC_WAKEUP: {
                if ("RTC Wakeup" == null) {
                    EnergyDuration.$$$reportNull$$$0(21);
                }
                return "RTC Wakeup";
            }
            case ELAPSED_REALTIME: {
                if ("Elapsed Realtime" == null) {
                    EnergyDuration.$$$reportNull$$$0(22);
                }
                return "Elapsed Realtime";
            }
            case ELAPSED_REALTIME_WAKEUP: {
                if ("Elapsed Realtime Wakeup" == null) {
                    EnergyDuration.$$$reportNull$$$0(23);
                }
                return "Elapsed Realtime Wakeup";
            }
        }
        if ("n/a" == null) {
            EnergyDuration.$$$reportNull$$$0(24);
        }
        return "n/a";
    }

    @NotNull
    public static String getMetadataName(EnergyProfiler.EnergyEvent.MetadataCase metadataCase) {
        switch (metadataCase) {
            case WAKE_LOCK_ACQUIRED: {
                if ("Acquired" == null) {
                    EnergyDuration.$$$reportNull$$$0(25);
                }
                return "Acquired";
            }
            case WAKE_LOCK_RELEASED: {
                if ("Released" == null) {
                    EnergyDuration.$$$reportNull$$$0(26);
                }
                return "Released";
            }
            case ALARM_SET: {
                if ("Set" == null) {
                    EnergyDuration.$$$reportNull$$$0(27);
                }
                return "Set";
            }
            case ALARM_FIRED: {
                if ("Triggered" == null) {
                    EnergyDuration.$$$reportNull$$$0(28);
                }
                return "Triggered";
            }
            case ALARM_CANCELLED: {
                if ("Cancelled" == null) {
                    EnergyDuration.$$$reportNull$$$0(29);
                }
                return "Cancelled";
            }
            case JOB_SCHEDULED: {
                if ("Scheduled" == null) {
                    EnergyDuration.$$$reportNull$$$0(30);
                }
                return "Scheduled";
            }
            case JOB_STARTED: {
                if ("Started" == null) {
                    EnergyDuration.$$$reportNull$$$0(31);
                }
                return "Started";
            }
            case JOB_STOPPED: {
                if ("Stopped" == null) {
                    EnergyDuration.$$$reportNull$$$0(32);
                }
                return "Stopped";
            }
            case JOB_FINISHED: {
                if ("Finished" == null) {
                    EnergyDuration.$$$reportNull$$$0(33);
                }
                return "Finished";
            }
            case LOCATION_UPDATE_REQUESTED: {
                if ("Requested" == null) {
                    EnergyDuration.$$$reportNull$$$0(34);
                }
                return "Requested";
            }
            case LOCATION_CHANGED: {
                if ("Location Updated" == null) {
                    EnergyDuration.$$$reportNull$$$0(35);
                }
                return "Location Updated";
            }
            case LOCATION_UPDATE_REMOVED: {
                if ("Request Removed" == null) {
                    EnergyDuration.$$$reportNull$$$0(36);
                }
                return "Request Removed";
            }
        }
        if ("" == null) {
            EnergyDuration.$$$reportNull$$$0(37);
        }
        return "";
    }

    @NotNull
    public String getCalledByTraceId() {
        String string = this.getEventList().stream().filter(e -> !e.getTraceId().isEmpty()).map(e -> e.getTraceId()).findFirst().orElse("");
        if (string == null) {
            EnergyDuration.$$$reportNull$$$0(38);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnergyDuration duration = (EnergyDuration)o;
        return this.myEventList.equals(duration.myEventList);
    }

    public int hashCode() {
        return Objects.hash(this.myEventList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/energy/EnergyDuration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/energy/EnergyDuration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "groupById";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getWakeLockLevelName";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlarmTypeName";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadataName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCalledByTraceId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "groupById";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getWakeLockLevelName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAlarmTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Kind {
        UNKNOWN("n/a"),
        WAKE_LOCK("Wake Lock"),
        ALARM("Alarm"),
        JOB("Job"),
        LOCATION("Location");

        @NotNull
        private final String myDisplayName;

        @NotNull
        public static Kind from(@NotNull EnergyProfiler.EnergyEvent event) {
            if (event == null) {
                Kind.$$$reportNull$$$0(0);
            }
            switch (event.getMetadataCase()) {
                case WAKE_LOCK_ACQUIRED: 
                case WAKE_LOCK_RELEASED: {
                    Kind kind = WAKE_LOCK;
                    if (kind == null) {
                        Kind.$$$reportNull$$$0(1);
                    }
                    return kind;
                }
                case ALARM_SET: 
                case ALARM_FIRED: 
                case ALARM_CANCELLED: {
                    Kind kind = ALARM;
                    if (kind == null) {
                        Kind.$$$reportNull$$$0(2);
                    }
                    return kind;
                }
                case JOB_SCHEDULED: 
                case JOB_STARTED: 
                case JOB_STOPPED: 
                case JOB_FINISHED: {
                    Kind kind = JOB;
                    if (kind == null) {
                        Kind.$$$reportNull$$$0(3);
                    }
                    return kind;
                }
                case LOCATION_UPDATE_REQUESTED: 
                case LOCATION_UPDATE_REMOVED: 
                case LOCATION_CHANGED: {
                    Kind kind = LOCATION;
                    if (kind == null) {
                        Kind.$$$reportNull$$$0(4);
                    }
                    return kind;
                }
            }
            EnergyDuration.getLogger().warn("Unsupported Kind for " + event.getMetadataCase().name());
            Kind kind = UNKNOWN;
            if (kind == null) {
                Kind.$$$reportNull$$$0(5);
            }
            return kind;
        }

        private Kind(String displayName) {
            if (displayName == null) {
                Kind.$$$reportNull$$$0(6);
            }
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName;
            if (string == null) {
                Kind.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/energy/EnergyDuration$Kind";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/energy/EnergyDuration$Kind";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

