/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.ProfilerClient;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class EnergyUsageDataSeries
implements DataSeries<Long> {
    @NotNull
    private final ProfilerClient myClient;
    private final Common.Session mySession;
    @NotNull
    private final Function<EnergyProfiler.EnergySample, Integer> mySampleToUsage;

    private static int getTotalUsage(@NotNull EnergyProfiler.EnergySample sample) {
        if (sample == null) {
            EnergyUsageDataSeries.$$$reportNull$$$0(0);
        }
        return sample.getCpuUsage() + sample.getNetworkUsage() + sample.getLocationUsage();
    }

    EnergyUsageDataSeries(@NotNull ProfilerClient client, Common.Session session) {
        if (client == null) {
            EnergyUsageDataSeries.$$$reportNull$$$0(1);
        }
        this(client, session, EnergyUsageDataSeries::getTotalUsage);
    }

    EnergyUsageDataSeries(@NotNull ProfilerClient client, Common.Session session, @NotNull Function<EnergyProfiler.EnergySample, Integer> sampleToUsage) {
        if (client == null) {
            EnergyUsageDataSeries.$$$reportNull$$$0(2);
        }
        if (sampleToUsage == null) {
            EnergyUsageDataSeries.$$$reportNull$$$0(3);
        }
        this.myClient = client;
        this.mySession = session;
        this.mySampleToUsage = sampleToUsage;
    }

    public List<SeriesData<Long>> getDataForXRange(Range range) {
        EnergyProfiler.EnergyRequest.Builder builder = EnergyProfiler.EnergyRequest.newBuilder().setSession(this.mySession);
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        builder.setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)range.getMin()) - bufferNs);
        builder.setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)range.getMax()) + bufferNs);
        EnergyProfiler.EnergySamplesResponse samples = this.myClient.getEnergyClient().getSamples(builder.build());
        return samples.getSamplesList().stream().map(data -> new SeriesData(TimeUnit.NANOSECONDS.toMicros(data.getTimestamp()), (Object)this.mySampleToUsage.apply((EnergyProfiler.EnergySample)data))).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleToUsage";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/energy/EnergyUsageDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTotalUsage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

