/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.event.ActivityAction;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerMonitorTooltipView;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.event.EventActivityTooltip;
import com.android.tools.profilers.event.EventMonitor;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EventActivityTooltipView
extends ProfilerMonitorTooltipView<EventMonitor> {
    @VisibleForTesting
    protected JLabel myDurationLabel;
    @NotNull
    private final EventActivityTooltip myActivityTooltip;
    @VisibleForTesting
    protected JLabel myContentLabel;

    public EventActivityTooltipView(StageView parent, @NotNull EventActivityTooltip tooltip) {
        if (tooltip == null) {
            EventActivityTooltipView.$$$reportNull$$$0(0);
        }
        super(tooltip.getMonitor());
        this.myActivityTooltip = tooltip;
        ((EventMonitor)((Object)this.getMonitor())).getProfilers().getTimeline().getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::timeChanged);
        ((EventMonitor)((Object)this.getMonitor())).getProfilers().getTimeline().getTooltipRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::timeChanged);
    }

    @Override
    public void dispose() {
        super.dispose();
        ((EventMonitor)((Object)this.getMonitor())).getProfilers().getTimeline().getDataRange().removeDependencies((AspectObserver)this);
    }

    private void timeChanged() {
        ProfilerTimeline timeline = ((EventMonitor)((Object)this.getMonitor())).getProfilers().getTimeline();
        Range dataRange = timeline.getDataRange();
        Range range = timeline.getTooltipRange();
        if (!range.isEmpty()) {
            this.showStackedEventInfo(timeline, dataRange, range);
        }
    }

    private void clearTooltipInfo() {
        this.myDurationLabel.setText("");
    }

    private void showStackedEventInfo(ProfilerTimeline timeline, Range dataRange, Range range) {
        ActivityAction activity = this.myActivityTooltip.getActivityAt(range.getMin());
        if (activity != null) {
            double endTime = activity.getEndUs() == 0L ? dataRange.getMax() : (double)activity.getEndUs();
            this.setTimelineText(timeline.getDataRange(), activity.getStartUs(), endTime);
            this.myContentLabel.setText(activity.getData());
        } else {
            this.clearTooltipInfo();
        }
    }

    private void setTimelineText(Range dataRange, double startTime, double endTime) {
        String startTimeString = TimeFormatter.getSemiSimplifiedClockString((long)((long)(startTime - dataRange.getMin())));
        String endTimeString = TimeFormatter.getSemiSimplifiedClockString((long)((long)(endTime - dataRange.getMin())));
        this.myDurationLabel.setText(String.format("%s - %s", startTimeString, endTimeString));
    }

    @Override
    @NotNull
    public JComponent createTooltip() {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*"));
        panel.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        this.myContentLabel = new JLabel();
        panel.add((Component)this.myContentLabel, new TabularLayout.Constraint(0, 0));
        this.myDurationLabel = new JLabel();
        this.myDurationLabel.setForeground(Color.GRAY);
        this.myDurationLabel.setFont(this.myFont);
        panel.add((Component)this.myDurationLabel, new TabularLayout.Constraint(1, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            EventActivityTooltipView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/event/EventActivityTooltipView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/event/EventActivityTooltipView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

