/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureEntry;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.HeapDumpCaptureObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HeapDumpSampleDataSeries
extends CaptureDataSeries<CaptureObject> {
    public HeapDumpSampleDataSeries(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @Nullable Common.Session session, @NotNull FeatureTracker featureTracker) {
        if (client == null) {
            HeapDumpSampleDataSeries.$$$reportNull$$$0(0);
        }
        if (featureTracker == null) {
            HeapDumpSampleDataSeries.$$$reportNull$$$0(1);
        }
        super(client, session, featureTracker);
    }

    public List<SeriesData<CaptureDurationData<CaptureObject>>> getDataForXRange(Range xRange) {
        long rangeMin = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMin());
        long rangeMax = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMax());
        MemoryProfiler.ListHeapDumpInfosResponse response = this.myClient.listHeapDumpInfos(MemoryProfiler.ListDumpInfosRequest.newBuilder().setSession(this.mySession).setStartTime(rangeMin).setEndTime(rangeMax).build());
        ArrayList<SeriesData<CaptureDurationData<CaptureObject>>> seriesData = new ArrayList<SeriesData<CaptureDurationData<CaptureObject>>>();
        for (MemoryProfiler.HeapDumpInfo info : response.getInfosList()) {
            seriesData.add((SeriesData<CaptureDurationData<CaptureObject>>)new SeriesData(HeapDumpSampleDataSeries.getHostTime(info.getStartTime()), new CaptureDurationData<CaptureObject>(HeapDumpSampleDataSeries.getDurationUs(info.getStartTime(), info.getEndTime()), false, false, new CaptureEntry<CaptureObject>(info, () -> new HeapDumpCaptureObject(this.myClient, this.mySession, info, null, this.myFeatureTracker)))));
        }
        return seriesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "client";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "featureTracker";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/memory/HeapDumpSampleDataSeries";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

