/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.AllocationInfosDataSeries;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MemoryProfiler
extends StudioProfiler {
    @NotNull
    private final AspectObserver myAspectObserver;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryProfiler.class);
    }

    public MemoryProfiler(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            MemoryProfiler.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myAspectObserver = new AspectObserver();
        this.myProfilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        sessionsManager.registerImportHandler("hprof", file -> {
            byte[] bytes;
            long startTimestampEpochMs = System.currentTimeMillis();
            long fileCreationTime = TimeUnit.MILLISECONDS.toNanos(startTimestampEpochMs);
            try {
                BasicFileAttributes attributes = Files.readAttributes(Paths.get(file.getPath(), new String[0]), BasicFileAttributes.class, new LinkOption[0]);
                fileCreationTime = TimeUnit.MILLISECONDS.toNanos(attributes.creationTime().toMillis());
            }
            catch (IOException e) {
                MemoryProfiler.getLogger().info("File creation time not provided, using system time instead...");
            }
            try {
                bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
            }
            catch (IOException e) {
                MemoryProfiler.getLogger().error("Importing Session Failed: can not read from file location...");
                return;
            }
            Common.Session session = sessionsManager.createImportedSession(file.getName(), Common.SessionMetaData.SessionType.MEMORY_CAPTURE, fileCreationTime, fileCreationTime + 1L, startTimestampEpochMs);
            MemoryProfiler.HeapDumpInfo heapDumpInfo = MemoryProfiler.HeapDumpInfo.newBuilder().setFileName(file.getName()).setStartTime(fileCreationTime).setEndTime(fileCreationTime + 1L).build();
            MemoryProfiler.ImportHeapDumpRequest heapDumpRequest = MemoryProfiler.ImportHeapDumpRequest.newBuilder().setSession(session).setData(ByteString.copyFrom((byte[])bytes)).setInfo(heapDumpInfo).build();
            MemoryProfiler.ImportHeapDumpResponse response = this.myProfilers.getClient().getMemoryClient().importHeapDump(heapDumpRequest);
            if (response.getStatus() == MemoryProfiler.ImportHeapDumpResponse.Status.SUCCESS) {
                sessionsManager.update();
                sessionsManager.setSession(session);
            } else {
                Logger.getInstance(this.getClass()).error("Importing Session Failed: can not import heap dump...");
            }
            this.myProfilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
        });
        this.myProfilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.MEMORY_CAPTURE, () -> {
            MemoryProfilerStage stage = new MemoryProfilerStage(this.myProfilers);
            this.myProfilers.setStage(stage);
            stage.setPendingCaptureStartTime(this.myProfilers.getSession().getStartTimestamp());
            ProfilerTimeline timeline = this.myProfilers.getTimeline();
            timeline.reset(this.myProfilers.getSession().getStartTimestamp(), this.myProfilers.getSession().getEndTimestamp());
            timeline.getViewRange().set(timeline.getDataRange());
            timeline.setIsPaused(true);
        });
    }

    @Override
    public ProfilerMonitor newMonitor() {
        return new MemoryMonitor(this.myProfilers);
    }

    @Override
    public void startProfiling(Common.Session session) {
        this.myProfilers.getClient().getMemoryClient().startMonitoringApp(MemoryProfiler.MemoryStartRequest.newBuilder().setSession(session).build());
    }

    @Override
    public void stopProfiling(Common.Session session) {
        try {
            Profiler.GetSessionMetaDataResponse response = this.myProfilers.getClient().getProfilerClient().getSessionMetaData(Profiler.GetSessionMetaDataRequest.newBuilder().setSessionId(session.getSessionId()).build());
            if (response.getData().getLiveAllocationEnabled() && MemoryProfiler.isUsingLiveAllocation(this.myProfilers, session)) {
                this.myProfilers.getClient().getMemoryClient().trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setSession(session).setEnabled(false).build());
            }
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.getLogger().info((Throwable)e);
        }
        this.myProfilers.getClient().getMemoryClient().stopMonitoringApp(MemoryProfiler.MemoryStopRequest.newBuilder().setSession(session).build());
    }

    private void agentStatusChanged() {
        Common.Session session = this.myProfilers.getSession();
        if (Common.Session.getDefaultInstance().equals((Object)session) || session.getEndTimestamp() != Long.MAX_VALUE) {
            return;
        }
        Profiler.GetSessionMetaDataResponse response = this.myProfilers.getClient().getProfilerClient().getSessionMetaData(Profiler.GetSessionMetaDataRequest.newBuilder().setSessionId(session.getSessionId()).build());
        if (!response.getData().getLiveAllocationEnabled()) {
            return;
        }
        if (MemoryProfiler.isUsingLiveAllocation(this.myProfilers, session)) {
            return;
        }
        if (!this.myProfilers.isAgentAttached()) {
            return;
        }
        Profiler.TimeResponse timeResponse = this.myProfilers.getClient().getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setDeviceId(session.getDeviceId()).build());
        long timeNs = timeResponse.getTimestampNs();
        try {
            this.myProfilers.getClient().getMemoryClient().trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setRequestTime(timeNs).setSession(session).setEnabled(false).build());
            this.myProfilers.getClient().getMemoryClient().trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setRequestTime(timeNs).setSession(session).setEnabled(true).build());
        }
        catch (StatusRuntimeException e) {
            MemoryProfiler.getLogger().info((Throwable)e);
        }
    }

    static boolean isUsingLiveAllocation(@NotNull StudioProfilers profilers, @NotNull Common.Session session) {
        long rangeMax;
        Range dataRange;
        long rangeMin;
        AllocationInfosDataSeries allocationSeries;
        List<MemoryProfiler.AllocationsInfo> series;
        if (profilers == null) {
            MemoryProfiler.$$$reportNull$$$0(1);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(2);
        }
        if (!(series = (allocationSeries = new AllocationInfosDataSeries(profilers.getClient().getMemoryClient(), session, profilers.getIdeServices().getFeatureTracker(), null)).getInfoForTimeRangeNs(rangeMin = TimeUnit.MICROSECONDS.toNanos((long)(dataRange = profilers.getTimeline().getDataRange()).getMin()), rangeMax = TimeUnit.MICROSECONDS.toNanos((long)dataRange.getMax()))).isEmpty() && !series.get(0).getLegacy()) {
            assert (series.size() == 1);
            return true;
        }
        return false;
    }

    public static void saveHeapDumpToFile(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, @NotNull MemoryProfiler.HeapDumpInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        MemoryProfiler.DumpDataResponse response;
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(3);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(4);
        }
        if (info == null) {
            MemoryProfiler.$$$reportNull$$$0(5);
        }
        if (outputStream == null) {
            MemoryProfiler.$$$reportNull$$$0(6);
        }
        if (featureTracker == null) {
            MemoryProfiler.$$$reportNull$$$0(7);
        }
        if ((response = client.getHeapDump(MemoryProfiler.DumpDataRequest.newBuilder().setSession(session).setDumpTime(info.getStartTime()).build())).getStatus() == MemoryProfiler.DumpDataResponse.Status.SUCCESS) {
            try {
                response.getData().writeTo(outputStream);
                featureTracker.trackExportHeap();
            }
            catch (IOException exception) {
                MemoryProfiler.getLogger().warn("Failed to export heap dump file:\n" + exception);
            }
        }
    }

    public static void saveLegacyAllocationToFile(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, @NotNull MemoryProfiler.AllocationsInfo info, @NotNull OutputStream outputStream, @NotNull FeatureTracker featureTracker) {
        MemoryProfiler.DumpDataResponse response;
        if (client == null) {
            MemoryProfiler.$$$reportNull$$$0(8);
        }
        if (session == null) {
            MemoryProfiler.$$$reportNull$$$0(9);
        }
        if (info == null) {
            MemoryProfiler.$$$reportNull$$$0(10);
        }
        if (outputStream == null) {
            MemoryProfiler.$$$reportNull$$$0(11);
        }
        if (featureTracker == null) {
            MemoryProfiler.$$$reportNull$$$0(12);
        }
        if ((response = client.getLegacyAllocationDump(MemoryProfiler.DumpDataRequest.newBuilder().setSession(session).setDumpTime(info.getStartTime()).build())).getStatus() == MemoryProfiler.DumpDataResponse.Status.SUCCESS) {
            try {
                response.getData().writeTo(outputStream);
                featureTracker.trackExportAllocation();
            }
            catch (IOException exception) {
                MemoryProfiler.getLogger().warn("Failed to export allocation records:\n" + exception);
            }
        }
    }

    @NotNull
    static String generateCaptureFileName() {
        StringBuilder builder = new StringBuilder("memory-");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        builder.append(LocalDateTime.now().format(formatter));
        String string = builder.toString();
        if (string == null) {
            MemoryProfiler.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfiler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCaptureFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUsingLiveAllocation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveHeapDumpToFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveLegacyAllocationToFile";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

