/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.FilterComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.SelectionComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.chart.linechart.OverlayComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.instructions.IconInstruction;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.FilterModel;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerAction;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.event.EventActivityTooltip;
import com.android.tools.profilers.event.EventActivityTooltipView;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.EventSimpleEventTooltip;
import com.android.tools.profilers.event.EventSimpleEventTooltipView;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.MemoryCaptureView;
import com.android.tools.profilers.memory.MemoryClassGrouping;
import com.android.tools.profilers.memory.MemoryClassSetView;
import com.android.tools.profilers.memory.MemoryClassifierView;
import com.android.tools.profilers.memory.MemoryHeapView;
import com.android.tools.profilers.memory.MemoryInstanceDetailsView;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryUsageTooltip;
import com.android.tools.profilers.memory.MemoryUsageTooltipView;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.Gray;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public class MemoryProfilerStageView
extends StageView<MemoryProfilerStage> {
    private static final String RECORD_TEXT = "Record";
    private static final String STOP_TEXT = "Stop";
    @NotNull
    private final MemoryCaptureView myCaptureView;
    @NotNull
    private final MemoryHeapView myHeapView;
    @NotNull
    private final MemoryClassifierView myClassifierView;
    @NotNull
    private final MemoryClassGrouping myClassGrouping;
    @NotNull
    private final MemoryClassSetView myClassSetView;
    @NotNull
    private final MemoryInstanceDetailsView myInstanceDetailsView;
    @Nullable
    private SelectionComponent mySelectionComponent;
    @Nullable
    private CaptureObject myCaptureObject;
    @NotNull
    private final JBSplitter myMainSplitter;
    @NotNull
    private final JBSplitter myChartCaptureSplitter;
    @NotNull
    private final JPanel myCapturePanel;
    @Nullable
    private LoadingPanel myCaptureLoadingPanel;
    @NotNull
    private final JBSplitter myInstanceDetailsSplitter;
    @NotNull
    private JButton myForceGarbageCollectionButton;
    @NotNull
    private JButton myHeapDumpButton;
    @NotNull
    private JButton myAllocationButton;
    @NotNull
    private ProfilerAction myForceGarbageCollectionAction;
    @NotNull
    private ProfilerAction myHeapDumpAction;
    @NotNull
    private ProfilerAction myAllocationAction;
    @NotNull
    private ProfilerAction myStopAllocationAction;
    @NotNull
    private final JLabel myCaptureElapsedTime;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryProfilerStageView.class);
    }

    public MemoryProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull MemoryProfilerStage stage) {
        if (profilersView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(1);
        }
        super(profilersView, stage);
        this.myCaptureView = new MemoryCaptureView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
        this.myHeapView = new MemoryHeapView((MemoryProfilerStage)this.getStage());
        this.myClassifierView = new MemoryClassifierView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
        this.myClassGrouping = new MemoryClassGrouping((MemoryProfilerStage)this.getStage());
        this.myClassSetView = new MemoryClassSetView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
        this.myInstanceDetailsView = new MemoryInstanceDetailsView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
        this.myCaptureObject = null;
        this.myMainSplitter = new JBSplitter(false);
        this.myChartCaptureSplitter = new JBSplitter(true);
        this.myInstanceDetailsSplitter = new JBSplitter(true);
        ((MemoryProfilerStage)this.getStage()).enableSelectLatestCapture(true, SwingUtilities::invokeLater);
        this.getTooltipBinder().bind(MemoryUsageTooltip.class, MemoryUsageTooltipView::new);
        this.getTooltipBinder().bind(EventActivityTooltip.class, EventActivityTooltipView::new);
        this.getTooltipBinder().bind(EventSimpleEventTooltip.class, EventSimpleEventTooltipView::new);
        this.myMainSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        this.myChartCaptureSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        this.myInstanceDetailsSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        if (!((MemoryProfilerStage)this.getStage()).isMemoryCaptureOnly()) {
            this.myChartCaptureSplitter.setFirstComponent((JComponent)this.buildMonitorUi());
        }
        this.myCapturePanel = this.buildCaptureUi();
        this.myInstanceDetailsSplitter.setOpaque(true);
        this.myInstanceDetailsSplitter.setFirstComponent(this.myClassSetView.getComponent());
        this.myInstanceDetailsSplitter.setSecondComponent(this.myInstanceDetailsView.getComponent());
        this.myMainSplitter.setFirstComponent((JComponent)this.myChartCaptureSplitter);
        this.myMainSplitter.setSecondComponent((JComponent)this.myInstanceDetailsSplitter);
        this.myMainSplitter.setProportion(0.6f);
        this.getComponent().add((Component)this.myMainSplitter, "Center");
        this.myForceGarbageCollectionButton = new CommonButton(StudioIcons.Profiler.Toolbar.FORCE_GARBAGE_COLLECTION);
        this.myForceGarbageCollectionButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.FORCE_GARBAGE_COLLECTION));
        this.myForceGarbageCollectionButton.addActionListener(e -> {
            ((MemoryProfilerStage)this.getStage()).forceGarbageCollection();
            ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackForceGc();
        });
        this.myForceGarbageCollectionAction = new ProfilerAction.Builder("Force garbage collection").setContainerComponent(this.getComponent()).setIcon(this.myForceGarbageCollectionButton.getIcon()).setActionRunnable(() -> this.myForceGarbageCollectionButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(71, AdtUiUtils.getActionMask())).build();
        this.myForceGarbageCollectionButton.setToolTipText(this.myForceGarbageCollectionAction.getDefaultToolTipText());
        this.myHeapDumpButton = new CommonButton(StudioIcons.Profiler.Toolbar.HEAP_DUMP);
        this.myHeapDumpButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.HEAP_DUMP));
        this.myHeapDumpButton.addActionListener(e -> {
            ((MemoryProfilerStage)this.getStage()).requestHeapDump();
            ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackDumpHeap();
        });
        this.myHeapDumpAction = new ProfilerAction.Builder("Dump Java heap").setContainerComponent(this.getComponent()).setIcon(this.myHeapDumpButton.getIcon()).setActionRunnable(() -> this.myHeapDumpButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(68, AdtUiUtils.getActionMask())).build();
        this.myHeapDumpButton.setToolTipText(this.myHeapDumpAction.getDefaultToolTipText());
        this.myCaptureElapsedTime = new JLabel("");
        this.myCaptureElapsedTime.setFont(ProfilerFonts.STANDARD_FONT);
        this.myCaptureElapsedTime.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.myCaptureElapsedTime.setForeground(ProfilerColors.CPU_CAPTURE_STATUS);
        this.myAllocationButton = new JButton(RECORD_TEXT);
        this.myAllocationButton.setPreferredSize(this.myAllocationButton.getPreferredSize());
        this.myAllocationButton.addActionListener(e -> {
            if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations()) {
                ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackRecordAllocations();
            }
            ((MemoryProfilerStage)this.getStage()).trackAllocations(!((MemoryProfilerStage)this.getStage()).isTrackingAllocations());
        });
        this.myAllocationButton.setVisible(!((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking());
        this.myAllocationAction = new ProfilerAction.Builder("Record allocations").setIcon(StudioIcons.Profiler.Toolbar.RECORD).setContainerComponent(this.getComponent()).setEnableBooleanSupplier(() -> !((MemoryProfilerStage)this.getStage()).isTrackingAllocations()).setActionRunnable(() -> this.myAllocationButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(82, AdtUiUtils.getActionMask())).build();
        this.myStopAllocationAction = new ProfilerAction.Builder("Stop recording").setIcon(StudioIcons.Profiler.Toolbar.STOP_RECORDING).setContainerComponent(this.getComponent()).setEnableBooleanSupplier(() -> ((MemoryProfilerStage)this.getStage()).isTrackingAllocations()).setActionRunnable(() -> this.myAllocationButton.doClick(0)).setKeyStrokes(KeyStroke.getKeyStroke(83, AdtUiUtils.getActionMask())).build();
        ((MemoryProfilerStage)this.getStage()).getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADING_CAPTURE, this::captureObjectChanged).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE, this::captureObjectFinishedLoading).onChange((Enum)MemoryProfilerAspect.TRACKING_ENABLED, this::allocationTrackingChanged).onChange((Enum)MemoryProfilerAspect.CURRENT_CAPTURE_ELAPSED_TIME, this::updateCaptureElapsedTime);
        this.captureObjectChanged();
        this.allocationTrackingChanged();
        this.buildContextMenu();
    }

    @Override
    public boolean isToolbarVisible() {
        return !((MemoryProfilerStage)this.getStage()).isMemoryCaptureOnly();
    }

    @Override
    public JComponent getToolbar() {
        JPanel toolBar = new JPanel(ProfilerLayout.createToolbarLayout());
        toolBar.add(this.myForceGarbageCollectionButton);
        toolBar.add(this.myHeapDumpButton);
        toolBar.add(this.myAllocationButton);
        toolBar.add(this.myCaptureElapsedTime);
        StudioProfilers profilers = ((MemoryProfilerStage)this.getStage()).getStudioProfilers();
        Runnable toggleButtons = () -> {
            boolean isAlive = profilers.getSessionsManager().isSessionAlive();
            this.myForceGarbageCollectionButton.setEnabled(isAlive);
            this.myHeapDumpButton.setEnabled(isAlive);
            this.myAllocationButton.setEnabled(isAlive);
        };
        profilers.getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, toggleButtons);
        toggleButtons.run();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolBar, "West");
        return panel;
    }

    @VisibleForTesting
    @NotNull
    public Splitter getMainSplitter() {
        JBSplitter jBSplitter = this.myMainSplitter;
        if (jBSplitter == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(2);
        }
        return jBSplitter;
    }

    @VisibleForTesting
    @NotNull
    public Splitter getChartCaptureSplitter() {
        JBSplitter jBSplitter = this.myChartCaptureSplitter;
        if (jBSplitter == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(3);
        }
        return jBSplitter;
    }

    @VisibleForTesting
    @NotNull
    public JPanel getCapturePanel() {
        JPanel jPanel = this.myCapturePanel;
        if (jPanel == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @VisibleForTesting
    @NotNull
    MemoryCaptureView getCaptureView() {
        MemoryCaptureView memoryCaptureView = this.myCaptureView;
        if (memoryCaptureView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(5);
        }
        return memoryCaptureView;
    }

    @VisibleForTesting
    @NotNull
    MemoryHeapView getHeapView() {
        MemoryHeapView memoryHeapView = this.myHeapView;
        if (memoryHeapView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(6);
        }
        return memoryHeapView;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassGrouping getClassGrouping() {
        MemoryClassGrouping memoryClassGrouping = this.myClassGrouping;
        if (memoryClassGrouping == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(7);
        }
        return memoryClassGrouping;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassifierView getClassifierView() {
        MemoryClassifierView memoryClassifierView = this.myClassifierView;
        if (memoryClassifierView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(8);
        }
        return memoryClassifierView;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassSetView getClassSetView() {
        MemoryClassSetView memoryClassSetView = this.myClassSetView;
        if (memoryClassSetView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(9);
        }
        return memoryClassSetView;
    }

    @VisibleForTesting
    @NotNull
    MemoryInstanceDetailsView getInstanceDetailsView() {
        MemoryInstanceDetailsView memoryInstanceDetailsView = this.myInstanceDetailsView;
        if (memoryInstanceDetailsView == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(10);
        }
        return memoryInstanceDetailsView;
    }

    @VisibleForTesting
    @Nullable
    SelectionComponent getSelectionComponent() {
        return this.mySelectionComponent;
    }

    @VisibleForTesting
    @NotNull
    JLabel getCaptureElapsedTimeLabel() {
        JLabel jLabel = this.myCaptureElapsedTime;
        if (jLabel == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(11);
        }
        return jLabel;
    }

    private void allocationTrackingChanged() {
        if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations()) {
            this.myAllocationButton.setText(STOP_TEXT);
            this.myAllocationButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.STOP_RECORDING));
            this.myAllocationButton.setToolTipText("Stop recording");
            this.myCaptureElapsedTime.setText(TimeFormatter.getSemiSimplifiedClockString((long)0L));
        } else {
            this.myCaptureElapsedTime.setText("");
            this.myAllocationButton.setText(RECORD_TEXT);
            this.myAllocationButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.RECORD));
            this.myAllocationButton.setToolTipText("Record memory allocations");
        }
    }

    private void updateCaptureElapsedTime() {
        if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations() && !((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            long elapsedTimeUs = TimeUnit.NANOSECONDS.toMicros(((MemoryProfilerStage)this.getStage()).getAllocationTrackingElapsedTimeNs());
            this.myCaptureElapsedTime.setText(TimeFormatter.getSemiSimplifiedClockString((long)elapsedTimeUs));
        }
    }

    @NotNull
    private JPanel buildMonitorUi() {
        StudioProfilers profilers = ((MemoryProfilerStage)this.getStage()).getStudioProfilers();
        ProfilerTimeline timeline = profilers.getTimeline();
        Range viewRange = this.getTimeline().getViewRange();
        this.mySelectionComponent = new SelectionComponent(((MemoryProfilerStage)this.getStage()).getSelectionModel(), timeline.getViewRange());
        this.mySelectionComponent.setCursorSetter(ProfilerLayeredPane::setCursorOnProfilerLayeredPane);
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> this.mySelectionComponent.getMode() != SelectionComponent.Mode.MOVE);
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel = new JBPanel((LayoutManager)layout);
        panel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        panel.add((Component)tooltip, new TabularLayout.Constraint(0, 0, 2, 1));
        ProfilerScrollbar sb = new ProfilerScrollbar(timeline, (JComponent)panel);
        panel.add((Component)((Object)sb), new TabularLayout.Constraint(3, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        panel.add((Component)timeAxis, new TabularLayout.Constraint(2, 0));
        EventMonitorView eventsView = new EventMonitorView(this.getProfilersView(), ((MemoryProfilerStage)this.getStage()).getEventMonitor());
        panel.add((Component)eventsView.getComponent(), new TabularLayout.Constraint(0, 0));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        JLabel label = new JLabel(((MemoryProfilerStage)this.getStage()).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        DetailedMemoryUsage memoryUsage = ((MemoryProfilerStage)this.getStage()).getDetailedMemoryUsage();
        LineChart lineChart = new LineChart((LineChartModel)memoryUsage);
        if (((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_JAVA_CAPTURED, memoryUsage.getJavaSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_NATIVE_CAPTURED, memoryUsage.getNativeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_GRAPHICS_CAPTURED, memoryUsage.getGraphicsSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_STACK_CAPTURED, memoryUsage.getStackSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_CODE_CAPTURED, memoryUsage.getCodeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_OTHERS_CAPTURED, memoryUsage.getOtherSeries());
            lineChart.configure(memoryUsage.getObjectsSeries(), new LineConfig(ProfilerColors.MEMORY_OBJECTS_CAPTURED).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        } else {
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_JAVA, memoryUsage.getJavaSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_NATIVE, memoryUsage.getNativeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_GRAPHICS, memoryUsage.getGraphicsSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_STACK, memoryUsage.getStackSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_CODE, memoryUsage.getCodeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_OTHERS, memoryUsage.getOtherSeries());
            lineChart.configure(memoryUsage.getObjectsSeries(), new LineConfig(ProfilerColors.MEMORY_OBJECTS).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        }
        lineChart.configure(memoryUsage.getTotalMemorySeries(), new LineConfig(new Color(0, 0, 0, 0)));
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChart.setTopPadding(ProfilerLayout.Y_AXIS_TOP_MARGIN);
        lineChart.setFillEndGap(true);
        DurationDataRenderer gcRenderer = new DurationDataRenderer.Builder(memoryUsage.getGcDurations(), Color.BLACK).setIcon(StudioIcons.Profiler.Events.GARBAGE_EVENT).setLabelOffsets((float)(-StudioIcons.Profiler.Events.GARBAGE_EVENT.getIconWidth()) / 2.0f, (float)StudioIcons.Profiler.Events.GARBAGE_EVENT.getIconHeight() / 2.0f + (float)ProfilerLayout.Y_AXIS_TOP_MARGIN).setHoverHandler(arg_0 -> ((MemoryProfilerStage)this.getStage()).getTooltipLegends().getGcDurationLegend().setPickData(arg_0)).setClickRegionPadding(0, 0).build();
        lineChart.addCustomRenderer((LineChartCustomRenderer)gcRenderer);
        JBPanel overlayPanel = new JBPanel((LayoutManager)new BorderLayout());
        overlayPanel.setOpaque(false);
        overlayPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        OverlayComponent overlay = new OverlayComponent((Component)this.mySelectionComponent);
        overlay.addDurationDataRenderer(gcRenderer);
        overlayPanel.add((Component)overlay, "Center");
        if (!((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            DurationDataRenderer allocationRenderer = new DurationDataRenderer.Builder(((MemoryProfilerStage)this.getStage()).getAllocationInfosDurations(), Color.LIGHT_GRAY).setDurationBg(ProfilerColors.MEMORY_ALLOC_BG).setLabelColors(Color.DARK_GRAY, Color.GRAY, Color.lightGray, Color.WHITE).setLabelProvider(data -> String.format("Allocation record (%s)", data.getDurationUs() == Long.MAX_VALUE ? "in progress" : TimeAxisFormatter.DEFAULT.getFormattedString(viewRange.getLength(), (double)data.getDurationUs(), true))).build();
            allocationRenderer.addCustomLineConfig(memoryUsage.getJavaSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getJavaSeries())).setColor(ProfilerColors.MEMORY_JAVA_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getNativeSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getNativeSeries())).setColor(ProfilerColors.MEMORY_NATIVE_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getGraphicsSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getGraphicsSeries())).setColor(ProfilerColors.MEMORY_GRAPHICS_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getStackSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getStackSeries())).setColor(ProfilerColors.MEMORY_STACK_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getCodeSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getCodeSeries())).setColor(ProfilerColors.MEMORY_CODE_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getOtherSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getOtherSeries())).setColor(ProfilerColors.MEMORY_OTHERS_CAPTURED));
            lineChart.addCustomRenderer((LineChartCustomRenderer)allocationRenderer);
            overlay.addDurationDataRenderer(allocationRenderer);
        }
        DurationDataRenderer heapDumpRenderer = new DurationDataRenderer.Builder(((MemoryProfilerStage)this.getStage()).getHeapDumpSampleDurations(), Color.DARK_GRAY).setDurationBg(ProfilerColors.MEMORY_HEAP_DUMP_BG).setLabelColors(Color.DARK_GRAY, Color.GRAY, Color.lightGray, Color.WHITE).setLabelProvider(data -> String.format("Dump (%s)", data.getDurationUs() == Long.MAX_VALUE ? "in progress" : TimeAxisFormatter.DEFAULT.getFormattedString(viewRange.getLength(), (double)data.getDurationUs(), true))).build();
        for (RangedContinuousSeries series : memoryUsage.getSeries()) {
            LineConfig config = lineChart.getLineConfig(series);
            int gray = (config.getColor().getBlue() + config.getColor().getRed() + config.getColor().getGreen()) / 3;
            LineConfig newConfig = LineConfig.copyOf((LineConfig)config).setColor((Color)Gray.get((int)gray));
            heapDumpRenderer.addCustomLineConfig(series, newConfig);
        }
        lineChart.addCustomRenderer((LineChartCustomRenderer)heapDumpRenderer);
        overlay.addDurationDataRenderer(heapDumpRenderer);
        overlay.addMouseListener((MouseListener)new ProfilerTooltipMouseAdapter((Stage)((Object)this.getStage()), () -> new MemoryUsageTooltip((MemoryProfilerStage)this.getStage())));
        overlayPanel.addMouseListener(new ProfilerTooltipMouseAdapter((Stage)((Object)this.getStage()), () -> new MemoryUsageTooltip((MemoryProfilerStage)this.getStage())));
        eventsView.registerTooltip(tooltip, (Stage)((Object)this.getStage()));
        tooltip.registerListenersOn((JComponent)overlay);
        tooltip.registerListenersOn((JComponent)overlayPanel);
        lineChartPanel.add((Component)lineChart, "Center");
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent memoryAxis = new AxisComponent(((MemoryProfilerStage)this.getStage()).getMemoryAxis(), AxisComponent.AxisOrientation.RIGHT);
        memoryAxis.setShowAxisLine(false);
        memoryAxis.setShowMax(true);
        memoryAxis.setShowUnitAtMax(true);
        memoryAxis.setHideTickAtMin(true);
        memoryAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        memoryAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)memoryAxis, "West");
        AxisComponent rightAxis = new AxisComponent(((MemoryProfilerStage)this.getStage()).getObjectsAxis(), AxisComponent.AxisOrientation.LEFT);
        rightAxis.setShowAxisLine(false);
        rightAxis.setShowMax(true);
        rightAxis.setShowUnitAtMax(true);
        rightAxis.setHideTickAtMin(true);
        rightAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        rightAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)rightAxis, "East");
        MemoryProfilerStage.MemoryStageLegends legends = ((MemoryProfilerStage)this.getStage()).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.configure((Legend)legends.getJavaLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getJavaSeries())));
        legend.configure((Legend)legends.getNativeLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getNativeSeries())));
        legend.configure((Legend)legends.getGraphicsLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getGraphicsSeries())));
        legend.configure((Legend)legends.getStackLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getStackSeries())));
        legend.configure((Legend)legends.getCodeLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getCodeSeries())));
        legend.configure((Legend)legends.getOtherLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getOtherSeries())));
        legend.configure((Legend)legends.getTotalLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getTotalMemorySeries())));
        legend.configure((Legend)legends.getObjectsLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getObjectsSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
        if (!((MemoryProfilerStage)this.getStage()).hasUserUsedMemoryCapture()) {
            this.installProfilingInstructions((JPanel)monitorPanel);
        }
        monitorPanel.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)overlayPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)this.mySelectionComponent, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        layout.setRowSizing(1, "*");
        panel.add((Component)monitorPanel, new TabularLayout.Constraint(1, 0));
        JBPanel jBPanel = panel;
        if (jBPanel == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(12);
        }
        return jBPanel;
    }

    private void buildContextMenu() {
        if (this.mySelectionComponent == null) {
            return;
        }
        IdeProfilerComponents ideProfilerComponents = this.getIdeComponents();
        ContextMenuInstaller contextMenuInstaller = ideProfilerComponents.createContextMenuInstaller();
        ProfilerAction exportHeapDumpAction = new ProfilerAction.Builder("Export...").setIcon(StudioIcons.Common.EXPORT).build();
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, exportHeapDumpAction, x -> this.getCaptureIntersectingWithMouseX(x) != null && this.getCaptureIntersectingWithMouseX(x).isExportable(), x -> this.getIdeComponents().createExportDialog().open(() -> "Export capture to file", () -> MemoryProfiler.generateCaptureFileName(), () -> this.getCaptureIntersectingWithMouseX(x).getExportableExtension(), file -> ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().saveFile((File)file, output -> {
            try {
                this.getCaptureIntersectingWithMouseX(x).saveToFile((OutputStream)output);
            }
            catch (IOException e) {
                MemoryProfilerStageView.getLogger().warn((Throwable)e);
            }
        }, null)));
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, ContextMenuItem.SEPARATOR);
        if (!((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, this.myAllocationAction);
            contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, this.myStopAllocationAction);
        }
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, this.myForceGarbageCollectionAction);
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, ContextMenuItem.SEPARATOR);
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, this.myHeapDumpAction);
        contextMenuInstaller.installGenericContextMenu((JComponent)this.mySelectionComponent, ContextMenuItem.SEPARATOR);
        this.getProfilersView().installCommonMenuItems((JComponent)this.mySelectionComponent);
    }

    @Nullable
    private CaptureObject getCaptureIntersectingWithMouseX(int mouseXLocation) {
        assert (this.mySelectionComponent != null);
        Range range = this.getTimeline().getViewRange();
        double pos = (double)mouseXLocation / this.mySelectionComponent.getSize().getWidth() * range.getLength() + range.getMin();
        CaptureDurationData<? extends CaptureObject> durationData = ((MemoryProfilerStage)this.getStage()).getIntersectingCaptureDuration(new Range(pos, pos));
        return durationData == null ? null : durationData.getCaptureEntry().getCaptureObject();
    }

    private void installProfilingInstructions(@NotNull JPanel parent) {
        RenderInstruction[] instructions;
        if (parent == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(13);
        }
        assert (parent.getLayout().getClass() == TabularLayout.class);
        Icon heapDumpIcon = UIUtil.isUnderDarcula() ? IconUtil.darker((Icon)StudioIcons.Profiler.Toolbar.HEAP_DUMP, (int)6) : IconUtil.brighter((Icon)StudioIcons.Profiler.Toolbar.HEAP_DUMP, (int)6);
        FontMetrics metrics = SwingUtilities2.getFontMetrics((JComponent)parent, ProfilerFonts.H2_FONT);
        if (((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            RenderInstruction[] liveAllocInstructions;
            instructions = liveAllocInstructions = new RenderInstruction[]{new TextInstruction(metrics, "Select a range to inspect allocations"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(metrics, "or click "), new IconInstruction(heapDumpIcon, ProfilerLayout.PROFILING_INSTRUCTIONS_ICON_PADDING, null), new TextInstruction(metrics, " for a heap dump")};
        } else {
            RenderInstruction[] legacyInstructions = new RenderInstruction[]{new TextInstruction(metrics, "Click the record button to inspect allocations"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(metrics, "or "), new IconInstruction(heapDumpIcon, ProfilerLayout.PROFILING_INSTRUCTIONS_ICON_PADDING, null), new TextInstruction(metrics, " for a heap dump")};
            instructions = legacyInstructions;
        }
        InstructionsPanel panel = new InstructionsPanel.Builder(instructions).setEaseOut(((MemoryProfilerStage)this.getStage()).getInstructionsEaseOutModel(), instructionsPanel -> {
            if (parent == null) {
                MemoryProfilerStageView.$$$reportNull$$$0(26);
            }
            parent.remove((Component)instructionsPanel);
        }).setBackgroundCornerRadius(ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER, ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER).build();
        parent.add((Component)panel, new TabularLayout.Constraint(0, 0));
    }

    @NotNull
    private JPanel buildCaptureUi() {
        JPanel capturePanel = new JPanel(new BorderLayout());
        JPanel toolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        toolbar.add(this.myCaptureView.getComponent());
        toolbar.add(this.myHeapView.getComponent());
        toolbar.add(this.myClassGrouping.getComponent());
        JPanel headingPanel = new JPanel(new BorderLayout());
        headingPanel.add((Component)toolbar, "West");
        JPanel buttonToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        buttonToolbar.setBorder((Border)new JBEmptyBorder(3, 0, 0, 0));
        buttonToolbar.setOpaque(false);
        if (!((MemoryProfilerStage)this.getStage()).isMemoryCaptureOnly()) {
            buttonToolbar.add(this.getSelectionTimeLabel());
        }
        if (((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isMemoryCaptureFilterEnabled()) {
            CommonToggleButton button = FilterComponent.createFilterToggleButton();
            buttonToolbar.add((Component)new FlatSeparator());
            buttonToolbar.add((Component)button);
            FilterComponent filterComponent = new FilterComponent(ProfilerLayout.FILTER_TEXT_FIELD_WIDTH, 5, 250);
            filterComponent.addOnFilterChange((pattern, model) -> ((MemoryProfilerStage)this.getStage()).selectCaptureFilter((Pattern)pattern, (FilterModel)model));
            headingPanel.add((Component)filterComponent, "South");
            filterComponent.setVisible(false);
            filterComponent.setBorder((Border)new JBEmptyBorder(0, 4, 0, 0));
            FilterComponent.configureKeyBindingAndFocusBehaviors((JComponent)capturePanel, (FilterComponent)filterComponent, (JToggleButton)button);
        }
        headingPanel.add((Component)buttonToolbar, "East");
        capturePanel.add((Component)headingPanel, "First");
        capturePanel.add((Component)this.myClassifierView.getComponent(), "Center");
        JPanel jPanel = capturePanel;
        if (jPanel == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(14);
        }
        return jPanel;
    }

    private void captureObjectChanged() {
        this.stopLoadingUi();
        this.myCaptureObject = ((MemoryProfilerStage)this.getStage()).getSelectedCapture();
        if (this.myCaptureObject == null) {
            this.myAllocationButton.setEnabled(true);
            this.myHeapDumpButton.setEnabled(true);
            this.myChartCaptureSplitter.setSecondComponent(null);
            return;
        }
        if (this.myCaptureObject.isDoneLoading()) {
            this.captureObjectFinishedLoading();
        } else {
            this.myAllocationButton.setEnabled(false);
            this.myHeapDumpButton.setEnabled(false);
            this.myCaptureLoadingPanel = this.getProfilersView().getIdeProfilerComponents().createLoadingPanel(-1);
            this.myCaptureLoadingPanel.setLoadingText("Fetching results");
            this.myCaptureLoadingPanel.startLoading();
            this.myChartCaptureSplitter.setSecondComponent(this.myCaptureLoadingPanel.getComponent());
        }
    }

    private void captureObjectFinishedLoading() {
        this.myAllocationButton.setEnabled(true);
        this.myHeapDumpButton.setEnabled(true);
        if (this.myCaptureObject != ((MemoryProfilerStage)this.getStage()).getSelectedCapture() || this.myCaptureObject == null) {
            return;
        }
        this.stopLoadingUi();
        this.myChartCaptureSplitter.setSecondComponent((JComponent)this.myCapturePanel);
    }

    private void stopLoadingUi() {
        if (this.myCaptureObject == null || this.myCaptureLoadingPanel == null) {
            return;
        }
        this.myCaptureLoadingPanel.stopLoading();
        this.myCaptureLoadingPanel = null;
        this.myChartCaptureSplitter.setSecondComponent(null);
    }

    private static void configureStackedFilledLine(LineChart chart, Color color, RangedContinuousSeries series) {
        chart.configure(series, new LineConfig(color).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
    }

    @NotNull
    static Icon getValueObjectIcon(@NotNull ValueObject valueObject) {
        if (valueObject == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(15);
        }
        if (valueObject instanceof FieldObject) {
            FieldObject field = (FieldObject)valueObject;
            if (field.getValueType() == ValueObject.ValueType.ARRAY) {
                Icon icon = MemoryProfilerStageView.getStackedIcon(field.getAsInstance(), StudioIcons.Profiler.Overlays.ARRAY_STACK, AllIcons.Debugger.Db_array);
                if (icon == null) {
                    MemoryProfilerStageView.$$$reportNull$$$0(16);
                }
                return icon;
            }
            if (field.getValueType().getIsPrimitive()) {
                Icon icon = AllIcons.Debugger.Db_primitive;
                if (icon == null) {
                    MemoryProfilerStageView.$$$reportNull$$$0(17);
                }
                return icon;
            }
            Icon icon = MemoryProfilerStageView.getStackedIcon(field.getAsInstance(), StudioIcons.Profiler.Overlays.FIELD_STACK, PlatformIcons.FIELD_ICON);
            if (icon == null) {
                MemoryProfilerStageView.$$$reportNull$$$0(18);
            }
            return icon;
        }
        if (valueObject instanceof ReferenceObject) {
            ReferenceObject referrer = (ReferenceObject)valueObject;
            if (referrer.getReferenceInstance().getIsRoot()) {
                Icon icon = AllIcons.Hierarchy.Subtypes;
                if (icon == null) {
                    MemoryProfilerStageView.$$$reportNull$$$0(19);
                }
                return icon;
            }
            if (referrer.getReferenceInstance().getValueType() == ValueObject.ValueType.ARRAY) {
                Icon icon = MemoryProfilerStageView.getStackedIcon(referrer.getReferenceInstance(), StudioIcons.Profiler.Overlays.ARRAY_STACK, AllIcons.Debugger.Db_array);
                if (icon == null) {
                    MemoryProfilerStageView.$$$reportNull$$$0(20);
                }
                return icon;
            }
            Icon icon = MemoryProfilerStageView.getStackedIcon(referrer.getReferenceInstance(), StudioIcons.Profiler.Overlays.FIELD_STACK, PlatformIcons.FIELD_ICON);
            if (icon == null) {
                MemoryProfilerStageView.$$$reportNull$$$0(21);
            }
            return icon;
        }
        if (valueObject instanceof InstanceObject) {
            Icon icon = MemoryProfilerStageView.getStackedIcon((InstanceObject)valueObject, StudioIcons.Profiler.Overlays.INTERFACE_STACK, PlatformIcons.INTERFACE_ICON);
            if (icon == null) {
                MemoryProfilerStageView.$$$reportNull$$$0(22);
            }
            return icon;
        }
        Icon icon = PlatformIcons.INTERFACE_ICON;
        if (icon == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(23);
        }
        return icon;
    }

    private static Icon getStackedIcon(@Nullable InstanceObject instance, @NotNull Icon stackedIcon, @NotNull Icon nonStackedIcon) {
        if (stackedIcon == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(24);
        }
        if (nonStackedIcon == null) {
            MemoryProfilerStageView.$$$reportNull$$$0(25);
        }
        return instance == null || instance.getCallStackDepth() == 0 ? nonStackedIcon : stackedIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfilerStageView";
                break;
            }
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueObject";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackedIcon";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonStackedIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfilerStageView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainSplitter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChartCaptureSplitter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturePanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassGrouping";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierView";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassSetView";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceDetailsView";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureElapsedTimeLabel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMonitorUi";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCaptureUi";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueObjectIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installProfilingInstructions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getValueObjectIcon";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getStackedIcon";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installProfilingInstructions$22";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

