/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.ext.NativeRegistryPostProcessor;
import com.android.tools.perflib.heap.io.InMemoryBuffer;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.HeapDumpInstanceObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.proguard.ProguardMap;
import com.google.common.annotations.VisibleForTesting;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapDumpCaptureObject
implements CaptureObject {
    @NotNull
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final FeatureTracker myFeatureTracker;
    @NotNull
    private final Map<Integer, HeapSet> myHeapSets;
    @NotNull
    private final Map<ClassObj, InstanceObject> myClassObjectIndex;
    @NotNull
    private final Map<Instance, InstanceObject> myInstanceIndex;
    @NotNull
    private final ClassDb myClassDb;
    @NotNull
    private final MemoryProfiler.HeapDumpInfo myHeapDumpInfo;
    @Nullable
    private final ProguardMap myProguardMap;
    @Nullable
    private volatile Snapshot mySnapshot;
    private volatile boolean myIsLoadingError;
    private boolean myHasNativeAllocations;

    public HeapDumpCaptureObject(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, @NotNull MemoryProfiler.HeapDumpInfo heapDumpInfo, @Nullable ProguardMap proguardMap, @NotNull FeatureTracker featureTracker) {
        if (client == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(0);
        }
        if (session == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(1);
        }
        if (heapDumpInfo == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(2);
        }
        if (featureTracker == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(3);
        }
        this.myHeapSets = new HashMap<Integer, HeapSet>();
        this.myClassObjectIndex = new HashMap<ClassObj, InstanceObject>();
        this.myInstanceIndex = new HashMap<Instance, InstanceObject>();
        this.myClassDb = new ClassDb();
        this.myIsLoadingError = false;
        this.myClient = client;
        this.mySession = session;
        this.myHeapDumpInfo = heapDumpInfo;
        this.myProguardMap = proguardMap;
        this.myFeatureTracker = featureTracker;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Heap Dump" == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(4);
        }
        return "Heap Dump";
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return "hprof";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) {
        if (outputStream == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(5);
        }
        MemoryProfiler.saveHeapDumpToFile(this.myClient, this.mySession, this.myHeapDumpInfo, outputStream, this.myFeatureTracker);
    }

    @VisibleForTesting
    @NotNull
    ClassDb getClassDb() {
        ClassDb classDb = this.myClassDb;
        if (classDb == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(6);
        }
        return classDb;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        Snapshot snapshot = this.mySnapshot;
        if (snapshot == null) {
            List<HeapSet> list = Collections.emptyList();
            if (list == null) {
                HeapDumpCaptureObject.$$$reportNull$$$0(7);
            }
            return list;
        }
        Collection<HeapSet> collection = this.myHeapSets.values();
        if (collection == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        return this.myHeapSets.getOrDefault(heapId, null);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        Snapshot snapshot = this.mySnapshot;
        if (snapshot == null) {
            Stream<InstanceObject> stream = Stream.empty();
            if (stream == null) {
                HeapDumpCaptureObject.$$$reportNull$$$0(9);
            }
            return stream;
        }
        Stream<InstanceObject> stream = this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity());
        if (stream == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @Override
    public long getStartTimeNs() {
        return this.myHeapDumpInfo.getStartTime();
    }

    @Override
    public long getEndTimeNs() {
        return this.myHeapDumpInfo.getEndTime();
    }

    public boolean getHasNativeAllocations() {
        return this.myHasNativeAllocations;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        HeapSet heapSet;
        MemoryProfiler.DumpDataResponse response;
        while ((response = this.myClient.getHeapDump(MemoryProfiler.DumpDataRequest.newBuilder().setSession(this.mySession).setDumpTime(this.myHeapDumpInfo.getStartTime()).build())).getStatus() != MemoryProfiler.DumpDataResponse.Status.SUCCESS) {
            if (response.getStatus() == MemoryProfiler.DumpDataResponse.Status.NOT_READY) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.myIsLoadingError = true;
                    return false;
                }
            }
            this.myIsLoadingError = true;
            return false;
        }
        InMemoryBuffer buffer = new InMemoryBuffer(response.getData().asReadOnlyByteBuffer());
        NativeRegistryPostProcessor nativeRegistryPostProcessor = new NativeRegistryPostProcessor();
        Snapshot snapshot = this.myProguardMap != null ? Snapshot.createSnapshot((DataBuffer)buffer, (ProguardMap)this.myProguardMap, Arrays.asList(nativeRegistryPostProcessor)) : Snapshot.createSnapshot((DataBuffer)buffer, (ProguardMap)new ProguardMap(), Arrays.asList(nativeRegistryPostProcessor));
        snapshot.computeDominators();
        this.myHasNativeAllocations = nativeRegistryPostProcessor.getHasNativeAllocations();
        this.mySnapshot = snapshot;
        HashMap<Heap, HeapSet> heapSets = new HashMap<Heap, HeapSet>(snapshot.getHeaps().size());
        InstanceObject javaLangClassObject = null;
        for (Heap heap : snapshot.getHeaps()) {
            ClassObj javaLangClass;
            HeapSet heapSet2 = new HeapSet(this, heap.getName(), heap.getId());
            heapSets.put(heap, heapSet2);
            if (javaLangClassObject != null || (javaLangClass = (ClassObj)heap.getClasses().stream().filter(classObj -> "java.lang.Class".equals(classObj.getClassName())).findFirst().orElse(null)) == null) continue;
            javaLangClassObject = this.createClassObjectInstance(null, javaLangClass);
        }
        InstanceObject finalJavaLangClassObject = javaLangClassObject;
        for (Heap heap : snapshot.getHeaps()) {
            heapSet = (HeapSet)heapSets.get(heap);
            heap.getClasses().forEach(classObj -> {
                InstanceObject classObject = this.createClassObjectInstance(finalJavaLangClassObject, (ClassObj)classObj);
                this.myInstanceIndex.put((Instance)classObj, classObject);
                heapSet.addDeltaInstanceObject(classObject);
            });
        }
        for (Heap heap : snapshot.getHeaps()) {
            heapSet = (HeapSet)heapSets.get(heap);
            heap.forEachInstance(instance -> {
                assert (!"java.lang.Class".equals(this.getName()));
                ClassObj classObj = instance.getClassObj();
                HeapDumpInstanceObject instanceObject = new HeapDumpInstanceObject(this, this.getClassObjectInstance((Instance)instance), (Instance)instance, this.myClassDb.registerClass(classObj.getClassLoaderId(), classObj.getClassName()), null);
                this.myInstanceIndex.put((Instance)instance, instanceObject);
                heapSet.addDeltaInstanceObject(instanceObject);
                return true;
            });
        }
        heapSets.forEach((key, value) -> {
            if ("default".equals(key.getName())) {
                if (heapSets.size() == 1 || key.getInstancesCount() > 0) {
                    this.myHeapSets.put(key.getId(), (HeapSet)value);
                }
            } else {
                this.myHeapSets.put(key.getId(), (HeapSet)value);
            }
        });
        return true;
    }

    @Override
    public boolean isDoneLoading() {
        return this.mySnapshot != null || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        List<CaptureObject.ClassifierAttribute> list = this.myHasNativeAllocations ? Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.NATIVE_SIZE, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE) : Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE);
        if (list == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        List<CaptureObject.InstanceAttribute> list = this.myHasNativeAllocations ? Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.NATIVE_SIZE, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE) : Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE);
        if (list == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public InstanceObject findInstanceObject(@NotNull Instance instance) {
        if (instance == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(13);
        }
        if (this.mySnapshot == null) {
            return null;
        }
        return this.myInstanceIndex.get(instance);
    }

    @NotNull
    InstanceObject createClassObjectInstance(@Nullable InstanceObject javaLangClass, @NotNull ClassObj classObj) {
        if (classObj == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(14);
        }
        if (javaLangClass == null) {
            assert (!this.myClassObjectIndex.containsKey(classObj));
            HeapDumpInstanceObject rootInstanceObject = new HeapDumpInstanceObject(this, null, (Instance)classObj, this.myClassDb.registerClass(classObj.getClassLoaderId(), "java.lang.Class"), ValueObject.ValueType.CLASS);
            this.myClassObjectIndex.put(classObj, rootInstanceObject);
            HeapDumpInstanceObject heapDumpInstanceObject = rootInstanceObject;
            if (heapDumpInstanceObject == null) {
                HeapDumpCaptureObject.$$$reportNull$$$0(15);
            }
            return heapDumpInstanceObject;
        }
        HeapDumpInstanceObject classObject = new HeapDumpInstanceObject(this, javaLangClass, (Instance)classObj, this.myClassDb.registerClass(classObj.getClassLoaderId(), javaLangClass.getClassEntry().getClassName()), ValueObject.ValueType.CLASS);
        this.myClassObjectIndex.put(classObj, classObject);
        HeapDumpInstanceObject heapDumpInstanceObject = classObject;
        if (heapDumpInstanceObject == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(16);
        }
        return heapDumpInstanceObject;
    }

    @Nullable
    InstanceObject getClassObjectInstance(@NotNull Instance instance) {
        if (instance == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(17);
        }
        ClassObj classObj = instance.getClassObj();
        return this.myClassObjectIndex.get(classObj);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapDumpInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/HeapDumpCaptureObject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classObj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/HeapDumpCaptureObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDb";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapSets";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceAttributes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassObjectInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findInstanceObject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createClassObjectInstance";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClassObjectInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

