/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.AllocationStackConverter;
import com.android.tools.profilers.memory.adapters.ArrayObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.ThreadId;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InstanceObject
extends ValueObject {
    public int getHeapId();

    @NotNull
    default public ThreadId getAllocationThreadId() {
        ThreadId threadId = ThreadId.INVALID_THREAD_ID;
        if (threadId == null) {
            InstanceObject.$$$reportNull$$$0(0);
        }
        return threadId;
    }

    @NotNull
    default public ThreadId getDeallocationThreadId() {
        ThreadId threadId = ThreadId.INVALID_THREAD_ID;
        if (threadId == null) {
            InstanceObject.$$$reportNull$$$0(1);
        }
        return threadId;
    }

    @NotNull
    public ClassDb.ClassEntry getClassEntry();

    @Nullable
    public InstanceObject getClassObject();

    default public int getFieldCount() {
        return 0;
    }

    @NotNull
    default public List<FieldObject> getFields() {
        List<FieldObject> list = Collections.emptyList();
        if (list == null) {
            InstanceObject.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    default public ArrayObject getArrayObject() {
        return null;
    }

    default public long getAllocTime() {
        return Long.MIN_VALUE;
    }

    default public long getDeallocTime() {
        return Long.MAX_VALUE;
    }

    @Nullable
    default public MemoryProfiler.AllocationStack getAllocationCallStack() {
        return null;
    }

    default public int getCallStackDepth() {
        MemoryProfiler.AllocationStack callStack = this.getAllocationCallStack();
        if (callStack == null) {
            return 0;
        }
        switch (callStack.getFrameCase()) {
            case FULL_STACK: {
                return callStack.getFullStack().getFramesCount();
            }
            case SMALL_STACK: {
                return callStack.getSmallStack().getFramesCount();
            }
        }
        return 0;
    }

    @NotNull
    default public List<CodeLocation> getAllocationCodeLocations() {
        MemoryProfiler.AllocationStack.StackFrameWrapper fullStack;
        MemoryProfiler.AllocationStack callStack = this.getAllocationCallStack();
        if (callStack != null && callStack.getFrameCase() == MemoryProfiler.AllocationStack.FrameCase.FULL_STACK && !(fullStack = callStack.getFullStack()).getFramesList().isEmpty()) {
            List<CodeLocation> stackFrames;
            List<CodeLocation> list = stackFrames = fullStack.getFramesList().stream().map(AllocationStackConverter::getCodeLocation).collect(Collectors.toList());
            if (list == null) {
                InstanceObject.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<CodeLocation> list = Collections.emptyList();
        if (list == null) {
            InstanceObject.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    default public List<CodeLocation> getDeallocationCodeLocations() {
        List<CodeLocation> list = Collections.emptyList();
        if (list == null) {
            InstanceObject.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    default public List<ReferenceObject> getReferences() {
        List<ReferenceObject> list = Collections.emptyList();
        if (list == null) {
            InstanceObject.$$$reportNull$$$0(6);
        }
        return list;
    }

    default public boolean getIsRoot() {
        return false;
    }

    default public boolean hasTimeData() {
        return false;
    }

    default public boolean hasAllocTime() {
        return false;
    }

    default public boolean hasDeallocTime() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/profilers/memory/adapters/InstanceObject";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationThreadId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeallocationThreadId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationCodeLocations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeallocationCodeLocations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

