/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LegacyAllocationsInstanceObject
implements InstanceObject {
    @NotNull
    static final Map<String, ValueObject.ValueType> ourTypeMap = ImmutableMap.builder().put((Object)"boolean", (Object)ValueObject.ValueType.BOOLEAN).put((Object)"byte", (Object)ValueObject.ValueType.BYTE).put((Object)"char", (Object)ValueObject.ValueType.CHAR).put((Object)"short", (Object)ValueObject.ValueType.SHORT).put((Object)"int", (Object)ValueObject.ValueType.INT).put((Object)"long", (Object)ValueObject.ValueType.LONG).put((Object)"float", (Object)ValueObject.ValueType.FLOAT).put((Object)"double", (Object)ValueObject.ValueType.DOUBLE).build();
    @NotNull
    private final MemoryProfiler.LegacyAllocationEvent myEvent;
    @NotNull
    private final ClassDb.ClassEntry myAllocationClassEntry;
    @NotNull
    private final MemoryProfiler.AllocationStack myCallStack;
    @NotNull
    private final ValueObject.ValueType myValueType;
    @NotNull
    private final ThreadId myThreadId;

    public LegacyAllocationsInstanceObject(@NotNull MemoryProfiler.LegacyAllocationEvent event, @NotNull ClassDb.ClassEntry allocationClassEntry, @NotNull MemoryProfiler.AllocationStack callStack) {
        if (event == null) {
            LegacyAllocationsInstanceObject.$$$reportNull$$$0(0);
        }
        if (allocationClassEntry == null) {
            LegacyAllocationsInstanceObject.$$$reportNull$$$0(1);
        }
        if (callStack == null) {
            LegacyAllocationsInstanceObject.$$$reportNull$$$0(2);
        }
        this.myEvent = event;
        this.myAllocationClassEntry = allocationClassEntry;
        this.myCallStack = callStack;
        this.myThreadId = new ThreadId(event.getThreadId());
        String className = this.myAllocationClassEntry.getClassName();
        this.myValueType = className.contains(".") ? (className.equals("java.lang.String") ? ValueObject.ValueType.STRING : ValueObject.ValueType.OBJECT) : (this.myAllocationClassEntry.getClassName().endsWith("[]") ? ValueObject.ValueType.ARRAY : ourTypeMap.getOrDefault(className, ValueObject.ValueType.OBJECT));
    }

    @Override
    @NotNull
    public String getName() {
        if ("" == null) {
            LegacyAllocationsInstanceObject.$$$reportNull$$$0(3);
        }
        return "";
    }

    @Override
    public int getHeapId() {
        return 0;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        ClassDb.ClassEntry classEntry = this.myAllocationClassEntry;
        if (classEntry == null) {
            LegacyAllocationsInstanceObject.$$$reportNull$$$0(4);
        }
        return classEntry;
    }

    @Override
    @Nullable
    public InstanceObject getClassObject() {
        return null;
    }

    @Override
    public int getShallowSize() {
        return this.myEvent.getSize();
    }

    @Override
    @NotNull
    public ThreadId getAllocationThreadId() {
        ThreadId threadId = this.myThreadId;
        if (threadId == null) {
            LegacyAllocationsInstanceObject.$$$reportNull$$$0(5);
        }
        return threadId;
    }

    @Override
    @NotNull
    public MemoryProfiler.AllocationStack getAllocationCallStack() {
        MemoryProfiler.AllocationStack allocationStack = this.myCallStack;
        if (allocationStack == null) {
            LegacyAllocationsInstanceObject.$$$reportNull$$$0(6);
        }
        return allocationStack;
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        ValueObject.ValueType valueType = this.myValueType;
        if (valueType == null) {
            LegacyAllocationsInstanceObject.$$$reportNull$$$0(7);
        }
        return valueType;
    }

    @Override
    @NotNull
    public String getValueText() {
        String string = this.myAllocationClassEntry.getSimpleClassName();
        if (string == null) {
            LegacyAllocationsInstanceObject.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationClassEntry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStack";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/LegacyAllocationsInstanceObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/LegacyAllocationsInstanceObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassEntry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationThreadId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationCallStack";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

