/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.JniReferenceInstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationInstanceObject;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongObjectHashMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class LiveAllocationCaptureObject
implements CaptureObject {
    @Nullable
    private MemoryProfilerStage myStage;
    final ExecutorService myExecutorService;
    private final ClassDb myClassDb;
    private final Map<ClassDb.ClassEntry, LiveAllocationInstanceObject> myClassMap;
    private final TIntObjectHashMap<LiveAllocationInstanceObject> myInstanceMap;
    private final TIntObjectHashMap<MemoryProfiler.AllocationStack> myCallstackMap;
    private final TIntObjectHashMap<ThreadId> myThreadIdMap;
    private final TLongObjectHashMap<MemoryProfiler.StackFrameInfoResponse> myFrameInfoResponseMap;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    private final Common.Session mySession;
    private final long myCaptureStartTime;
    private final List<HeapSet> myHeapSets;
    private final AspectObserver myAspectObserver;
    private final boolean myEnableJniRefsTracking;
    private long myEventsEndTimeNs;
    private long myContextEndTimeNs;
    private long myPreviousQueryStartTimeNs;
    private long myPreviousQueryEndTimeNs;
    private Range myQueryRange;
    private Future myCurrentTask;

    private static Logger getLogger() {
        return Logger.getInstance(LiveAllocationCaptureObject.class);
    }

    /*
     * WARNING - void declaration
     */
    public LiveAllocationCaptureObject(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session, long captureStartTime, @Nullable ExecutorService loadService, @Nullable MemoryProfilerStage memoryProfilerStage) {
        void stage;
        if (client == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(0);
        }
        if (session == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(1);
        }
        this.myExecutorService = loadService == null ? Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("profiler-live-allocation").build()) : loadService;
        this.myClassDb = new ClassDb();
        this.myClassMap = new HashMap<ClassDb.ClassEntry, LiveAllocationInstanceObject>();
        this.myInstanceMap = new TIntObjectHashMap();
        this.myCallstackMap = new TIntObjectHashMap();
        this.myThreadIdMap = new TIntObjectHashMap();
        this.myFrameInfoResponseMap = new TLongObjectHashMap();
        this.myClient = client;
        this.mySession = session;
        this.myCaptureStartTime = captureStartTime;
        this.myAspectObserver = new AspectObserver();
        this.myStage = stage;
        this.myHeapSets = new ArrayList<HeapSet>(Arrays.asList(new HeapSet(this, "default", 0), new HeapSet(this, "image", 1), new HeapSet(this, "zygote", 2), new HeapSet(this, "app", 3)));
        this.myEnableJniRefsTracking = stage.getStudioProfilers().getIdeServices().getFeatureConfig().isJniReferenceTrackingEnabled();
        if (this.myEnableJniRefsTracking) {
            this.myHeapSets.add(new HeapSet(this, "JNI", 4));
        }
        this.myEventsEndTimeNs = Long.MIN_VALUE;
        this.myContextEndTimeNs = Long.MIN_VALUE;
        this.myPreviousQueryStartTimeNs = Long.MIN_VALUE;
        this.myPreviousQueryEndTimeNs = Long.MIN_VALUE;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        Common.Session session = this.mySession;
        if (session == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(2);
        }
        return session;
    }

    @Override
    @NotNull
    public MemoryServiceGrpc.MemoryServiceBlockingStub getClient() {
        MemoryServiceGrpc.MemoryServiceBlockingStub memoryServiceBlockingStub = this.myClient;
        if (memoryServiceBlockingStub == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(3);
        }
        return memoryServiceBlockingStub;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Live Allocation" == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(4);
        }
        return "Live Allocation";
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return null;
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(5);
        }
        throw new NotImplementedException();
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isMemorySnapshotEnabled()) {
            ImmutableList immutableList = ImmutableList.of((Object)((Object)CaptureObject.ClassifierAttribute.LABEL), (Object)((Object)CaptureObject.ClassifierAttribute.ALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.DEALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.TOTAL_COUNT), (Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_SIZE));
            if (immutableList == null) {
                LiveAllocationCaptureObject.$$$reportNull$$$0(6);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.of((Object)((Object)CaptureObject.ClassifierAttribute.LABEL), (Object)((Object)CaptureObject.ClassifierAttribute.ALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.DEALLOCATIONS), (Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_SIZE));
        if (immutableList == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        ImmutableList immutableList = ImmutableList.of((Object)((Object)CaptureObject.InstanceAttribute.LABEL), (Object)((Object)CaptureObject.InstanceAttribute.ALLOCATION_TIME), (Object)((Object)CaptureObject.InstanceAttribute.DEALLOCATION_TIME));
        if (immutableList == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        if (this.myHeapSets.get(0).getInstancesCount() > 0) {
            List<HeapSet> list = this.myHeapSets;
            if (list == null) {
                LiveAllocationCaptureObject.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<HeapSet> list = this.myHeapSets.subList(1, this.myHeapSets.size());
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        return this.myHeapSets.get(heapId);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        Stream<InstanceObject> stream = this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity());
        if (stream == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @Override
    public long getStartTimeNs() {
        return this.myCaptureStartTime;
    }

    @Override
    public long getEndTimeNs() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        assert (queryRange != null);
        assert (queryJoiner != null);
        this.myQueryRange = queryRange;
        this.myQueryRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, () -> this.loadTimeRange(this.myQueryRange, queryJoiner));
        this.loadTimeRange(this.myQueryRange, queryJoiner);
        return true;
    }

    @Override
    @Nullable
    public MemoryProfiler.StackFrameInfoResponse getStackFrameInfoResponse(long methodId) {
        MemoryProfiler.StackFrameInfoResponse frameInfo = (MemoryProfiler.StackFrameInfoResponse)this.myFrameInfoResponseMap.get(methodId);
        if (frameInfo == null) {
            frameInfo = this.getClient().getStackFrameInfo(MemoryProfiler.StackFrameInfoRequest.newBuilder().setSession(this.getSession()).setMethodId(methodId).build());
            this.myFrameInfoResponseMap.put(methodId, (Object)frameInfo);
        }
        return frameInfo;
    }

    @Override
    public boolean isDoneLoading() {
        return true;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public void unload() {
        this.myQueryRange.removeDependencies(this.myAspectObserver);
        this.myExecutorService.shutdownNow();
    }

    private void updateAllocationContexts(long endTimeNs) {
        if (this.myContextEndTimeNs >= endTimeNs) {
            return;
        }
        MemoryProfiler.AllocationContextsResponse contextsResponse = this.myClient.getAllocationContexts(MemoryProfiler.AllocationContextsRequest.newBuilder().setSession(this.mySession).setStartTime(this.myContextEndTimeNs).setEndTime(endTimeNs).build());
        for (MemoryProfiler.AllocatedClass klass : contextsResponse.getAllocatedClassesList()) {
            ClassDb.ClassEntry entry = this.myClassDb.registerClass(-1L, klass.getClassName(), klass.getClassId());
            if (this.myClassMap.containsKey(entry)) continue;
            LiveAllocationInstanceObject instance = new LiveAllocationInstanceObject(this, entry, null, null, null, -1L, -1);
            instance.setAllocationTime(this.myCaptureStartTime);
            this.myClassMap.put(entry, instance);
        }
        contextsResponse.getAllocationStacksList().forEach(callStack -> {
            if (!this.myCallstackMap.contains(callStack.getStackId())) {
                this.myCallstackMap.put(callStack.getStackId(), callStack);
            }
        });
        contextsResponse.getAllocationThreadsList().forEach(thread2 -> {
            if (!this.myThreadIdMap.contains(thread2.getThreadId())) {
                this.myThreadIdMap.put(thread2.getThreadId(), (Object)new ThreadId(thread2.getThreadName()));
            }
        });
        this.myContextEndTimeNs = Math.max(this.myContextEndTimeNs, contextsResponse.getTimestamp());
    }

    private void loadTimeRange(@NotNull Range queryRange, @NotNull Executor joiner) {
        if (queryRange == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(12);
        }
        if (joiner == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(13);
        }
        try {
            if (this.myCurrentTask != null) {
                this.myCurrentTask.cancel(false);
            }
            this.myCurrentTask = this.myExecutorService.submit(() -> {
                boolean clear;
                if (queryRange == null) {
                    LiveAllocationCaptureObject.$$$reportNull$$$0(21);
                }
                if (joiner == null) {
                    LiveAllocationCaptureObject.$$$reportNull$$$0(22);
                }
                long newStartTimeNs = TimeUnit.MICROSECONDS.toNanos((long)queryRange.getMin());
                long newEndTimeNs = TimeUnit.MICROSECONDS.toNanos((long)queryRange.getMax());
                if (newStartTimeNs == this.myPreviousQueryStartTimeNs && newEndTimeNs == this.myPreviousQueryEndTimeNs && newEndTimeNs != Long.MAX_VALUE) {
                    return null;
                }
                joiner.execute(() -> this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATING));
                this.updateAllocationContexts(newEndTimeNs);
                if (newEndTimeNs > this.myEventsEndTimeNs + 1L) {
                    MemoryProfiler.LatestAllocationTimeResponse timeResponse = this.myClient.getLatestAllocationTime(MemoryProfiler.LatestAllocationTimeRequest.newBuilder().setSession(this.mySession).build());
                    this.myEventsEndTimeNs = Math.max(this.myEventsEndTimeNs, timeResponse.getTimestamp());
                    if (newEndTimeNs > this.myEventsEndTimeNs + 1L) {
                        newEndTimeNs = this.myEventsEndTimeNs + 1L;
                        newStartTimeNs = Math.min(newStartTimeNs, newEndTimeNs);
                    }
                }
                ArrayList<InstanceObject> snapshotList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetSnapshotList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> deltaAllocationList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetDeltaAllocationList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> deltaFreeList = new ArrayList<InstanceObject>();
                ArrayList<InstanceObject> resetDeltaFreeList = new ArrayList<InstanceObject>();
                boolean bl = clear = this.myPreviousQueryEndTimeNs <= newStartTimeNs || newEndTimeNs <= this.myPreviousQueryStartTimeNs;
                if (clear) {
                    this.myInstanceMap.clear();
                    this.queryJavaInstanceSnapshot(newStartTimeNs, snapshotList);
                    this.queryJniReferencesSnapshot(newStartTimeNs, snapshotList);
                    this.queryJavaInstanceDelta(newStartTimeNs, newEndTimeNs, deltaAllocationList, deltaFreeList, false);
                    this.queryJniReferencesDelta(newStartTimeNs, newEndTimeNs, deltaAllocationList, deltaFreeList, false);
                } else {
                    ArrayList<InstanceObject> leftAllocations = new ArrayList<InstanceObject>();
                    ArrayList<InstanceObject> leftDeallocations = new ArrayList<InstanceObject>();
                    if (newStartTimeNs < this.myPreviousQueryStartTimeNs) {
                        this.queryJavaInstanceDelta(newStartTimeNs, this.myPreviousQueryStartTimeNs, leftAllocations, leftDeallocations, false);
                        this.queryJniReferencesDelta(newStartTimeNs, this.myPreviousQueryStartTimeNs, leftAllocations, leftDeallocations, false);
                        deltaAllocationList.addAll(leftAllocations);
                        deltaFreeList.addAll(leftDeallocations);
                        resetSnapshotList.addAll(leftAllocations);
                        snapshotList.addAll(leftDeallocations);
                    } else if (newStartTimeNs > this.myPreviousQueryStartTimeNs) {
                        this.queryJavaInstanceDelta(this.myPreviousQueryStartTimeNs, newStartTimeNs, leftAllocations, leftDeallocations, true);
                        this.queryJniReferencesDelta(this.myPreviousQueryStartTimeNs, newStartTimeNs, leftAllocations, leftDeallocations, true);
                        resetDeltaAllocationList.addAll(leftAllocations);
                        resetDeltaFreeList.addAll(leftDeallocations);
                        snapshotList.addAll(leftAllocations);
                        resetSnapshotList.addAll(leftDeallocations);
                    }
                    ArrayList<InstanceObject> rightAllocations = new ArrayList<InstanceObject>();
                    ArrayList<InstanceObject> rightDeallocations = new ArrayList<InstanceObject>();
                    if (newEndTimeNs < this.myPreviousQueryEndTimeNs) {
                        this.queryJavaInstanceDelta(newEndTimeNs, this.myPreviousQueryEndTimeNs, rightAllocations, rightDeallocations, true);
                        this.queryJniReferencesDelta(newEndTimeNs, this.myPreviousQueryEndTimeNs, rightAllocations, rightDeallocations, true);
                        resetDeltaAllocationList.addAll(rightAllocations);
                        resetDeltaFreeList.addAll(rightDeallocations);
                    } else if (newEndTimeNs > this.myPreviousQueryEndTimeNs) {
                        this.queryJavaInstanceDelta(this.myPreviousQueryEndTimeNs, newEndTimeNs, rightAllocations, rightDeallocations, false);
                        this.queryJniReferencesDelta(this.myPreviousQueryEndTimeNs, newEndTimeNs, rightAllocations, rightDeallocations, false);
                        deltaAllocationList.addAll(rightAllocations);
                        deltaFreeList.addAll(rightDeallocations);
                    }
                }
                this.myPreviousQueryStartTimeNs = newStartTimeNs;
                this.myPreviousQueryEndTimeNs = newEndTimeNs;
                joiner.execute(() -> {
                    this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATED);
                    if (clear || deltaAllocationList.size() + deltaFreeList.size() + resetDeltaAllocationList.size() + resetDeltaFreeList.size() > 0) {
                        if (clear) {
                            this.myHeapSets.forEach(heap -> heap.clearClassifierSets());
                            if (this.myStage.getSelectedClassSet() != null) {
                                this.myStage.selectClassSet(ClassSet.EMPTY_SET);
                            }
                        }
                        if (this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isMemorySnapshotEnabled()) {
                            snapshotList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addSnapshotInstanceObject((InstanceObject)instance));
                            resetSnapshotList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeSnapshotInstanceObject((InstanceObject)instance));
                        }
                        deltaAllocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addDeltaInstanceObject((InstanceObject)instance));
                        deltaFreeList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).freeDeltaInstanceObject((InstanceObject)instance));
                        resetDeltaAllocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeAddedDeltaInstanceObject((InstanceObject)instance));
                        resetDeltaFreeList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeFreedDeltaInstanceObject((InstanceObject)instance));
                        this.myStage.refreshSelectedHeap();
                    }
                });
                return null;
            });
        }
        catch (RejectedExecutionException e) {
            LiveAllocationCaptureObject.getLogger().debug((Throwable)e);
        }
    }

    @NotNull
    private LiveAllocationInstanceObject getOrCreateInstanceObject(int tag, int classTag, int stackId, int threadId, long size, int heapId) {
        LiveAllocationInstanceObject instance = (LiveAllocationInstanceObject)this.myInstanceMap.get(tag);
        if (instance == null) {
            ClassDb.ClassEntry entry = this.myClassDb.getEntry(classTag);
            assert (this.myClassMap.containsKey(entry));
            MemoryProfiler.AllocationStack callstack = null;
            if (stackId != 0) {
                assert (this.myCallstackMap.containsKey(stackId));
                callstack = (MemoryProfiler.AllocationStack)this.myCallstackMap.get(stackId);
            }
            ThreadId thread2 = null;
            if (threadId != 0) {
                assert (this.myThreadIdMap.containsKey(threadId));
                thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
            }
            instance = new LiveAllocationInstanceObject(this, entry, this.myClassMap.get(entry), thread2, callstack, size, heapId);
            this.myInstanceMap.put(tag, (Object)instance);
        }
        LiveAllocationInstanceObject liveAllocationInstanceObject = instance;
        if (liveAllocationInstanceObject == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(14);
        }
        return liveAllocationInstanceObject;
    }

    @Nullable
    private JniReferenceInstanceObject getOrCreateJniRefObject(int tag, long refValue) {
        LiveAllocationInstanceObject referencedObject = (LiveAllocationInstanceObject)this.myInstanceMap.get(tag);
        if (referencedObject == null) {
            return null;
        }
        JniReferenceInstanceObject result = referencedObject.getJniRefByValue(refValue);
        if (result == null) {
            result = new JniReferenceInstanceObject(this, referencedObject, tag, refValue);
            referencedObject.addJniRef(result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void queryJavaInstanceSnapshot(long newTimeNs, @NotNull List<InstanceObject> list) {
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(15);
        }
        if (!this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isMemorySnapshotEnabled()) {
            return;
        }
        MemoryProfiler.BatchAllocationSample sampleResponse = this.myClient.getAllocations(MemoryProfiler.AllocationSnapshotRequest.newBuilder().setSession(this.mySession).setEndTime(newTimeNs).setLiveObjectsOnly(true).build());
        for (MemoryProfiler.AllocationEvent event : sampleResponse.getEventsList()) {
            if (event.getEventCase() == MemoryProfiler.AllocationEvent.EventCase.ALLOC_DATA) {
                void setAllocationList;
                MemoryProfiler.AllocationEvent.Allocation allocation = event.getAllocData();
                LiveAllocationInstanceObject instance = this.getOrCreateInstanceObject(allocation.getTag(), allocation.getClassTag(), allocation.getStackId(), allocation.getThreadId(), allocation.getSize(), allocation.getHeapId());
                instance.setAllocationTime(event.getTimestamp());
                setAllocationList.add(instance);
                continue;
            }
            assert (false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void queryJniReferencesSnapshot(long newTimeNs, @NotNull List<InstanceObject> list) {
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(16);
        }
        if (!this.myEnableJniRefsTracking) {
            return;
        }
        MemoryProfiler.JNIGlobalRefsEventsRequest request = MemoryProfiler.JNIGlobalRefsEventsRequest.newBuilder().setSession(this.mySession).setLiveObjectsOnly(true).setEndTime(newTimeNs).build();
        MemoryProfiler.BatchJNIGlobalRefEvent jniBatch = this.myClient.getJNIGlobalRefsEvents(request);
        for (MemoryProfiler.JNIGlobalReferenceEvent event : jniBatch.getEventsList()) {
            void setAllocationList;
            JniReferenceInstanceObject refObject;
            if (event.getEventType() != MemoryProfiler.JNIGlobalReferenceEvent.Type.CREATE_GLOBAL_REF || (refObject = this.getOrCreateJniRefObject(event.getObjectTag(), event.getRefValue())) == null) continue;
            if (event.hasBacktrace()) {
                refObject.setAllocationBacktrace(event.getBacktrace());
            }
            int threadId = event.getThreadId();
            ThreadId thread2 = ThreadId.INVALID_THREAD_ID;
            if (threadId != 0) {
                assert (this.myThreadIdMap.containsKey(threadId));
                thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
            }
            refObject.setAllocThreadId(thread2);
            refObject.setAllocationTime(event.getTimestamp());
            setAllocationList.add(refObject);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void queryJavaInstanceDelta(long startTimeNs, long endTimeNs, @NotNull List<InstanceObject> allocationList, @NotNull List<InstanceObject> list, boolean bl) {
        if (allocationList == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(17);
        }
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(18);
        }
        if (startTimeNs == endTimeNs) {
            return;
        }
        MemoryProfiler.BatchAllocationSample sampleResponse = this.myClient.getAllocations(MemoryProfiler.AllocationSnapshotRequest.newBuilder().setSession(this.mySession).setStartTime(startTimeNs).setEndTime(endTimeNs).build());
        for (MemoryProfiler.AllocationEvent event : sampleResponse.getEventsList()) {
            void resetInstance;
            LiveAllocationInstanceObject instance;
            if (event.getEventCase() == MemoryProfiler.AllocationEvent.EventCase.ALLOC_DATA) {
                MemoryProfiler.AllocationEvent.Allocation allocation = event.getAllocData();
                instance = this.getOrCreateInstanceObject(allocation.getTag(), allocation.getClassTag(), allocation.getStackId(), allocation.getThreadId(), allocation.getSize(), allocation.getHeapId());
                instance.setAllocationTime(resetInstance != false ? Long.MIN_VALUE : event.getTimestamp());
                allocationList.add(instance);
                continue;
            }
            if (event.getEventCase() == MemoryProfiler.AllocationEvent.EventCase.FREE_DATA) {
                void deallocatoinList;
                MemoryProfiler.AllocationEvent.Deallocation deallocation = event.getFreeData();
                instance = this.getOrCreateInstanceObject(deallocation.getTag(), deallocation.getClassTag(), deallocation.getStackId(), deallocation.getThreadId(), deallocation.getSize(), deallocation.getHeapId());
                instance.setDeallocTime(resetInstance != false ? Long.MAX_VALUE : event.getTimestamp());
                deallocatoinList.add(instance);
                continue;
            }
            assert (false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void queryJniReferencesDelta(long startTimeNs, long endTimeNs, @NotNull List<InstanceObject> allocationList, @NotNull List<InstanceObject> list, boolean bl) {
        if (allocationList == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(19);
        }
        if (list == null) {
            LiveAllocationCaptureObject.$$$reportNull$$$0(20);
        }
        if (!this.myEnableJniRefsTracking || startTimeNs == endTimeNs) {
            return;
        }
        MemoryProfiler.JNIGlobalRefsEventsRequest request = MemoryProfiler.JNIGlobalRefsEventsRequest.newBuilder().setSession(this.mySession).setStartTime(startTimeNs).setEndTime(endTimeNs).build();
        MemoryProfiler.BatchJNIGlobalRefEvent jniBatch = this.myClient.getJNIGlobalRefsEvents(request);
        block4: for (MemoryProfiler.JNIGlobalReferenceEvent event : jniBatch.getEventsList()) {
            JniReferenceInstanceObject refObject = this.getOrCreateJniRefObject(event.getObjectTag(), event.getRefValue());
            if (refObject == null) continue;
            int threadId = event.getThreadId();
            ThreadId thread2 = ThreadId.INVALID_THREAD_ID;
            if (threadId != 0) {
                assert (this.myThreadIdMap.containsKey(threadId));
                thread2 = (ThreadId)this.myThreadIdMap.get(threadId);
            }
            switch (event.getEventType()) {
                case CREATE_GLOBAL_REF: {
                    void resetInstance;
                    if (resetInstance != false) {
                        refObject.setAllocationTime(Long.MIN_VALUE);
                    } else {
                        refObject.setAllocationTime(event.getTimestamp());
                        if (event.hasBacktrace()) {
                            refObject.setAllocationBacktrace(event.getBacktrace());
                        }
                        refObject.setAllocThreadId(thread2);
                    }
                    allocationList.add(refObject);
                    continue block4;
                }
                case DELETE_GLOBAL_REF: {
                    void deallocatoinList;
                    void resetInstance;
                    if (resetInstance != false) {
                        refObject.setAllocationTime(Long.MAX_VALUE);
                    } else {
                        refObject.setDeallocTime(event.getTimestamp());
                        if (event.hasBacktrace()) {
                            refObject.setDeallocationBacktrace(event.getBacktrace());
                        }
                        refObject.setDeallocThreadId(thread2);
                    }
                    deallocatoinList.add(refObject);
                    continue block4;
                }
            }
            assert (false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryRange";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joiner";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setAllocationList";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationList";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deallocatoinList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClient";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierAttributes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceAttributes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapSets";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateInstanceObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadTimeRange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "queryJavaInstanceSnapshot";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "queryJniReferencesSnapshot";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "queryJavaInstanceDelta";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "queryJniReferencesDelta";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadTimeRange$12";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

