/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.statechart.DefaultStateChartReducer;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.chart.statechart.StateChartConfig;
import com.android.tools.adtui.chart.statechart.StateChartReducer;
import com.android.tools.adtui.model.legend.FixedLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.network.NetworkRadioDataSeries;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.EnumMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class NetworkRadioView {
    private static final String LABEL = "RADIO";
    private static final double STATE_CHART_HEIGHT_RATIO = 0.6;
    private static final double STATE_CHART_OVER_HEIGHT_RATIO = 1.0;
    private static final float STATE_CHART_OFFSET = 0.1f;
    private static final EnumMap<NetworkRadioDataSeries.RadioState, Color> RADIO_STATE_COLOR = new EnumMap(NetworkRadioDataSeries.RadioState.class);
    @NotNull
    private final StateChart<NetworkRadioDataSeries.RadioState> myRadioChart;
    @NotNull
    private final JComponent myComponent;

    public NetworkRadioView(@NotNull NetworkProfilerStageView stageView) {
        if (stageView == null) {
            NetworkRadioView.$$$reportNull$$$0(0);
        }
        StateChartConfig config = new StateChartConfig((StateChartReducer)new DefaultStateChartReducer(), 0.6, 1.0, 0.1f);
        this.myRadioChart = new StateChart(((NetworkProfilerStage)stageView.getStage()).getRadioState(), config, (StateChartColorProvider)new StateChartColorProvider<NetworkRadioDataSeries.RadioState>(){

            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull NetworkRadioDataSeries.RadioState value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                Color color = (Color)RADIO_STATE_COLOR.get((Object)value);
                if (color == null) {
                    1.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/network/NetworkRadioView$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/network/NetworkRadioView$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getColor";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myComponent = new JPanel();
        this.myComponent.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myComponent.setBorder(ProfilerLayout.MONITOR_BORDER);
        this.populateUI(this.myComponent);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            NetworkRadioView.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    private void populateUI(@NotNull JComponent panel) {
        if (panel == null) {
            NetworkRadioView.$$$reportNull$$$0(2);
        }
        JLabel label = new JLabel(LABEL);
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        LegendComponentModel legendModel = new LegendComponentModel(100);
        FixedLegend wifiLegend = new FixedLegend(NetworkRadioDataSeries.RadioState.WIFI.toString());
        FixedLegend highLegend = new FixedLegend(NetworkRadioDataSeries.RadioState.HIGH.toString());
        FixedLegend lowLegend = new FixedLegend(NetworkRadioDataSeries.RadioState.LOW.toString());
        legendModel.add((Legend)wifiLegend);
        legendModel.add((Legend)highLegend);
        legendModel.add((Legend)lowLegend);
        LegendComponent legend = new LegendComponent.Builder(legendModel).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.configure((Legend)wifiLegend, new LegendConfig(LegendConfig.IconType.LINE, RADIO_STATE_COLOR.get((Object)NetworkRadioDataSeries.RadioState.WIFI)));
        legend.configure((Legend)highLegend, new LegendConfig(LegendConfig.IconType.LINE, RADIO_STATE_COLOR.get((Object)NetworkRadioDataSeries.RadioState.HIGH)));
        legend.configure((Legend)lowLegend, new LegendConfig(LegendConfig.IconType.LINE, RADIO_STATE_COLOR.get((Object)NetworkRadioDataSeries.RadioState.LOW)));
        legendModel.update(1L);
        JPanel topPane = new JPanel(new BorderLayout());
        topPane.setOpaque(false);
        topPane.add((Component)label, "West");
        topPane.add((Component)legend, "East");
        panel.setLayout((LayoutManager)new TabularLayout("*", "Fit-,12px,8px"));
        panel.add((Component)topPane, new TabularLayout.Constraint(0, 0));
        panel.add((Component)this.myRadioChart, new TabularLayout.Constraint(1, 0));
    }

    static {
        RADIO_STATE_COLOR.put(NetworkRadioDataSeries.RadioState.NONE, ProfilerColors.DEFAULT_BACKGROUND);
        RADIO_STATE_COLOR.put(NetworkRadioDataSeries.RadioState.WIFI, ProfilerColors.NETWORK_RADIO_WIFI);
        RADIO_STATE_COLOR.put(NetworkRadioDataSeries.RadioState.HIGH, ProfilerColors.NETWORK_RADIO_HIGH);
        RADIO_STATE_COLOR.put(NetworkRadioDataSeries.RadioState.LOW, ProfilerColors.NETWORK_RADIO_LOW);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/NetworkRadioView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/NetworkRadioView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "populateUI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

