/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.details.TabUiUtils;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.android.tools.profilers.network.httpdata.Payload;
import com.android.tools.profilers.stacktrace.DataViewer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HttpDataViewModel {
    private static final String ID_PAYLOAD_VIEWER = "PAYLOAD_VIEWER";
    private final NetworkConnectionsModel myModel;
    private final HttpData myHttpData;

    public HttpDataViewModel(@NotNull NetworkConnectionsModel model, @NotNull HttpData httpData) {
        if (model == null) {
            HttpDataViewModel.$$$reportNull$$$0(0);
        }
        if (httpData == null) {
            HttpDataViewModel.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myHttpData = httpData;
    }

    @VisibleForTesting
    @Nullable
    static JComponent findPayloadViewer(@Nullable JComponent body) {
        if (body == null) {
            return null;
        }
        return TabUiUtils.findComponentWithUniqueName(body, ID_PAYLOAD_VIEWER);
    }

    @NotNull
    public JComponent createHeaderComponent(@NotNull ConnectionType type) {
        if (type == null) {
            HttpDataViewModel.$$$reportNull$$$0(2);
        }
        JComponent jComponent = TabUiUtils.createStyledMapComponent(type.getHeader(this.myHttpData).getFields());
        if (jComponent == null) {
            HttpDataViewModel.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    public String getBodyTitle(@NotNull ConnectionType type) {
        HttpData.Header header;
        HttpData.ContentType contentType;
        if (type == null) {
            HttpDataViewModel.$$$reportNull$$$0(4);
        }
        if ((contentType = (header = type.getHeader(this.myHttpData)).getContentType()).isEmpty()) {
            if ("Body" == null) {
                HttpDataViewModel.$$$reportNull$$$0(5);
            }
            return "Body";
        }
        String string = String.format("Body ( %s )", contentType.getTypeDisplayName());
        if (string == null) {
            HttpDataViewModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public JComponent createBodyComponent(@NotNull IdeProfilerComponents components, @NotNull ConnectionType type) {
        JComponent payloadComponent;
        Payload payload;
        File payloadFile;
        if (components == null) {
            HttpDataViewModel.$$$reportNull$$$0(7);
        }
        if (type == null) {
            HttpDataViewModel.$$$reportNull$$$0(8);
        }
        if ((payloadFile = (payload = type.getPayload(this.myModel, this.myHttpData)).toFile()).length() > 0L) {
            DataViewer viewer = components.createFileViewer(payloadFile);
            JComponent viewerComponent = viewer.getComponent();
            viewerComponent.setName(ID_PAYLOAD_VIEWER);
            int minimumHeight = 300;
            int originalHeight = viewer.getDimension() != null ? (int)viewer.getDimension().getHeight() : minimumHeight;
            viewerComponent.setMinimumSize(new Dimension(1, Math.min(minimumHeight, originalHeight)));
            viewerComponent.setBorder((Border)new JBEmptyBorder(6, 0, 0, 0));
            payloadComponent = new JPanel((LayoutManager)new TabularLayout("*"));
            payloadComponent.add((Component)viewerComponent, new TabularLayout.Constraint(0, 0));
        } else {
            payloadComponent = new JLabel("Not available");
        }
        JLabel jLabel = payloadComponent;
        if (jLabel == null) {
            HttpDataViewModel.$$$reportNull$$$0(9);
        }
        return jLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpData";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/details/HttpDataViewModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/details/HttpDataViewModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderComponent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyTitle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createBodyComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHeaderComponent";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBodyTitle";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBodyComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ConnectionType {
        REQUEST,
        RESPONSE;


        @NotNull
        HttpData.Header getHeader(@NotNull HttpData data) {
            if (data == null) {
                ConnectionType.$$$reportNull$$$0(0);
            }
            HttpData.Header header = this == REQUEST ? data.getRequestHeader() : data.getResponseHeader();
            if (header == null) {
                ConnectionType.$$$reportNull$$$0(1);
            }
            return header;
        }

        @NotNull
        Payload getPayload(@NotNull NetworkConnectionsModel model, @NotNull HttpData data) {
            if (model == null) {
                ConnectionType.$$$reportNull$$$0(2);
            }
            if (data == null) {
                ConnectionType.$$$reportNull$$$0(3);
            }
            Payload payload = this == REQUEST ? Payload.newRequestPayload(model, data) : Payload.newResponsePayload(model, data);
            if (payload == null) {
                ConnectionType.$$$reportNull$$$0(4);
            }
            return payload;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/details/HttpDataViewModel$ConnectionType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/details/HttpDataViewModel$ConnectionType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeader";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPayload";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getHeader";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPayload";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

