/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.ui.BreakWordWrapHtmlTextPane;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerFonts;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TabUiUtils {
    public static final int SCROLL_UNIT = JBUI.scale((int)10);
    public static final int HORIZONTAL_PADDING = 15;
    public static final int TAB_SECTION_VGAP = JBUI.scale((int)5);
    public static final int PAGE_VGAP = JBUI.scale((int)28);
    public static final int SECTION_VGAP = JBUI.scale((int)10);
    public static final int HGAP = JBUI.scale((int)22);
    public static final String SECTION_TITLE_HEADERS = "Headers";

    private TabUiUtils() {
    }

    @NotNull
    public static JPanel createVerticalPanel(int verticalGap) {
        JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, verticalGap));
        if (jPanel == null) {
            TabUiUtils.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @NotNull
    public static JBScrollPane createScrollPane(@NotNull JComponent component) {
        if (component == null) {
            TabUiUtils.$$$reportNull$$$0(1);
        }
        JBScrollPane scrollPane = new JBScrollPane((Component)component);
        scrollPane.getVerticalScrollBar().setUnitIncrement(SCROLL_UNIT);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(SCROLL_UNIT);
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            TabUiUtils.$$$reportNull$$$0(2);
        }
        return jBScrollPane;
    }

    @NotNull
    public static JBScrollPane createVerticalScrollPane(@NotNull JComponent component) {
        if (component == null) {
            TabUiUtils.$$$reportNull$$$0(3);
        }
        JBScrollPane scrollPane = TabUiUtils.createScrollPane(component);
        scrollPane.setHorizontalScrollBarPolicy(31);
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            TabUiUtils.$$$reportNull$$$0(4);
        }
        return jBScrollPane;
    }

    @NotNull
    public static JSeparator createSeparator() {
        JSeparator separator = new JSeparator();
        separator.setForeground(UIManager.getColor("Table.gridColor"));
        JSeparator jSeparator = separator;
        if (jSeparator == null) {
            TabUiUtils.$$$reportNull$$$0(5);
        }
        return jSeparator;
    }

    @NotNull
    public static HideablePanel createHideablePanel(@NotNull String title, @NotNull JComponent content, @Nullable JComponent northEastComponent) {
        if (title == null) {
            TabUiUtils.$$$reportNull$$$0(6);
        }
        if (content == null) {
            TabUiUtils.$$$reportNull$$$0(7);
        }
        title = String.format("<html><b>%s</b></html>", title);
        HideablePanel hideablePanel = new HideablePanel.Builder(title, content).setNorthEastComponent(northEastComponent).setPanelBorder((Border)new JBEmptyBorder(10, 0, 0, 0)).setContentBorder((Border)new JBEmptyBorder(10, 12, 0, 0)).build();
        if (hideablePanel == null) {
            TabUiUtils.$$$reportNull$$$0(8);
        }
        return hideablePanel;
    }

    @NotNull
    public static JComponent createStyledMapComponent(@NotNull Map<String, String> map) {
        if (map == null) {
            TabUiUtils.$$$reportNull$$$0(9);
        }
        if (map.isEmpty()) {
            JLabel jLabel = new JLabel("Not available");
            if (jLabel == null) {
                TabUiUtils.$$$reportNull$$$0(10);
            }
            return jLabel;
        }
        BreakWordWrapHtmlTextPane textPane = new BreakWordWrapHtmlTextPane();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append("<p><b>").append(entry.getKey()).append("</b>:&nbsp&nbsp");
            stringBuilder.append("<span>").append(entry.getValue()).append("</span></p>");
        }
        stringBuilder.append("</html>");
        textPane.setText(stringBuilder.toString());
        BreakWordWrapHtmlTextPane breakWordWrapHtmlTextPane = textPane;
        if (breakWordWrapHtmlTextPane == null) {
            TabUiUtils.$$$reportNull$$$0(11);
        }
        return breakWordWrapHtmlTextPane;
    }

    @NotNull
    public static JComponent createMapComponent(@NotNull Map<String, String> argsMap) {
        if (argsMap == null) {
            TabUiUtils.$$$reportNull$$$0(12);
        }
        if (argsMap.isEmpty()) {
            JLabel jLabel = new JLabel("Not available");
            if (jLabel == null) {
                TabUiUtils.$$$reportNull$$$0(13);
            }
            return jLabel;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        for (Map.Entry<String, String> entry : argsMap.entrySet()) {
            stringBuilder.append("<p><nobr><b>").append(entry.getKey()).append(":&nbsp&nbsp</b></nobr>");
            stringBuilder.append("<span>").append(entry.getValue()).append("</span></p>");
        }
        stringBuilder.append("</html>");
        JTextPane jTextPane = TabUiUtils.createTextPane(stringBuilder.toString());
        if (jTextPane == null) {
            TabUiUtils.$$$reportNull$$$0(14);
        }
        return jTextPane;
    }

    @NotNull
    private static JTextPane createTextPane(String text) {
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/html");
        textPane.setBackground(null);
        textPane.setBorder(null);
        textPane.setEditable(false);
        textPane.setText(text);
        String rule = "body { font-family: " + ProfilerFonts.STANDARD_FONT.getFamily() + "; font-size: " + ProfilerFonts.STANDARD_FONT.getSize2D() + "pt; }";
        ((HTMLDocument)textPane.getDocument()).getStyleSheet().addRule(rule);
        JTextPane jTextPane = textPane;
        if (jTextPane == null) {
            TabUiUtils.$$$reportNull$$$0(15);
        }
        return jTextPane;
    }

    public static void adjustFont(@NotNull Component c) {
        if (c == null) {
            TabUiUtils.$$$reportNull$$$0(16);
        }
        if (c.getFont() == null) {
            return;
        }
        c.setFont(c.getFont().deriveFont(0, ProfilerFonts.STANDARD_FONT.getSize2D()));
    }

    @Nullable
    public static JComponent findComponentWithUniqueName(@NotNull JComponent root, @NotNull String name) {
        List matches;
        if (root == null) {
            TabUiUtils.$$$reportNull$$$0(17);
        }
        if (name == null) {
            TabUiUtils.$$$reportNull$$$0(18);
        }
        if ((matches = new TreeWalker((Component)root).descendantStream().filter(c -> {
            if (name == null) {
                TabUiUtils.$$$reportNull$$$0(19);
            }
            return name.equals(c.getName());
        }).collect(Collectors.toList())).size() > 1) {
            throw new IllegalStateException("More than one component found with the name: " + name);
        }
        return matches.size() == 1 ? (JComponent)matches.get(0) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/details/TabUiUtils";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argsMap";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVerticalPanel";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/details/TabUiUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVerticalScrollPane";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createHideablePanel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createStyledMapComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createMapComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVerticalScrollPane";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createHideablePanel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createStyledMapComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createMapComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "adjustFont";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findComponentWithUniqueName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findComponentWithUniqueName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

