/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.util;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import trebuchet.io.DataSlice;
import trebuchet.io.GenericByteBuffer;
import trebuchet.io.StreamingReader;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0006J\"\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00152\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0006J\"\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0006J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0014\u001a\u00020\u0006J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006 "}, d2={"Ltrebuchet/util/StringSearch;", "", "lookFor", "", "(Ljava/lang/String;)V", "length", "", "getLength", "()I", "getLookFor", "()Ljava/lang/String;", "skipLut", "", "getSkipLut", "()[B", "suffixSkip", "getSuffixSkip", "find", "buffer", "startIndex", "endIndex", "Ltrebuchet/io/GenericByteBuffer;", "reader", "Ltrebuchet/io/StreamingReader;", "inEndIndex", "findInLoadedRegion", "findInWindow", "window", "Ltrebuchet/io/StreamingReader$Window;", "globalStartIndex", "globalEndIndex", "Companion", "profilers-atrace"})
public final class StringSearch {
    @NotNull
    private final byte[] skipLut;
    @NotNull
    private final byte[] suffixSkip;
    @NotNull
    private final String lookFor;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] getSkipLut() {
        return this.skipLut;
    }

    @NotNull
    public final byte[] getSuffixSkip() {
        return this.suffixSkip;
    }

    public final int getLength() {
        return this.lookFor.length();
    }

    public final int find(@NotNull StreamingReader reader, int startIndex, int inEndIndex) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        int index = startIndex + this.lookFor.length() - 1;
        int endIndex = inEndIndex;
        while (index <= endIndex) {
            if (index > reader.getEndIndex()) {
                if (!reader.loadIndex(index)) {
                    return -1;
                }
                if (reader.getReachedEof()) {
                    endIndex = reader.getEndIndex();
                }
            }
            while (reader.windowFor(index) != reader.windowFor(index - this.lookFor.length() + 1)) {
                byte by;
                int lookForIndex;
                for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && reader.get(index) == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                    --index;
                }
                if (lookForIndex < 0) {
                    return index + 1;
                }
                int n = index;
                byte by2 = this.skipLut[reader.get(index) & 0xFF];
                byte by3 = (byte)Math.max(by2, by = this.suffixSkip[lookForIndex]);
                if ((index = n + by3) <= reader.getEndIndex()) continue;
                if (!reader.loadIndex(index)) {
                    return -1;
                }
                if (!reader.getReachedEof()) continue;
                endIndex = reader.getEndIndex();
            }
            StreamingReader.Window window = reader.windowFor(index);
            if ((index = this.findInWindow(window, index, endIndex)) > window.getGlobalEndIndex()) continue;
            return index;
        }
        return -1;
    }

    public static /* bridge */ /* synthetic */ int find$default(StringSearch stringSearch, StreamingReader streamingReader, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        return stringSearch.find(streamingReader, n, n2);
    }

    public final int findInLoadedRegion(@NotNull StreamingReader reader, int endIndex) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        int index = reader.getStartIndex() + this.lookFor.length() - 1;
        while (index <= endIndex) {
            while (reader.windowFor(index) != reader.windowFor(index - this.lookFor.length() + 1)) {
                int lookForIndex;
                for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && reader.get(index) == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                    --index;
                }
                if (lookForIndex < 0) {
                    return index + 1;
                }
                byte by = this.skipLut[reader.get(index) & 0xFF];
                byte by2 = this.suffixSkip[lookForIndex];
                int n = index;
                byte by3 = (byte)Math.max(by, by2);
                index = n + by3;
            }
            StreamingReader.Window window = reader.windowFor(index);
            if ((index = this.findInWindow(window, index, endIndex)) >= window.getGlobalEndIndex() || index >= endIndex) continue;
            return index;
        }
        return -1;
    }

    public static /* bridge */ /* synthetic */ int findInLoadedRegion$default(StringSearch stringSearch, StreamingReader streamingReader, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = streamingReader.getEndIndex();
        }
        return stringSearch.findInLoadedRegion(streamingReader, n);
    }

    public final int find(@NotNull GenericByteBuffer buffer, int startIndex, int endIndex) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        int index = startIndex + this.lookFor.length() - 1;
        while (index < endIndex) {
            int lookForIndex;
            for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && buffer.get(index) == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                --index;
            }
            if (lookForIndex < 0) {
                ++index;
                break;
            }
            byte by = this.skipLut[buffer.get(index) & 0xFF];
            byte by2 = this.suffixSkip[lookForIndex];
            int n = index;
            byte by3 = (byte)Math.max(by, by2);
            index = n + by3;
        }
        return index;
    }

    public static /* bridge */ /* synthetic */ int find$default(StringSearch stringSearch, GenericByteBuffer genericByteBuffer, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = genericByteBuffer.getLength();
        }
        return stringSearch.find(genericByteBuffer, n, n2);
    }

    public final int find(@NotNull byte[] buffer, int startIndex, int endIndex) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        int index = startIndex + this.lookFor.length() - 1;
        while (index < endIndex) {
            int lookForIndex;
            for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && buffer[index] == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                --index;
            }
            if (lookForIndex < 0) {
                ++index;
                break;
            }
            byte by = this.skipLut[buffer[index] & 0xFF];
            byte by2 = this.suffixSkip[lookForIndex];
            int n = index;
            byte by3 = (byte)Math.max(by, by2);
            index = n + by3;
        }
        return index;
    }

    public static /* bridge */ /* synthetic */ int find$default(StringSearch stringSearch, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return stringSearch.find(byArray, n, n2);
    }

    private final int findInWindow(StreamingReader.Window window, int globalStartIndex, int globalEndIndex) {
        int index = globalStartIndex - window.getGlobalStartIndex();
        DataSlice buffer = window.getSlice();
        int n = window.getGlobalEndIndex();
        int endIndex = Math.min(n, globalEndIndex) - window.getGlobalStartIndex();
        while (index <= endIndex) {
            DataSlice this_$iv;
            int lookForIndex;
            for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && (this_$iv = buffer).getBuffer()[this_$iv.getStartIndex() + index] == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                --index;
            }
            if (lookForIndex < 0) {
                ++index;
                break;
            }
            this_$iv = buffer;
            byte[] byArray = this.skipLut;
            int n2 = index;
            byte by = this_$iv.getBuffer()[this_$iv.getStartIndex() + index];
            byte by2 = byArray[by & 0xFF];
            byte by3 = this.suffixSkip[lookForIndex];
            byte by4 = (byte)Math.max(by2, by3);
            index = n2 + by4;
        }
        return index + window.getGlobalStartIndex();
    }

    @NotNull
    public final String getLookFor() {
        return this.lookFor;
    }

    /*
     * WARNING - void declaration
     */
    public StringSearch(@NotNull String lookFor) {
        int i;
        byte[] byArray;
        int i$iv;
        void size$iv;
        Intrinsics.checkParameterIsNotNull((Object)lookFor, (String)"lookFor");
        this.lookFor = lookFor;
        int n = 256;
        StringSearch stringSearch = this;
        byte[] result$iv22 = new byte[size$iv];
        int n2 = 0;
        int n3 = result$iv22.length;
        while (n2 < n3) {
            byte by;
            void var6_8 = i$iv;
            int n4 = i$iv++;
            byArray = result$iv22;
            byArray[n4] = by = (byte)this.lookFor.length();
        }
        byArray = result$iv22;
        stringSearch.skipLut = byArray;
        this.suffixSkip = new byte[this.lookFor.length()];
        int result$iv22 = 0;
        int last = this.lookFor.length() - 1;
        i$iv = last - 1;
        if (result$iv22 <= i$iv) {
            while (true) {
                void i2;
                this.skipLut[this.lookFor.charAt((int)i2) & 0xFF] = (byte)(last - i2);
                if (i2 == i$iv) break;
                ++i2;
            }
        }
        int lastPrefix = last;
        i$iv = last;
        n3 = 0;
        while (i$iv >= 0) {
            if (Companion.isPrefix(this.lookFor, i + 1)) {
                lastPrefix = i + 1;
            }
            this.suffixSkip[i] = (byte)(lastPrefix + last - i);
            --i;
        }
        n3 = last;
        for (i = 0; i < n3; ++i) {
            int suffixLength = Companion.longestCommonSuffix(this.lookFor, i);
            if (this.lookFor.charAt(i - suffixLength) == this.lookFor.charAt(last - suffixLength)) continue;
            this.suffixSkip[last - suffixLength] = (byte)(suffixLength + last - i);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Ltrebuchet/util/StringSearch$Companion;", "", "()V", "isPrefix", "", "str", "", "pos", "", "longestCommonSuffix", "word", "profilers-atrace"})
    private static final class Companion {
        public final boolean isPrefix(@NotNull CharSequence str, int pos) {
            boolean bl;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
                Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)(str.length() - pos));
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $receiver$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv = ((IntIterator)iterator).nextInt();
                        int it = element$iv;
                        if (!(str.charAt(it) != str.charAt(pos + it))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final int longestCommonSuffix(@NotNull CharSequence word, int pos) {
            int i;
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            for (i = 0; word.charAt(pos - i) == word.charAt(word.length() - 1 - i) && i < pos; ++i) {
            }
            return i;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

