/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.api;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.google.appindexing.util.AppIndexingBundle;
import com.google.appindexing.util.DeepLinkUtils;
import com.google.common.collect.ImmutableList;
import com.google.urlassistant.util.InsertCodeUtils;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.StatementFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.VersionComparatorUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApiCreator {
    private static final String METHOD_GET_ACTION = "getIndexApiAction";
    private static final String CLASS_ACTION = "Action";
    private static final String CLASS_FIREBASE_USER_ACTION = "FirebaseUserActions";
    private static final String CLASS_BUILDERS_ACTIONS = "Actions";
    private static final String CLASS_FIREBASE_APP_INDEX = "FirebaseAppIndex";
    private static final String CLASS_INDEXABLE = "Indexable";
    private static final String CLASS_ACTION_FULL = "com.google.firebase.appindexing.Action";
    private static final String CLASS_FIREBASE_USER_ACTION_FULL = "com.google.firebase.appindexing.FirebaseUserActions";
    private static final String CLASS_BUILDERS_ACTIONS_FULL = "com.google.firebase.appindexing.builders.Actions";
    private static final String CLASS_FIREBASE_APP_INDEX_FULL = "com.google.firebase.appindexing.FirebaseAppIndex";
    private static final String CLASS_INDEXABLE_FULL = "com.google.firebase.appindexing.Indexable";
    private static final String ON_START_FORMAT = "@Override\npublic void onStart(){\n  super.onStart();\n  \n  // ATTENTION: This was auto-generated to implement the App Indexing API.\n  // See https://g.co/AppIndexing/AndroidStudio for more information.\n  %1$s\n  %2$s.getInstance().start(%3$s());\n}";
    private static final String ON_STOP_FORMAT = "@Override\npublic void onStop() {\n  \n  // ATTENTION: This was auto-generated to implement the App Indexing API.\n  // See https://g.co/AppIndexing/AndroidStudio for more information.\n  %1$s.getInstance().end(%2$s());\n  super.onStop();\n}";
    private static final String GET_ACTION_FORMAT = "/**\n * ATTENTION: This was auto-generated to implement the App Indexing API.\n * See https://g.co/AppIndexing/AndroidStudio for more information.\n */\npublic %1$s %2$s() {\n  return %3$s.newView(\"%4$s\", \"%5$s\");\n}";
    private static final String FIREBASE_APP_INDEX_UPDATE_TEMPLATE = "%1$s.getInstance().update(new %2$s.Builder().setName(\"%3$s\").setUrl(\"%4$s\").build());";
    private static final String FIREBASE_USER_ACTION_START_TEMPLATE = "%1$s.getInstance().start(%2$s());";
    private static final String FIREBASE_USER_ACTION_END_TEMPLATE = "%1$s.getInstance().end(%2$s());";
    private static final String FIREBASE_USER_ACTION_START = "FirebaseUserActions.getInstance().start";
    private static final String FIREBASE_APP_INDEX_UPDATE = "FirebaseAppIndex.getInstance().update";
    private static final String FIREBASE_USER_ACTION_END = "FirebaseUserActions.getInstance().end";
    private static final List<String> COMMENT_IN_JAVA = ImmutableList.of((Object)"// ATTENTION: This was auto-generated to implement the App Indexing API.", (Object)"// See https://g.co/AppIndexing/AndroidStudio for more information.");
    private static final String APP_INDEXING_LIB_DEPENDENCY = "com.google.firebase:firebase-appindexing:10.0.1+";
    private static final String APP_INDEXING_CLASSPATH_DEPENDENCY = "com.google.gms:google-services:3.0.0+";
    private static final String APP_INDEXING_PLUGIN_DEPENDENCY = "com.google.gms.google-services";
    private Project myProject;
    private Module myModule;
    private PsiFile myFile;
    private PsiClass myActivity;
    private PsiElementFactory myFactory;
    private CodeStyleManager myCodeStyleManager;
    private PsiCodeBlock myOnStart;
    private PsiCodeBlock myOnStop;
    private String myDeepLink;
    private List<PsiStatement> myIndexUpdateStatements;
    private List<PsiStatement> myStartStatements;
    private List<PsiStatement> myEndStatements;
    private static Map<String, String> myImportClasses = new HashMap<String, String>();

    public ApiCreator(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiClass activityClass) {
        if (project == null) {
            ApiCreator.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ApiCreator.$$$reportNull$$$0(1);
        }
        if (activityClass == null) {
            ApiCreator.$$$reportNull$$$0(2);
        }
        this.myProject = null;
        this.myModule = null;
        this.myFile = null;
        this.myActivity = null;
        this.myFactory = null;
        this.myCodeStyleManager = null;
        this.myOnStart = null;
        this.myOnStop = null;
        this.myDeepLink = null;
        this.myIndexUpdateStatements = new ArrayList<PsiStatement>();
        this.myStartStatements = new ArrayList<PsiStatement>();
        this.myEndStatements = new ArrayList<PsiStatement>();
        this.myProject = project;
        this.myFile = file;
        this.myModule = ModuleUtilCore.findModuleForFile((VirtualFile)this.myFile.getVirtualFile(), (Project)this.myProject);
        this.myActivity = activityClass;
        this.myOnStart = InsertCodeUtils.getMethodBodyByName((String)"onStart", Collections.emptyList(), (PsiClass)this.myActivity);
        this.myOnStop = InsertCodeUtils.getMethodBodyByName((String)"onStop", Collections.emptyList(), (PsiClass)this.myActivity);
        if (this.myOnStart != null) {
            this.myIndexUpdateStatements = StatementFilter.filterCodeBlock((String)FIREBASE_APP_INDEX_UPDATE, (PsiCodeBlock)this.myOnStart);
            this.myStartStatements = StatementFilter.filterCodeBlock((String)FIREBASE_USER_ACTION_START, (PsiCodeBlock)this.myOnStart);
        }
        if (this.myOnStop != null) {
            this.myEndStatements = StatementFilter.filterCodeBlock((String)FIREBASE_USER_ACTION_END, (PsiCodeBlock)this.myOnStop);
        }
        this.myDeepLink = this.getFirstDeepLinkOfActivity();
        this.myFactory = (PsiElementFactory)JVMElementFactories.getFactory((Language)JavaLanguage.INSTANCE, (Project)this.myProject);
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        myImportClasses.put(CLASS_ACTION, CLASS_ACTION_FULL);
        myImportClasses.put(CLASS_BUILDERS_ACTIONS, CLASS_BUILDERS_ACTIONS_FULL);
        myImportClasses.put(CLASS_FIREBASE_USER_ACTION, CLASS_FIREBASE_USER_ACTION_FULL);
        myImportClasses.put(CLASS_FIREBASE_APP_INDEX, CLASS_FIREBASE_APP_INDEX_FULL);
        myImportClasses.put(CLASS_INDEXABLE, CLASS_INDEXABLE_FULL);
    }

    @NotNull
    public InsertStatusCode eligibleForInsertingAppIndexingApiCode() {
        if (!(this.myFile instanceof PsiJavaFile)) {
            InsertStatusCode insertStatusCode = InsertStatusCode.NON_JAVA_FILE;
            if (insertStatusCode == null) {
                ApiCreator.$$$reportNull$$$0(3);
            }
            return insertStatusCode;
        }
        if (this.myActivity == null) {
            InsertStatusCode insertStatusCode = InsertStatusCode.JAVA_FILE_WITHOUT_ACTIVITY;
            if (insertStatusCode == null) {
                ApiCreator.$$$reportNull$$$0(4);
            }
            return insertStatusCode;
        }
        assert (this.myModule != null);
        if (!ApiCreator.hasEnoughDependencies(this.myModule)) {
            InsertStatusCode insertStatusCode = InsertStatusCode.DEPENDENCY_MISSING;
            if (insertStatusCode == null) {
                ApiCreator.$$$reportNull$$$0(5);
            }
            return insertStatusCode;
        }
        assert (this.myFactory != null);
        assert (this.myCodeStyleManager != null);
        if (StringUtil.isEmpty((String)this.myDeepLink)) {
            InsertStatusCode insertStatusCode = InsertStatusCode.DEEP_LINK_MISSING;
            if (insertStatusCode == null) {
                ApiCreator.$$$reportNull$$$0(6);
            }
            return insertStatusCode;
        }
        if (this.myOnStart == null || this.myOnStop == null) {
            InsertStatusCode insertStatusCode = InsertStatusCode.SUCCESS;
            if (insertStatusCode == null) {
                ApiCreator.$$$reportNull$$$0(7);
            }
            return insertStatusCode;
        }
        if (this.myStartStatements.isEmpty() || this.myIndexUpdateStatements.isEmpty() || this.myEndStatements.isEmpty()) {
            InsertStatusCode insertStatusCode = InsertStatusCode.SUCCESS;
            if (insertStatusCode == null) {
                ApiCreator.$$$reportNull$$$0(8);
            }
            return insertStatusCode;
        }
        InsertStatusCode insertStatusCode = InsertStatusCode.API_EXISTS;
        if (insertStatusCode == null) {
            ApiCreator.$$$reportNull$$$0(9);
        }
        return insertStatusCode;
    }

    @NotNull
    public InsertStatusCode insertAppIndexingApiCodeForActivity() {
        InsertStatusCode statusCode = this.eligibleForInsertingAppIndexingApiCode();
        if (statusCode == InsertStatusCode.SUCCESS) {
            this.insertAppIndexingApiCodeInJavaFile();
        }
        InsertStatusCode insertStatusCode = statusCode;
        if (insertStatusCode == null) {
            ApiCreator.$$$reportNull$$$0(10);
        }
        return insertStatusCode;
    }

    void insertAppIndexingApiCodeInJavaFile() {
        this.insertImportStatements();
        String getActionMethodCallText = this.insertGetActionMethod();
        this.addOrMergeOnStart(getActionMethodCallText);
        this.addOrMergeOnStop(getActionMethodCallText);
        JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)this.myActivity);
        this.unlockFromPsiOperation(this.myFile);
    }

    @NotNull
    private String insertGetActionMethod() {
        String methodName = this.getUnusedMethodName(METHOD_GET_ACTION);
        String getActionMethod = String.format(GET_ACTION_FORMAT, myImportClasses.get(CLASS_ACTION), methodName, myImportClasses.get(CLASS_BUILDERS_ACTIONS), this.getMyPageName(), this.myDeepLink);
        PsiMethod newGetAction = this.myFactory.createMethodFromText(getActionMethod, null);
        this.myActivity.add((PsiElement)newGetAction);
        String string = methodName;
        if (string == null) {
            ApiCreator.$$$reportNull$$$0(11);
        }
        return string;
    }

    private String getMyPageName() {
        String pageName = this.myActivity.getName();
        return pageName == null ? "" : StringUtil.trimEnd((String)pageName, (String)"Activity");
    }

    @NotNull
    private String getUnusedMethodName(@NotNull String methodName) {
        if (methodName == null) {
            ApiCreator.$$$reportNull$$$0(12);
        }
        PsiMethod[] psiMethods = this.myActivity.getMethods();
        HashSet<String> usedMethodNames = new HashSet<String>();
        for (PsiMethod p : psiMethods) {
            usedMethodNames.add(p.getName());
        }
        String unusedMethodName = methodName;
        int suffix = 0;
        while (usedMethodNames.contains(unusedMethodName)) {
            unusedMethodName = methodName + suffix;
            ++suffix;
        }
        String string = unusedMethodName;
        if (string == null) {
            ApiCreator.$$$reportNull$$$0(13);
        }
        return string;
    }

    private void insertImportStatements() {
        for (Map.Entry<String, String> className : myImportClasses.entrySet()) {
            if (ImportUtils.hasOnDemandImportConflict((String)className.getValue(), (PsiElement)this.myActivity) || ApiCreator.hasExactImportConflict(className.getValue(), (PsiJavaFile)this.myFile)) continue;
            this.insertSingleImportIfNeeded(className.getValue());
            className.setValue(className.getKey());
        }
    }

    private static boolean hasExactImportConflict(String fqName, PsiJavaFile file) {
        PsiImportList imports = file.getImportList();
        if (imports == null) {
            return false;
        }
        PsiImportStatement[] importStatements = imports.getImportStatements();
        int lastDotIndex = fqName.lastIndexOf(46);
        String shortName = fqName.substring(lastDotIndex + 1);
        String dottedShortName = '.' + shortName;
        for (PsiImportStatement importStatement : importStatements) {
            if (importStatement.isOnDemand()) continue;
            String importName = importStatement.getQualifiedName();
            if (importName == null) {
                return false;
            }
            if (importName.equals(fqName) || !importName.endsWith(dottedShortName)) continue;
            return true;
        }
        return false;
    }

    private void addOrMergeOnStart(@NotNull String getActionMethodCallText) {
        if (getActionMethodCallText == null) {
            ApiCreator.$$$reportNull$$$0(14);
        }
        if (this.myOnStart == null) {
            String onStartMethod = String.format(ON_START_FORMAT, String.format(FIREBASE_APP_INDEX_UPDATE_TEMPLATE, myImportClasses.get(CLASS_FIREBASE_APP_INDEX), myImportClasses.get(CLASS_INDEXABLE), this.getMyPageName(), this.myDeepLink), myImportClasses.get(CLASS_FIREBASE_USER_ACTION), getActionMethodCallText);
            this.myActivity.add((PsiElement)this.myFactory.createMethodFromText(onStartMethod, null));
            return;
        }
        if (this.myIndexUpdateStatements.isEmpty() || this.myStartStatements.isEmpty()) {
            String updateText = String.format(FIREBASE_APP_INDEX_UPDATE_TEMPLATE, myImportClasses.get(CLASS_FIREBASE_APP_INDEX), myImportClasses.get(CLASS_INDEXABLE), this.getMyPageName(), this.myDeepLink);
            PsiStatement updateStatement = this.myFactory.createStatementFromText(updateText, null);
            updateStatement = this.myStartStatements.isEmpty() ? this.myOnStart.add((PsiElement)updateStatement) : this.myOnStart.addBefore((PsiElement)updateStatement, (PsiElement)this.myStartStatements.get(0));
            String startText = String.format(FIREBASE_USER_ACTION_START_TEMPLATE, myImportClasses.get(CLASS_FIREBASE_USER_ACTION), getActionMethodCallText);
            PsiStatement startStatement = this.myFactory.createStatementFromText(startText, null);
            this.myOnStart.addAfter((PsiElement)startStatement, (PsiElement)updateStatement);
            this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStart, (PsiElement)updateStatement);
        }
    }

    private void addOrMergeOnStop(@NotNull String getActionMethodCallText) {
        if (getActionMethodCallText == null) {
            ApiCreator.$$$reportNull$$$0(15);
        }
        if (this.myOnStop == null) {
            String onStopMethod = String.format(ON_STOP_FORMAT, myImportClasses.get(CLASS_FIREBASE_USER_ACTION), getActionMethodCallText);
            this.myActivity.add((PsiElement)this.myFactory.createMethodFromText(onStopMethod, null));
            return;
        }
        if (!this.myEndStatements.isEmpty()) {
            return;
        }
        PsiStatement endStatement = this.myFactory.createStatementFromText(String.format(FIREBASE_USER_ACTION_END_TEMPLATE, myImportClasses.get(CLASS_FIREBASE_USER_ACTION), getActionMethodCallText), null);
        List superOnStopStatements = StatementFilter.filterCodeBlock((String)"super.onStop();", (PsiCodeBlock)this.myOnStop);
        if (!superOnStopStatements.isEmpty()) {
            endStatement = (PsiStatement)this.myOnStop.addAfter((PsiElement)endStatement, (PsiElement)superOnStopStatements.get(0));
            this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStop, (PsiElement)endStatement);
        } else {
            endStatement = (PsiStatement)this.myOnStop.addAfter((PsiElement)endStatement, this.myOnStop.getFirstBodyElement());
            this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStop, (PsiElement)endStatement);
        }
    }

    @Nullable
    String getFirstDeepLinkOfActivity() {
        XmlFile manifest = ManifestUtils.getAndroidManifestPsi((Module)this.myModule);
        if (manifest != null && manifest.getRootTag() != null) {
            List activityTags = ManifestUtils.searchXmlTagsByName((XmlTag)manifest.getRootTag(), (String)"activity");
            for (XmlTag activityTag : activityTags) {
                List<String> deepLinks;
                String activityName = activityTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                if (activityName == null || !activityName.equals("." + this.myActivity.getName()) || (deepLinks = DeepLinkUtils.getAllDeepLinks(activityTag)).isEmpty()) continue;
                return deepLinks.get(0);
            }
        }
        return null;
    }

    private void addCommentsBefore(@NotNull List<String> texts, @NotNull PsiElement element, @NotNull PsiElement anchor) {
        if (texts == null) {
            ApiCreator.$$$reportNull$$$0(16);
        }
        if (element == null) {
            ApiCreator.$$$reportNull$$$0(17);
        }
        if (anchor == null) {
            ApiCreator.$$$reportNull$$$0(18);
        }
        this.myCodeStyleManager.reformat(element);
        for (String text : texts) {
            element.addBefore((PsiElement)this.myFactory.createCommentFromText(text, null), anchor);
            this.myCodeStyleManager.reformat(element);
        }
    }

    private void unlockFromPsiOperation(@NotNull PsiFile file) {
        Document doc;
        if (file == null) {
            ApiCreator.$$$reportNull$$$0(19);
        }
        if ((doc = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file)) != null) {
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(doc);
        }
    }

    private void insertSingleImportIfNeeded(@NotNull String className) {
        PsiImportList importList;
        if (className == null) {
            ApiCreator.$$$reportNull$$$0(20);
        }
        if ((importList = ((PsiJavaFile)this.myFile).getImportList()) != null && !InsertCodeUtils.hasImportStatement((PsiImportList)importList, (String)className)) {
            String dummyFileName = "_Dummy_" + className + "_." + JavaFileType.INSTANCE.getDefaultExtension();
            PsiJavaFile aFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(dummyFileName, (FileType)JavaFileType.INSTANCE, (CharSequence)("import " + className + ";"));
            PsiImportList dummyImportList = aFile.getImportList();
            if (dummyImportList != null) {
                PsiImportStatement[] statements = dummyImportList.getImportStatements();
                PsiImportStatement statement = (PsiImportStatement)this.myCodeStyleManager.reformat((PsiElement)statements[0]);
                importList.add((PsiElement)statement);
            }
        }
    }

    public static boolean hasEnoughDependencies(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        GradleBuildModel gradleBuildModel = GradleBuildModel.get((Module)module);
        if (gradleBuildModel == null) {
            return false;
        }
        DependenciesModel dependenciesModel = gradleBuildModel.dependencies();
        if (dependenciesModel == null) {
            return false;
        }
        if (!ApiCreator.hasDependency(APP_INDEXING_LIB_DEPENDENCY, dependenciesModel.artifacts())) {
            return false;
        }
        List plugins = PluginModel.extractNames((List)gradleBuildModel.plugins());
        if (!plugins.contains(APP_INDEXING_PLUGIN_DEPENDENCY)) {
            return false;
        }
        GradleBuildModel projectGradleBuildModel = GradleBuildModel.get((Project)module.getProject());
        if (projectGradleBuildModel == null) {
            return false;
        }
        DependenciesModel dependencies = projectGradleBuildModel.buildscript().dependencies();
        return ApiCreator.hasDependency(APP_INDEXING_CLASSPATH_DEPENDENCY, dependencies.artifacts("classpath"));
    }

    private static boolean hasDependency(@NotNull String dependencyValue, @NotNull List<? extends ArtifactDependencyModel> existingDeps) {
        ArtifactDependencySpec requiredDepSpec;
        if (dependencyValue == null) {
            ApiCreator.$$$reportNull$$$0(21);
        }
        if (existingDeps == null) {
            ApiCreator.$$$reportNull$$$0(22);
        }
        if ((requiredDepSpec = ArtifactDependencySpec.create((String)dependencyValue)) == null) {
            return true;
        }
        for (ArtifactDependencyModel artifactDependencyModel : existingDeps) {
            ArtifactDependencySpec foundDepSpec = ArtifactDependencySpec.create((ArtifactDependencyModel)artifactDependencyModel);
            if (!foundDepSpec.equalsIgnoreVersion((Object)requiredDepSpec) || VersionComparatorUtil.compare((String)foundDepSpec.getVersion(), (String)requiredDepSpec.getVersion()) < 0) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/appindexing/api/ApiCreator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getActionMethodCallText";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyValue";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingDeps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/appindexing/api/ApiCreator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "eligibleForInsertingAppIndexingApiCode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "insertAppIndexingApiCodeForActivity";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "insertGetActionMethod";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedMethodName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addOrMergeOnStart";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addOrMergeOnStop";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addCommentsBefore";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unlockFromPsiOperation";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "insertSingleImportIfNeeded";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum InsertStatusCode {
        SUCCESS,
        NON_JAVA_FILE,
        JAVA_FILE_WITHOUT_ACTIVITY,
        DEEP_LINK_MISSING,
        DEPENDENCY_MISSING,
        API_EXISTS;

        private final String message = this.name() == "SUCCESS" ? "" : AppIndexingBundle.message("app.indexing.code.insert.error." + this.name().toLowerCase(), new Object[0]);

        public String getMessage() {
            return this.message;
        }
    }
}

