/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.editor;

import com.google.api.client.util.Maps;
import com.google.appindexing.editor.AppIndexingVirtualFile;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleTask;
import com.google.appindexing.ui.AppIndexingResultPanel;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppIndexingFileEditor
extends UserDataHolderBase
implements FileEditor {
    private JBScrollPane myScrollPane;
    private JPanel myRootPanel;
    private JPanel myLoadingPanel;
    private AsyncProcessIcon myLoadingIcon;
    private JPanel myLoadingMessagePanel;
    private JBLabel myLoadingMessage;
    private JPanel myResultsPanel;
    private static final Map<FetchAsGoogleTask.Status, String> STATUS_TO_TEXT = Maps.newHashMap();
    private AppIndexingVirtualFile myFile;

    public AppIndexingFileEditor(@NotNull AppIndexingVirtualFile file) {
        if (file == null) {
            AppIndexingFileEditor.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myScrollPane = new JBScrollPane((Component)this.myRootPanel);
        this.myFile = file;
        this.myFile.addContentChangeCallback(() -> this.refreshUi());
        this.refreshUi();
    }

    private void createUIComponents() {
        this.myLoadingIcon = new AsyncProcessIcon.Big("Fetch as Google");
    }

    private void refreshUi() {
        FetchAsGoogleTask task = this.myFile.getFetchAsGoogleTask();
        FetchAsGoogleTask.Status status = task.getStatus();
        AppIndexingResultPanel appIndexingResultPanel = null;
        switch (status) {
            case NOT_STARTED: 
            case BUILDING_APK: 
            case UPLOADING_APK: 
            case FETCHING_RESULT: {
                this.myLoadingMessage.setText(STATUS_TO_TEXT.get((Object)status));
                break;
            }
            case FAIL: 
            case SUCCESS: {
                appIndexingResultPanel = AppIndexingResultPanel.buildPanelFromFetchTask(task, this.myFile.getDeepLink());
                this.myResultsPanel.add(appIndexingResultPanel);
                ((CardLayout)this.myRootPanel.getLayout()).show(this.myRootPanel, "results");
            }
        }
    }

    @NotNull
    public JComponent getComponent() {
        JBScrollPane jBScrollPane = this.myScrollPane;
        if (jBScrollPane == null) {
            AppIndexingFileEditor.$$$reportNull$$$0(1);
        }
        return jBScrollPane;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myScrollPane;
    }

    @NotNull
    public String getName() {
        if ("App Indexing" == null) {
            AppIndexingFileEditor.$$$reportNull$$$0(2);
        }
        return "App Indexing";
    }

    public void setState(@NotNull FileEditorState fileEditorState) {
        if (fileEditorState == null) {
            AppIndexingFileEditor.$$$reportNull$$$0(3);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            AppIndexingFileEditor.$$$reportNull$$$0(4);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            AppIndexingFileEditor.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    static {
        STATUS_TO_TEXT.put(FetchAsGoogleTask.Status.NOT_STARTED, "The task has not started yet.");
        STATUS_TO_TEXT.put(FetchAsGoogleTask.Status.BUILDING_APK, "Building APK...");
        STATUS_TO_TEXT.put(FetchAsGoogleTask.Status.UPLOADING_APK, "Uploading APK to Firebase App Indexing testing service...");
        STATUS_TO_TEXT.put(FetchAsGoogleTask.Status.FETCHING_RESULT, "Testing; takes about 2 minutes to complete.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/appindexing/editor/AppIndexingFileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorState";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyChangeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/appindexing/editor/AppIndexingFileEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        this.myLoadingPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, "loading");
        this.myLoadingMessagePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myLoadingMessage = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myLoadingIcon;
        jPanel2.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myResultsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, "results");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

