/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.editor;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.google.api.client.util.Lists;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleTask;
import com.google.appindexing.icons.AppIndexingIcons;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppIndexingVirtualFile
extends LightVirtualFile {
    private static final String FILENAME_FORMAT = "FirebaseAppIndexingTest [%s]";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss");
    private String myDeepLink;
    private List<Runnable> myContentChangingCallbacks;
    private FetchAsGoogleTask myFetchAsGoogleTask;

    public AppIndexingVirtualFile(@NotNull String deepLink, @NotNull FetchAsGoogleTask fetchAsGoogleTask) {
        if (deepLink == null) {
            AppIndexingVirtualFile.$$$reportNull$$$0(0);
        }
        if (fetchAsGoogleTask == null) {
            AppIndexingVirtualFile.$$$reportNull$$$0(1);
        }
        super(String.format(FILENAME_FORMAT, DATE_FORMAT.format(fetchAsGoogleTask.getCreatedTime())));
        this.myContentChangingCallbacks = Lists.newArrayList();
        this.myDeepLink = deepLink;
        this.myFetchAsGoogleTask = fetchAsGoogleTask;
    }

    public void fireContentChange() {
        for (Runnable callback : this.myContentChangingCallbacks) {
            callback.run();
        }
    }

    @NotNull
    public FetchAsGoogleTask getFetchAsGoogleTask() {
        FetchAsGoogleTask fetchAsGoogleTask = this.myFetchAsGoogleTask;
        if (fetchAsGoogleTask == null) {
            AppIndexingVirtualFile.$$$reportNull$$$0(2);
        }
        return fetchAsGoogleTask;
    }

    public void addContentChangeCallback(@NotNull Runnable runnable) {
        if (runnable == null) {
            AppIndexingVirtualFile.$$$reportNull$$$0(3);
        }
        this.myContentChangingCallbacks.add(runnable);
    }

    @NotNull
    public String getDeepLink() {
        String string = this.myDeepLink;
        if (string == null) {
            AppIndexingVirtualFile.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public VirtualFile getParent() {
        return null;
    }

    @NotNull
    public FileType getFileType() {
        AppIndexingFileType appIndexingFileType = AppIndexingFileType.INSTANCE;
        if (appIndexingFileType == null) {
            AppIndexingVirtualFile.$$$reportNull$$$0(5);
        }
        return appIndexingFileType;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = AndroidFakeFileSystem.INSTANCE;
        if (virtualFileSystem == null) {
            AppIndexingVirtualFile.$$$reportNull$$$0(6);
        }
        return virtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myDeepLink;
        if (string == null) {
            AppIndexingVirtualFile.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepLink";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetchAsGoogleTask";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/appindexing/editor/AppIndexingVirtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/appindexing/editor/AppIndexingVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFetchAsGoogleTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepLink";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addContentChangeCallback";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AppIndexingFileType
    extends FakeFileType {
        public static final AppIndexingFileType INSTANCE = new AppIndexingFileType();

        private AppIndexingFileType() {
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            if (file == null) {
                AppIndexingFileType.$$$reportNull$$$0(0);
            }
            return file.getFileType() instanceof AppIndexingFileType;
        }

        @NotNull
        public String getName() {
            if ("" == null) {
                AppIndexingFileType.$$$reportNull$$$0(1);
            }
            return "";
        }

        @NotNull
        public String getDescription() {
            if ("" == null) {
                AppIndexingFileType.$$$reportNull$$$0(2);
            }
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return AppIndexingIcons.FETCH_AS_GOOGLE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/appindexing/editor/AppIndexingVirtualFile$AppIndexingFileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/appindexing/editor/AppIndexingVirtualFile$AppIndexingFileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isMyFileType";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

