/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.fetchasgoogle;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.fetchasgoogle_pa.FetchasgooglePa;
import com.google.api.services.fetchasgoogle_pa.model.Apk;
import com.google.api.services.fetchasgoogle_pa.model.ApkDataRef;
import com.google.api.services.fetchasgoogle_pa.model.ApkHolder;
import com.google.api.services.fetchasgoogle_pa.model.FetchRequest;
import com.google.api.services.fetchasgoogle_pa.model.FetchResponse;
import com.google.api.services.fetchasgoogle_pa.model.Intent;
import com.google.api.services.fetchasgoogle_pa.model.Operation;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleTask;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FetchAsGoogleClient {
    private static final NetHttpTransport httpTransport = new NetHttpTransport();
    private static final JsonFactory jsonFactory = new JacksonFactory();
    private static final String SERVER_PATH = "";
    private static final String ROOT_URL = "https://fetchasgoogle-pa.googleapis.com";
    private static final String MIME_TYPE = "application/vnd.android.package-archive";
    private static final int CHUNK_SIZE = 1024;
    private static final int KB = 1024;
    private static final String UPLOAD_SOURCE = "ANDROID_STUDIO";
    private static final String APPLICATION_NAME = "AS_APP_INDEXING_PLUGIN";
    private static final String URL_TYPE_KEY = "@type";
    private static final String URL_TYPE = "type.googleapis.com/google.internal.fetchasgoogle.v1.FetchResponse";
    private static final String STATUS_KEY = "status";
    private static final String URL_KEY = "url";
    private static final String ADDITIONAL_URLS_KEY = "additionalUrls";
    private static final String OK_STATUS = "OK";
    private static final int FETCH_TIME_INTERVAL_IN_MS = 5000;
    @NotNull
    private FetchasgooglePa myStub;

    @NotNull
    public static FetchAsGoogleClient createInstance() throws FetchAsGoogleException {
        FetchasgooglePa stub = FetchAsGoogleClient.createStub();
        if (stub == null) {
            throw new FetchAsGoogleException("Could not find user credentials", FetchAsGoogleTask.ErrorCode.NEED_SIGNIN);
        }
        FetchAsGoogleClient fetchAsGoogleClient = new FetchAsGoogleClient(stub);
        if (fetchAsGoogleClient == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(0);
        }
        return fetchAsGoogleClient;
    }

    private FetchAsGoogleClient(@NotNull FetchasgooglePa stub) {
        if (stub == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(1);
        }
        this.myStub = stub;
    }

    @Nullable
    private static FetchasgooglePa createStub() {
        CredentialedUser user = GoogleLogin.getInstance().getActiveUser();
        if (user != null) {
            return new FetchasgooglePa.Builder((HttpTransport)httpTransport, jsonFactory, (HttpRequestInitializer)new FetchAsGoogleHttpRequestInitializer(user.getCredential())).setServicePath(SERVER_PATH).setRootUrl(ROOT_URL).setApplicationName(APPLICATION_NAME).build();
        }
        return null;
    }

    @NotNull
    public ApkHolder uploadApk(@NotNull String packageId, @NotNull File apkFile) throws FetchAsGoogleException, IOException {
        if (packageId == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(2);
        }
        if (apkFile == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(3);
        }
        ApkDataRef apkDataRef = (ApkDataRef)this.myStub.apks().startUpload().execute();
        FetchasgooglePa.Media.Upload upload = this.myStub.media().upload(apkDataRef.getResourceName(), null, (AbstractInputStreamContent)new FileContent(MIME_TYPE, apkFile));
        upload.getMediaHttpUploader().setDirectUploadEnabled(true);
        upload.getMediaHttpUploader().setChunkSize(0x100000);
        HttpResponse response = upload.executeUnparsed();
        if (response.getStatusCode() != 200) {
            throw new FetchAsGoogleException("Failed to upload Apk: " + response, FetchAsGoogleTask.ErrorCode.UPLOAD_APK_FAILED);
        }
        Apk feagApk = new Apk().setPackageId(packageId).setSource(UPLOAD_SOURCE);
        ApkHolder apk = new ApkHolder().setApk(feagApk).setApkDataRef(apkDataRef);
        ApkHolder apkHolder = (ApkHolder)this.myStub.apks().create(apk).execute();
        if (apkHolder == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(4);
        }
        return apkHolder;
    }

    @NotNull
    public FetchResponse fetchAsGoogle(@NotNull String deepLink, @NotNull String packageId, @Nullable String apkId, @NotNull FetchAsGoogleTask.RequestType requestType) throws FetchAsGoogleException, IOException, InterruptedException {
        Operation startFetchResult;
        if (deepLink == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(5);
        }
        if (packageId == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(6);
        }
        if (requestType == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(7);
        }
        if ((startFetchResult = this.startFetch(deepLink, packageId, apkId, requestType)) == null) {
            throw new FetchAsGoogleException("Operation failed with an empty response", FetchAsGoogleTask.ErrorCode.FETCH_RESULT_FAILED);
        }
        Operation result = null;
        String fetchToken = startFetchResult.getName();
        if (fetchToken == null || fetchToken.isEmpty()) {
            throw new FetchAsGoogleException("No fetch token returned", FetchAsGoogleTask.ErrorCode.FETCH_RESULT_FAILED);
        }
        do {
            Thread.sleep(5000L);
            result = this.getFetchResult(fetchToken);
            if (result == null) {
                throw new FetchAsGoogleException("Operation failed with an empty response", FetchAsGoogleTask.ErrorCode.FETCH_RESULT_FAILED);
            }
            if (result.getDone() == null || !result.getDone().booleanValue()) continue;
            if (result.getError() != null) {
                throw new FetchAsGoogleException("Operation failed with error status: " + result.getError(), FetchAsGoogleTask.ErrorCode.FETCH_RESULT_FAILED);
            }
            if (result.getResponse() == null) {
                throw new FetchAsGoogleException("Operation failed with an empty response", FetchAsGoogleTask.ErrorCode.FETCH_RESULT_FAILED);
            }
            if (!result.getResponse().get(URL_TYPE_KEY).equals(URL_TYPE)) {
                throw new FetchAsGoogleException("Operation response contains unexpected type: " + result.getResponse().get(URL_TYPE_KEY), FetchAsGoogleTask.ErrorCode.FETCH_RESULT_FAILED);
            }
            if (result.getResponse().get(STATUS_KEY) == null) {
                throw new FetchAsGoogleException("Operation failed with an empty status", FetchAsGoogleTask.ErrorCode.FETCH_RESULT_FAILED);
            }
            String status = (String)result.getResponse().get(STATUS_KEY);
            if (OK_STATUS.equals(status)) continue;
            Logger.getInstance(FetchAsGoogleClient.class).warn(status);
            throw new FetchAsGoogleException("Operation failed with error status: " + result.getResponse().get(STATUS_KEY), FetchAsGoogleTask.ErrorCode.valueOf(status));
        } while (result.getDone() == null || !result.getDone().booleanValue());
        FetchResponse fetchResponse = FetchAsGoogleClient.constructFetchResponse(result.getResponse());
        if (fetchResponse == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(8);
        }
        return fetchResponse;
    }

    @NotNull
    private static FetchResponse constructFetchResponse(Map<String, Object> map) {
        FetchResponse response = new FetchResponse();
        response.setStatus((String)map.get(STATUS_KEY));
        if (map.get(URL_KEY) != null) {
            response.setUrl((String)map.get(URL_KEY));
        }
        if (map.get(ADDITIONAL_URLS_KEY) != null) {
            response.setAdditionalUrls((List)((ArrayList)map.get(ADDITIONAL_URLS_KEY)));
        }
        FetchResponse fetchResponse = response;
        if (fetchResponse == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(9);
        }
        return fetchResponse;
    }

    private Operation startFetch(@NotNull String deepLink, @NotNull String packageId, @Nullable String apkId, @NotNull FetchAsGoogleTask.RequestType requestType) throws IOException {
        if (deepLink == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(10);
        }
        if (packageId == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(11);
        }
        if (requestType == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(12);
        }
        FetchRequest request = new FetchRequest().setIntent(new Intent().setUri(deepLink)).setSource(UPLOAD_SOURCE).setPreviewFeature(requestType.toString()).setPackageId(packageId);
        if (apkId != null) {
            request.setApkId(apkId);
        }
        FetchasgooglePa.Apks.Fetch fetch = this.myStub.apks().fetch(request);
        return (Operation)fetch.execute();
    }

    @NotNull
    public FetchResponse getAppIndexingErrorStats(@NotNull String packageId, @NotNull FetchAsGoogleTask.RequestType requestType) throws IOException {
        if (packageId == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(13);
        }
        if (requestType == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(14);
        }
        FetchasgooglePa.Apks.GetFetch getFetch = this.myStub.apks().getFetch();
        FetchResponse fetchResponse = (FetchResponse)getFetch.setPackageId(packageId).setPreviewFeature(requestType.toString()).execute();
        if (fetchResponse == null) {
            FetchAsGoogleClient.$$$reportNull$$$0(15);
        }
        return fetchResponse;
    }

    private Operation getFetchResult(String fetchToken) throws IOException {
        FetchasgooglePa.Operations.Get get = this.myStub.operations().get(fetchToken);
        return (Operation)get.execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/appindexing/fetchasgoogle/FetchAsGoogleClient";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFile";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepLink";
                break;
            }
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/appindexing/fetchasgoogle/FetchAsGoogleClient";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "uploadApk";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchAsGoogle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "constructFetchResponse";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppIndexingErrorStats";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uploadApk";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fetchAsGoogle";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "startFetch";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAppIndexingErrorStats";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FetchAsGoogleHttpRequestInitializer
    implements HttpExecuteInterceptor,
    HttpRequestInitializer {
        private final Credential access;

        public FetchAsGoogleHttpRequestInitializer(Credential access) {
            this.access = access;
        }

        public void initialize(HttpRequest request) throws IOException {
            this.access.initialize(request);
            request.setInterceptor((HttpExecuteInterceptor)this);
        }

        public void intercept(HttpRequest request) throws IOException {
            this.access.intercept(request);
        }
    }

    public static class FetchAsGoogleException
    extends Exception {
        @NotNull
        FetchAsGoogleTask.ErrorCode myErrorCode;

        public FetchAsGoogleException(String message, @NotNull FetchAsGoogleTask.ErrorCode code) {
            if (code == null) {
                FetchAsGoogleException.$$$reportNull$$$0(0);
            }
            super(message);
            this.myErrorCode = code;
        }

        @NotNull
        public FetchAsGoogleTask.ErrorCode getErrorCode() {
            FetchAsGoogleTask.ErrorCode errorCode = this.myErrorCode;
            if (errorCode == null) {
                FetchAsGoogleException.$$$reportNull$$$0(1);
            }
            return errorCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/appindexing/fetchasgoogle/FetchAsGoogleClient$FetchAsGoogleException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/appindexing/fetchasgoogle/FetchAsGoogleClient$FetchAsGoogleException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorCode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

