/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.fetchasgoogle;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.model.AndroidModel;
import com.google.api.services.fetchasgoogle_pa.model.ApkHolder;
import com.google.api.services.fetchasgoogle_pa.model.FetchResponse;
import com.google.appindexing.editor.AppIndexingVirtualFile;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleClient;
import com.google.appindexing.fetchasgoogle.UploadedApkManager;
import com.google.appindexing.util.AppIndexingBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FetchAsGoogleTask
implements Runnable {
    private static final Logger logger = Logger.getInstance(FetchAsGoogleTask.class);
    private final boolean myBuildApkToRun;
    private final RequestType myRequestType;
    private Status myStatus;
    private ErrorCode myErrorCode;
    private Project myProject;
    private String myDeepLink;
    private AppIndexingVirtualFile myVirtualFile;
    private FetchAsGoogleClient myFetchAsGoogleClient;
    private ApkHolder myApkHolder;
    private FetchResponse myFetchResponse;
    private Date myCreatedTime;
    private UploadedApkManager myUploadedApkManager;
    private Helper myHelper;
    private String myPackageId;

    @Nullable
    public String getPackageId() {
        return this.myPackageId;
    }

    @NotNull
    public RequestType getRequestType() {
        RequestType requestType = this.myRequestType;
        if (requestType == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(0);
        }
        return requestType;
    }

    public static FetchAsGoogleTask createFetchAsGoogleTask(@NotNull Project project, @NotNull Module module, @NotNull String deepLink, boolean buildApk, @NotNull RequestType type) throws FetchAsGoogleClient.FetchAsGoogleException {
        if (project == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(1);
        }
        if (module == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(2);
        }
        if (deepLink == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(3);
        }
        if (type == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(4);
        }
        return new FetchAsGoogleTask(project, deepLink, FetchAsGoogleClient.createInstance(), UploadedApkManager.INSTANCE, new Helper(project, module), buildApk, type);
    }

    FetchAsGoogleTask(@NotNull Project project, @NotNull String deepLink, @NotNull FetchAsGoogleClient fetchAsGoogleClient, @NotNull UploadedApkManager uploadedApkManager, @NotNull Helper helper, boolean buildApk, @NotNull RequestType type) {
        if (project == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(5);
        }
        if (deepLink == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(6);
        }
        if (fetchAsGoogleClient == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(7);
        }
        if (uploadedApkManager == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(8);
        }
        if (helper == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(9);
        }
        if (type == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(10);
        }
        this.myStatus = Status.NOT_STARTED;
        this.myProject = project;
        this.myDeepLink = deepLink;
        this.myCreatedTime = new Date();
        this.myFetchAsGoogleClient = fetchAsGoogleClient;
        this.myUploadedApkManager = uploadedApkManager;
        this.myHelper = helper;
        this.myBuildApkToRun = buildApk;
        this.myRequestType = type;
    }

    @NotNull
    public Status getStatus() {
        Status status = this.myStatus;
        if (status == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(11);
        }
        return status;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myHelper.myModule;
        if (module == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(12);
        }
        return module;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(13);
        }
        return project;
    }

    @Nullable
    public ErrorCode getErrorCode() {
        return this.myErrorCode;
    }

    @NotNull
    public Date getCreatedTime() {
        Date date = this.myCreatedTime;
        if (date == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(14);
        }
        return date;
    }

    @Nullable
    public FetchResponse getFetchResponse() {
        return this.myFetchResponse;
    }

    private void changeStatus(@NotNull Status newStatus) {
        if (newStatus == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(15);
        }
        this.changeStatus(newStatus, null);
    }

    private void changeStatus(@NotNull Status newStatus, @Nullable ErrorCode errorCode) {
        if (newStatus == null) {
            FetchAsGoogleTask.$$$reportNull$$$0(16);
        }
        this.myStatus = newStatus;
        if (errorCode != null) {
            this.myErrorCode = errorCode;
        }
        Logger.getInstance(FetchAsGoogleTask.class).warn(newStatus.toString());
        ApplicationManager.getApplication().invokeAndWait(() -> this.myVirtualFile.fireContentChange(), ModalityState.any());
    }

    @Override
    public void run() {
        this.myVirtualFile = new AppIndexingVirtualFile(this.myDeepLink, this);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            fileEditorManager.openFile((VirtualFile)this.myVirtualFile, true);
        }, ModalityState.any());
        try {
            if (RequestType.PERSONAL_CONTENT_INDEXING_DEBUGGING == this.myRequestType || RequestType.USER_ACTION_LOGGING_DEBUGGING == this.myRequestType) {
                this.changeStatus(Status.FETCHING_RESULT);
                this.myPackageId = this.myHelper.getPackageId();
                if (this.myPackageId != null) {
                    this.myFetchResponse = this.myFetchAsGoogleClient.getAppIndexingErrorStats(this.myPackageId, this.myRequestType);
                    this.changeStatus(Status.SUCCESS, ErrorCode.valueOf(this.myFetchResponse.getStatus()));
                } else {
                    this.changeStatus(Status.FAIL, ErrorCode.EMPTY_PACKAGE_ID);
                }
                return;
            }
            if (this.myBuildApkToRun) {
                this.changeStatus(Status.BUILDING_APK);
                if (!this.myHelper.buildApk()) {
                    this.changeStatus(Status.FAIL, ErrorCode.BUILD_APK_FAILED);
                    return;
                }
                this.changeStatus(Status.UPLOADING_APK);
                if (!this.uploadApkIfNeeded()) {
                    this.changeStatus(Status.FAIL, ErrorCode.UPLOAD_APK_FAILED);
                    return;
                }
                this.changeStatus(Status.FETCHING_RESULT);
                this.myPackageId = this.myApkHolder.getApk().getPackageId();
                this.myFetchResponse = this.myFetchAsGoogleClient.fetchAsGoogle(this.myDeepLink, this.myPackageId, this.myApkHolder.getApk().getApkId(), RequestType.APP_INDEXING);
            } else {
                this.changeStatus(Status.FETCHING_RESULT);
                this.myPackageId = this.myHelper.getPackageId();
                if (StringUtil.isNotEmpty((String)this.myPackageId)) {
                    this.myFetchResponse = this.myFetchAsGoogleClient.fetchAsGoogle(this.myDeepLink, this.myPackageId, null, this.myRequestType);
                    Logger.getInstance(FetchAsGoogleTask.class).warn(this.myFetchResponse.getStatus());
                } else {
                    this.changeStatus(Status.FAIL, ErrorCode.FETCH_RESULT_FAILED);
                    return;
                }
            }
            this.changeStatus(Status.SUCCESS);
        }
        catch (FetchAsGoogleClient.FetchAsGoogleException e) {
            this.changeStatus(Status.FAIL, e.getErrorCode());
            logger.warn((Throwable)e);
        }
        catch (IOException ex) {
            this.changeStatus(Status.FAIL, ErrorCode.NETWORK_ERROR);
            logger.warn((Throwable)ex);
        }
        catch (Exception exx) {
            this.changeStatus(Status.FAIL, ErrorCode.UNKNOWN);
            logger.warn((Throwable)exx);
        }
    }

    private boolean uploadApkIfNeeded() throws FetchAsGoogleClient.FetchAsGoogleException, IOException {
        File apkFile = this.myHelper.getApkFile();
        if (apkFile == null || !apkFile.exists()) {
            return false;
        }
        String packageId = this.myHelper.getPackageId();
        if (packageId == null || packageId.isEmpty()) {
            return false;
        }
        byte[] apkHash = this.myUploadedApkManager.hashApk(apkFile);
        if (apkHash == null) {
            logger.warn("Couldn't get apk file hash");
            return false;
        }
        this.myApkHolder = this.myUploadedApkManager.getApkHolder(apkHash);
        if (this.myApkHolder == null) {
            this.myApkHolder = this.myFetchAsGoogleClient.uploadApk(packageId, apkFile);
            this.myUploadedApkManager.addUploadedApk(apkHash, this.myApkHolder);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepLink";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetchAsGoogleClient";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uploadedApkManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreatedTime";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFetchAsGoogleTask";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "changeStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Helper {
        private Project myProject;
        private Module myModule;
        private static final Logger logger = Logger.getInstance(Helper.class);

        public Helper(@NotNull Project project, @NotNull Module module) {
            if (project == null) {
                Helper.$$$reportNull$$$0(0);
            }
            if (module == null) {
                Helper.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myModule = module;
        }

        public boolean buildApk() {
            final AtomicBoolean success = new AtomicBoolean();
            try {
                String errorMsg;
                final Semaphore done = new Semaphore();
                done.down();
                final AtomicReference errorMsgRef = new AtomicReference();
                GradleSyncState syncState = GradleSyncState.getInstance((Project)this.myProject);
                if (syncState.isSyncNeeded() != ThreeState.NO) {
                    GradleSyncInvoker.Request request = GradleSyncInvoker.Request.userRequest();
                    request.runInBackground = false;
                    GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request, new GradleSyncListener(){

                        public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                            if (project == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (errorMessage == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            errorMsgRef.set(errorMessage);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "project";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "errorMessage";
                                    break;
                                }
                            }
                            objectArray[1] = "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask$Helper$1";
                            objectArray[2] = "syncFailed";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
                if ((errorMsg = (String)errorMsgRef.get()) != null) {
                    logger.warn("Unable to launch task. Project sync failed with message: " + errorMsg);
                    return false;
                }
                final GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance((Project)this.myProject);
                GradleBuildInvoker.AfterGradleInvocationTask afterTask = new GradleBuildInvoker.AfterGradleInvocationTask(){

                    public void execute(@NotNull GradleInvocationResult result) {
                        if (result == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        success.set(result.isBuildSuccessful());
                        gradleBuildInvoker.remove((GradleBuildInvoker.AfterGradleInvocationTask)this);
                        done.up();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask$Helper$2", "execute"));
                    }
                };
                if (this.myProject.isDisposed()) {
                    done.up();
                } else {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        gradleBuildInvoker.add(afterTask);
                        gradleBuildInvoker.assemble(new Module[]{this.myModule}, TestCompileType.ALL);
                    }, ModalityState.NON_MODAL);
                    done.waitFor();
                }
            }
            catch (Throwable t) {
                return false;
            }
            return success.get();
        }

        @Nullable
        public File getApkFile() {
            AndroidModuleModel model;
            File apkFile = null;
            AndroidFacet facet = AndroidFacet.getInstance((Module)this.myModule);
            if (facet != null && (model = AndroidModuleModel.get((AndroidFacet)facet)) != null) {
                IdeAndroidArtifact artifact = model.getMainArtifact();
                for (AndroidArtifactOutput output : artifact.getOutputs()) {
                    OutputFile file = output.getMainOutputFile();
                    apkFile = file.getOutputFile();
                }
            }
            return apkFile;
        }

        @Nullable
        public String getPackageId() {
            AtomicReference packageId = new AtomicReference();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                AndroidModel androidModel;
                AndroidFacet androidFacet = AndroidFacet.getInstance((Module)this.myModule);
                if (androidFacet != null && (androidModel = ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel()) != null) {
                    packageId.set(androidModel.getApplicationId());
                }
            }, ModalityState.any());
            return (String)packageId.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
            }
            objectArray[1] = "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask$Helper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum RequestType {
        UNKNOWN_PREVIEW_FEATURE,
        APP_INDEXING,
        INSTANT_APP,
        USER_ACTION_LOGGING_DEBUGGING,
        PERSONAL_CONTENT_INDEXING_DEBUGGING;

    }

    public static enum ErrorCode {
        UNKNOWN,
        BUILD_APK_FAILED,
        UPLOAD_APK_FAILED,
        FETCH_RESULT_FAILED,
        NEED_SIGNIN,
        NETWORK_ERROR,
        URI_NOT_SUPPORTED,
        UNKNOWN_URL,
        UNKNOWN_APP_URI,
        APK_NOT_FOUND,
        BLACKLISTED_URL,
        URL_INDEX_ERROR,
        EMPTY_PACKAGE_ID,
        USER_ACTION_LOGGING_ERROR,
        PERSONAL_CONTENT_INDEXING_ERROR,
        BACKEND_ERROR,
        RESOURCE_EXHAUSTED,
        NOT_FOUND,
        APP_OWNERSHIP_VERIFICATION_FAILED,
        OK;

        private final String message = AppIndexingBundle.message("app.indexing.fetch.as.google.test.error." + this.name(), new Object[0]);

        public String getName() {
            return super.name();
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum Status {
        NOT_STARTED,
        BUILDING_APK,
        UPLOADING_APK,
        FETCHING_RESULT,
        SUCCESS,
        FAIL;

    }
}

