/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.ui;

import com.android.tools.analytics.UsageTracker;
import com.google.appindexing.api.ApiCreator;
import com.google.appindexing.util.AppIndexingBundle;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.UrlAssistIcons;
import com.google.urlassistant.util.ManifestUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertApiCodeDialog
extends DialogWrapper {
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private JList myJList;
    private JPanel myContentPanel;
    private final JTextPane myWarningMessage;
    private final JBPanel myMessagePanel;
    private List<ActivityData> myActivities;
    private ApiCreator myCreator;

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJList;
    }

    public InsertApiCodeDialog(@NotNull Project project) {
        if (project == null) {
            InsertApiCodeDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myContentPanel = new JBPanel((LayoutManager)new BorderLayout(0, 0));
        this.myWarningMessage = new JTextPane();
        this.myMessagePanel = new JBPanel((LayoutManager)new GridLayoutManager(1, 2));
        this.myProject = project;
        this.myFileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        this.myMessagePanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(8);
        JBLabel iconLabel = new JBLabel();
        iconLabel.setIcon(UrlAssistIcons.FAIL_ICON);
        this.myMessagePanel.add((Component)iconLabel, (Object)constraints);
        constraints.setColumn(1);
        this.myWarningMessage.setAlignmentX(0.0f);
        this.myWarningMessage.setBackground(this.myContentPanel.getBackground());
        this.myMessagePanel.add((Component)this.myWarningMessage, (Object)constraints);
        this.myMessagePanel.setVisible(false);
        this.myContentPanel.setPreferredSize(new Dimension(400, 200));
        this.myContentPanel.add((Component)this.myMessagePanel, "South");
        this.initializeActivityList();
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myJList);
        this.myContentPanel.add((Component)scrollPane, "Center");
        this.getOKAction().putValue("Name", AppIndexingBundle.message("app.indexing.code.insert.dialog.ok.button", new Object[0]));
        this.setOKActionEnabled(false);
        this.setTitle(AppIndexingBundle.message("app.indexing.code.insert.dialog.title", new Object[0]));
        this.init();
    }

    private void initializeActivityList() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            this.myActivities = ManifestUtils.getAllActivities((Module[])ModuleManager.getInstance((Project)this.myProject).getModules(), (boolean)true, (boolean)true);
        }, ModalityState.any());
        AbstractListModel model = new AbstractListModel(){

            @Override
            public int getSize() {
                return InsertApiCodeDialog.this.myActivities.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((ActivityData)InsertApiCodeDialog.this.myActivities.get(i)).getActivityAndModuleName();
            }
        };
        this.myJList = new JBList((ListModel)model);
        if (this.myActivities.isEmpty()) {
            this.myWarningMessage.setText(AppIndexingBundle.message("app.indexing.code.insert.error.deep_link_missing", new Object[0]));
            this.myMessagePanel.setVisible(true);
            return;
        }
        this.myJList.setSelectionMode(0);
        this.myJList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && this.myJList.getSelectedValue() != null) {
                this.handleListMouseClickEvent(this.myJList.getSelectedIndex());
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (InsertApiCodeDialog.this.isOKActionEnabled()) {
                    InsertApiCodeDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myJList);
    }

    private void handleListMouseClickEvent(int index) {
        this.setOKActionEnabled(false);
        ActivityData activityData = this.myActivities.get(index);
        VirtualFile file = activityData.getActivityVirtualFile();
        assert (file != null);
        ApplicationManager.getApplication().invokeAndWait(() -> this.myFileEditorManager.openFile(file, true), ModalityState.any());
        Editor editor = this.myFileEditorManager.getSelectedTextEditor();
        assert (editor != null);
        PsiFile selectedPsiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        assert (selectedPsiFile != null);
        this.myCreator = new ApiCreator(this.myProject, selectedPsiFile, activityData.getActivityClass());
        ApiCreator.InsertStatusCode statusCode = this.myCreator.eligibleForInsertingAppIndexingApiCode();
        if (statusCode != ApiCreator.InsertStatusCode.SUCCESS) {
            this.myWarningMessage.setText(statusCode.getMessage());
            this.myMessagePanel.setVisible(true);
            return;
        }
        this.myMessagePanel.setVisible(false);
        this.setOKActionEnabled(true);
    }

    protected void doOKAction() {
        try {
            new WriteCommandAction(this.myProject, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    ApiCreator.InsertStatusCode statusCode;
                    if (result == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((statusCode = InsertApiCodeDialog.this.myCreator.insertAppIndexingApiCodeForActivity()) != ApiCreator.InsertStatusCode.SUCCESS) {
                        Messages.showErrorDialog((String)statusCode.getMessage(), (String)AppIndexingBundle.message("app.indexing.code.insert.error.title", new Object[0]));
                        return;
                    }
                    UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.APP_INDEXING).setKind(AndroidStudioEvent.EventKind.APP_INDEXING_API_CODE_CREATED));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/google/appindexing/ui/InsertApiCodeDialog$3", "run"));
                }
            }.execute();
        }
        finally {
            super.doOKAction();
        }
    }

    @Nullable
    protected String getHelpId() {
        return "https://firebase.google.com/docs/app-indexing/android/migrate";
    }

    protected void doHelpAction() {
        String helpId = this.getHelpId();
        assert (helpId != null);
        BrowserUtil.browse((String)helpId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/appindexing/ui/InsertApiCodeDialog", "<init>"));
    }
}

