/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.util;

import com.google.common.collect.Lists;
import com.google.urlassistant.util.ManifestUtils;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeepLinkUtils {
    private static final String TAG_ACTION = "action";
    private static final String TAG_CATEGORY = "category";
    private static final String ACTION_VIEW = "android.intent.action.VIEW";
    private static final String CATEGORY_DEFAULT = "android.intent.category.DEFAULT";
    private static final String CATEGORY_BROWSABLE = "android.intent.category.BROWSABLE";

    @NotNull
    public static List<String> getAllDeepLinks(@NotNull XmlTag root) {
        if (root == null) {
            DeepLinkUtils.$$$reportNull$$$0(0);
        }
        List intentFilters = ManifestUtils.searchXmlTagsByName((XmlTag)root, (String)"intent-filter");
        ArrayList deepLinks = Lists.newArrayList();
        for (XmlTag intentFilter : intentFilters) {
            String deepLink = DeepLinkUtils.getDeepLinkFromIntentFilter(intentFilter);
            if (deepLink == null) continue;
            deepLinks.add(deepLink);
        }
        ArrayList arrayList = deepLinks;
        if (arrayList == null) {
            DeepLinkUtils.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    private static String getDeepLinkFromIntentFilter(@NotNull XmlTag intentFilter) {
        if (intentFilter == null) {
            DeepLinkUtils.$$$reportNull$$$0(2);
        }
        List actions = ManifestUtils.searchXmlTagsByName((XmlTag)intentFilter, (String)TAG_ACTION);
        boolean hasActionView = false;
        for (XmlTag action : actions) {
            String name = action.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (name == null || !name.equals(ACTION_VIEW)) continue;
            hasActionView = true;
            break;
        }
        if (!hasActionView) {
            return null;
        }
        List categories = ManifestUtils.searchXmlTagsByName((XmlTag)intentFilter, (String)TAG_CATEGORY);
        boolean hasDefaultCategory = false;
        boolean hasBrowsableCategory = false;
        for (XmlTag category : categories) {
            String name = category.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (name != null && name.equals(CATEGORY_DEFAULT)) {
                hasDefaultCategory = true;
                continue;
            }
            if (name == null || !name.equals(CATEGORY_BROWSABLE)) continue;
            hasBrowsableCategory = true;
        }
        if (!hasDefaultCategory || !hasBrowsableCategory) {
            return null;
        }
        List datas = ManifestUtils.searchXmlTagsByName((XmlTag)intentFilter, (String)"data");
        String scheme = null;
        String host = null;
        String pathPrefix = null;
        String path = null;
        for (XmlTag data : datas) {
            if (scheme == null) {
                scheme = data.getAttributeValue("scheme", "http://schemas.android.com/apk/res/android");
            }
            if (host == null) {
                host = data.getAttributeValue("host", "http://schemas.android.com/apk/res/android");
            }
            if (pathPrefix == null) {
                pathPrefix = data.getAttributeValue("pathPrefix", "http://schemas.android.com/apk/res/android");
            }
            if (path != null) continue;
            path = data.getAttributeValue("path", "http://schemas.android.com/apk/res/android");
        }
        if (scheme != null && host != null) {
            StringBuilder buf = new StringBuilder(scheme);
            buf.append("://").append(host);
            if (path != null && path.startsWith("/")) {
                buf.append(path);
            } else if (pathPrefix != null && pathPrefix.startsWith("/")) {
                buf.append(pathPrefix);
            }
            return buf.toString();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/appindexing/util/DeepLinkUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/appindexing/util/DeepLinkUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDeepLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllDeepLinks";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDeepLinkFromIntentFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

