/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallNdkHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.NdkProjectInfo;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.ndk.AndroidSysroot;
import com.android.tools.ndk.ModuleResolveConfiguration;
import com.android.tools.ndk.NdkCompilerInfoCache;
import com.android.tools.ndk.NdkHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleWorkspace
extends AbstractProjectComponent {
    private static final String GRADLE_LANGUAGE_TYPE_C = "c";
    private static final String GRADLE_LANGUAGE_TYPE_CPP = "c++";
    @NotNull
    private final Map<String, OCLanguageKind> myProjectFileExtensions;
    @NotNull
    private Map<String, ModuleResolveConfiguration> myResolveConfigurations;
    @NotNull
    private NdkCompilerInfoCache myCompilerInfoCache;

    @NotNull
    public static GradleWorkspace getInstance(@NotNull Project project) {
        if (project == null) {
            GradleWorkspace.$$$reportNull$$$0(0);
        }
        GradleWorkspace instance = (GradleWorkspace)((Object)project.getComponent(GradleWorkspace.class));
        assert (instance != null);
        GradleWorkspace gradleWorkspace = instance;
        if (gradleWorkspace == null) {
            GradleWorkspace.$$$reportNull$$$0(1);
        }
        return gradleWorkspace;
    }

    public GradleWorkspace(@NotNull Project project) {
        if (project == null) {
            GradleWorkspace.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProjectFileExtensions = new HashMap<String, OCLanguageKind>();
        this.myResolveConfigurations = ImmutableMap.of();
        this.myCompilerInfoCache = new NdkCompilerInfoCache();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            OCLanguage.LANGUAGE_SUPPORT_DISABLED.set((UserDataHolder)project, (Object)true);
        }
        GradleSyncState.subscribe((Project)this.myProject, (GradleSyncListener)new GradleSyncListener(){

            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(2);
                }
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/ndk/GradleWorkspace$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSkipped";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        GradleBuildState.subscribe((Project)this.myProject, (GradleBuildListener)new GradleBuildListener.Adapter(){

            public void buildFinished(@NotNull BuildStatus status, @Nullable BuildContext context) {
                if (status == null) {
                    2.$$$reportNull$$$0(0);
                }
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/android/tools/ndk/GradleWorkspace$2", "buildFinished"));
            }
        });
    }

    private void scheduleGradleWorkspaceUpdate() {
        this.myProjectFileExtensions.clear();
        this.myResolveConfigurations = ImmutableMap.of();
        this.myCompilerInfoCache = new NdkCompilerInfoCache();
        new Task.Backgroundable(this.myProject, "Resolving C/C++ Configurations", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                GradleWorkspace.this.updateGradleWorkspace(indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/ndk/GradleWorkspace$3", "run"));
            }
        }.queue();
    }

    private void logProjectInfo() {
        String gradleModelVersion = "UNKNOWN";
        GradleVersion gradleVersion = GradleVersions.getInstance().getGradleVersion(this.myProject);
        if (gradleVersion != null) {
            gradleModelVersion = gradleVersion.toString();
        }
        String ndkVersion = "UNKNOWN";
        try {
            File ndkPath = this.getNdkPath();
            if (ndkPath != null) {
                ndkVersion = NdkHelper.getNdkVersion(ndkPath);
            }
        }
        catch (Exception e) {
            GradleWorkspace.getLog().warn((Throwable)e);
        }
        GradleWorkspace.getLog().info(String.format("Project settings: Gradle model version=%s, NDK version=%s", gradleModelVersion, ndkVersion));
    }

    private void updateGradleWorkspace(@NotNull ProgressIndicator indicator) {
        boolean newDisableLanguageSupport;
        boolean isValidNdkProject;
        if (indicator == null) {
            GradleWorkspace.$$$reportNull$$$0(3);
        }
        indicator.setIndeterminate(true);
        String incompatibleModelVersion = GradleWorkspace.getModelVersionIfIncompatible(this.myProject);
        boolean isNdkSpecified = this.isNdkDefined() && SdkPaths.validateAndroidNdk((File)this.getNdkPath(), (boolean)false).success;
        HashMap<String, ModuleResolveConfiguration> projectResolveConfigurations = new HashMap<String, ModuleResolveConfiguration>();
        ArrayList<Module> nativeAppModules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ImmutableMap moduleFileExtensions;
            Map<String, ModuleResolveConfiguration> moduleResolveConfigurations;
            AndroidModuleModel androidModel = AndroidModuleModel.get((Module)module);
            NdkModuleModel ndkModel = NdkModuleModel.get((Module)module);
            if (ndkModel != null) {
                moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, ndkModel);
                moduleFileExtensions = GradleWorkspace.getFileExtensions(ndkModel);
            } else {
                if (androidModel == null) continue;
                moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, androidModel);
                moduleFileExtensions = ImmutableMap.of();
            }
            if (androidModel != null && !moduleResolveConfigurations.isEmpty()) {
                nativeAppModules.add(module);
            }
            if (!moduleResolveConfigurations.isEmpty()) {
                if (incompatibleModelVersion != null) {
                    GradleWorkspace.addModelVersionIncompatibilityNotification(incompatibleModelVersion, this.myProject);
                    return;
                }
                if (!isNdkSpecified) {
                    GradleWorkspace.addNdkNotSpecifiedNotification(this.myProject, this.isNdkDefined());
                    return;
                }
            }
            projectResolveConfigurations.putAll(moduleResolveConfigurations);
            this.myProjectFileExtensions.putAll((Map<String, OCLanguageKind>)moduleFileExtensions);
        }
        this.myResolveConfigurations = GradleWorkspace.getValidConfigurations(projectResolveConfigurations);
        this.updateModel();
        boolean bl = isValidNdkProject = !this.myResolveConfigurations.isEmpty();
        if (isValidNdkProject) {
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_CPP_SYNC_COMPLETED));
            this.logProjectInfo();
        }
        boolean bl2 = newDisableLanguageSupport = !isValidNdkProject;
        if ((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)this.myProject, (Object)false) != newDisableLanguageSupport) {
            NdkHelper.disableCppLanguageSupport(this.myProject, newDisableLanguageSupport);
            if (newDisableLanguageSupport) {
                GradleWorkspace.getLog().warn("NDK support for project '" + this.myProject.getName() + "' is disabled because the project doesn't contain any valid native configurations.");
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            OCWorkspaceModificationTrackers trackers = OCWorkspaceModificationTrackers.getInstance((Project)this.myProject);
            trackers.getProjectsListTracker().incModificationCount();
            trackers.getSourceFilesListTracker().incModificationCount();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                trackers.getBuildSettingsChangesTracker().incModificationCount();
            }
        }), indicator.getModalityState());
        NdkProjectInfo projectInfo = NdkProjectInfo.get((Project)this.myProject);
        projectInfo.setHasNdkModules(!nativeAppModules.isEmpty());
    }

    @Nullable
    private static String getModelVersionIfIncompatible(@NotNull Project project) {
        if (project == null) {
            GradleWorkspace.$$$reportNull$$$0(4);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            IdeAndroidProject androidProject;
            String version;
            AndroidModuleModel androidModel = AndroidModuleModel.get((Module)module);
            if (androidModel == null || (version = GradleWorkspace.getModelVersionIfIncompatible((AndroidProject)(androidProject = androidModel.getAndroidProject()))) == null) continue;
            return version;
        }
        return null;
    }

    private static void addModelVersionIncompatibilityNotification(@NotNull String modelVersion, @NotNull Project project) {
        if (modelVersion == null) {
            GradleWorkspace.$$$reportNull$$$0(5);
        }
        if (project == null) {
            GradleWorkspace.$$$reportNull$$$0(6);
        }
        String text = String.format("Android plugin version %1$s is not compatible with the NDK support. ", modelVersion) + "Please use the experimental plugin.";
        GradleSyncMessages.getInstance((Project)project).report(new SyncMessage("Gradle Sync Issues", MessageType.WARNING, new String[]{text}));
        String title = "Incompatible Android Plugin Version";
        AndroidNotification.getInstance((Project)project).showBalloon(title, text, NotificationType.WARNING);
    }

    private static void addNdkNotSpecifiedNotification(@NotNull Project project, boolean isNdkDefined) {
        if (project == null) {
            GradleWorkspace.$$$reportNull$$$0(7);
        }
        InstallNdkHyperlink downloadLink = new InstallNdkHyperlink();
        String text = String.format("Android NDK location is not %1$s.", isNdkDefined ? "valid" : "specified");
        AndroidNotification.getInstance((Project)project).showBalloon("Project Sync Error", text, NotificationType.ERROR, new NotificationHyperlink[]{downloadLink});
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getResolveConfigurations(@NotNull Project project, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull AndroidModuleModel androidModel) {
        if (project == null) {
            GradleWorkspace.$$$reportNull$$$0(8);
        }
        if (compilerInfoCache == null) {
            GradleWorkspace.$$$reportNull$$$0(9);
        }
        if (androidModel == null) {
            GradleWorkspace.$$$reportNull$$$0(10);
        }
        HashMap<String, ModuleResolveConfiguration> configurations = new HashMap<String, ModuleResolveConfiguration>();
        IdeAndroidProject androidProject = androidModel.getAndroidProject();
        Map<String, NativeToolchain> toolchains = GradleWorkspace.getToolchainsByName((AndroidProject)androidProject);
        for (Variant variant : androidProject.getVariants()) {
            Collection<NativeLibrary> nativeLibraries = GradleWorkspace.getNativeLibraries(variant, (AndroidProject)androidProject);
            for (NativeLibrary library : nativeLibraries) {
                NativeToolchain toolchain = toolchains.get(library.getToolchainName());
                String key = GradleWorkspace.getResolvedConfigurationKey(androidModel, variant, library);
                if (toolchain == null || configurations.containsKey(key)) continue;
                ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(key, project, androidModel.getRootDirPath(), compilerInfoCache, library, toolchain);
                configurations.put(key, configuration);
            }
        }
        HashMap<String, ModuleResolveConfiguration> hashMap = configurations;
        if (hashMap == null) {
            GradleWorkspace.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, NativeToolchain> getToolchainsByName(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            GradleWorkspace.$$$reportNull$$$0(12);
        }
        if (GradleWorkspace.isModelVersionIncompatible(androidProject)) {
            Map<String, NativeToolchain> map = Collections.emptyMap();
            if (map == null) {
                GradleWorkspace.$$$reportNull$$$0(13);
            }
            return map;
        }
        HashMap<String, NativeToolchain> toolchains = new HashMap<String, NativeToolchain>();
        for (NativeToolchain toolchain : androidProject.getNativeToolchains()) {
            toolchains.put(toolchain.getName(), toolchain);
        }
        HashMap<String, NativeToolchain> hashMap = toolchains;
        if (hashMap == null) {
            GradleWorkspace.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    private static String getResolvedConfigurationKey(AndroidModuleModel androidModel, Variant variant, NativeLibrary library) {
        return androidModel.getModuleName() + variant.getName() + library.getAbi();
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getResolveConfigurations(@NotNull Project project, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull NdkModuleModel ndkModel) {
        if (project == null) {
            GradleWorkspace.$$$reportNull$$$0(15);
        }
        if (compilerInfoCache == null) {
            GradleWorkspace.$$$reportNull$$$0(16);
        }
        if (ndkModel == null) {
            GradleWorkspace.$$$reportNull$$$0(17);
        }
        HashMap<String, ModuleResolveConfiguration> configurations = new HashMap<String, ModuleResolveConfiguration>();
        for (NdkVariant variant : ndkModel.getVariants()) {
            for (NativeArtifact artifact : variant.getArtifacts()) {
                NativeToolchain toolchain = ndkModel.findToolchain(artifact.getToolChain());
                if (toolchain == null) continue;
                for (NativeFolder folder : artifact.getSourceFolders()) {
                    for (String settingsName : folder.getPerLanguageSettings().values()) {
                        File workingDirectory;
                        String key;
                        NativeSettings settings = ndkModel.findSettings(settingsName);
                        if (settings == null || configurations.containsKey(key = GradleWorkspace.getResolvedConfigurationKey(artifact, toolchain, settings, workingDirectory = GradleWorkspace.getWorkingDirectory(ndkModel, folder)))) continue;
                        ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(key, project, workingDirectory, compilerInfoCache, toolchain, artifact, settings);
                        configurations.put(key, configuration);
                    }
                }
                for (NativeFile file : artifact.getSourceFiles()) {
                    File workingDirectory;
                    String key;
                    NativeSettings settings = ndkModel.findSettings(file.getSettingsName());
                    if (settings == null || configurations.containsKey(key = GradleWorkspace.getResolvedConfigurationKey(artifact, toolchain, settings, workingDirectory = GradleWorkspace.getWorkingDirectory(ndkModel, file)))) continue;
                    ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(key, project, workingDirectory, compilerInfoCache, toolchain, artifact, settings);
                    configurations.put(key, configuration);
                }
            }
        }
        HashMap<String, ModuleResolveConfiguration> hashMap = configurations;
        if (hashMap == null) {
            GradleWorkspace.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    @NotNull
    private static String getResolvedConfigurationKey(@NotNull NativeArtifact artifact, @NotNull NativeToolchain toolchain, @NotNull NativeSettings settings, @NotNull File workingDirectory) {
        if (artifact == null) {
            GradleWorkspace.$$$reportNull$$$0(19);
        }
        if (toolchain == null) {
            GradleWorkspace.$$$reportNull$$$0(20);
        }
        if (settings == null) {
            GradleWorkspace.$$$reportNull$$$0(21);
        }
        if (workingDirectory == null) {
            GradleWorkspace.$$$reportNull$$$0(22);
        }
        String string = artifact.getName() + toolchain.getName() + settings.getName() + FileUtilRt.toSystemIndependentName((String)workingDirectory.getPath());
        if (string == null) {
            GradleWorkspace.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static File getWorkingDirectory(@NotNull NdkModuleModel ndkModel, @NotNull NativeFile nativeFile) {
        if (ndkModel == null) {
            GradleWorkspace.$$$reportNull$$$0(24);
        }
        if (nativeFile == null) {
            GradleWorkspace.$$$reportNull$$$0(25);
        }
        File workingDirectory = null;
        if (ndkModel.getFeatures().isWorkingDirectorySupported()) {
            workingDirectory = nativeFile.getWorkingDirectory();
        }
        File file = workingDirectory != null ? workingDirectory : ndkModel.getRootDirPath();
        if (file == null) {
            GradleWorkspace.$$$reportNull$$$0(26);
        }
        return file;
    }

    @NotNull
    private static File getWorkingDirectory(@NotNull NdkModuleModel ndkModel, @NotNull NativeFolder nativeFolder) {
        if (ndkModel == null) {
            GradleWorkspace.$$$reportNull$$$0(27);
        }
        if (nativeFolder == null) {
            GradleWorkspace.$$$reportNull$$$0(28);
        }
        File workingDirectory = null;
        if (ndkModel.getFeatures().isWorkingDirectorySupported()) {
            workingDirectory = nativeFolder.getWorkingDirectory();
        }
        if (workingDirectory != null) {
            File file = workingDirectory;
            if (file == null) {
                GradleWorkspace.$$$reportNull$$$0(29);
            }
            return file;
        }
        File file = ndkModel.getRootDirPath();
        if (file == null) {
            GradleWorkspace.$$$reportNull$$$0(30);
        }
        return file;
    }

    @NotNull
    private static Map<String, OCLanguageKind> getFileExtensions(@NotNull NdkModuleModel ndkModel) {
        if (ndkModel == null) {
            GradleWorkspace.$$$reportNull$$$0(31);
        }
        HashMap<String, OCLanguageKind> fileExtensions = new HashMap<String, OCLanguageKind>();
        for (Map.Entry entry : ndkModel.getAndroidProject().getFileExtensions().entrySet()) {
            String fileExtension = (String)entry.getKey();
            String languageType = (String)entry.getValue();
            OCLanguageKind languageKind = null;
            if (GRADLE_LANGUAGE_TYPE_C.equals(languageType)) {
                languageKind = OCLanguageKind.C;
            } else if (GRADLE_LANGUAGE_TYPE_CPP.equals(languageType)) {
                languageKind = OCLanguageKind.CPP;
            }
            if (languageKind == null) {
                GradleWorkspace.getLog().warn(String.format("Unknown language type '%1$s' found in '%2$s'", languageType, ndkModel.getModuleName()));
                continue;
            }
            fileExtensions.put(fileExtension, languageKind);
        }
        HashMap<String, OCLanguageKind> hashMap = fileExtensions;
        if (hashMap == null) {
            GradleWorkspace.$$$reportNull$$$0(32);
        }
        return hashMap;
    }

    public boolean isNdkDefined() {
        return this.getNdkPath() != null;
    }

    @Nullable
    public File getNdkPath() {
        try {
            return new LocalProperties(this.myProject).getAndroidNdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", this.myProject.getName());
            GradleWorkspace.getLog().info(msg, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public File getSdkPath() {
        try {
            return new LocalProperties(this.myProject).getAndroidSdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", this.myProject.getName());
            GradleWorkspace.getLog().info(msg, (Throwable)e);
            return null;
        }
    }

    public boolean isNativeModule(@NotNull Module module) {
        if (module == null) {
            GradleWorkspace.$$$reportNull$$$0(33);
        }
        Map<String, ModuleResolveConfiguration> moduleResolveConfigurations = null;
        AndroidModuleModel androidModel = AndroidModuleModel.get((Module)module);
        NdkModuleModel ndkModel = NdkModuleModel.get((Module)module);
        if (ndkModel != null) {
            moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, ndkModel);
        } else if (androidModel != null) {
            moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, androidModel);
        }
        return androidModel != null && !moduleResolveConfigurations.isEmpty();
    }

    private static void addToModelFromConfiguration(@NotNull OCWorkspaceImpl.ModifiableModel model, @NotNull ModuleResolveConfiguration configuration, @Nullable Collection<NativeFile> files) {
        if (model == null) {
            GradleWorkspace.$$$reportNull$$$0(34);
        }
        if (configuration == null) {
            GradleWorkspace.$$$reportNull$$$0(35);
        }
        HashMap<OCLanguageKind, Trinity> configLanguages = new HashMap<OCLanguageKind, Trinity>();
        for (OCLanguageKind kind : ImmutableList.of((Object)OCLanguageKind.C, (Object)OCLanguageKind.CPP)) {
            File compilerExecutable = configuration.getCompilerSettings().getCompilerExecutable(kind);
            configLanguages.put(kind, Trinity.create((Object)configuration.getCompilerSettings().getCompiler(kind), (Object)compilerExecutable, (Object)configuration.getCompilerSettings().getCompilerSwitches(kind, null)));
        }
        NullableFunction fileMapper = OCWorkspaceImpl.createFileMapper();
        HashMap<VirtualFile, Pair> configSourceFiles = new HashMap<VirtualFile, Pair>();
        if (files != null) {
            for (NativeFile file : files) {
                VirtualFile virtualFile = (VirtualFile)fileMapper.fun((Object)file.getFilePath());
                OCLanguageKind kind = configuration.getDeclaredLanguageKind(virtualFile);
                if (kind == null) continue;
                configSourceFiles.put(virtualFile, Pair.create((Object)kind, (Object)configuration.getCompilerSettings().getCompilerSwitches(kind, virtualFile)));
            }
        }
        model.addConfiguration(configuration.getUniqueId(), configuration.getDisplayName(false), configuration.getDisplayName(true), configuration.getCompilerSettings().getCompilerWorkingDir(), configLanguages, configSourceFiles, new CidrToolEnvironment(), fileMapper);
    }

    private void updateModel() {
        if (this.myResolveConfigurations.isEmpty()) {
            return;
        }
        OCWorkspaceImpl.ModifiableModel workspaceModel = OCWorkspaceImpl.getInstanceImpl((Project)this.myProject).getModifiableModel();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            NdkModuleModel ndkModel = NdkModuleModel.get((Module)module);
            if (ndkModel == null) continue;
            for (NdkVariant variant : ndkModel.getVariants()) {
                ListMultimap addedConfigurations = MultimapBuilder.hashKeys().arrayListValues().build();
                for (NativeArtifact nativeArtifact : variant.getArtifacts()) {
                    NativeToolchain toolchain = ndkModel.findToolchain(nativeArtifact.getToolChain());
                    if (toolchain == null) continue;
                    for (NativeFolder folder : nativeArtifact.getSourceFolders()) {
                        for (String settingsName : folder.getPerLanguageSettings().values()) {
                            File workingDirectory;
                            String key;
                            NativeSettings settings = ndkModel.findSettings(settingsName);
                            if (settings == null || this.myResolveConfigurations.get(key = GradleWorkspace.getResolvedConfigurationKey(nativeArtifact, toolchain, settings, workingDirectory = GradleWorkspace.getWorkingDirectory(ndkModel, folder))) == null) continue;
                            GradleWorkspace.addToModelFromConfiguration(workspaceModel, this.myResolveConfigurations.get(key), nativeArtifact.getSourceFiles());
                        }
                    }
                    for (NativeFile file : nativeArtifact.getSourceFiles()) {
                        File workingDirectory;
                        String key;
                        NativeSettings settings = ndkModel.findSettings(file.getSettingsName());
                        if (settings == null || this.myResolveConfigurations.get(key = GradleWorkspace.getResolvedConfigurationKey(nativeArtifact, toolchain, settings, workingDirectory = GradleWorkspace.getWorkingDirectory(ndkModel, file))) == null) continue;
                        addedConfigurations.put((Object)key, (Object)file);
                    }
                }
                for (Map.Entry entry : addedConfigurations.asMap().entrySet()) {
                    if (entry.getValue() == null || this.myResolveConfigurations.get(entry.getKey()) == null) continue;
                    GradleWorkspace.addToModelFromConfiguration(workspaceModel, this.myResolveConfigurations.get(entry.getKey()), (Collection)entry.getValue());
                }
            }
        }
        workspaceModel.commit(0);
    }

    @NotNull
    private static Collection<NativeLibrary> getNativeLibraries(@NotNull Variant variant, @NotNull AndroidProject androidProject) {
        if (variant == null) {
            GradleWorkspace.$$$reportNull$$$0(36);
        }
        if (androidProject == null) {
            GradleWorkspace.$$$reportNull$$$0(37);
        }
        if (GradleWorkspace.isModelVersionIncompatible(androidProject)) {
            List<NativeLibrary> list = Collections.emptyList();
            if (list == null) {
                GradleWorkspace.$$$reportNull$$$0(38);
            }
            return list;
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        Collection nativeLibraries = mainArtifact.getNativeLibraries();
        if (nativeLibraries != null) {
            Collection collection = nativeLibraries;
            if (collection == null) {
                GradleWorkspace.$$$reportNull$$$0(39);
            }
            return collection;
        }
        List<NativeLibrary> list = Collections.emptyList();
        if (list == null) {
            GradleWorkspace.$$$reportNull$$$0(40);
        }
        return list;
    }

    private static boolean isModelVersionIncompatible(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            GradleWorkspace.$$$reportNull$$$0(41);
        }
        return GradleWorkspace.getModelVersionIfIncompatible(androidProject) != null;
    }

    @Nullable
    private static String getModelVersionIfIncompatible(@NotNull AndroidProject androidProject) {
        String modelVersion;
        if (androidProject == null) {
            GradleWorkspace.$$$reportNull$$$0(42);
        }
        if (!(modelVersion = androidProject.getModelVersion()).startsWith("1.0") && !modelVersion.startsWith("1.1") && androidProject.getApiVersion() >= 3) {
            return null;
        }
        return modelVersion;
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getValidConfigurations(@NotNull Map<String, ModuleResolveConfiguration> configs) {
        if (configs == null) {
            GradleWorkspace.$$$reportNull$$$0(43);
        }
        ImmutableMap.Builder configurationsBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ModuleResolveConfiguration> entry : configs.entrySet()) {
            if (!GradleWorkspace.isValidConfiguration(entry.getValue())) continue;
            configurationsBuilder.put(entry);
        }
        ImmutableMap immutableMap = configurationsBuilder.build();
        if (immutableMap == null) {
            GradleWorkspace.$$$reportNull$$$0(44);
        }
        return immutableMap;
    }

    private static boolean isValidConfiguration(@NotNull ModuleResolveConfiguration configuration) {
        if (configuration == null) {
            GradleWorkspace.$$$reportNull$$$0(45);
        }
        if (!GradleWorkspace.isValidConfiguration(configuration, OCLanguageKind.C)) {
            return false;
        }
        return GradleWorkspace.isValidConfiguration(configuration, OCLanguageKind.CPP);
    }

    private static boolean isValidConfiguration(@NotNull ModuleResolveConfiguration configuration, @NotNull OCLanguageKind kind) {
        if (configuration == null) {
            GradleWorkspace.$$$reportNull$$$0(46);
        }
        if (kind == null) {
            GradleWorkspace.$$$reportNull$$$0(47);
        }
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings();
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches(kind, null);
        assert (compilerSwitches != null);
        boolean isValidConfiguration = false;
        boolean isystemFound = false;
        boolean sysrootFound = false;
        for (String argument : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            File sysroot;
            String sysrootPath = StringUtil.trimStart((String)(argument = StringUtil.unquoteString((String)argument.trim())), (String)"--sysroot=");
            if (sysrootPath.length() < argument.length()) {
                sysroot = new File(FileUtilRt.toSystemIndependentName((String)sysrootPath));
                if (!sysroot.isAbsolute()) {
                    sysroot = new File(compilerSettings.getCompilerWorkingDir(), sysroot.getPath());
                }
                if (isValidConfiguration = AndroidSysroot.isValidAndroidSysroot(sysroot)) continue;
                return false;
            }
            if (argument.equals("--sysroot")) {
                sysrootFound = true;
                continue;
            }
            if (sysrootFound) {
                sysrootFound = false;
                sysroot = new File(FileUtilRt.toSystemIndependentName((String)argument));
                if (!sysroot.isAbsolute()) {
                    sysroot = new File(compilerSettings.getCompilerWorkingDir(), sysroot.getPath());
                }
                if (isValidConfiguration = AndroidSysroot.isValidAndroidSysroot(sysroot)) continue;
                return false;
            }
            if (argument.equals("-isystem")) {
                isystemFound = true;
                continue;
            }
            if (!isystemFound) continue;
            isystemFound = false;
            File systemIncludePath = new File(FileUtilRt.toSystemIndependentName((String)argument));
            if (!systemIncludePath.isAbsolute()) {
                systemIncludePath = new File(compilerSettings.getCompilerWorkingDir(), systemIncludePath.getPath());
            }
            if (AndroidSysroot.isValidAndroidSysrootUsrInclude(systemIncludePath)) {
                isValidConfiguration = true;
                continue;
            }
            if (!AndroidSysroot.isPotentialNonAndroidSysrootUsrInclude(systemIncludePath)) continue;
            return false;
        }
        return isValidConfiguration;
    }

    @Nullable
    public OCLanguageKind getLanguageKind(@NotNull String fileName) {
        if (fileName == null) {
            GradleWorkspace.$$$reportNull$$$0(48);
        }
        if (!OCFileTypeHelpers.isSourceFile((String)fileName)) {
            return null;
        }
        String fileExtension = FileUtilRt.getExtension((String)fileName);
        OCLanguageKind languageKind = this.myProjectFileExtensions.get(fileExtension);
        if (languageKind == null && !this.myResolveConfigurations.isEmpty()) {
            languageKind = fileExtension.equalsIgnoreCase(GRADLE_LANGUAGE_TYPE_C) ? OCLanguageKind.C : OCLanguageKind.CPP;
            GradleWorkspace.getLog().warn(String.format("Unable to find language kind for files with extension '%1$s', assuming it as '%2$s'", fileExtension, languageKind));
            this.myProjectFileExtensions.put(fileExtension, languageKind);
        }
        return languageKind;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(GradleWorkspace.class);
        if (logger == null) {
            GradleWorkspace.$$$reportNull$$$0(49);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/GradleWorkspace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelVersion";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerInfoCache";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 12: 
            case 37: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 17: 
            case 24: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModel";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeFolder";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 35: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/GradleWorkspace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 11: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveConfigurations";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolchainsByName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedConfigurationKey";
                break;
            }
            case 26: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtensions";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeLibraries";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidConfigurations";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 49: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateGradleWorkspace";
                break;
            }
            case 4: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getModelVersionIfIncompatible";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addModelVersionIncompatibilityNotification";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNdkNotSpecifiedNotification";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getResolveConfigurations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getToolchainsByName";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedConfigurationKey";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtensions";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isNativeModule";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addToModelFromConfiguration";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNativeLibraries";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isModelVersionIncompatible";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getValidConfigurations";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isValidConfiguration";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageKind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

