/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.sdklib.devices.Abi;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulePathManager {
    private static final Map<Abi, Abi> ABI_MAPPINGS = Collections.singletonMap(Abi.ARMEABI_V7A, Abi.ARMEABI);

    @NotNull
    public static File getLldbCommonFile(@NotNull String relativePath) {
        if (relativePath == null) {
            ModulePathManager.$$$reportNull$$$0(0);
        }
        if (PluginManagerCore.isRunningFromSources()) {
            File file = Paths.get(PathManager.getHomePath(), "../../prebuilts/tools/common/lldb", relativePath).toFile();
            if (file == null) {
                ModulePathManager.$$$reportNull$$$0(1);
            }
            return file;
        }
        File file = new File(ModulePathManager.getShippedLldbDirectory(), relativePath);
        if (file == null) {
            ModulePathManager.$$$reportNull$$$0(2);
        }
        return file;
    }

    private static File getShippedLldbDirectory() {
        return Paths.get(PathManager.getBinPath(), "lldb").toFile();
    }

    private static File getDevLldbOsDirectory() {
        String os;
        if (SystemInfo.isLinux) {
            os = "linux-x86_64";
        } else if (SystemInfo.isMac) {
            os = "darwin-x86_64";
        } else if (SystemInfo.isWindows) {
            os = "windows-x86_64";
        } else {
            throw new IllegalStateException("Unknown operating system");
        }
        return Paths.get(PathManager.getHomePath(), "../../prebuilts/tools", os, "lldb").toFile();
    }

    @NotNull
    public static File getLldbHostDir() {
        if (PluginManagerCore.isRunningFromSources()) {
            File file = ModulePathManager.getDevLldbOsDirectory();
            if (file == null) {
                ModulePathManager.$$$reportNull$$$0(3);
            }
            return file;
        }
        File file = ModulePathManager.getShippedLldbDirectory();
        if (file == null) {
            ModulePathManager.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public static File getLldbHostFile(@NotNull String relativePath) {
        if (relativePath == null) {
            ModulePathManager.$$$reportNull$$$0(5);
        }
        File file = new File(ModulePathManager.getLldbHostDir(), relativePath);
        if (file == null) {
            ModulePathManager.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    public static File getLldbPythonHome() {
        String pythonOsDir;
        if (SystemInfo.isLinux) {
            pythonOsDir = "linux-x86";
        } else if (SystemInfo.isWindows) {
            pythonOsDir = "windows-x86";
        } else {
            throw new IllegalStateException("getLldbPythonHome should not be called for darwin");
        }
        if (PluginManagerCore.isRunningFromSources()) {
            File file = Paths.get(PathManager.getHomePath(), "../../prebuilts/python", pythonOsDir).toFile();
            if (file == null) {
                ModulePathManager.$$$reportNull$$$0(7);
            }
            return file;
        }
        File file = ModulePathManager.getShippedLldbDirectory();
        if (file == null) {
            ModulePathManager.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public static File getLldbAndroidFile(@NotNull String relativePath) {
        if (relativePath == null) {
            ModulePathManager.$$$reportNull$$$0(9);
        }
        File file = new File(ModulePathManager.getLldbCommonFile("android"), relativePath);
        if (file == null) {
            ModulePathManager.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    public static File getLldbSharedFile(@NotNull String relativePath) {
        if (relativePath == null) {
            ModulePathManager.$$$reportNull$$$0(11);
        }
        File file = new File(ModulePathManager.getLldbCommonFile("shared"), relativePath);
        if (file == null) {
            ModulePathManager.$$$reportNull$$$0(12);
        }
        return file;
    }

    @Nullable
    public static File findLLDBServer(@NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        if (facet == null) {
            ModulePathManager.$$$reportNull$$$0(13);
        }
        if (debuggerState == null) {
            ModulePathManager.$$$reportNull$$$0(14);
        }
        if (abis == null) {
            ModulePathManager.$$$reportNull$$$0(15);
        }
        File foundServerFile = null;
        for (Abi abi : abis) {
            File serverFile = ModulePathManager.getServerFileByAbi(abi);
            if (serverFile != null) {
                foundServerFile = serverFile;
            }
            if (AndroidNativeAppDebugProcess.getSymbolsDir(facet, debuggerState, Collections.singletonList(abi)).isEmpty()) continue;
            return serverFile;
        }
        return foundServerFile;
    }

    @Nullable
    private static File getServerFileByAbi(@NotNull Abi abi) {
        File lldbServerFile;
        if (abi == null) {
            ModulePathManager.$$$reportNull$$$0(16);
        }
        if ((lldbServerFile = ModulePathManager.getAndroidLldbBinFile(abi)).exists()) {
            return lldbServerFile;
        }
        Abi mappedAbi = ABI_MAPPINGS.get(abi);
        if (mappedAbi != null && (lldbServerFile = ModulePathManager.getAndroidLldbBinFile(mappedAbi)).exists()) {
            return lldbServerFile;
        }
        return null;
    }

    @NotNull
    private static File getAndroidLldbBinFile(Abi abi) {
        File file = ModulePathManager.getLldbAndroidFile(new File(abi.toString(), "lldb-server").getPath());
        if (file == null) {
            ModulePathManager.$$$reportNull$$$0(17);
        }
        return file;
    }

    @NotNull
    public static File getRepoLLDBStlPrintersFolder() {
        File file = ModulePathManager.getLldbSharedFile("stl_printers");
        if (file == null) {
            ModulePathManager.$$$reportNull$$$0(18);
        }
        return file;
    }

    @NotNull
    public static File getRepoLLDBStlPrintersBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            ModulePathManager.$$$reportNull$$$0(19);
        }
        File file = new File(ModulePathManager.getRepoLLDBStlPrintersFolder(), relativePath);
        if (file == null) {
            ModulePathManager.$$$reportNull$$$0(20);
        }
        return file;
    }

    @NotNull
    public static File getRepoLLDBPrettyPrinterScriptsFolder() {
        File file = ModulePathManager.getLldbSharedFile("jobject_printers");
        if (file == null) {
            ModulePathManager.$$$reportNull$$$0(21);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/ModulePathManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerState";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abis";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/ModulePathManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLldbCommonFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLldbHostDir";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLldbHostFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLldbPythonHome";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLldbAndroidFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLldbSharedFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidLldbBinFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoLLDBStlPrintersFolder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoLLDBStlPrintersBinFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoLLDBPrettyPrinterScriptsFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLldbCommonFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLldbHostFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLldbAndroidFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLldbSharedFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findLLDBServer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getServerFileByAbi";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRepoLLDBStlPrintersBinFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

