/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.tools.ndk.NdkCompilerInfoCache;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceUtil;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleResolveConfiguration
extends UserDataHolderBase
implements OCResolveConfiguration {
    private static final NotificationGroup EVENT_LOG_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"NDK Compile");
    private static final Logger LOG = Logger.getInstance(ModuleResolveConfiguration.class);
    @NotNull
    private final String myId;
    @NotNull
    private final Project myProject;
    @NotNull
    private final NativeToolchain myNativeToolchain;
    @Nullable
    private final NativeArtifact myNativeArtifact;
    @NotNull
    private final NdkCompilerInfoCache myCompilerInfoCache;
    @NotNull
    private final CompilerSettings myCompilerSettings;
    @NotNull
    private final CidrCompilerSwitches mycSwitches;
    @NotNull
    private final CidrCompilerSwitches mycppSwitches;

    ModuleResolveConfiguration(@NotNull String id, @NotNull Project project, @NotNull File compilerWorkingDir, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull NativeLibrary nativeLibrary, @NotNull NativeToolchain nativeToolchain) {
        if (id == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(1);
        }
        if (compilerWorkingDir == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(2);
        }
        if (compilerInfoCache == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(3);
        }
        if (nativeLibrary == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(4);
        }
        if (nativeToolchain == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(5);
        }
        this(id, project, compilerWorkingDir, compilerInfoCache, nativeToolchain, nativeLibrary, null, null);
    }

    ModuleResolveConfiguration(@NotNull String id, @NotNull Project project, @NotNull File compilerWorkingDir, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull NativeToolchain nativeToolchain, @NotNull NativeArtifact nativeArtifact, @NotNull NativeSettings nativeSettings) {
        if (id == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(7);
        }
        if (compilerWorkingDir == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(8);
        }
        if (compilerInfoCache == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(9);
        }
        if (nativeToolchain == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(10);
        }
        if (nativeArtifact == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(11);
        }
        if (nativeSettings == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(12);
        }
        this(id, project, compilerWorkingDir, compilerInfoCache, nativeToolchain, null, nativeArtifact, nativeSettings);
    }

    private ModuleResolveConfiguration(@NotNull String id, @NotNull Project project, @NotNull File compilerWorkingDir, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull NativeToolchain nativeToolchain, @Nullable NativeLibrary nativeLibrary, @Nullable NativeArtifact nativeArtifact, @Nullable NativeSettings nativeSettings) {
        if (id == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(13);
        }
        if (project == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(14);
        }
        if (compilerWorkingDir == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(15);
        }
        if (compilerInfoCache == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(16);
        }
        if (nativeToolchain == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(17);
        }
        this.myId = id;
        this.myProject = project;
        this.myNativeToolchain = nativeToolchain;
        this.myNativeArtifact = nativeArtifact;
        this.myCompilerInfoCache = compilerInfoCache;
        this.myCompilerSettings = new CompilerSettings(compilerWorkingDir);
        if (nativeLibrary != null) {
            this.mycSwitches = ModuleResolveConfiguration.convertSwitches(nativeLibrary.getCCompilerFlags());
            this.mycppSwitches = ModuleResolveConfiguration.convertSwitches(nativeLibrary.getCppCompilerFlags());
        } else if (nativeSettings != null) {
            this.mycppSwitches = this.mycSwitches = ModuleResolveConfiguration.convertSwitches(nativeSettings.getCompilerFlags());
        } else {
            this.mycppSwitches = this.mycSwitches = ModuleResolveConfiguration.convertSwitches(Collections.emptyList());
            LOG.info("Falling back to empty c/c++ switches");
        }
    }

    private static CidrCompilerSwitches convertSwitches(List<String> compilerFlags) {
        CidrSwitchBuilder builder = new CidrSwitchBuilder();
        for (String compilerFlag : compilerFlags) {
            builder.addSingleRaw(compilerFlag);
        }
        return builder.build();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(18);
        }
        return project;
    }

    @NotNull
    public String getUniqueId() {
        String string = this.myId;
        if (string == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public String getDisplayName(boolean shorten) {
        if (this.myNativeArtifact != null) {
            String string = shorten ? this.myNativeArtifact.getName() : String.format("Artifact: '%1$s''", this.myNativeArtifact.getName());
            if (string == null) {
                ModuleResolveConfiguration.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = shorten ? this.myNativeToolchain.getName() : String.format("Toolchain: '%1$s''", this.myNativeToolchain.getName());
        if (string == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public Set<VirtualFile> getPrecompiledHeaders() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    public List<VirtualFile> getPrecompiledHeaders(@NotNull OCLanguageKind kind, @NotNull VirtualFile sourceFile) {
        if (kind == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(23);
        }
        if (sourceFile == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(24);
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Nullable
    public VirtualFile getMappedInclude(@NotNull OCLanguageKind languageKind, @Nullable VirtualFile sourceFile, @NotNull String include) {
        if (languageKind == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(26);
        }
        if (include == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(27);
        }
        return null;
    }

    @NotNull
    public Collection<VirtualFile> getSources() {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public char[] getFileSeparators() {
        char[] cArray = this.myCompilerSettings.getEnvironment().getSupportedFileSeparators();
        if (cArray == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(29);
        }
        return cArray;
    }

    @NotNull
    public List<HeadersSearchRoot> getProjectHeadersRoots() {
        List<HeadersSearchRoot> list = Collections.emptyList();
        if (list == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    public List<HeadersSearchRoot> getLibraryHeadersRoots(@NotNull OCLanguageKind languageKind, @Nullable VirtualFile sourceFile) {
        NdkCompilerInfoCache.NdkCompilerInfo compilerInfo;
        if (languageKind == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(31);
        }
        if ((compilerInfo = this.getNdkCompilerInfo(languageKind, sourceFile)) != null) {
            List<HeadersSearchRoot> list = compilerInfo.getHeaderSearchPaths().stream().map(s -> HeadersSearchRoot.createFromHeaderSearchPath((Project)this.myProject, (HeadersSearchPath)s, (Disposable)this.myProject)).collect(Collectors.toList());
            if (list == null) {
                ModuleResolveConfiguration.$$$reportNull$$$0(32);
            }
            return list;
        }
        List<HeadersSearchRoot> list = Collections.emptyList();
        if (list == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    public String getPreprocessorDefines(@NotNull OCLanguageKind languageKind, @Nullable VirtualFile sourceFile) {
        NdkCompilerInfoCache.NdkCompilerInfo info;
        if (languageKind == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(34);
        }
        if ((info = this.getNdkCompilerInfo(languageKind, sourceFile)) != null) {
            String string = info.getDefines();
            if (string == null) {
                ModuleResolveConfiguration.$$$reportNull$$$0(35);
            }
            return string;
        }
        if ("" == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(36);
        }
        return "";
    }

    @NotNull
    public Map<OCCompilerFeatures.Type<?>, ?> getCompilerFeatures(@NotNull OCLanguageKind languageKind, @Nullable VirtualFile sourceFile) {
        NdkCompilerInfoCache.NdkCompilerInfo info;
        if (languageKind == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(37);
        }
        if ((info = this.getNdkCompilerInfo(languageKind, sourceFile)) != null) {
            Map<OCCompilerFeatures.Type<?>, ?> map = info.getFeatures();
            if (map == null) {
                ModuleResolveConfiguration.$$$reportNull$$$0(38);
            }
            return map;
        }
        Map map = Collections.emptyMap();
        if (map == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(39);
        }
        return map;
    }

    @Nullable
    private NdkCompilerInfoCache.NdkCompilerInfo getNdkCompilerInfo(OCLanguageKind languageKind, VirtualFile sourceFile) {
        try {
            return this.myCompilerInfoCache.getCompilerInfo(this.myProject, this.myCompilerSettings, languageKind, sourceFile, this.myCompilerSettings.getEnvironment());
        }
        catch (NdkCompilerInfoCache.NdkCompilerInvocationException e) {
            EVENT_LOG_NOTIFICATION.createNotification(e.getMessage(), MessageType.ERROR).notify(this.myProject);
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    private OCLanguageKind getLanguageKind(@Nullable VirtualFile sourceFile) {
        OCLanguageKind kind = OCLanguageKindCalculator.tryFileTypeAndExtension((Project)this.myProject, (VirtualFile)sourceFile);
        OCLanguageKind oCLanguageKind = kind != null ? kind : this.getMaximumLanguageKind();
        if (oCLanguageKind == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(40);
        }
        return oCLanguageKind;
    }

    @Nullable
    public OCLanguageKind getDeclaredLanguageKind(@Nullable VirtualFile sourceOrHeaderFile) {
        if (sourceOrHeaderFile == null) {
            return null;
        }
        String fileName = sourceOrHeaderFile.getName();
        if (OCFileTypeHelpers.isSourceFile((String)fileName)) {
            return this.getLanguageKind(sourceOrHeaderFile);
        }
        if (OCFileTypeHelpers.isHeaderFile((String)fileName)) {
            return this.getLanguageKind(this.getSourceFileForHeaderFile(sourceOrHeaderFile));
        }
        return null;
    }

    @Nullable
    private VirtualFile getSourceFileForHeaderFile(@NotNull VirtualFile headerFile) {
        if (headerFile == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(41);
        }
        ArrayList roots = new ArrayList(OCImportGraph.getAllHeaderRoots((Project)this.myProject, (VirtualFile)headerFile));
        String headerNameWithoutExtension = headerFile.getNameWithoutExtension();
        for (VirtualFile root : roots) {
            if (!root.getNameWithoutExtension().equals(headerNameWithoutExtension)) continue;
            return root;
        }
        return null;
    }

    @NotNull
    public OCLanguageKind getMaximumLanguageKind() {
        OCLanguageKind oCLanguageKind = OCLanguageKind.CPP;
        if (oCLanguageKind == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(42);
        }
        return oCLanguageKind;
    }

    @NotNull
    public OCCompilerSettings getCompilerSettings() {
        CompilerSettings compilerSettings = this.myCompilerSettings;
        if (compilerSettings == null) {
            ModuleResolveConfiguration.$$$reportNull$$$0(43);
        }
        return compilerSettings;
    }

    @Nullable
    public Object getIndexingCluster() {
        return null;
    }

    public int compareTo(OCResolveConfiguration o) {
        return OCWorkspaceUtil.compareConfigurations((OCResolveConfiguration)this, (OCResolveConfiguration)o);
    }

    static OCCompilerKind determineCompilerKind(@Nullable File cCompiler) {
        if (cCompiler != null) {
            if (cCompiler.getName().endsWith("clang") || cCompiler.getName().endsWith("clang.exe")) {
                return OCCompilerKind.CLANG;
            }
            if (cCompiler.getName().endsWith("gcc") || cCompiler.getName().endsWith("gcc.exe")) {
                return OCCompilerKind.GCC;
            }
        }
        return OCCompilerKind.UNKNOWN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerWorkingDir";
                break;
            }
            case 3: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerInfoCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeLibrary";
                break;
            }
            case 5: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeToolchain";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeArtifact";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeSettings";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/ModuleResolveConfiguration";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 26: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "include";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/ModuleResolveConfiguration";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueId";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrecompiledHeaders";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSeparators";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectHeadersRoots";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryHeadersRoots";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreprocessorDefines";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerFeatures";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageKind";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaximumLanguageKind";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPrecompiledHeaders";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMappedInclude";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryHeadersRoots";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPreprocessorDefines";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerFeatures";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFileForHeaderFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CompilerSettings
    implements OCCompilerSettings {
        @NotNull
        private final File myWorkingDir;
        @NotNull
        private final OCCompilerKind myCompilerKind;
        @NotNull
        private final CidrToolEnvironment myToolEnvironment;

        CompilerSettings(File workingDir) {
            if (workingDir == null) {
                CompilerSettings.$$$reportNull$$$0(0);
            }
            this.myToolEnvironment = new CidrToolEnvironment();
            this.myWorkingDir = workingDir;
            this.myCompilerKind = ModuleResolveConfiguration.determineCompilerKind(ModuleResolveConfiguration.this.myNativeToolchain.getCCompilerExecutable());
            if (this.myCompilerKind == OCCompilerKind.UNKNOWN) {
                LOG.warn("Unknown compiler kind inferred from C compiler " + ModuleResolveConfiguration.this.myNativeToolchain.getCCompilerExecutable());
            }
        }

        @NotNull
        public OCCompilerKind getCompiler(@NotNull OCLanguageKind languageKind) {
            if (languageKind == null) {
                CompilerSettings.$$$reportNull$$$0(1);
            }
            OCCompilerKind oCCompilerKind = this.myCompilerKind;
            if (oCCompilerKind == null) {
                CompilerSettings.$$$reportNull$$$0(2);
            }
            return oCCompilerKind;
        }

        @Nullable
        public File getCompilerExecutable(@NotNull OCLanguageKind lang) {
            if (lang == null) {
                CompilerSettings.$$$reportNull$$$0(3);
            }
            if (lang == OCLanguageKind.C) {
                return ModuleResolveConfiguration.this.myNativeToolchain.getCCompilerExecutable();
            }
            return ModuleResolveConfiguration.this.myNativeToolchain.getCppCompilerExecutable();
        }

        @NotNull
        public File getCompilerWorkingDir() {
            File file = this.myWorkingDir;
            if (file == null) {
                CompilerSettings.$$$reportNull$$$0(4);
            }
            return file;
        }

        @NotNull
        public CidrToolEnvironment getEnvironment() {
            CidrToolEnvironment cidrToolEnvironment = this.myToolEnvironment;
            if (cidrToolEnvironment == null) {
                CompilerSettings.$$$reportNull$$$0(5);
            }
            return cidrToolEnvironment;
        }

        @NotNull
        public CidrCompilerSwitches getCompilerSwitches(@NotNull OCLanguageKind lang, @Nullable VirtualFile sourceFile) {
            if (lang == null) {
                CompilerSettings.$$$reportNull$$$0(6);
            }
            if (lang == OCLanguageKind.C) {
                CidrCompilerSwitches cidrCompilerSwitches = ModuleResolveConfiguration.this.mycSwitches;
                if (cidrCompilerSwitches == null) {
                    CompilerSettings.$$$reportNull$$$0(7);
                }
                return cidrCompilerSwitches;
            }
            CidrCompilerSwitches cidrCompilerSwitches = ModuleResolveConfiguration.this.mycppSwitches;
            if (cidrCompilerSwitches == null) {
                CompilerSettings.$$$reportNull$$$0(8);
            }
            return cidrCompilerSwitches;
        }

        @Nullable
        public CompilerSettingsKey getCompilerKey(@NotNull OCLanguageKind languageKind, @Nullable VirtualFile sourceFile) {
            NdkCompilerInfoCache.NdkCompilerInfo info;
            if (languageKind == null) {
                CompilerSettings.$$$reportNull$$$0(9);
            }
            return (info = ModuleResolveConfiguration.this.getNdkCompilerInfo(languageKind, sourceFile)) == null ? null : info.getCompilerKey();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingDir";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageKind";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/ndk/ModuleResolveConfiguration$CompilerSettings";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lang";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/ndk/ModuleResolveConfiguration$CompilerSettings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompiler";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompilerWorkingDir";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnvironment";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompilerSwitches";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompiler";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompilerExecutable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompilerSwitches";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompilerKey";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

