/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoCache;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkCompilerInfoCache {
    @NotNull
    private final CompilerInfoCache myCompilerInfoCache;

    public NdkCompilerInfoCache() {
        this(new CompilerInfoCache());
    }

    @VisibleForTesting
    NdkCompilerInfoCache(@NotNull CompilerInfoCache compilerInfoCache) {
        if (compilerInfoCache == null) {
            NdkCompilerInfoCache.$$$reportNull$$$0(0);
        }
        this.myCompilerInfoCache = compilerInfoCache;
    }

    @Nullable
    public NdkCompilerInfo getCompilerInfo(@NotNull Project project, @NotNull OCCompilerSettings compilerSettings, @NotNull OCLanguageKind lang, @Nullable VirtualFile sourceFile, @NotNull CidrToolEnvironment environment) throws NdkCompilerInvocationException {
        CidrCompilerSwitches switches;
        if (project == null) {
            NdkCompilerInfoCache.$$$reportNull$$$0(1);
        }
        if (compilerSettings == null) {
            NdkCompilerInfoCache.$$$reportNull$$$0(2);
        }
        if (lang == null) {
            NdkCompilerInfoCache.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            NdkCompilerInfoCache.$$$reportNull$$$0(4);
        }
        if ((switches = compilerSettings.getCompilerSwitches(lang, sourceFile)) == null) {
            return null;
        }
        OCCompilerKind compilerKind = compilerSettings.getCompiler(lang);
        if (compilerKind == null) {
            return null;
        }
        File compilerExecutable = compilerSettings.getCompilerExecutable(lang);
        if (compilerExecutable == null) {
            return null;
        }
        CompilerInfoCache.Result compilerResult = this.myCompilerInfoCache.getCompilerInfoCache(lang, switches, compilerKind, compilerExecutable, compilerSettings.getCompilerWorkingDir(), environment);
        CompilerInfo compilerInfo = compilerResult.getInfo();
        if (compilerInfo == null) {
            if (OCWorkspace.getInstance((Project)project).getConfigurationsForFile(sourceFile).isEmpty()) {
                return null;
            }
            String message = "Failed to get the compiler information " + (sourceFile != null ? "for file " + sourceFile.getPath() : "");
            throw new NdkCompilerInvocationException(message, compilerResult.getError());
        }
        return new NdkCompilerInfo(compilerInfo, compilerResult.getKey());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerInfoCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/ndk/NdkCompilerInfoCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompilerInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class NdkCompilerInvocationException
    extends Exception {
        private NdkCompilerInvocationException(@NotNull String message, @Nullable Throwable cause) {
            if (message == null) {
                NdkCompilerInvocationException.$$$reportNull$$$0(0);
            }
            super(message, cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/ndk/NdkCompilerInfoCache$NdkCompilerInvocationException", "<init>"));
        }
    }

    public static class NdkCompilerInfo {
        @NotNull
        private final CompilerInfo myInfo;
        @NotNull
        private final CompilerSettingsKey myCompilerKey;

        private NdkCompilerInfo(@NotNull CompilerInfo info, @NotNull CompilerSettingsKey key) {
            if (info == null) {
                NdkCompilerInfo.$$$reportNull$$$0(0);
            }
            if (key == null) {
                NdkCompilerInfo.$$$reportNull$$$0(1);
            }
            this.myInfo = info;
            this.myCompilerKey = key;
        }

        @NotNull
        public String getDefines() {
            String string = this.myInfo.getDefines();
            if (string == null) {
                NdkCompilerInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Map<OCCompilerFeatures.Type<?>, ?> getFeatures() {
            Map map = this.myInfo.getFeatures();
            if (map == null) {
                NdkCompilerInfo.$$$reportNull$$$0(3);
            }
            return map;
        }

        @NotNull
        public List<HeadersSearchPath> getHeaderSearchPaths() {
            List list = this.myInfo.getHeadersSearchPaths();
            if (list == null) {
                NdkCompilerInfo.$$$reportNull$$$0(4);
            }
            return list;
        }

        @VisibleForTesting
        @NotNull
        CompilerInfo getInfo() {
            CompilerInfo compilerInfo = this.myInfo;
            if (compilerInfo == null) {
                NdkCompilerInfo.$$$reportNull$$$0(5);
            }
            return compilerInfo;
        }

        @NotNull
        public CompilerSettingsKey getCompilerKey() {
            CompilerSettingsKey compilerSettingsKey = this.myCompilerKey;
            if (compilerSettingsKey == null) {
                NdkCompilerInfo.$$$reportNull$$$0(6);
            }
            return compilerSettingsKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/ndk/NdkCompilerInfoCache$NdkCompilerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/ndk/NdkCompilerInfoCache$NdkCompilerInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefines";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFeatures";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeaderSearchPaths";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompilerKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

