/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.project.NdkProjectInfo;
import com.android.tools.ndk.GradleWorkspace;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.util.graph.Graph;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkHelper {
    @NotNull
    public static String getArchitectureId(@NotNull Abi abi) {
        if (abi == null) {
            NdkHelper.$$$reportNull$$$0(0);
        }
        switch (abi) {
            case ARMEABI_V7A: 
            case ARMEABI: 
            case ARM64_V8A: {
                String string = ArchitectureType.ARM.getId();
                if (string == null) {
                    NdkHelper.$$$reportNull$$$0(1);
                }
                return string;
            }
            case X86_64: {
                String string = ArchitectureType.X86_64.getId();
                if (string == null) {
                    NdkHelper.$$$reportNull$$$0(2);
                }
                return string;
            }
            case X86: {
                String string = ArchitectureType.I386.getId();
                if (string == null) {
                    NdkHelper.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        String string = ArchitectureType.UNKNOWN.getId();
        if (string == null) {
            NdkHelper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static Abi getAbi(@NotNull IDevice targetDevice) {
        if (targetDevice == null) {
            NdkHelper.$$$reportNull$$$0(5);
        }
        List abis = targetDevice.getAbis();
        for (String a : abis) {
            Abi abi = Abi.getEnum((String)a);
            if (abi == null) continue;
            Abi abi2 = abi;
            if (abi2 == null) {
                NdkHelper.$$$reportNull$$$0(6);
            }
            return abi2;
        }
        Abi abi = Abi.ARMEABI_V7A;
        if (abi == null) {
            NdkHelper.$$$reportNull$$$0(7);
        }
        return abi;
    }

    @NotNull
    private static String getHostPlatformString() {
        String platformString;
        if (SystemInfo.isLinux) {
            platformString = "linux";
        } else if (SystemInfo.isWindows) {
            platformString = "windows";
        } else if (SystemInfo.isMac) {
            platformString = "darwin";
        } else {
            if ("UNKNOWN" == null) {
                NdkHelper.$$$reportNull$$$0(8);
            }
            return "UNKNOWN";
        }
        platformString = platformString + "-";
        if (SystemInfo.is64Bit) {
            platformString = platformString + "x86_64";
        } else if (SystemInfo.is32Bit) {
            platformString = platformString + "x86";
        } else {
            if ("UNKNOWN" == null) {
                NdkHelper.$$$reportNull$$$0(9);
            }
            return "UNKNOWN";
        }
        String string = platformString;
        if (string == null) {
            NdkHelper.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static File getLibStdCxxPrintersPath(@NotNull File ndkRoot, @NotNull String gccVersion) {
        if (ndkRoot == null) {
            NdkHelper.$$$reportNull$$$0(11);
        }
        if (gccVersion == null) {
            NdkHelper.$$$reportNull$$$0(12);
        }
        File prebuilt = new File(ndkRoot, "prebuilt");
        File hostPlatform = new File(prebuilt, NdkHelper.getHostPlatformString());
        File share = new File(hostPlatform, "share");
        File prettyPrinters = new File(share, "pretty-printers");
        File libStdCxx = new File(prettyPrinters, "libstdcxx");
        File file = new File(libStdCxx, "gcc-" + gccVersion);
        if (file == null) {
            NdkHelper.$$$reportNull$$$0(13);
        }
        return file;
    }

    public static boolean isNdkProject(@NotNull Project project) {
        if (project == null) {
            NdkHelper.$$$reportNull$$$0(14);
        }
        return NdkProjectInfo.get((Project)project).hasNdkModules() || AndroidProjectInfo.getInstance((Project)project).isApkProject();
    }

    public static boolean isNdkDeployment(@NotNull Project project, @Nullable Module debuggeeModule) {
        if (project == null) {
            NdkHelper.$$$reportNull$$$0(15);
        }
        if (debuggeeModule == null) {
            return NdkHelper.isNdkProject(project);
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                NdkHelper.$$$reportNull$$$0(23);
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Graph dependencyGraph = moduleManager.moduleGraph();
            LinkedList<Object> workQueue = new LinkedList<Object>();
            workQueue.add(debuggeeModule);
            while (!workQueue.isEmpty()) {
                Module dependency = (Module)workQueue.remove();
                if (dependency == null) continue;
                if (GradleWorkspace.getInstance(project).isNativeModule(dependency)) {
                    return true;
                }
                Iterator dependencies = dependencyGraph.getOut((Object)dependency);
                while (dependencies.hasNext()) {
                    workQueue.add(dependencies.next());
                }
            }
            return false;
        });
    }

    public static void disableCppLanguageSupport(@NotNull Project project, boolean disable) {
        if (project == null) {
            NdkHelper.$$$reportNull$$$0(16);
        }
        OCLanguage.LANGUAGE_SUPPORT_DISABLED.set((UserDataHolder)project, (Object)disable);
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project == null) {
                NdkHelper.$$$reportNull$$$0(21);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    NdkHelper.$$$reportNull$$$0(22);
                }
                if (project.isDisposed()) {
                    return;
                }
                OCLanguage langToReset = disable ? OCLanguage.getInstance() : PlainTextLanguage.INSTANCE;
                FileManager fileManager = ((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager();
                for (PsiFile file : fileManager.getAllCachedFiles()) {
                    VirtualFile vf;
                    if (file.getLanguage() != langToReset || (vf = OCInclusionContextUtil.getVirtualFile((PsiFile)file)) == null) continue;
                    fileManager.setViewProvider(vf, null);
                }
            });
        });
    }

    @NotNull
    public static String getNdkVersion(@NotNull File ndkRoot) throws ExecutionException {
        File sourcePropertiesFile;
        if (ndkRoot == null) {
            NdkHelper.$$$reportNull$$$0(17);
        }
        if ((sourcePropertiesFile = new File(ndkRoot, "source.properties")).exists()) {
            String string;
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(sourcePropertiesFile);
                Properties props = new Properties();
                props.load(fileInput);
                String string2 = props.getProperty("Pkg.Revision");
                string = string2;
            }
            catch (Exception e) {
                throw new ExecutionException((Throwable)e);
            }
            finally {
                if (fileInput != null) {
                    try {
                        ((InputStream)fileInput).close();
                    }
                    catch (IOException e) {
                        Logger.getInstance(NdkHelper.class).warn("Failed to close '" + sourcePropertiesFile.getPath() + "'", (Throwable)e);
                    }
                }
            }
            if (string == null) {
                NdkHelper.$$$reportNull$$$0(18);
            }
            return string;
        }
        File releaseTxtFile = new File(ndkRoot, "RELEASE.TXT");
        if (releaseTxtFile.exists()) {
            String string;
            try {
                byte[] content = Files.readAllBytes(releaseTxtFile.toPath());
                string = new String(content).trim();
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            if (string == null) {
                NdkHelper.$$$reportNull$$$0(19);
            }
            return string;
        }
        if ("UNKNOWN" == null) {
            NdkHelper.$$$reportNull$$$0(20);
        }
        return "UNKNOWN";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abi";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/NdkHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDevice";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkRoot";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gccVersion";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/NdkHelper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchitectureId";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbi";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostPlatformString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibStdCxxPrintersPath";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNdkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getArchitectureId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAbi";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLibStdCxxPrintersPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isNdkProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isNdkDeployment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "disableCppLanguageSupport";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNdkVersion";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$disableCppLanguageSupport$2";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isNdkDeployment$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

