/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.cdt.utils.debug.dwarf.DwarfReader;
import org.eclipse.cdt.utils.elf.Elf;
import org.jetbrains.annotations.NotNull;

public class SourceRootsExtractor {
    @NotNull
    public List<String> extractSourceRoots(@NotNull File path) throws IOException {
        if (path == null) {
            SourceRootsExtractor.$$$reportNull$$$0(0);
        }
        HashSet<String> sourceRoots = new HashSet<String>();
        this.doExtractSourceRoots(path, sourceRoots);
        List<String> list = SourceRootsExtractor.mergePaths(sourceRoots);
        if (list == null) {
            SourceRootsExtractor.$$$reportNull$$$0(1);
        }
        return list;
    }

    private void doExtractSourceRoots(@NotNull File path, @NotNull Set<String> sourceRoots) throws IOException {
        if (path == null) {
            SourceRootsExtractor.$$$reportNull$$$0(2);
        }
        if (sourceRoots == null) {
            SourceRootsExtractor.$$$reportNull$$$0(3);
        }
        if (path.isDirectory()) {
            for (File child : FileUtil.notNullize((File[])path.listFiles())) {
                this.doExtractSourceRoots(child, sourceRoots);
            }
        } else {
            sourceRoots.addAll(this.extractSourceRootsFromFile(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<String> extractSourceRootsFromFile(@NotNull File filePath) throws IOException {
        if (filePath == null) {
            SourceRootsExtractor.$$$reportNull$$$0(4);
        }
        if (!filePath.exists() || !"so".equals(FileUtilRt.getExtension((String)filePath.getName()))) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                SourceRootsExtractor.$$$reportNull$$$0(5);
            }
            return list;
        }
        Elf elf = new Elf(filePath.getPath());
        Elf.Section debugInfo = elf.getSectionByName(".debug_info");
        if (debugInfo == null) {
            SourceRootsExtractor.getLog().info("No debug info in the ELF lib");
            List<String> list = Collections.emptyList();
            List<String> list2 = list;
            if (list2 == null) {
                SourceRootsExtractor.$$$reportNull$$$0(6);
            }
            return list2;
        }
        DwarfReader reader = new DwarfReader(elf);
        String[] sourceFilePaths = reader.getSourceFiles();
        if (sourceFilePaths == null) {
            SourceRootsExtractor.getLog().info("No source files can be found in ELF lib");
            List<String> list = Collections.emptyList();
            List<String> list3 = list;
            if (list3 == null) {
                SourceRootsExtractor.$$$reportNull$$$0(7);
            }
            return list3;
        }
        List<String> list = SourceRootsExtractor.computeRootPathsForFiles(Arrays.stream(sourceFilePaths));
        List<String> list4 = list;
        if (list4 == null) {
            SourceRootsExtractor.$$$reportNull$$$0(8);
        }
        return list4;
        finally {
            elf.dispose();
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(SourceRootsExtractor.class);
        if (logger == null) {
            SourceRootsExtractor.$$$reportNull$$$0(9);
        }
        return logger;
    }

    @NotNull
    static List<String> computeRootPathsForFiles(@NotNull Stream<String> filePaths) {
        if (filePaths == null) {
            SourceRootsExtractor.$$$reportNull$$$0(10);
        }
        ArrayList<String> folderPaths = new ArrayList<String>();
        filePaths.forEach(filePath -> {
            String parentPath = PathUtil.getParentPath((String)filePath);
            folderPaths.add(parentPath);
        });
        List<String> list = SourceRootsExtractor.mergePaths(folderPaths);
        if (list == null) {
            SourceRootsExtractor.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static List<String> mergePaths(@NotNull Collection<String> paths) {
        if (paths == null) {
            SourceRootsExtractor.$$$reportNull$$$0(12);
        }
        if (paths.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                SourceRootsExtractor.$$$reportNull$$$0(13);
            }
            return list;
        }
        TreeSet<String> sortedPaths = new TreeSet<String>(paths);
        ArrayList<String> result = new ArrayList<String>(paths.size());
        String current = (String)sortedPaths.first();
        for (String folder : sortedPaths) {
            if (folder.startsWith(current)) continue;
            result.add(current);
            current = folder;
        }
        result.add(current);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            SourceRootsExtractor.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/SourceRootsExtractor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/SourceRootsExtractor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSourceRoots";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSourceRootsFromFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootPathsForFiles";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "mergePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractSourceRoots";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doExtractSourceRoots";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractSourceRootsFromFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeRootPathsForFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mergePaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

