/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.cmake;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.ndk.cmake.CMakePreHighlightingVisitor;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.CMakeEditingEvent;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.cpp.cmake.CMakeListsFileType;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0001H\u0016J\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/ndk/cmake/CMakePostHighlightingVisitor;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "analyze", "", "file", "Lcom/intellij/psi/PsiFile;", "updateWholeFile", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "action", "Ljava/lang/Runnable;", "clone", "getStartTime", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Long;", "order", "", "suitableForFile", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "android-ndk"})
public final class CMakePostHighlightingVisitor
implements HighlightVisitor {
    private final Logger LOG = Logger.getInstance(CMakePostHighlightingVisitor.class);

    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return FileTypeManager.getInstance().isFileOfType(file.getVirtualFile(), CMakeListsFileType.INSTANCE);
    }

    public void visit(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
    }

    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        if (this.suitableForFile(file)) {
            Project project = file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            Long startTime = this.getStartTime(project);
            if (startTime != null) {
                long duration = System.currentTimeMillis() - startTime;
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CMAKE_EDITING_EVENT).setCmakeEditingEvent(CMakeEditingEvent.newBuilder().setEventDurationMs(duration).setKind(CMakeEditingEvent.CMakeEditingEventKind.SYNTAX_HIGHLIGHTING)));
                this.LOG.info("CMake syntax highlighting completed in " + duration + "ms");
            }
        }
        action.run();
        return true;
    }

    @NotNull
    public HighlightVisitor clone() {
        return new CMakePostHighlightingVisitor();
    }

    @Deprecated(message="Deprecated in interface")
    public int order() {
        return 1;
    }

    private final Long getStartTime(Project project) {
        for (HighlightVisitor visitor : (HighlightVisitor[])Extensions.getExtensions((ExtensionPointName)HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)((AreaInstance)project))) {
            if (!(visitor instanceof CMakePreHighlightingVisitor)) continue;
            return (Long)((CMakePreHighlightingVisitor)visitor).getMyStartTime().get();
        }
        return null;
    }
}

