/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniUtilsKt;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/ndk/jni/JniFunctionExternInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "android-ndk"})
public final class JniFunctionExternInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new PsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@Nullable PsiElement element) {
                if (!(element instanceof OCFunctionDeclaration) || !JniUtilsKt.isJniFunction((OCFunctionDeclaration)element)) {
                    return;
                }
                OCLanguageKind oCLanguageKind = OCLanguageKindCalculator.calculateLanguageKind((OCFile)((OCFunctionDeclaration)element).getContainingOCFile());
                Intrinsics.checkExpressionValueIsNotNull((Object)oCLanguageKind, (String)"OCLanguageKindCalculator\u2026element.containingOCFile)");
                if (oCLanguageKind.isCpp()) {
                    ASTNode aSTNode = ((OCFunctionDeclaration)element).getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
                    ASTNode aSTNode2 = aSTNode.getTreeParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"element.node.treeParent");
                    if (Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)OCElementTypes.CPP_EXTERN_BLOCK) ^ true) {
                        PsiElement psiElement = ((OCFunctionDeclaration)element).getNameIdentifier();
                        if (psiElement == null) {
                            psiElement = element;
                        }
                        this.$holder.registerProblem(psiElement, "<html><body>This JNI function call may be using an incorrect linkage. To make sure the C++ compiler uses unmodified names when calling functions in your C code, list your C functions in your C++ code using <tt>extern \"C\"</tt>.</body></html>", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new LocalQuickFix(){

                            @NotNull
                            public String getFamilyName() {
                                return "Add extern \"C\"";
                            }

                            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                                Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                                OCFunctionDeclaration oCFunctionDeclaration = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), OCFunctionDeclaration.class);
                                if (oCFunctionDeclaration == null) {
                                    return;
                                }
                                PsiElement elementToFix = (PsiElement)oCFunctionDeclaration;
                                if (elementToFix.getPrevSibling() instanceof OCMacroCall) {
                                    PsiElement psiElement = elementToFix.getPrevSibling();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"elementToFix.prevSibling");
                                    elementToFix = psiElement;
                                }
                                PsiFile psiFile = elementToFix.getContainingFile();
                                TextRange textRange = elementToFix.getTextRange();
                                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"elementToFix.textRange");
                                OCChangeUtil.changeText((Project)project, (PsiFile)psiFile, (int)textRange.getStartOffset(), (int)0, (String)" extern \"C\" ", (boolean)true);
                            }
                        }});
                    }
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

