/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniNameMangler;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        return JniGotoDeclarationHandler.getGotoDeclarationTargets(sourceElement);
    }

    @Nullable
    public static PsiElement[] getGotoDeclarationTargets(@NotNull PsiMethod method, @NotNull Project project) {
        if (method == null) {
            JniGotoDeclarationHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JniGotoDeclarationHandler.$$$reportNull$$$0(1);
        }
        return JniGotoDeclarationHandler.findNativeDeclarationTargets(method, project);
    }

    @Nullable
    public static PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement) {
        PsiMethod method = JniGotoDeclarationHandler.elementToMethod(sourceElement);
        if (method == null) {
            return null;
        }
        PsiFile file = method.getContainingFile();
        if (file == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        Project project = facet.getModule().getProject();
        return JniGotoDeclarationHandler.getGotoDeclarationTargets(method, project);
    }

    @Nullable
    private static PsiMethod elementToMethod(@Nullable PsiElement sourceElement) {
        if (sourceElement == null) {
            return null;
        }
        if (sourceElement instanceof PsiIdentifier) {
            return JniGotoDeclarationHandler.getMethod((PsiIdentifier)sourceElement);
        }
        if (sourceElement instanceof PsiKeyword) {
            PsiKeyword keyword = (PsiKeyword)sourceElement;
            if (keyword.getTokenType() == JavaTokenType.NATIVE_KEYWORD) {
                return JniGotoDeclarationHandler.getMethod(keyword);
            }
        } else if (sourceElement instanceof PsiMethod) {
            return (PsiMethod)sourceElement;
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethod(PsiKeyword nativeKeyword) {
        assert (nativeKeyword.getTokenType() == JavaTokenType.NATIVE_KEYWORD) : nativeKeyword;
        if (nativeKeyword.getParent() instanceof PsiModifierList && nativeKeyword.getParent().getParent() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)nativeKeyword.getParent().getParent();
            return method;
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethod(PsiIdentifier identifier) {
        PsiMethod method;
        if (identifier.getParent() instanceof PsiMethod && (method = (PsiMethod)identifier.getParent()).getModifierList().hasExplicitModifier("native")) {
            return method;
        }
        return null;
    }

    @Nullable
    private static PsiElement[] findNativeDeclarationTargets(PsiMethod method, @NotNull Project project) {
        if (project == null) {
            JniGotoDeclarationHandler.$$$reportNull$$$0(2);
        }
        ArrayList elements = Lists.newArrayList();
        int numArgs = method.getParameterList().getParametersCount();
        Processor processor = symbol -> {
            if (project == null) {
                JniGotoDeclarationHandler.$$$reportNull$$$0(3);
            }
            if (symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION) {
                List parameterTypes = ((OCFunctionType)symbol.getType()).getParameterTypes();
                int symbolNumArgs = parameterTypes.size();
                PsiElement definition = symbol.locateDefinition(project);
                if (definition != null && symbolNumArgs == numArgs + 2 && JniGotoDeclarationHandler.parameterTypesCorrect(method, parameterTypes) && JniGotoDeclarationHandler.returnTypeCorrect(method, ((OCFunctionType)symbol.getType()).getReturnType())) {
                    elements.add(definition);
                }
            }
            return true;
        };
        String signature = JniNameMangler.getJniMethodName(method, false);
        OCGlobalProjectSymbolsCache.processByQualifiedName((Project)project, (Processor)processor, (String)signature);
        if (elements.isEmpty()) {
            signature = JniNameMangler.getJniMethodName(method, true);
            OCGlobalProjectSymbolsCache.processByQualifiedName((Project)project, (Processor)processor, (String)signature);
        }
        return !elements.isEmpty() ? elements.toArray(new PsiElement[elements.size()]) : null;
    }

    private static boolean parameterTypesCorrect(PsiMethod method, List<OCType> parameterTypes) {
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)method);
        PsiParameter[] methodParameters = method.getParameterList().getParameters();
        Iterator<OCType> it = parameterTypes.iterator();
        OCType type = it.next();
        if (!type.isPointer() || !type.getCanonicalName(context).equals("JNIEnv *")) {
            return false;
        }
        type = it.next();
        if (!type.getCanonicalName(context).equals("jclass") && !type.getCanonicalName(context).equals("jobject")) {
            return false;
        }
        for (PsiParameter methodParameter : methodParameters) {
            type = it.next();
            if (JniNameMangler.getJniType(methodParameter.getType()).equals(type.getName())) continue;
            return false;
        }
        return true;
    }

    private static boolean returnTypeCorrect(PsiMethod method, OCType returnType) {
        PsiType type = method.getReturnType();
        if (type == null) {
            return false;
        }
        return JniNameMangler.getJniType(type).equals(returnType.getName());
    }

    @Nullable
    public String getActionText(DataContext context) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/ndk/jni/JniGotoDeclarationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGotoDeclarationTargets";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findNativeDeclarationTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findNativeDeclarationTargets$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

