/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.JniGotoDeclarationHandler;
import com.android.tools.ndk.jni.JniNameMangler;
import com.android.tools.ndk.jni.JniUtilsKt;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.PsiNavigateUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniMissingFunctionInspection
extends LocalInspectionTool {
    private static final String REGISTER_NATIVES = "RegisterNatives";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JniMissingFunctionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JniMissingFunctionInspection.$$$reportNull$$$0(1);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                if (!method.hasModifierProperty("native")) {
                    return;
                }
                PsiElement[] targets = JniGotoDeclarationHandler.getGotoDeclarationTargets((PsiElement)method);
                if (targets != null && targets.length > 0) {
                    return;
                }
                Project project = holder.getProject();
                if (JniMissingFunctionInspection.projectUsesRegisterNatives(project)) {
                    return;
                }
                String jniMethodName = JniNameMangler.getJniMethodName(method);
                String message = String.format("Cannot resolve corresponding JNI function %1$s", jniMethodName);
                LocalQuickFix[] fixes = new LocalQuickFix[]{new CreateJniFunctionFix(method, jniMethodName)};
                if (!NdkHelper.isNdkProject(project)) {
                    fixes = LocalQuickFix.EMPTY_ARRAY;
                }
                holder.registerProblem((PsiElement)(method.getNameIdentifier() != null ? method.getNameIdentifier() : method), message, ProblemHighlightType.ERROR, fixes);
            }
        };
        if (javaElementVisitor == null) {
            JniMissingFunctionInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static boolean projectUsesRegisterNatives(Project project) {
        Ref registersNatives = new Ref((Object)false);
        OCGlobalProjectSymbolsCache.processByQualifiedName((Project)project, symbol -> {
            PsiElement definition;
            if (symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
                PsiElement definition2;
                OCFile containingOCFile = symbol.getContainingOCFile(project);
                if (containingOCFile != null && (symbol = containingOCFile.findSymbol(REGISTER_NATIVES, OCSymbolWithQualifiedName.class)) != null && (definition2 = symbol.locateDefinition(project)) != null) {
                    GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)definition2.getProject());
                    Collection all = ReferencesSearch.search((PsiElement)definition2.getParent(), (SearchScope)scope).findAll();
                    if (!all.isEmpty()) {
                        registersNatives.set((Object)true);
                    }
                }
            } else if ((symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION) && (definition = symbol.locateDefinition(project)) != null) {
                GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)definition.getProject());
                Collection all = ReferencesSearch.search((PsiElement)definition.getParent(), (SearchScope)scope).findAll();
                if (!all.isEmpty()) {
                    registersNatives.set((Object)true);
                }
            }
            return true;
        }, (String)REGISTER_NATIVES);
        return (Boolean)registersNatives.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/jni/JniMissingFunctionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/jni/JniMissingFunctionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CreateJniFunctionFix
    implements LocalQuickFix {
        protected final SmartPsiElementPointer<PsiMethod> myMethod;
        private final String myMethodName;

        public CreateJniFunctionFix(PsiMethod method, String methodName) {
            this.myMethod = SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)method);
            this.myMethodName = methodName;
        }

        @NotNull
        public String getName() {
            String string = String.format("Create function %1$s", this.myMethodName);
            if (string == null) {
                CreateJniFunctionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Create JNI function" == null) {
                CreateJniFunctionFix.$$$reportNull$$$0(1);
            }
            return "Create JNI function";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            OCFile file;
            if (project == null) {
                CreateJniFunctionFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreateJniFunctionFix.$$$reportNull$$$0(3);
            }
            if ((file = this.findJniTargetFile(project)) == null) {
                Logger.getInstance(JniMissingFunctionInspection.class).warn("Can't create JNI file");
                return;
            }
            OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind((OCFile)file);
            this.createMethod(project, file, kind == OCLanguageKind.CPP, true);
        }

        private void createMethod(@NotNull Project project, @NotNull OCFile file, boolean cpp, boolean insertConversions) {
            PsiMethod method;
            if (project == null) {
                CreateJniFunctionFix.$$$reportNull$$$0(4);
            }
            if (file == null) {
                CreateJniFunctionFix.$$$reportNull$$$0(5);
            }
            if ((method = (PsiMethod)this.myMethod.getElement()) == null) {
                return;
            }
            String text = JniUtilsKt.createMethodDeclarationCode(method, this.myMethodName, cpp, insertConversions);
            PsiElement declaration = OCElementFactory.topLevelDeclarationFromText((String)text, (PsiElement)file, (boolean)true);
            PsiElement added = OCChangeUtil.add((PsiElement)file, (PsiElement)declaration);
            OCChangeUtil.reformatTextIfNotInjected((PsiFile)file, (int)added.getTextOffset(), (int)(added.getTextOffset() + added.getTextLength()));
            Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)added, PsiComment.class);
            if (!comments.isEmpty()) {
                PsiComment firstComment = (PsiComment)comments.iterator().next();
                PsiNavigateUtil.navigate((PsiElement)firstComment);
                TextRange textRange = firstComment.getTextRange();
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                if (editor != null) {
                    editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                }
            } else {
                Collection functions = PsiTreeUtil.findChildrenOfType((PsiElement)added, OCFunctionDeclaration.class);
                if (!functions.isEmpty()) {
                    OCFunctionDeclaration first = (OCFunctionDeclaration)functions.iterator().next();
                    PsiNavigateUtil.navigate((PsiElement)first);
                } else {
                    PsiNavigateUtil.navigate((PsiElement)added);
                }
            }
        }

        @Nullable
        private OCFile findJniTargetFile(Project project) {
            OCFile existing = CreateJniFunctionFix.findFileWithJniFunctions(project);
            if (existing != null) {
                return existing;
            }
            return this.createNewTargetFile(project);
        }

        @Nullable
        private AndroidFacet pickModule() {
            AndroidFacet facet;
            PsiMethod method = (PsiMethod)this.myMethod.getElement();
            if (method == null) {
                return null;
            }
            Module module = AndroidPsiUtils.getModuleSafely((PsiElement)method);
            if (module != null && (facet = AndroidFacet.getInstance((Module)module)) != null) {
                return facet;
            }
            for (Module m : ModuleManager.getInstance((Project)method.getProject()).getModules()) {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)m);
                if (facet2 == null) continue;
                return facet2;
            }
            return null;
        }

        @Nullable
        private OCFile createNewTargetFile(@NotNull Project project) {
            PsiFile file;
            SourceProvider provider;
            Collection cDirectories;
            AndroidFacet facet;
            if (project == null) {
                CreateJniFunctionFix.$$$reportNull$$$0(6);
            }
            if ((facet = this.pickModule()) == null) {
                return null;
            }
            VirtualFile dir = null;
            PsiDirectory psiDirectory = null;
            if (((AndroidFacetConfiguration)facet.getConfiguration()).getModel() != null && !(cDirectories = (provider = facet.getMainSourceProvider()).getCDirectories()).isEmpty()) {
                File dirFile = (File)cDirectories.iterator().next();
                dir = LocalFileSystem.getInstance().findFileByIoFile(dirFile);
                if (dir == null) {
                    psiDirectory = DirectoryUtil.mkdirs((PsiManager)PsiManager.getInstance((Project)project), (String)FileUtil.toSystemIndependentName((String)dirFile.getPath()));
                    if (psiDirectory != null) {
                        dir = psiDirectory.getVirtualFile();
                    }
                } else {
                    psiDirectory = PsiManager.getInstance((Project)project).findDirectory(dir);
                }
            }
            if (dir == null || psiDirectory == null) {
                return null;
            }
            String fileName = this.pickFilename();
            VirtualFile newFile = dir.findChild(fileName);
            if (newFile == null) {
                OCNewFileHelperUtil.addCreatedFiles((PsiDirectory)psiDirectory, (String[])new String[]{fileName}, (PsiFile[])new PsiFile[]{null}, (Project)project, (Function)Function.NULL);
                newFile = dir.findChild(fileName);
                if (newFile == null) {
                    return null;
                }
                try {
                    VfsUtil.saveText((VirtualFile)newFile, (String)"#include <jni.h>\n");
                }
                catch (IOException ioe) {
                    Logger.getInstance(JniMissingFunctionInspection.class).error((Throwable)ioe);
                    return null;
                }
            }
            if ((file = PsiManager.getInstance((Project)project).findFile(newFile)) instanceof OCFile) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = documentManager.getDocument(file);
                if (document != null) {
                    documentManager.commitDocument(document);
                }
                return (OCFile)file;
            }
            return null;
        }

        @NotNull
        private String pickFilename() {
            PsiClass cls;
            PsiMethod method;
            PsiFile containingFile = this.myMethod.getContainingFile();
            if (containingFile != null) {
                for (PsiMethodCallExpression expression : PsiTreeUtil.findChildrenOfType((PsiElement)containingFile, PsiMethodCallExpression.class)) {
                    PsiLiteralExpression literal;
                    Object value;
                    PsiExpression[] argumentList;
                    String qualifiedName;
                    PsiMethod method2;
                    PsiClass cls2;
                    PsiElement resolved;
                    PsiReferenceExpression methodExpression = expression.getMethodExpression();
                    String referenceName = methodExpression.getReferenceName();
                    if (!"loadLibrary".equals(referenceName) || (resolved = methodExpression.resolve()) instanceof PsiMethod && (cls2 = (method2 = (PsiMethod)resolved).getContainingClass()) != null && (qualifiedName = cls2.getQualifiedName()) != null && !qualifiedName.equals("java.lang.System") || (argumentList = expression.getArgumentList().getExpressions()).length != 1 || !(argumentList[0] instanceof PsiLiteralExpression) || !((value = (literal = (PsiLiteralExpression)argumentList[0]).getValue()) instanceof String)) continue;
                    String name = (String)value;
                    StringBuilder sb = new StringBuilder();
                    int n = name.length();
                    for (int i = 0; i < n; ++i) {
                        char c = name.charAt(i);
                        if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_' && c != '-') continue;
                        sb.append(c);
                    }
                    if (sb.length() <= 0) continue;
                    sb.append(".c");
                    String string = sb.toString();
                    if (string == null) {
                        CreateJniFunctionFix.$$$reportNull$$$0(7);
                    }
                    return string;
                }
            }
            if ((method = (PsiMethod)this.myMethod.getElement()) != null && (cls = method.getContainingClass()) != null && cls.getName() != null) {
                String string = cls.getName().toLowerCase(Locale.US) + ".c";
                if (string == null) {
                    CreateJniFunctionFix.$$$reportNull$$$0(8);
                }
                return string;
            }
            if ("jni.c" == null) {
                CreateJniFunctionFix.$$$reportNull$$$0(9);
            }
            return "jni.c";
        }

        @Nullable
        private static OCFile findFileWithJniFunctions(@NotNull Project project) {
            if (project == null) {
                CreateJniFunctionFix.$$$reportNull$$$0(10);
            }
            Ref ref = new Ref();
            for (String symbol : OCGlobalProjectSymbolsCache.getAllSymbolNames((Project)project)) {
                if (!symbol.startsWith("Java_")) continue;
                Processor processor = symbol1 -> {
                    OCFile containing;
                    if (project == null) {
                        CreateJniFunctionFix.$$$reportNull$$$0(11);
                    }
                    if ((symbol1.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol1.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION) && (containing = symbol1.getContainingOCFile(project)) != null) {
                        ref.set((Object)containing);
                        return false;
                    }
                    return true;
                };
                OCGlobalProjectSymbolsCache.processTopLevelSymbols((Project)project, (Processor)processor, (String)symbol);
                OCFile file = (OCFile)ref.get();
                if (file == null) continue;
                return file;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/ndk/jni/JniMissingFunctionInspection$CreateJniFunctionFix";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/ndk/jni/JniMissingFunctionInspection$CreateJniFunctionFix";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pickFilename";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createMethod";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewTargetFile";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findFileWithJniFunctions";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$findFileWithJniFunctions$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

