/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniNameMangler {
    @Nullable
    public static PsiMethod findDeclaration(@NotNull Project project, @NotNull String jniMethodName) {
        PsiMethod[] methods;
        int methodEnd;
        int methodBegin;
        int classBegin;
        if (project == null) {
            JniNameMangler.$$$reportNull$$$0(0);
        }
        if (jniMethodName == null) {
            JniNameMangler.$$$reportNull$$$0(1);
        }
        if (!jniMethodName.startsWith("Java_")) {
            return null;
        }
        jniMethodName = jniMethodName.replaceAll("_00024", "_");
        int pkgStart = "Java_".length();
        int length = jniMethodName.length();
        boolean lastWasUnderscore = false;
        for (classBegin = pkgStart; classBegin < length; ++classBegin) {
            char c = jniMethodName.charAt(classBegin);
            if (c == '_') {
                lastWasUnderscore = true;
                continue;
            }
            if (Character.isUpperCase(c) && lastWasUnderscore) break;
            lastWasUnderscore = false;
        }
        if ((methodBegin = jniMethodName.indexOf(95, classBegin) + 1) == 0) {
            return null;
        }
        lastWasUnderscore = true;
        while (methodBegin < length) {
            char c = jniMethodName.charAt(methodBegin);
            if (c == '_') {
                lastWasUnderscore = true;
            } else {
                if (Character.isLowerCase(c) && lastWasUnderscore) break;
                lastWasUnderscore = false;
            }
            ++methodBegin;
        }
        if ((methodEnd = jniMethodName.indexOf("__", methodBegin)) == -1) {
            methodEnd = length;
        }
        String pkg = classBegin > pkgStart ? JniNameMangler.jniDecodeUnderscore(jniMethodName.substring(pkgStart, classBegin - 1), true) : null;
        String cls = JniNameMangler.jniDecodeUnderscore(jniMethodName.substring(classBegin, methodBegin - 1), false);
        String methodName = JniNameMangler.jniDecodeUnderscore(jniMethodName.substring(methodBegin, methodEnd), false);
        String fqn = pkg != null ? pkg + '.' + cls : cls;
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass psiClass = psiFacade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
        if (psiClass == null) {
            cls = cls.replace('_', '.');
            fqn = pkg != null ? pkg + '.' + cls : cls;
            psiClass = psiFacade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
            if (psiClass == null) {
                return null;
            }
        }
        if ((methods = psiClass.findMethodsByName(methodName, false)).length == 1) {
            return methods[0];
        }
        ArrayList nativeMethods = Lists.newArrayListWithExpectedSize((int)methods.length);
        for (PsiMethod method : methods) {
            if (!method.hasModifierProperty("native")) continue;
            nativeMethods.add(method);
        }
        if (nativeMethods.size() == 1) {
            return (PsiMethod)nativeMethods.get(0);
        }
        if (nativeMethods.isEmpty()) {
            return null;
        }
        for (PsiMethod method : nativeMethods) {
            String escaped = JniNameMangler.getJniMethodName(method, true);
            if (!jniMethodName.equals(escaped)) continue;
            return method;
        }
        for (PsiMethod method : nativeMethods) {
            String escaped = JniNameMangler.getJniMethodName(method, false);
            if (!jniMethodName.equals(escaped)) continue;
            return method;
        }
        return (PsiMethod)nativeMethods.get(0);
    }

    static PsiMethod findDeclaration(@NotNull OCDeclarator element) {
        String jniMethodName;
        if (element == null) {
            JniNameMangler.$$$reportNull$$$0(2);
        }
        if ((jniMethodName = element.getName()) != null) {
            return JniNameMangler.findDeclaration(element.getProject(), jniMethodName);
        }
        return null;
    }

    @NotNull
    public static String getJniMethodName(@NotNull PsiMethod method) {
        if (method == null) {
            JniNameMangler.$$$reportNull$$$0(3);
        }
        boolean overloaded = JniNameMangler.isOverloaded(method);
        String string = JniNameMangler.getJniMethodName(method, overloaded);
        if (string == null) {
            JniNameMangler.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isOverloaded(@NotNull PsiMethod method) {
        PsiClass containingClass;
        if (method == null) {
            JniNameMangler.$$$reportNull$$$0(5);
        }
        return (containingClass = method.getContainingClass()) != null && containingClass.findMethodsByName(method.getName(), false).length > 1;
    }

    @NotNull
    public static String getJniMethodName(@NotNull PsiMethod method, boolean overloaded) {
        if (method == null) {
            JniNameMangler.$$$reportNull$$$0(6);
        }
        String string = JniNameMangler.getJniMethodName(JniNameMangler.getJniClassName(method.getContainingClass()), method.getName(), method.getParameterList().getParameters(), overloaded);
        if (string == null) {
            JniNameMangler.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getJniMethodName(String jniClassName, String name, PsiParameter[] parameters, boolean overloaded) {
        StringBuilder sb = new StringBuilder();
        sb.append("Java_");
        sb.append(jniClassName);
        sb.append('_');
        sb.append(JniNameMangler.jniEncodeUnderscore(name, false));
        if (overloaded) {
            sb.append('_').append('_');
            for (PsiParameter parameter : parameters) {
                PsiType type = parameter.getType();
                if (ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                    type = TypeConversionUtil.erasure((PsiType)type);
                }
                String internal = JniNameMangler.getJvmType(type);
                sb.append(JniNameMangler.jniEscape(internal));
            }
        }
        String string = sb.toString();
        if (string == null) {
            JniNameMangler.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getJniClassName(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            if ("" == null) {
                JniNameMangler.$$$reportNull$$$0(9);
            }
            return "";
        }
        PsiClass containingClass = psiClass.getContainingClass();
        if (containingClass != null) {
            StringBuilder stringBuilder = new StringBuilder();
            JniNameMangler.getJniClassName(psiClass, stringBuilder);
            String string = stringBuilder.toString();
            if (string == null) {
                JniNameMangler.$$$reportNull$$$0(10);
            }
            return string;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName != null) {
            String string = JniNameMangler.jniEncodeUnderscore(qualifiedName, true);
            if (string == null) {
                JniNameMangler.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = JniNameMangler.jniEncodeUnderscore(psiClass.getName(), false);
        if (string == null) {
            JniNameMangler.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void getJniClassName(@NotNull PsiClass psiClass, @NotNull StringBuilder stringBuilder) {
        PsiClass containingClass;
        if (psiClass == null) {
            JniNameMangler.$$$reportNull$$$0(13);
        }
        if (stringBuilder == null) {
            JniNameMangler.$$$reportNull$$$0(14);
        }
        if ((containingClass = psiClass.getContainingClass()) != null) {
            JniNameMangler.getJniClassName(containingClass, stringBuilder);
            stringBuilder.append("_00024");
            stringBuilder.append(JniNameMangler.jniEncodeUnderscore(psiClass.getName(), false));
            return;
        }
        stringBuilder.append(JniNameMangler.getJniClassName(psiClass));
    }

    public static String jniEncodeUnderscore(@NotNull String javaName, boolean isPackageName) {
        if (javaName == null) {
            JniNameMangler.$$$reportNull$$$0(15);
        }
        if (isPackageName) {
            return javaName.replaceAll("_", "_1").replace('.', '_');
        }
        return javaName.replaceAll("_", "_1");
    }

    private static String jniDecodeUnderscore(@NotNull String nativeName, boolean isPackageName) {
        if (nativeName == null) {
            JniNameMangler.$$$reportNull$$$0(16);
        }
        if (isPackageName) {
            return nativeName.replace('_', '.').replaceAll("\\.1", "_");
        }
        return nativeName.replaceAll("_1", "_");
    }

    @NotNull
    public static String getJniType(@NotNull PsiType type) {
        if (type == null) {
            JniNameMangler.$$$reportNull$$$0(17);
        }
        if (PsiType.VOID.equals((Object)type)) {
            if ("void" == null) {
                JniNameMangler.$$$reportNull$$$0(18);
            }
            return "void";
        }
        if (PsiType.BOOLEAN.equals((Object)type)) {
            if ("jboolean" == null) {
                JniNameMangler.$$$reportNull$$$0(19);
            }
            return "jboolean";
        }
        if (PsiType.INT.equals((Object)type)) {
            if ("jint" == null) {
                JniNameMangler.$$$reportNull$$$0(20);
            }
            return "jint";
        }
        if (PsiType.LONG.equals((Object)type)) {
            if ("jlong" == null) {
                JniNameMangler.$$$reportNull$$$0(21);
            }
            return "jlong";
        }
        if (PsiType.FLOAT.equals((Object)type)) {
            if ("jfloat" == null) {
                JniNameMangler.$$$reportNull$$$0(22);
            }
            return "jfloat";
        }
        if (PsiType.DOUBLE.equals((Object)type)) {
            if ("jdouble" == null) {
                JniNameMangler.$$$reportNull$$$0(23);
            }
            return "jdouble";
        }
        if (PsiType.BYTE.equals((Object)type)) {
            if ("jbyte" == null) {
                JniNameMangler.$$$reportNull$$$0(24);
            }
            return "jbyte";
        }
        if (PsiType.CHAR.equals((Object)type)) {
            if ("jchar" == null) {
                JniNameMangler.$$$reportNull$$$0(25);
            }
            return "jchar";
        }
        if (PsiType.SHORT.equals((Object)type)) {
            if ("jshort" == null) {
                JniNameMangler.$$$reportNull$$$0(26);
            }
            return "jshort";
        }
        if (type instanceof PsiArrayType) {
            if (PsiType.BOOLEAN.equals((Object)(type = ((PsiArrayType)type).getComponentType()))) {
                if ("jbooleanArray" == null) {
                    JniNameMangler.$$$reportNull$$$0(27);
                }
                return "jbooleanArray";
            }
            if (PsiType.INT.equals((Object)type)) {
                if ("jintArray" == null) {
                    JniNameMangler.$$$reportNull$$$0(28);
                }
                return "jintArray";
            }
            if (PsiType.LONG.equals((Object)type)) {
                if ("jlongArray" == null) {
                    JniNameMangler.$$$reportNull$$$0(29);
                }
                return "jlongArray";
            }
            if (PsiType.DOUBLE.equals((Object)type)) {
                if ("jdoubleArray" == null) {
                    JniNameMangler.$$$reportNull$$$0(30);
                }
                return "jdoubleArray";
            }
            if (PsiType.CHAR.equals((Object)type)) {
                if ("jcharArray" == null) {
                    JniNameMangler.$$$reportNull$$$0(31);
                }
                return "jcharArray";
            }
            if (PsiType.FLOAT.equals((Object)type)) {
                if ("jfloatArray" == null) {
                    JniNameMangler.$$$reportNull$$$0(32);
                }
                return "jfloatArray";
            }
            if (PsiType.SHORT.equals((Object)type)) {
                if ("jshortArray" == null) {
                    JniNameMangler.$$$reportNull$$$0(33);
                }
                return "jshortArray";
            }
            if (PsiType.BYTE.equals((Object)type)) {
                if ("jbyteArray" == null) {
                    JniNameMangler.$$$reportNull$$$0(34);
                }
                return "jbyteArray";
            }
            if ("jobjectArray" == null) {
                JniNameMangler.$$$reportNull$$$0(35);
            }
            return "jobjectArray";
        }
        if (JniNameMangler.isString(type)) {
            if ("jstring" == null) {
                JniNameMangler.$$$reportNull$$$0(36);
            }
            return "jstring";
        }
        if (JniNameMangler.isClass(type)) {
            if ("jclass" == null) {
                JniNameMangler.$$$reportNull$$$0(37);
            }
            return "jclass";
        }
        if (JniNameMangler.isThrowable(type)) {
            if ("jthrowable" == null) {
                JniNameMangler.$$$reportNull$$$0(38);
            }
            return "jthrowable";
        }
        if ("jobject" == null) {
            JniNameMangler.$$$reportNull$$$0(39);
        }
        return "jobject";
    }

    @Contract(value="null -> false")
    public static boolean isClass(@NotNull PsiType type) {
        if (type == null) {
            JniNameMangler.$$$reportNull$$$0(40);
        }
        return "java.lang.Class".equals(type.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isString(@NotNull PsiType type) {
        String shortName;
        if (type == null) {
            JniNameMangler.$$$reportNull$$$0(41);
        }
        if (type instanceof PsiClassType && !Comparing.equal((String)(shortName = ((PsiClassType)type).getClassName()), (String)"String")) {
            return false;
        }
        return "java.lang.String".equals(type.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isThrowable(@Nullable PsiType type) {
        return type != null && InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Throwable");
    }

    @NotNull
    private static String getJvmType(@NotNull PsiType type) {
        if (type == null) {
            JniNameMangler.$$$reportNull$$$0(42);
        }
        if (PsiType.BOOLEAN.equals((Object)type)) {
            if ("Z" == null) {
                JniNameMangler.$$$reportNull$$$0(43);
            }
            return "Z";
        }
        if (PsiType.BYTE.equals((Object)type)) {
            if ("B" == null) {
                JniNameMangler.$$$reportNull$$$0(44);
            }
            return "B";
        }
        if (PsiType.CHAR.equals((Object)type)) {
            if ("C" == null) {
                JniNameMangler.$$$reportNull$$$0(45);
            }
            return "C";
        }
        if (PsiType.SHORT.equals((Object)type)) {
            if ("S" == null) {
                JniNameMangler.$$$reportNull$$$0(46);
            }
            return "S";
        }
        if (PsiType.INT.equals((Object)type)) {
            if ("I" == null) {
                JniNameMangler.$$$reportNull$$$0(47);
            }
            return "I";
        }
        if (PsiType.LONG.equals((Object)type)) {
            if ("J" == null) {
                JniNameMangler.$$$reportNull$$$0(48);
            }
            return "J";
        }
        if (PsiType.FLOAT.equals((Object)type)) {
            if ("F" == null) {
                JniNameMangler.$$$reportNull$$$0(49);
            }
            return "F";
        }
        if (PsiType.DOUBLE.equals((Object)type)) {
            if ("D" == null) {
                JniNameMangler.$$$reportNull$$$0(50);
            }
            return "D";
        }
        if (PsiType.VOID.equals((Object)type)) {
            if ("V" == null) {
                JniNameMangler.$$$reportNull$$$0(51);
            }
            return "V";
        }
        String string = "L" + type.getCanonicalText().replace('.', '/') + ";";
        if (string == null) {
            JniNameMangler.$$$reportNull$$$0(52);
        }
        return string;
    }

    static String jniEscape(String name) {
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        block6: for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            switch (c) {
                case '.': 
                case '/': {
                    sb.append('_');
                    continue block6;
                }
                case '_': {
                    sb.append('_').append('1');
                    continue block6;
                }
                case ';': {
                    sb.append('_').append('2');
                    continue block6;
                }
                case '[': {
                    sb.append('_').append('3');
                    continue block6;
                }
                default: {
                    sb.append('_').append('0');
                    sb.append((int)c);
                }
            }
        }
        return sb.toString();
    }

    @Nullable
    public static String getRename(@NotNull PsiMethod method, @NotNull String newMangledName) {
        PsiClass clazz;
        if (method == null) {
            JniNameMangler.$$$reportNull$$$0(53);
        }
        if (newMangledName == null) {
            JniNameMangler.$$$reportNull$$$0(54);
        }
        if ((clazz = method.getContainingClass()) == null) {
            return null;
        }
        String qualifiedName = clazz.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        String underscoreName = "Java_" + qualifiedName.replace('.', '_');
        if (!newMangledName.startsWith(underscoreName)) {
            return null;
        }
        int methodEnd = newMangledName.indexOf("__", underscoreName.length());
        if (methodEnd == -1) {
            methodEnd = newMangledName.length();
        }
        return newMangledName.substring(underscoreName.length() + 1, methodEnd);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jniMethodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/jni/JniNameMangler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringBuilder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeName";
                break;
            }
            case 17: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMangledName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/jni/JniNameMangler";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJniMethodName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJniClassName";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getJniType";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaration";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getJniMethodName";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOverloaded";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getJniClassName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "jniEncodeUnderscore";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "jniDecodeUnderscore";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getJniType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isClass";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isString";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getJvmType";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

