/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniNameMangler;
import com.android.tools.ndk.jni.JniParametersInspection;
import com.android.tools.ndk.jni.JniUtilsKt;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/ndk/jni/JniParametersInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "android-ndk"})
public final class JniParametersInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new PsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@Nullable PsiElement element) {
                if (!(element instanceof OCFunctionDeclaration) || !JniUtilsKt.isJniFunction((OCFunctionDeclaration)element)) {
                    return;
                }
                List list = ((OCFunctionDeclaration)element).getParameters();
                if (list == null) {
                    return;
                }
                List parameters = list;
                if (parameters.size() < 2) {
                    OCParameterList oCParameterList = ((OCFunctionDeclaration)element).getParameterList();
                    if (oCParameterList == null) {
                        return;
                    }
                    OCParameterList parameterList = oCParameterList;
                    this.$holder.registerProblem((PsiElement)parameterList, "Not enough parameters", ProblemHighlightType.ERROR, new LocalQuickFix[]{new LocalQuickFix(element, parameterList){
                        final /* synthetic */ PsiElement $element;
                        final /* synthetic */ OCParameterList $parameterList;

                        @NotNull
                        public String getFamilyName() {
                            return "Fix JNI parameters";
                        }

                        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                            PsiMethod method;
                            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                            OCDeclarator oCDeclarator = ((OCFunctionDeclaration)this.$element).getDeclarator();
                            if (oCDeclarator == null) {
                                return;
                            }
                            PsiMethod psiMethod = method = JniNameMangler.findDeclaration(oCDeclarator);
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"method");
                            boolean cpp = Intrinsics.areEqual((Object)psiMethod.getLanguage(), (Object)OCLanguageKind.CPP);
                            String fixedParameterList = JniUtilsKt.createParameterList(method, cpp, false, null, null);
                            ApplicationManager.getApplication().runWriteAction(new Runnable(this, project, fixedParameterList){
                                final /* synthetic */ buildVisitor.visitElement.1 this$0;
                                final /* synthetic */ Project $project;
                                final /* synthetic */ String $fixedParameterList;

                                public final void run() {
                                    OCParameterList oCParameterList = this.this$0.$parameterList;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)oCParameterList, (String)"parameterList");
                                    PsiFile psiFile = oCParameterList.getContainingFile();
                                    OCParameterList oCParameterList2 = this.this$0.$parameterList;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)oCParameterList2, (String)"parameterList");
                                    int n = oCParameterList2.getTextOffset();
                                    OCParameterList oCParameterList3 = this.this$0.$parameterList;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)oCParameterList3, (String)"parameterList");
                                    OCChangeUtil.changeText((Project)this.$project, (PsiFile)psiFile, (int)n, (int)oCParameterList3.getTextLength(), (String)this.$fixedParameterList, (boolean)true);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$project = project;
                                    this.$fixedParameterList = string;
                                }
                            });
                        }
                        {
                            this.$element = $captured_local_variable$0;
                            this.$parameterList = $captured_local_variable$1;
                        }
                    }});
                    return;
                }
                E e = parameters.get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"parameters[0]");
                OCType oCType = ((OCDeclarator)e).getResolvedType();
                Intrinsics.checkExpressionValueIsNotNull((Object)oCType, (String)"parameters[0].resolvedType");
                String firstParameterType = oCType.getName();
                if (Intrinsics.areEqual((Object)firstParameterType, (Object)"JNIEnv *") ^ true) {
                    this.$holder.registerProblem((PsiElement)parameters.get(0), "Incorrect type", ProblemHighlightType.ERROR, new LocalQuickFix[]{new LocalQuickFix(element){
                        final /* synthetic */ PsiElement $element;

                        @NotNull
                        public String getFamilyName() {
                            return "Fix JNI parameters";
                        }

                        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                            Object object = ((OCFunctionDeclaration)this.$element).getDeclarator();
                            if (object == null || (object = object.getParameterList()) == null || (object = object.getParameters()) == null || (object = (OCDeclarator)object.get(0)) == null || (object = object.getParent()) == null) {
                                return;
                            }
                            Object parameter = object;
                            ApplicationManager.getApplication().runWriteAction(new Runnable(project, (PsiElement)parameter){
                                final /* synthetic */ Project $project;
                                final /* synthetic */ PsiElement $parameter;

                                public final void run() {
                                    OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.$parameter.getContainingFile(), (int)this.$parameter.getTextOffset(), (int)this.$parameter.getTextLength(), (String)"JNIEnv *env", (boolean)true);
                                }
                                {
                                    this.$project = project;
                                    this.$parameter = psiElement;
                                }
                            });
                        }
                        {
                            this.$element = $captured_local_variable$0;
                        }
                    }});
                }
                E e2 = parameters.get(1);
                Intrinsics.checkExpressionValueIsNotNull(e2, (String)"parameters[1]");
                OCType oCType2 = ((OCDeclarator)e2).getResolvedType();
                Intrinsics.checkExpressionValueIsNotNull((Object)oCType2, (String)"parameters[1].resolvedType");
                String secondParameterType = oCType2.getName();
                OCDeclarator oCDeclarator = ((OCFunctionDeclaration)element).getDeclarator();
                if (oCDeclarator == null) {
                    return;
                }
                boolean isStatic = JniNameMangler.findDeclaration(oCDeclarator).hasModifier(JvmModifier.STATIC);
                if (isStatic && Intrinsics.areEqual((Object)secondParameterType, (Object)"jclass") ^ true || !isStatic && Intrinsics.areEqual((Object)secondParameterType, (Object)"jobject") ^ true) {
                    this.$holder.registerProblem((PsiElement)parameters.get(1), "Incorrect type", ProblemHighlightType.ERROR, new LocalQuickFix[]{new LocalQuickFix(element, isStatic){
                        final /* synthetic */ PsiElement $element;
                        final /* synthetic */ boolean $isStatic;

                        @NotNull
                        public String getFamilyName() {
                            return "Fix JNI parameters";
                        }

                        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                            Object object = ((OCFunctionDeclaration)this.$element).getDeclarator();
                            if (object == null || (object = object.getParameterList()) == null || (object = object.getParameters()) == null || (object = (OCDeclarator)object.get(1)) == null || (object = object.getParent()) == null) {
                                return;
                            }
                            Object parameter = object;
                            ApplicationManager.getApplication().runWriteAction(new Runnable(this, project, (PsiElement)parameter){
                                final /* synthetic */ buildVisitor.visitElement.3 this$0;
                                final /* synthetic */ Project $project;
                                final /* synthetic */ PsiElement $parameter;

                                public final void run() {
                                    OCChangeUtil.changeText((Project)this.$project, (PsiFile)this.$parameter.getContainingFile(), (int)this.$parameter.getTextOffset(), (int)this.$parameter.getTextLength(), (String)(this.this$0.$isStatic ? "jclass type" : "jobject instance"), (boolean)true);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$project = project;
                                    this.$parameter = psiElement;
                                }
                            });
                        }
                        {
                            this.$element = $captured_local_variable$0;
                            this.$isStatic = $captured_local_variable$1;
                        }
                    }});
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

