/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniGotoDeclarationHandler;
import com.android.tools.ndk.jni.JniNameMangler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.PsiNavigateUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import icons.CidrLangIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JniRelatedItemMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiElement[] targets;
        PsiMethod method;
        if (element == null) {
            JniRelatedItemMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            JniRelatedItemMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof LeafPsiElement && element.getParent() instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element.getParent();
            String name = declarator.getName();
            if (!name.startsWith("Java_")) {
                return;
            }
            PsiMethod declaration = JniNameMangler.findDeclaration(declarator);
            if (declaration != null) {
                List<GotoRelatedItem> items = Collections.singletonList(new GotoRelatedItem((PsiElement)declaration));
                TextRange textRange = element.getTextRange();
                ToJavaNavigationHandler handler = new ToJavaNavigationHandler();
                RelatedItemLineMarkerInfo info = new RelatedItemLineMarkerInfo((PsiElement)((LeafPsiElement)element), textRange, CidrLangIcons.AssocFile, 11, (Function)handler, (GutterIconNavigationHandler)handler, GutterIconRenderer.Alignment.LEFT, items);
                result.add((RelatedItemLineMarkerInfo)info);
            }
        } else if (element instanceof PsiIdentifier && element.getParent() instanceof PsiMethod && (method = (PsiMethod)element.getParent()).hasModifierProperty("native") && (targets = JniGotoDeclarationHandler.getGotoDeclarationTargets(element)) != null && targets.length > 0) {
            ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>(targets.length);
            for (PsiElement target : targets) {
                items.add(new GotoRelatedItem(target));
            }
            TextRange textRange = element.getTextRange();
            ToNativeNavigationHandler handler = new ToNativeNavigationHandler();
            RelatedItemLineMarkerInfo info = new RelatedItemLineMarkerInfo((PsiElement)((PsiIdentifier)element), textRange, CidrLangIcons.AssocFile, 11, (Function)handler, (GutterIconNavigationHandler)handler, GutterIconRenderer.Alignment.LEFT, items);
            result.add((RelatedItemLineMarkerInfo)info);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/android/tools/ndk/jni/JniRelatedItemMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ToJavaNavigationHandler
    implements GutterIconNavigationHandler<LeafPsiElement>,
    Function<LeafPsiElement, String> {
        private ToJavaNavigationHandler() {
        }

        public void navigate(MouseEvent e, LeafPsiElement identifier) {
            PsiMethod declaration = JniNameMangler.findDeclaration((OCDeclarator)identifier.getParent());
            if (declaration != null) {
                PsiNavigateUtil.navigate((PsiElement)declaration);
            }
        }

        public String fun(LeafPsiElement identifier) {
            PsiMethod declaration = JniNameMangler.findDeclaration((OCDeclarator)identifier.getParent());
            if (declaration != null) {
                PsiClass containingClass = declaration.getContainingClass();
                return "Native declaration: " + declaration.getName() + (containingClass != null ? " in " + containingClass.getName() : "");
            }
            return null;
        }
    }

    private static class ToNativeNavigationHandler
    implements GutterIconNavigationHandler<PsiIdentifier>,
    Function<PsiIdentifier, String> {
        private ToNativeNavigationHandler() {
        }

        public void navigate(MouseEvent e, PsiIdentifier identifier) {
            PsiMethod method = (PsiMethod)identifier.getParent();
            PsiElement[] targets = JniGotoDeclarationHandler.getGotoDeclarationTargets((PsiElement)method);
            if (targets != null && targets.length != 0) {
                if (targets.length == 1) {
                    PsiNavigateUtil.navigate((PsiElement)targets[0]);
                } else {
                    JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])targets, (String)("<html>Choose target for <b>" + method.getName() + "<b></html>"));
                    popup.show(new RelativePoint(e));
                }
            }
        }

        public String fun(PsiIdentifier identifier) {
            return "JNI implementation: " + JniNameMangler.getJniMethodName((PsiMethod)identifier.getParent());
        }
    }
}

