/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.JniNameMangler;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniRenameHandler
extends OCInplaceRenameHandler
implements TitledHandler {
    protected boolean isAvailable(@Nullable PsiElement element, Editor editor, PsiFile file) {
        return element != null && JniRenameHandler.isJniFunction(element) || super.isAvailable(element, editor, file);
    }

    @Nullable
    public VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor) {
        OCSymbol symbol;
        if (elementToRename == null) {
            JniRenameHandler.$$$reportNull$$$0(0);
        }
        if (JniRenameHandler.isJniFunction(elementToRename) && elementToRename instanceof PsiNamedElement && (symbol = OCRenameUtil.getSymbolToRename((PsiElement)elementToRename)) != null) {
            return new JniInplaceRenamer((PsiNamedElement)elementToRename, editor, symbol);
        }
        return super.createRenamer(elementToRename, editor);
    }

    @NotNull
    public String getActionTitle() {
        if ("Rename native and Java" == null) {
            JniRenameHandler.$$$reportNull$$$0(1);
        }
        return "Rename native and Java";
    }

    private static boolean isJniFunction(@NotNull PsiElement element) {
        if (element == null) {
            JniRenameHandler.$$$reportNull$$$0(2);
        }
        return NdkHelper.isNdkProject(element.getProject()) && element instanceof OCDeclarator && ((OCDeclarator)element).getName().startsWith("Java_");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/jni/JniRenameHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/jni/JniRenameHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRenamer";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isJniFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class JniInplaceRenamer
    extends OCInplaceRenamer {
        @NotNull
        private final Project myProject;
        @Nullable
        private final PsiMethod myOldNativeDeclaration;

        public JniInplaceRenamer(@NotNull PsiNamedElement elementToRename, @NotNull Editor editor, @NotNull OCSymbol symbol) {
            if (elementToRename == null) {
                JniInplaceRenamer.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                JniInplaceRenamer.$$$reportNull$$$0(1);
            }
            if (symbol == null) {
                JniInplaceRenamer.$$$reportNull$$$0(2);
            }
            super(elementToRename, symbol, editor, false, elementToRename.getName(), elementToRename.getName());
            this.myProject = elementToRename.getProject();
            assert (elementToRename.getName() != null);
            assert (elementToRename.getContainingFile() != null);
            this.myOldNativeDeclaration = JniNameMangler.findDeclaration(this.myProject, elementToRename.getName());
        }

        public void performRenameInner(PsiElement element, String newName) {
            if (this.myOldNativeDeclaration != null) {
                String newMethodName = JniNameMangler.getRename(this.myOldNativeDeclaration, newName);
                RenamePsiElementProcessor renamePsiElementProcessor = RenamePsiElementProcessor.forElement((PsiElement)this.myOldNativeDeclaration);
                UsageInfo[] usages = (UsageInfo[])renamePsiElementProcessor.findReferences((PsiElement)this.myOldNativeDeclaration).stream().map(ref -> new UsageInfo(ref)).toArray(UsageInfo[]::new);
                ApplicationManager.getApplication().runWriteAction(() -> renamePsiElementProcessor.renameElement((PsiElement)this.myOldNativeDeclaration, newMethodName, usages, null));
            }
            super.performRenameInner(element, newName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elementToRename";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbol";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/ndk/jni/JniRenameHandler$JniInplaceRenamer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

