/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniNameMangler;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001ab\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u00020\u0001`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u00012\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001aR\u0010\u000f\u001a\u00020\u00012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u00020\u0001`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u00012\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a \u0010\u0010\u001a\u00020\u00012\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u00020\u0001`\u0006H\u0002\u001a(\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e\u001a>\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u000e\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\u000e\u0010\f\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b\u001a*\u0010\u0018\u001a\u00020\u00012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u00020\u0001`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0002\u001a(\u0010\u0019\u001a\u00020\u000e2\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u00020\u0001`\u00062\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d\u00a8\u0006\u001e"}, d2={"convertArray", "", "elementType", "methodNameMiddle", "parameters", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "name", "envName", "allocate", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "deallocate", "cpp", "", "convertString", "createEnvName", "parametersNameSet", "createMethodDeclarationCode", "method", "Lcom/intellij/psi/PsiMethod;", "jniMethodName", "insertConversions", "createParameterList", "findUniqueParameterName", "hasParameterName", "candidate", "isJniFunction", "element", "Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "android-ndk"})
public final class JniUtilsKt {
    public static final boolean isJniFunction(@NotNull OCFunctionDeclaration element) {
        String name;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        OCDeclarator oCDeclarator = element.getDeclarator();
        if (oCDeclarator == null) {
            return false;
        }
        OCDeclarator declarator = oCDeclarator;
        String string = element.getName();
        if (string == null) {
            return false;
        }
        String string2 = name = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        return StringsKt.startsWith$default((String)string2, (String)"Java_", (boolean)false, (int)2, null) && JniNameMangler.findDeclaration(declarator) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String createMethodDeclarationCode(@NotNull PsiMethod method, @Nullable String jniMethodName, boolean cpp, boolean insertConversions) {
        String string;
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        String string2 = jniMethodName;
        if (string2 == null) {
            String string3 = JniNameMangler.getJniMethodName(method);
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"JniNameMangler.getJniMethodName(method)");
        }
        String jniMethodName2 = string2;
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        PsiParameter[] parameters = psiParameterList.getParameters();
        String maybeExternC = cpp ? "extern \"C\"\n" : "";
        PsiType returnType = method.getReturnType();
        String jniReturnType = returnType != null ? JniNameMangler.getJniType(returnType) : "void";
        StringBuilder allocate = new StringBuilder();
        StringBuilder deallocate = new StringBuilder();
        String parameterList = JniUtilsKt.createParameterList(method, cpp, insertConversions, allocate, deallocate);
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"parameters");
        Object[] objectArray = $receiver$iv = (Object[])parameters;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        int n = ((void)$receiver$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String string4;
            PsiParameter it;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $receiver$iv$iv$iv[i];
            PsiParameter psiParameter = it = (PsiParameter)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"it");
            if (psiParameter.getName() == null) continue;
            String it$iv$iv = string4;
            destination$iv$iv.add(it$iv$iv);
        }
        HashSet parametersNameSet = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        String envName = JniUtilsKt.createEnvName(parametersNameSet);
        if (insertConversions && Intrinsics.areEqual((Object)jniReturnType, (Object)"jstring")) {
            String cStart = !cpp ? "(*" : "";
            String cEnd = !cpp ? ")" : "";
            String cEnv = !cpp ? "" + envName + ", " : "";
            string = "\nreturn " + cStart + "" + envName + "" + cEnd + "->NewStringUTF(" + cEnv + "returnValue);\n";
        } else {
            string = "";
        }
        String returnString = string;
        return "" + maybeExternC + "JNIEXPORT " + jniReturnType + " JNICALL\n" + jniMethodName2 + "" + parameterList + "\n{\n" + allocate + "\n // TODO\n\n" + deallocate + "" + returnString + '}';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String createParameterList(@NotNull PsiMethod method, boolean cpp, boolean insertConversions, @Nullable StringBuilder allocate, @Nullable StringBuilder deallocate) {
        StringBuilder stringBuilder;
        StringBuilder allocate2;
        String objName;
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        PsiParameter[] parameters = psiParameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"parameters");
        Object[] objectArray = $receiver$iv = (Object[])parameters;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        int n = ((void)$receiver$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String string;
            PsiParameter it;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $receiver$iv$iv$iv[i];
            PsiParameter psiParameter = it = (PsiParameter)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"it");
            if (psiParameter.getName() == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        HashSet parametersNameSet = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        String envName = JniUtilsKt.createEnvName(parametersNameSet);
        StringBuilder sb = new StringBuilder();
        sb.append("(JNIEnv* " + envName + ", ");
        if (method.hasModifierProperty("static")) {
            sb.append("jclass");
            objName = "type";
        } else {
            sb.append("jobject");
            objName = "instance";
        }
        sb.append(" ");
        while (JniUtilsKt.hasParameterName(parametersNameSet, objName)) {
            objName = objName + "_";
        }
        sb.append(objName);
        StringBuilder stringBuilder2 = allocate;
        if (stringBuilder2 == null) {
            stringBuilder2 = allocate2 = new StringBuilder();
        }
        if ((stringBuilder = deallocate) == null) {
            stringBuilder = new StringBuilder();
        }
        StringBuilder deallocate2 = stringBuilder;
        for (PsiParameter parameter : parameters) {
            sb.append(", ");
            PsiParameter psiParameter = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameter");
            PsiType type = psiParameter.getType();
            String jniType = JniNameMangler.getJniType(type);
            String name = parameter.getName();
            if (insertConversions) {
                switch (jniType) {
                    case "jstring": {
                        name = JniUtilsKt.convertString(parametersNameSet, name, envName, allocate2, deallocate2, cpp);
                        break;
                    }
                    case "jintArray": {
                        name = JniUtilsKt.convertArray("jint", "Int", parametersNameSet, name, envName, allocate2, deallocate2, cpp);
                        break;
                    }
                    case "jlongArray": {
                        name = JniUtilsKt.convertArray("jlong", "Long", parametersNameSet, name, envName, allocate2, deallocate2, cpp);
                        break;
                    }
                    case "jbooleanArray": {
                        name = JniUtilsKt.convertArray("jboolean", "Boolean", parametersNameSet, name, envName, allocate2, deallocate2, cpp);
                        break;
                    }
                    case "jdoubleArray": {
                        name = JniUtilsKt.convertArray("jdouble", "Double", parametersNameSet, name, envName, allocate2, deallocate2, cpp);
                        break;
                    }
                    case "jcharArray": {
                        name = JniUtilsKt.convertArray("jchar", "Char", parametersNameSet, name, envName, allocate2, deallocate2, cpp);
                        break;
                    }
                    case "jbyteArray": {
                        name = JniUtilsKt.convertArray("jbyte", "Byte", parametersNameSet, name, envName, allocate2, deallocate2, cpp);
                        break;
                    }
                    case "jshortArray": {
                        name = JniUtilsKt.convertArray("jshort", "Short", parametersNameSet, name, envName, allocate2, deallocate2, cpp);
                        break;
                    }
                    case "jfloatArray": {
                        name = JniUtilsKt.convertArray("jfloat", "Float", parametersNameSet, name, envName, allocate2, deallocate2, cpp);
                    }
                }
            }
            sb.append("" + jniType + ' ' + name);
        }
        sb.append(")");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final String createEnvName(HashSet<String> parametersNameSet) {
        String envName = "env";
        while (JniUtilsKt.hasParameterName(parametersNameSet, envName)) {
            envName = envName + "_";
        }
        return envName;
    }

    private static final boolean hasParameterName(HashSet<String> parameters, String candidate) {
        return parameters.contains(candidate);
    }

    private static final String convertString(HashSet<String> parameters, String name, String envName, StringBuilder allocate, StringBuilder deallocate, boolean cpp) {
        String tempName = JniUtilsKt.findUniqueParameterName(parameters, name);
        String envNameWithDereference = cpp ? envName : "(*" + envName + ')';
        String maybeEnvNameWithComma = cpp ? "" : "" + envName + ", ";
        allocate.append("const char *" + name + " = " + envNameWithDereference + "->GetStringUTFChars(" + maybeEnvNameWithComma + "" + tempName + ", 0);\n");
        deallocate.append("" + envNameWithDereference + "->ReleaseStringUTFChars(" + maybeEnvNameWithComma + "" + tempName + ", " + name + ");\n");
        return tempName;
    }

    private static final String convertArray(String elementType, String methodNameMiddle, HashSet<String> parameters, String name, String envName, StringBuilder allocate, StringBuilder deallocate, boolean cpp) {
        String tempName = JniUtilsKt.findUniqueParameterName(parameters, name);
        String envNameWithDereference = cpp ? envName : "(*" + envName + ')';
        String maybeEnvNameWithComma = cpp ? "" : "" + envName + ", ";
        allocate.append("" + elementType + " *" + name + " = " + envNameWithDereference + "->Get" + methodNameMiddle + "ArrayElements(" + maybeEnvNameWithComma + "" + tempName + ", NULL);\n");
        deallocate.append("" + envNameWithDereference + "->Release" + methodNameMiddle + "ArrayElements(" + maybeEnvNameWithComma + "" + tempName + ", " + name + ", 0);\n");
        return tempName;
    }

    private static final String findUniqueParameterName(HashSet<String> parameters, String name) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = name;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String tempName = stringBuilder.append(string).append("_").toString();
        while (JniUtilsKt.hasParameterName(parameters, tempName)) {
            tempName = tempName + "_";
        }
        return tempName;
    }
}

