/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.SourceProvider;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.debug.AndroidNativeDebugProcess;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.ndk.MemoryRegionMap;
import com.android.tools.ndk.run.OptimizedFileNotificationProvider;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.crash.CrashLoggingEvent;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.AddressBreakpointHandler;
import com.android.tools.ndk.run.lldb.AndroidDisasmView;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.diagnostic.LogEventException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidNativeAppDebugProcess
extends CidrDebugProcess
implements AndroidNativeDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidNativeAppDebugProcess.class);
    private static final String LIBART_SO = "libart.so";
    private static final String ART_SIGSEGV_FAULT = "art_sigsegv_fault";
    private static final List<String> SKIPPABLE_UNITY_SIGNALS = ImmutableList.of((Object)"SIGPWR", (Object)"SIGXCPU");
    private static final List<String> UNITY_IDENTIFYING_LIBRARIES = ImmutableList.of((Object)"libil2cpp.so", (Object)"libmono.so");
    private static final CidrSymbolicBreakpointType SYMBOLIC_BREAKPOINT_TYPE = (CidrSymbolicBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class);
    private static final boolean ENABLE_ATTACH_ERROR_REPORTING = true;
    private static final boolean ADD_IDEA_LOG_TO_ERROR_REPORTS = false;
    private final ConsolePrinter myPrinter;
    private final SessionStarter mySessionStarter;
    protected final ProgressReporter myProgressReporter;
    private final String mySessionId;
    private long myStops;
    private long myErrors;
    private boolean myReportedSessionEnd;
    private final boolean mySigSegvFaultReliable;
    private static final Map<String, String> DANGEROUS_COMPILER_FLAGS = ImmutableMap.of((Object)"-flto", (Object)"Combining -flto with -g is currently experimental and expected to produce unexpected results", (Object)"-Wl,--gc-sections", (Object)"can remove unused functions, breaking expression evaluation");
    private final Project myProject;
    private final Client myClient;
    private XBreakpoint<CidrSymbolicBreakpointType.Properties> myArtSigSegvFaultBp;
    private boolean myArt;
    private final MemoryRegionMap myArtMemRegionMap;
    private final boolean myDetachOnStop;
    private final Set<String> myLoadedModules;
    private final Map<File, File> myModuleToSymbols;
    private final JdwpConnector myJdwpConnector;
    @Nullable
    private final AddressBreakpointHandler myAddressBreakpointHandler;
    @Nullable
    private final AndroidDisasmView myDisasmView;

    public AndroidNativeAppDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @Nullable JdwpConnector jdwpConnector, @NotNull Client client, @NotNull ProgressReporter progressReporter, boolean detachOnStop) throws ExecutionException {
        if (sessionId == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(1);
        }
        if (session == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(2);
        }
        if (consoleBuilder == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(3);
        }
        if (printer == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(4);
        }
        if (sessionStarter == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(5);
        }
        if (client == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(6);
        }
        if (progressReporter == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(7);
        }
        super(parameters, session, consoleBuilder);
        this.myStops = 0L;
        this.myErrors = 0L;
        this.myReportedSessionEnd = false;
        this.myArt = false;
        this.myArtMemRegionMap = new MemoryRegionMap(Arrays.asList(".*\\.dex", ".*\\.odex", ".*\\.oat"));
        this.myLoadedModules = Sets.newHashSet();
        this.mySessionId = sessionId;
        this.myPrinter = printer;
        this.mySessionStarter = sessionStarter;
        this.myProgressReporter = progressReporter;
        session.addSessionListener((XDebugSessionListener)new WarnIfOptimizedListener());
        AndroidLLDBDriverConfiguration configuration = (AndroidLLDBDriverConfiguration)this.myRunParameters.getDebuggerDriverConfiguration();
        ApkFacet apkFacet = ApkFacet.getInstance((Module)configuration.getFacet().getModule());
        if (apkFacet != null && !configuration.getClientABIs().isEmpty()) {
            Abi abi = configuration.getClientABIs().get(0);
            this.myModuleToSymbols = ((ApkFacetConfiguration)apkFacet.getConfiguration()).getExplicitModuleSymbolMap(abi);
        } else {
            this.myModuleToSymbols = Collections.emptyMap();
        }
        this.myProject = session.getProject();
        this.myClient = client;
        this.myDetachOnStop = detachOnStop;
        this.myJdwpConnector = jdwpConnector;
        AndroidVersion ver = this.mySessionStarter.getDevice().getVersion();
        boolean bl = this.mySigSegvFaultReliable = ver.getApiLevel() > 27 || "P".equals(ver.getCodename());
        if (this.shouldShowDisassembly()) {
            this.myDisasmView = AndroidDisasmView.create(this);
            if (this.myDisasmView != null) {
                this.myAddressBreakpointHandler = new AddressBreakpointHandler(this);
            } else {
                LOG.warn("Could not set up disassembly view.  Will not work for this debug session.");
                this.myAddressBreakpointHandler = null;
            }
        } else {
            this.myAddressBreakpointHandler = null;
            this.myDisasmView = null;
        }
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (!this.shouldShowDisassembly()) {
            XBreakpointHandler[] xBreakpointHandlerArray = super.getBreakpointHandlers();
            if (xBreakpointHandlerArray == null) {
                AndroidNativeAppDebugProcess.$$$reportNull$$$0(8);
            }
            return xBreakpointHandlerArray;
        }
        ArrayList<AddressBreakpointHandler> handlerList = new ArrayList<AddressBreakpointHandler>();
        Collections.addAll(handlerList, super.getBreakpointHandlers());
        handlerList.add(this.myAddressBreakpointHandler);
        XBreakpointHandler[] xBreakpointHandlerArray = (XBreakpointHandler[])ContainerUtil.toArray(handlerList, (Object[])new XBreakpointHandler[handlerList.size()]);
        if (xBreakpointHandlerArray == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(9);
        }
        return xBreakpointHandlerArray;
    }

    private boolean shouldShowDisassembly() {
        return (Boolean)StudioFlags.LLDB_ASSEMBLY_DEBUGGING.get() != false && this.driverSupportsDisasm();
    }

    @Nullable
    public XSourcePosition createDisasmPosition(@NotNull Address address) {
        if (address == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(10);
        }
        if (!this.shouldShowDisassembly() || this.myDisasmView == null) {
            return null;
        }
        return this.myDisasmView.disassemble(address);
    }

    @NotNull
    protected DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver driver) throws ExecutionException {
        DebuggerDriver.Inferior inferior;
        if (driver == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(11);
        }
        try {
            this.mySessionStarter.pushFilesToDevice();
            AndroidLLDBDriver androidDriver = (AndroidLLDBDriver)driver;
            ClientData clientData = this.myClient.getClientData();
            this.myProgressReporter.step("Loading debugger driver");
            inferior = androidDriver.loadForAttach(clientData.getPid(), (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> {
                LOG.info(String.format("Attaching to inferior: pid=%d, ABI=%s, native debuggable=%b", clientData.getPid(), clientData.getAbi(), clientData.isNativeDebuggable()));
                this.myProgressReporter.step("Attaching to the app");
            }), (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> {
                if (driver == null) {
                    AndroidNativeAppDebugProcess.$$$reportNull$$$0(52);
                }
                this.myArt = this.isArtVM();
                if (this.myArt) {
                    LOG.info("Running in ART VM");
                    this.initArtSigSegvFaultBreakpoint(driver);
                } else {
                    LOG.info("Running in Dalvik VM");
                }
                this.loadExplicitSymbols();
                LOG.info("Resuming paused inferior");
                this.myProgressReporter.step("Resuming the app process");
                driver.resume();
            }));
        }
        catch (ExecutionException launchException) {
            this.myProgressReporter.finish();
            throw this.handleLaunchException(launchException);
        }
        if (inferior == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(12);
        }
        return inferior;
    }

    public void sessionInitialized() {
        super.sessionInitialized();
        this.getProcessHandler().startNotify();
    }

    @NotNull
    public Client getClient() {
        Client client = this.myClient;
        if (client == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(13);
        }
        return client;
    }

    public boolean isDetachDefault() {
        return this.myDetachOnStop;
    }

    @NotNull
    protected XBreakpointManager getBreakpointManager() {
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
        if (xBreakpointManager == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(14);
        }
        return xBreakpointManager;
    }

    @NotNull
    protected static Application getApp() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(15);
        }
        return application;
    }

    private void initArtSigSegvFaultBreakpoint(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(16);
        }
        AndroidNativeAppDebugProcess.getApp().runReadAction(() -> {
            for (XBreakpoint bp : this.getBreakpointManager().getBreakpoints((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE)) {
                CidrSymbolicBreakpointType.Properties bpProps = (CidrSymbolicBreakpointType.Properties)bp.getProperties();
                if (!LIBART_SO.equals(bpProps.getModuleName()) || !ART_SIGSEGV_FAULT.equals(bpProps.getSymbolPattern())) continue;
                this.myArtSigSegvFaultBp = bp;
                break;
            }
        });
        if (this.myArtSigSegvFaultBp != null) {
            return;
        }
        AndroidNativeAppDebugProcess.getApp().invokeLater(() -> AndroidNativeAppDebugProcess.getApp().runWriteAction(() -> {
            CidrSymbolicBreakpointType.Properties props = new CidrSymbolicBreakpointType.Properties(ART_SIGSEGV_FAULT, LIBART_SO);
            this.myArtSigSegvFaultBp = this.getBreakpointManager().addBreakpoint((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE, (XBreakpointProperties)props);
        }));
        if (this.mySigSegvFaultReliable) {
            try {
                driver.handleSignal("SIGSEGV", false, true, false);
            }
            catch (DebuggerCommandException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
    }

    private boolean isArtVM() {
        return this.myLoadedModules.contains(LIBART_SO);
    }

    private void loadExplicitSymbols() {
        for (Map.Entry<File, File> entry : this.myModuleToSymbols.entrySet()) {
            String cmd = String.format("target modules add -s \"%s\" \"%s\"", entry.getValue().getAbsolutePath(), entry.getKey().getAbsolutePath());
            this.executeConsoleCommand(cmd);
        }
    }

    public void stop() {
        super.stop();
        if (this.myAddressBreakpointHandler != null) {
            this.myAddressBreakpointHandler.cleanup();
        }
        if (this.myJdwpConnector != null) {
            this.myJdwpConnector.dispose();
        }
        AndroidNativeAppDebugProcess.getApp().invokeLater(() -> AndroidNativeAppDebugProcess.getApp().runWriteAction(() -> {
            if (this.myArtSigSegvFaultBp != null && !this.myProject.isDisposed()) {
                XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager().removeBreakpoint(this.myArtSigSegvFaultBp);
                this.myArtSigSegvFaultBp = null;
            }
        }));
    }

    private boolean isUnityApp() {
        for (String unityLibrary : UNITY_IDENTIFYING_LIBRARIES) {
            if (!this.myLoadedModules.contains(unityLibrary)) continue;
            return true;
        }
        return false;
    }

    public void handleSignal(final @NotNull DebuggerDriver.StopPlace stopPlace, final @NotNull String signal, final @NotNull String meaning) {
        if (stopPlace == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(17);
        }
        if (signal == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(18);
        }
        if (meaning == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(19);
        }
        if (SKIPPABLE_UNITY_SIGNALS.contains(signal)) {
            this.postCommand(new CidrDebugProcess.DebuggerCommand(){

                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    if (driver == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (AndroidNativeAppDebugProcess.this.isUnityApp()) {
                        for (String skippableUnixSignal : SKIPPABLE_UNITY_SIGNALS) {
                            try {
                                driver.handleSignal(skippableUnixSignal, false, true, false);
                            }
                            catch (DebuggerCommandException e) {
                                throw new ExecutionException((Throwable)e);
                            }
                        }
                        driver.resume();
                    } else {
                        AndroidNativeAppDebugProcess.super.handleSignal(stopPlace, signal, meaning);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeAppDebugProcess$1", "run"));
                }
            });
            return;
        }
        if (this.myArt && signal.equals("SIGSEGV")) {
            this.postCommand(new CidrDebugProcess.DebuggerCommand(){

                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    if (driver == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!AndroidNativeAppDebugProcess.this.handleArtSigSegv(driver, stopPlace.thread)) {
                        AndroidNativeAppDebugProcess.super.handleSignal(stopPlace, signal, meaning);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeAppDebugProcess$2", "run"));
                }
            });
            return;
        }
        super.handleSignal(stopPlace, signal, meaning);
    }

    private boolean handleArtSigSegv(@NotNull DebuggerDriver driver, @NotNull LLThread thread) {
        if (driver == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(20);
        }
        if (thread == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(21);
        }
        try {
            List frames = driver.getFrames((long)thread.getId(), (int)0, (int)1).list;
            if (frames.isEmpty()) {
                return false;
            }
            LLFrame firstFrame = (LLFrame)frames.get(0);
            LOG.info("Got SIGSEGV signal, PC address: " + firstFrame.getProgramCounter());
            MemoryRegionMap.Region region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter().unsignedLongValue());
            if (region == null || !region.isExecutable()) {
                this.myArtMemRegionMap.clear();
                String procMapsContent = this.readProcMapsFile(driver);
                this.myArtMemRegionMap.addMapEntries(StringUtil.splitByLines((String)procMapsContent));
            }
            if ((region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter().unsignedLongValue())) != null && region.isExecutable()) {
                LOG.info(String.format("SIGSEGV came from ART module '%s' - resuming the inferior", region.getFileName()));
                driver.resume();
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    @NotNull
    private String readProcMapsFile(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(22);
        }
        String string = driver.executeShellCommand("cat", (List)Lists.newArrayList((Object[])new String[]{String.format("/proc/%d/maps", this.myClient.getClientData().getPid())}), null, 0).getOutput();
        if (string == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(23);
        }
        return string;
    }

    public void handleModulesLoaded(@NotNull List<String> modules) {
        if (modules == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(24);
        }
        ArrayList<String> trimmedModules = new ArrayList<String>();
        for (String m : modules) {
            if (m == null || m.isEmpty()) continue;
            trimmedModules.add(m.trim());
        }
        for (String m : trimmedModules) {
            this.myProgressReporter.step("Loaded module: " + m);
        }
        super.handleModulesLoaded(trimmedModules);
        this.myLoadedModules.addAll(trimmedModules);
    }

    protected long doStartTarget(@NotNull DebuggerDriver.Inferior inferior) throws ExecutionException {
        if (inferior == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(25);
        }
        try {
            long ret = super.doStartTarget(inferior);
            this.mySessionStarter.sessionStarted();
            LOG.info("Launch has been completed");
            long l = ret;
            return l;
        }
        catch (ExecutionException launchException) {
            throw this.handleLaunchException(launchException);
        }
        finally {
            this.myProgressReporter.finish();
        }
    }

    private LogEventException handleLaunchException(@NotNull ExecutionException launchException) throws ExecutionException {
        Boolean userRequestedTermination;
        if (launchException == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(26);
        }
        if ((userRequestedTermination = (Boolean)this.getProcessHandler().getUserData(ProcessHandler.TERMINATION_REQUESTED)) != null && userRequestedTermination.booleanValue()) {
            throw new ExecutionException("Launch native debugger exception after stop (cancel) requested", (Throwable)launchException);
        }
        this.getSession().stop();
        LOG.warn((Throwable)launchException);
        this.myPrinter.stderr(launchException.getMessage());
        if (this.reportSessionEnd()) {
            this.reportFatalError(launchException);
        }
        List<Attachment> logs = this.mySessionStarter.getLogFilesFromDevice();
        return new CrashLoggingEvent(launchException.getMessage(), launchException, logs, AndroidStudioUsageTracker.deviceToDeviceInfo((IDevice)this.mySessionStarter.getDevice()), launchException.toString()).makeException();
    }

    @NotNull
    private static Attachment getIdeaLog() {
        String content;
        File logFile = new File(PathManager.getLogPath(), "idea.log");
        try {
            content = FileUtil.loadFile((File)logFile);
            int logTailSize = 100000;
            if (content.length() > 100000) {
                content = content.substring(content.length() - 100000);
            }
        }
        catch (IOException e) {
            content = e.toString();
        }
        Attachment attachment = new Attachment(logFile.getPath(), content);
        if (attachment == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(27);
        }
        return attachment;
    }

    @NotNull
    private static Set<String> getAbiNameSet(@NotNull List<Abi> abis) {
        if (abis == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(28);
        }
        HashSet abiNames = Sets.newHashSetWithExpectedSize((int)abis.size());
        for (Abi abi : abis) {
            abiNames.add(abi.toString());
        }
        HashSet hashSet = abiNames;
        if (hashSet == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    private static void visitNativeLibraries(@NotNull Module module, @NotNull Set<String> abiNames, @NotNull NativeLibraryVisitor visitor) {
        if (module == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(30);
        }
        if (abiNames == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(31);
        }
        if (visitor == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(32);
        }
        AndroidNativeAppDebugProcess.visitNativeLibrariesHelper(module, abiNames, visitor, new HashSet<Module>());
    }

    private static void visitNativeLibrariesHelper(@NotNull Module module, @NotNull Set<String> abiNames, @NotNull NativeLibraryVisitor visitor, @NotNull Set<Module> seenModules) {
        Collection nativeLibraries;
        AndroidModuleModel androidModel;
        if (module == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(33);
        }
        if (abiNames == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(34);
        }
        if (visitor == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(35);
        }
        if (seenModules == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(36);
        }
        if (!seenModules.add(module)) {
            return;
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get((Module)module);
        if (ndkModuleModel != null) {
            NdkVariant variant = ndkModuleModel.getSelectedVariant();
            Collection nativeArtifacts = variant.getArtifacts();
            for (NativeArtifact nativeArtifact : nativeArtifacts) {
                String abi;
                File artifactOutputFile = nativeArtifact.getOutputFile();
                if (!artifactOutputFile.exists() || !abiNames.contains(abi = artifactOutputFile.getParentFile().getName())) continue;
                visitor.visit(ndkModuleModel, nativeArtifact);
            }
        }
        if ((androidModel = AndroidModuleModel.get((Module)module)) == null) {
            return;
        }
        IdeAndroidArtifact androidArtifact = androidModel.getSelectedVariant().getMainArtifact();
        if (AndroidPluginGeneration.find((Module)module) == AndroidPluginGeneration.COMPONENT && (nativeLibraries = androidArtifact.getNativeLibraries()) != null) {
            for (NativeLibrary library : nativeLibraries) {
                if (!abiNames.contains(library.getAbi())) continue;
                visitor.visit(library);
            }
        }
        Dependencies dependencies = androidArtifact.getDependencies();
        for (AndroidLibrary lib : dependencies.getLibraries()) {
            AndroidModuleModel moduleModel;
            AndroidFacet moduleFacet;
            Module depModule;
            String projectName = lib.getProject();
            if (projectName == null || (depModule = GradleUtil.findModuleByGradlePath((Project)module.getProject(), (String)projectName)) == null || (moduleFacet = AndroidFacet.getInstance((Module)depModule)) == null || (moduleModel = AndroidModuleModel.get((AndroidFacet)moduleFacet)) == null) continue;
            AndroidNativeAppDebugProcess.visitNativeLibrariesHelper(depModule, abiNames, visitor, seenModules);
        }
    }

    @NotNull
    public static Map<String, String> getSourceMap(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(37);
        }
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        ApkFacet apkFacet = ApkFacet.getInstance((Module)facet.getModule());
        if (apkFacet != null) {
            for (Map.Entry entry : ((ApkFacetConfiguration)apkFacet.getConfiguration()).getSymbolFolderPathMappings().entrySet()) {
                if (((String)entry.getValue()).isEmpty() || ((String)entry.getKey()).equals(entry.getValue())) continue;
                sourceMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        HashMap<String, String> hashMap = sourceMap;
        if (hashMap == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(38);
        }
        return hashMap;
    }

    @NotNull
    public static Collection<File> getSymbolsDir(@NotNull AndroidFacet facet, @Nullable NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        AndroidModuleModel androidModel;
        ApkFacet apkFacet;
        if (facet == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(39);
        }
        if (abis == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(40);
        }
        final LinkedHashSet symDirs = Sets.newLinkedHashSet();
        if (debuggerState != null) {
            AndroidNativeAppDebugProcess.addSymbolDirectories(symDirs, debuggerState.getSymbolDirs());
        }
        if ((apkFacet = ApkFacet.getInstance((Module)facet.getModule())) != null) {
            AndroidNativeAppDebugProcess.addSymbolDirectories(symDirs, ((ApkFacetConfiguration)apkFacet.getConfiguration()).getDebugSymbolFolderPaths(abis));
        }
        if ((androidModel = AndroidModuleModel.get((AndroidFacet)facet)) != null) {
            for (SourceProvider sourceProvider : androidModel.getActiveSourceProviders()) {
                for (File jniLib : sourceProvider.getJniLibsDirectories()) {
                    if (!jniLib.exists()) continue;
                    for (Abi abi : abis) {
                        File abiJniLib = new File(jniLib, abi.toString());
                        if (!abiJniLib.exists()) continue;
                        symDirs.add(abiJniLib);
                    }
                }
            }
        }
        AndroidNativeAppDebugProcess.visitNativeLibraries(facet.getModule(), AndroidNativeAppDebugProcess.getAbiNameSet(abis), new NativeLibraryVisitor(){

            @Override
            public void visit(@NotNull NativeLibrary library) {
                if (library == null) {
                    3.$$$reportNull$$$0(0);
                }
                symDirs.addAll(library.getDebuggableLibraryFolders());
            }

            @Override
            public void visit(@NotNull NdkModuleModel ndkModuleModel, @NotNull NativeArtifact artifact) {
                if (ndkModuleModel == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (artifact == null) {
                    3.$$$reportNull$$$0(2);
                }
                symDirs.add(artifact.getOutputFile().getParentFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "library";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ndkModuleModel";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "artifact";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/ndk/run/AndroidNativeAppDebugProcess$3";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LinkedHashSet linkedHashSet = symDirs;
        if (linkedHashSet == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(41);
        }
        return linkedHashSet;
    }

    private static void addSymbolDirectories(@NotNull Set<File> symDirs, @NotNull Iterable<String> paths) {
        if (symDirs == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(42);
        }
        if (paths == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(43);
        }
        for (String path : paths) {
            File dir = new File(FileUtils.toSystemDependentPath((String)path));
            symDirs.add(dir);
            FileFilter symbolFileFilter = f -> {
                String extension = Files.getFileExtension((String)f.getName()).toLowerCase();
                return extension.equals("so") || extension.equals("dwo");
            };
            Files.fileTreeTraverser().preOrderTraversal((Object)dir).filter(subdir -> {
                if (subdir == null) {
                    return false;
                }
                if (!subdir.isDirectory()) {
                    return false;
                }
                File[] files = subdir.listFiles(symbolFileFilter);
                return files != null && files.length != 0;
            }).copyInto(symDirs);
        }
    }

    public static void verifyNativeModel(@NotNull AndroidFacet facet, @NotNull List<Abi> abis, final @NotNull ConsolePrinter printer) {
        if (facet == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(44);
        }
        if (abis == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(45);
        }
        if (printer == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(46);
        }
        AndroidNativeAppDebugProcess.visitNativeLibraries(facet.getModule(), AndroidNativeAppDebugProcess.getAbiNameSet(abis), new NativeLibraryVisitor(){

            @Override
            public void visit(@NotNull NativeLibrary nativeLibrary) {
                if (nativeLibrary == null) {
                    4.$$$reportNull$$$0(0);
                }
                HashSet compilerFlags = Sets.newHashSet();
                compilerFlags.addAll(nativeLibrary.getCCompilerFlags());
                compilerFlags.addAll(nativeLibrary.getCppCompilerFlags());
                this.verifyCompilerFlags(nativeLibrary.getName(), compilerFlags);
            }

            @Override
            public void visit(@NotNull NdkModuleModel ndkModuleModel, @NotNull NativeArtifact nativeArtifact) {
                if (ndkModuleModel == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (nativeArtifact == null) {
                    4.$$$reportNull$$$0(2);
                }
                HashSet compilerFlags = Sets.newHashSet();
                for (NativeFile nativeFile : nativeArtifact.getSourceFiles()) {
                    NativeSettings settings = ndkModuleModel.findSettings(nativeFile.getSettingsName());
                    if (settings == null) {
                        LOG.warn(String.format("Cannot find settings \"%s\" for native file \"%s\"", nativeFile.getSettingsName(), nativeFile.getFilePath()));
                        continue;
                    }
                    compilerFlags.addAll(settings.getCompilerFlags());
                }
                for (NativeFolder nativeFolder : nativeArtifact.getSourceFolders()) {
                    for (Map.Entry setting : nativeFolder.getPerLanguageSettings().entrySet()) {
                        NativeSettings settings = ndkModuleModel.findSettings((String)setting.getValue());
                        if (settings == null) {
                            LOG.warn(String.format("Cannot find settings \"%s\" for native folder \"%s\"", setting.getValue(), nativeFolder.getFolderPath()));
                            continue;
                        }
                        compilerFlags.addAll(settings.getCompilerFlags());
                    }
                }
                this.verifyCompilerFlags(nativeArtifact.getName(), compilerFlags);
            }

            private void verifyCompilerFlags(@NotNull String libraryName, @NotNull Collection<String> compilerFlags) {
                if (libraryName == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (compilerFlags == null) {
                    4.$$$reportNull$$$0(4);
                }
                HashMap foundDangerousFlags = Maps.newHashMap();
                for (Map.Entry flag : DANGEROUS_COMPILER_FLAGS.entrySet()) {
                    if (!compilerFlags.contains(flag.getKey())) continue;
                    foundDangerousFlags.put(flag.getKey(), flag.getValue());
                }
                if (!foundDangerousFlags.isEmpty()) {
                    String mainWarning = String.format("Native library %s is using compiler flags which may be debug incompatible:", libraryName);
                    printer.stderr(mainWarning);
                    LOG.warn(mainWarning);
                    for (Map.Entry flag : foundDangerousFlags.entrySet()) {
                        String flagWarning = String.format("%s: %s", flag.getKey(), flag.getValue());
                        printer.stderr(flagWarning);
                        LOG.warn(flagWarning);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nativeLibrary";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ndkModuleModel";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nativeArtifact";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "libraryName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "compilerFlags";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/ndk/run/AndroidNativeAppDebugProcess$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "verifyCompilerFlags";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull CidrDebugProcess.DebuggerCommand command, @NotNull ExecutionException exception) {
        if (driver == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(47);
        }
        if (command == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(48);
        }
        if (exception == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(49);
        }
        ++this.myErrors;
        if (AndroidLLDBBreakpadIntegration.checkForCrashes((AndroidLLDBDriver)driver)) {
            if (this.reportSessionEnd()) {
                this.reportLldbCrash();
            }
            this.getSession().stop();
            return;
        }
        if (ExceptionUtil.causedBy((Throwable)exception, ExecutionFinishedException.class)) {
            if (!ExceptionUtil.causedBy((Throwable)exception, ProcessCanceledException.class)) {
                LOG.info((Throwable)exception);
                if (this.reportSessionEnd()) {
                    this.reportFatalError(exception);
                }
            }
            this.getSession().stop();
            return;
        }
        boolean isFatalError = ExceptionUtil.causedBy((Throwable)exception, DebuggerFatalException.class);
        if (command instanceof CidrDebugProcess.DebuggerStartupCommand || isFatalError) {
            if (this.reportSessionEnd()) {
                this.reportFatalError(exception);
            }
            LOG.error((Throwable)exception);
            this.printlnToConsole(exception.getMessage());
            if (isFatalError) {
                driver.getProcessHandler().destroyProcess();
            }
            this.getSession().stop();
            return;
        }
        LOG.warn("Non-fatal exception during native debugging", (Throwable)exception);
    }

    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        if (stopPlace == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(50);
        }
        ++this.myStops;
        super.handleInterrupted(stopPlace);
    }

    private void reportFatalError(@NotNull Throwable e) {
        if (e == null) {
            AndroidNativeAppDebugProcess.$$$reportNull$$$0(51);
        }
        LLDBUsageTracker.sessionFailed(e, this.mySessionId, this.myStops, this.myErrors);
    }

    private void reportLldbCrash() {
        LLDBUsageTracker.sessionFailed("LLDB crash detected", this.mySessionId, this.myStops, this.myErrors);
    }

    private synchronized boolean reportSessionEnd() {
        if (this.myReportedSessionEnd) {
            return false;
        }
        this.myReportedSessionEnd = true;
        return true;
    }

    public void handleTargetFinished(int code, @Nullable String description) {
        super.handleTargetFinished(code, description);
        if (this.reportSessionEnd()) {
            LLDBUsageTracker.sessionStopped(this.mySessionId, this.myStops, this.myErrors);
        }
    }

    public void handleTargetTerminated() {
        super.handleTargetTerminated();
        if (this.reportSessionEnd()) {
            LLDBUsageTracker.sessionStopped(this.mySessionId, this.myStops, this.myErrors);
        }
    }

    public void handleExited(int code) {
        LOG.info("LLDBFrontend exited with code " + code);
        super.handleExited(code);
        if (this.reportSessionEnd()) {
            if (code == 0) {
                LLDBUsageTracker.sessionStopped(this.mySessionId, this.myStops, this.myErrors);
            } else {
                ++this.myErrors;
                LLDBUsageTracker.sessionFailed("LLDBFrontend exited with code " + code, this.mySessionId, this.myStops, this.myErrors);
            }
        }
    }

    static {
        AndroidLLDBBreakpadIntegration.checkForStaleMinidumps();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 27: 
            case 29: 
            case 38: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 27: 
            case 29: 
            case 38: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 4: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionStarter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressReporter";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 27: 
            case 29: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/AndroidNativeAppDebugProcess";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 11: 
            case 16: 
            case 20: 
            case 22: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 17: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signal";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meaning";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferior";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchException";
                break;
            }
            case 28: 
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abis";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abiNames";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenModules";
                break;
            }
            case 37: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symDirs";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/AndroidNativeAppDebugProcess";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadTarget";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getClient";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointManager";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getApp";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "readProcMapsFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeaLog";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbiNameSet";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMap";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolsDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 27: 
            case 29: 
            case 38: 
            case 41: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDisasmPosition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doLoadTarget";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initArtSigSegvFaultBreakpoint";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "handleSignal";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "handleArtSigSegv";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readProcMapsFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "handleModulesLoaded";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doStartTarget";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handleLaunchException";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAbiNameSet";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitNativeLibraries";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitNativeLibrariesHelper";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSourceMap";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolsDir";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolDirectories";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "verifyNativeModel";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "handleCommandException";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "handleInterrupted";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "reportFatalError";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doLoadTarget$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 27: 
            case 29: 
            case 38: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class WarnIfOptimizedListener
    implements XDebugSessionListener {
        private Data myData = null;

        private WarnIfOptimizedListener() {
        }

        public void sessionPaused() {
            this.update();
        }

        public void sessionResumed() {
        }

        public void sessionStopped() {
            this.updateData(this.myData, null);
            this.myData = null;
        }

        public void stackFrameChanged() {
            this.update();
        }

        private void updateData(@Nullable Data data, @Nullable AndroidLLDBDriverConfiguration o) {
            if (data == null) {
                return;
            }
            for (FileEditor editor : data.editors) {
                editor.putUserData(OptimizedFileNotificationProvider.WARNING_KEY, (Object)o);
            }
            EditorNotifications.getInstance((Project)AndroidNativeAppDebugProcess.this.getProject()).updateNotifications(data.file);
        }

        private Data getData() {
            AndroidLLDBDriverConfiguration configuration = (AndroidLLDBDriverConfiguration)AndroidNativeAppDebugProcess.this.myRunParameters.getDebuggerDriverConfiguration();
            if (!configuration.isOptimizedWarningEnabled()) {
                return null;
            }
            XStackFrame frame = AndroidNativeAppDebugProcess.this.getSession().getCurrentStackFrame();
            if (frame == null) {
                return null;
            }
            XSourcePosition position = frame.getSourcePosition();
            if (position == null) {
                return null;
            }
            if (!((CidrStackFrame)frame).getFrame().getOptimized()) {
                return null;
            }
            return new Data(position.getFile(), FileEditorManager.getInstance((Project)AndroidNativeAppDebugProcess.this.getProject()).getAllEditors(position.getFile()));
        }

        private void update() {
            Data newData = this.getData();
            if (Objects.equals(this.myData, newData)) {
                return;
            }
            this.updateData(this.myData, null);
            this.updateData(newData, (AndroidLLDBDriverConfiguration)AndroidNativeAppDebugProcess.this.myRunParameters.getDebuggerDriverConfiguration());
            this.myData = newData;
        }

        private class Data {
            public final VirtualFile file;
            public final FileEditor[] editors;

            public Data(VirtualFile file, FileEditor[] editors) {
                this.file = file;
                this.editors = editors;
            }

            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof Data)) {
                    return false;
                }
                Data other = (Data)obj;
                return Objects.equals(this.file, other.file) && Arrays.equals(this.editors, other.editors);
            }

            public int hashCode() {
                int result = this.file.hashCode();
                result = 31 * result + Arrays.hashCode(this.editors);
                return result;
            }
        }
    }

    private static interface NativeLibraryVisitor {
        public void visit(@NotNull NativeLibrary var1);

        public void visit(@NotNull NdkModuleModel var1, @NotNull NativeArtifact var2);
    }
}

