/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.WorkspaceSettings;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfigurationConverter
extends ProjectConverter {
    @Nullable
    public ConversionProcessor<WorkspaceSettings> createWorkspaceFileConverter() {
        return new AndroidNativeRunConfigurationWorkspaceFileConverter();
    }

    private static class AndroidNativeRunConfigurationWorkspaceFileConverter
    extends ConversionProcessor<WorkspaceSettings> {
        private static final String TYPE = "type";
        private static final String ANDROID_NATIVE_RUN_CONFIGURATION_TYPE = "AndroidNativeRunConfigurationType";
        private static final String FACTORY_NAME = "factoryName";
        private static final String ANDROID_NATIVE_FACTORY = "Android Native";
        private static final String ANDROID_NATIVE_REGEX = "^Android Native\\..*";
        private static final String ANDROID_FACTORY = AndroidBundle.message((String)"android.run.configuration.type.name", (Object[])new Object[0]);
        private static final String DEBUGGER_TYPE = "DEBUGGER_TYPE";
        private static final String DEFAULT = "default";
        private static final String TRUE = "true";
        private static final String NAME = "name";
        private static final String VALUE = "value";
        private static final String RUN_MANAGER = "RunManager";

        private AndroidNativeRunConfigurationWorkspaceFileConverter() {
        }

        public boolean isConversionNeeded(WorkspaceSettings workspaceSettings) {
            Element runManager = AndroidNativeRunConfigurationWorkspaceFileConverter.findRunManager(workspaceSettings.getRootElement());
            return runManager != null && (AndroidNativeRunConfigurationWorkspaceFileConverter.checkForNativeConfigurations(runManager) || AndroidNativeRunConfigurationWorkspaceFileConverter.checkForNonAutoDefaultConfigurations(runManager));
        }

        public void process(WorkspaceSettings workspaceSettings) throws CannotConvertException {
            Element runManager = AndroidNativeRunConfigurationWorkspaceFileConverter.findRunManager(workspaceSettings.getRootElement());
            if (runManager == null) {
                throw new CannotConvertException("Cannot find the run manager element to convert.");
            }
            for (Attribute attribute : runManager.getAttributes()) {
                if (!attribute.getName().equals("selected") || !attribute.getValue().matches(ANDROID_NATIVE_REGEX)) continue;
                attribute.setValue(attribute.getValue().replaceFirst(ANDROID_NATIVE_FACTORY, ANDROID_FACTORY));
            }
            for (Element element : runManager.getChildren()) {
                if (AndroidNativeRunConfigurationWorkspaceFileConverter.isNativeRunConfiguration(element)) {
                    for (Attribute attribute : element.getAttributes()) {
                        if (attribute.getName().equals(TYPE)) {
                            attribute.setValue(AndroidRunConfigurationType.class.getSimpleName());
                            continue;
                        }
                        if (!attribute.getName().equals(FACTORY_NAME)) continue;
                        attribute.setValue(ANDROID_FACTORY);
                    }
                }
                if (!AndroidNativeRunConfigurationWorkspaceFileConverter.isDefaultWithoutAutoDebugger(element)) continue;
                for (Element subElement : element.getChildren()) {
                    Attribute name = subElement.getAttribute(NAME);
                    Attribute value = subElement.getAttribute(VALUE);
                    if (name == null || value == null || !DEBUGGER_TYPE.equals(name.getValue())) continue;
                    value.setValue("Auto");
                }
            }
        }

        @Nullable
        private static Element findRunManager(@NotNull Element element) {
            if (element == null) {
                AndroidNativeRunConfigurationWorkspaceFileConverter.$$$reportNull$$$0(0);
            }
            for (Element subElement : element.getChildren()) {
                for (Attribute attribute : subElement.getAttributes()) {
                    if (!attribute.getName().equals(NAME) || !attribute.getValue().equals(RUN_MANAGER)) continue;
                    return subElement;
                }
            }
            return null;
        }

        private static boolean checkForNativeConfigurations(@NotNull Element runManager) {
            if (runManager == null) {
                AndroidNativeRunConfigurationWorkspaceFileConverter.$$$reportNull$$$0(1);
            }
            for (Element subElement : runManager.getChildren()) {
                if (!AndroidNativeRunConfigurationWorkspaceFileConverter.isNativeRunConfiguration(subElement)) continue;
                return true;
            }
            return false;
        }

        private static boolean isNativeRunConfiguration(@NotNull Element element) {
            if (element == null) {
                AndroidNativeRunConfigurationWorkspaceFileConverter.$$$reportNull$$$0(2);
            }
            for (Attribute attribute : element.getAttributes()) {
                if ((!attribute.getName().equals(TYPE) || !attribute.getValue().equals(ANDROID_NATIVE_RUN_CONFIGURATION_TYPE)) && (!attribute.getName().equals(FACTORY_NAME) || !attribute.getValue().equals(ANDROID_NATIVE_FACTORY))) continue;
                return true;
            }
            return false;
        }

        private static boolean checkForNonAutoDefaultConfigurations(Element runManager) {
            for (Element subElement : runManager.getChildren()) {
                if (!AndroidNativeRunConfigurationWorkspaceFileConverter.isDefaultWithoutAutoDebugger(subElement)) continue;
                return true;
            }
            return false;
        }

        private static boolean isDefaultWithoutAutoDebugger(Element element) {
            for (Attribute attribute : element.getAttributes()) {
                if (!attribute.getName().equals(DEFAULT) || !attribute.getValue().equals(TRUE)) continue;
                for (Element subElement : element.getChildren()) {
                    Attribute name = subElement.getAttribute(NAME);
                    Attribute value = subElement.getAttribute(VALUE);
                    if (name == null || value == null || !DEBUGGER_TYPE.equals(name.getValue()) || "Auto".equals(value.getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runManager";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/ndk/run/AndroidRunConfigurationConverter$AndroidNativeRunConfigurationWorkspaceFileConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findRunManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkForNativeConfigurations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNativeRunConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

