/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ClientShellHelper {
    private static final String RUNAS = "run-as";
    private static final String USER_ARG = "--user";
    private final ClientData myClientData;

    public ClientShellHelper(@NotNull Client client) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (client == null) {
            ClientShellHelper.$$$reportNull$$$0(0);
        }
        this.myClientData = client.getClientData();
        if (this.isRestrictedUser()) {
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            client.getDevice().executeShellCommand(RUNAS, (IShellOutputReceiver)receiver);
            if (!receiver.getOutput().contains(USER_ARG)) {
                throw new IllegalStateException("Native debugging under restricted user is not supported yet.");
            }
        }
    }

    @NotNull
    public String getRunAsCommand(@NotNull String command) {
        if (command == null) {
            ClientShellHelper.$$$reportNull$$$0(1);
        }
        String prefix = String.format("%s %s", RUNAS, this.myClientData.getPackageName());
        if (this.isRestrictedUser()) {
            prefix = String.format("%s %s %d", prefix, USER_ARG, this.myClientData.getUserId());
        }
        String string = prefix + " " + command;
        if (string == null) {
            ClientShellHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    private boolean isRestrictedUser() {
        return this.myClientData.isValidUserId() && this.myClientData.getUserId() > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/ClientShellHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/ClientShellHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunAsCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRunAsCommand";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

