/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationType;
import com.google.common.collect.ImmutableSet;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.WorkspaceSettings;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaAwareConfigRemovalConverter
extends ProjectConverter {
    @Nullable
    public ConversionProcessor<WorkspaceSettings> createWorkspaceFileConverter() {
        return new Processor();
    }

    private static class Processor
    extends ConversionProcessor<WorkspaceSettings> {
        private static final String OPTION = "option";
        private static final String TYPE = "type";
        private static final String ANDROID_RUN_CONFIG_TYPE = AndroidRunConfigurationType.getInstance().getId();
        private static final String ANDROID_TEST_CONFIG_TYPE = AndroidTestRunConfigurationType.getInstance().getId();
        private static final String TRUE = "true";
        private static final String FALSE = "false";
        private static final String NAME = "name";
        private static final String VALUE = "value";
        private static final String RUN_MANAGER = "RunManager";
        private static final String USE_JAVA_AWARE_DEBUGGER = "USE_JAVA_AWARE_DEBUGGER";
        private static final ImmutableSet<String> DEBUGGER_TYPES = ImmutableSet.of((Object)"Auto", (Object)"Hybrid", (Object)"Native");
        private static final ImmutableSet<String> RUN_CONFIG_TYPES = ImmutableSet.of((Object)ANDROID_RUN_CONFIG_TYPE, (Object)ANDROID_TEST_CONFIG_TYPE);

        private Processor() {
        }

        public boolean isConversionNeeded(WorkspaceSettings workspaceSettings) {
            Element runManager = Processor.findRunManager(workspaceSettings.getRootElement());
            return runManager != null && Processor.checkForJavaAwareDebugger(runManager);
        }

        public void process(WorkspaceSettings workspaceSettings) throws CannotConvertException {
            Element runManager = Processor.findRunManager(workspaceSettings.getRootElement());
            if (runManager == null) {
                return;
            }
            for (Element element : runManager.getChildren()) {
                if (!Processor.isAndroidRunConfig(element)) continue;
                Processor.unsetJavaAwareNative(element);
            }
        }

        private static void unsetJavaAwareNative(@NotNull Element runConfig) {
            if (runConfig == null) {
                Processor.$$$reportNull$$$0(0);
            }
            for (Element element : runConfig.getChildren()) {
                Element javaAwareOption;
                if (!Processor.isApplicableDebuggerConfig(element) || (javaAwareOption = Processor.findJavaAwareOption(element)) == null) continue;
                javaAwareOption.setAttribute(VALUE, FALSE);
            }
        }

        private static Element findJavaAwareOption(@NotNull Element debuggerType) {
            if (debuggerType == null) {
                Processor.$$$reportNull$$$0(1);
            }
            for (Element option : debuggerType.getChildren()) {
                if (!option.getName().equals(OPTION)) continue;
                for (Attribute attribute : option.getAttributes()) {
                    if (!attribute.getName().equals(NAME) || !attribute.getValue().equals(USE_JAVA_AWARE_DEBUGGER)) continue;
                    return option;
                }
            }
            return null;
        }

        @Nullable
        private static Element findRunManager(@NotNull Element element) {
            if (element == null) {
                Processor.$$$reportNull$$$0(2);
            }
            for (Element subElement : element.getChildren()) {
                for (Attribute attribute : subElement.getAttributes()) {
                    if (!attribute.getName().equals(NAME) || !attribute.getValue().equals(RUN_MANAGER)) continue;
                    return subElement;
                }
            }
            return null;
        }

        private static boolean checkForJavaAwareDebugger(@NotNull Element runManager) {
            if (runManager == null) {
                Processor.$$$reportNull$$$0(3);
            }
            for (Element subElement : runManager.getChildren()) {
                if (!Processor.isAndroidRunConfig(subElement) || !Processor.usesJavaAwareNativeDebugger(subElement)) continue;
                return true;
            }
            return false;
        }

        private static boolean isAndroidRunConfig(@NotNull Element element) {
            if (element == null) {
                Processor.$$$reportNull$$$0(4);
            }
            for (Attribute attribute : element.getAttributes()) {
                if (!attribute.getName().equals(TYPE) || !RUN_CONFIG_TYPES.contains((Object)attribute.getValue())) continue;
                return true;
            }
            return false;
        }

        private static boolean isApplicableDebuggerConfig(@NotNull Element element) {
            if (element == null) {
                Processor.$$$reportNull$$$0(5);
            }
            return DEBUGGER_TYPES.contains((Object)element.getName());
        }

        private static boolean usesJavaAwareNativeDebugger(@NotNull Element runConfig) {
            if (runConfig == null) {
                Processor.$$$reportNull$$$0(6);
            }
            for (Element element : runConfig.getChildren()) {
                Attribute valueAttribute;
                Element javaAwareOption;
                if (!Processor.isApplicableDebuggerConfig(element) || (javaAwareOption = Processor.findJavaAwareOption(element)) == null || (valueAttribute = javaAwareOption.getAttribute(VALUE)) == null || !valueAttribute.getValue().equals(TRUE)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfig";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggerType";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runManager";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/ndk/run/JavaAwareConfigRemovalConverter$Processor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unsetJavaAwareNative";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findJavaAwareOption";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findRunManager";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkForJavaAwareDebugger";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAndroidRunConfig";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicableDebuggerConfig";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "usesJavaAwareNativeDebugger";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

